/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl;

import com.sshtools.forker.client.EffectiveUser;
import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.ForkerProcess;
import com.sshtools.forker.common.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class LocalProcess
extends ForkerProcess {
    private Process nativeProcess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalProcess(ForkerBuilder builder) throws IOException {
        IO io = builder.getCommand().getIO();
        if (!io.isLocal()) {
            throw new IOException(String.format("IO mode %s currently requires the daemon.", io));
        }
        EffectiveUser effectiveUser = builder.effectiveUser();
        if (effectiveUser != null) {
            effectiveUser.elevate(builder, null, builder.getCommand());
        }
        try {
            List allArguments = builder.getCommand().getAllArguments();
            ProcessBuilder pb = new ProcessBuilder(allArguments);
            if (builder.getCommand().isRedirectError()) {
                pb.redirectErrorStream(true);
            }
            if (builder.getCommand().getDirectory() != null) {
                pb.directory(builder.getCommand().getDirectory());
            }
            if (builder.getCommand().getEnvironment() != null) {
                pb.environment().putAll(builder.getCommand().getEnvironment());
            }
            this.nativeProcess = pb.start();
        }
        finally {
            if (effectiveUser != null) {
                effectiveUser.descend(builder, null, builder.getCommand());
            }
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.nativeProcess.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.nativeProcess.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.nativeProcess.getErrorStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.nativeProcess.waitFor();
    }

    @Override
    public int exitValue() {
        return this.nativeProcess.exitValue();
    }

    @Override
    public void destroy() {
        this.nativeProcess.destroy();
    }
}

