/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl;

import com.sshtools.forker.client.AbstractOSProcess;
import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.common.CSystem;
import com.sshtools.forker.common.IO;
import com.sun.jna.Memory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class POpenProcess
extends AbstractOSProcess {
    private CSystem.FILE fd;
    private int exitValue = Integer.MIN_VALUE;
    private ForkerBuilder builder;
    private InputStream in;
    private OutputStream out;

    public POpenProcess(ForkerBuilder builder) throws IOException {
        this.builder = builder;
        if (builder.effectiveUser() == null) {
            this.doBuildCommand(builder);
        } else {
            builder.effectiveUser().elevate(builder, this, null);
            try {
                this.doBuildCommand(builder);
            }
            finally {
                builder.effectiveUser().descend(builder, this, null);
            }
        }
        if (this.fd == null) {
            throw new IOException("Failed popen.");
        }
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.builder.io() != IO.OUTPUT) {
            throw new IllegalStateException("Not in " + IO.OUTPUT + " mode.");
        }
        if (this.out == null) {
            this.out = new OutputStream(){
                private boolean closed;

                @Override
                public void write(int b) throws IOException {
                    if (this.closed) {
                        throw new IOException("Closed.");
                    }
                    CSystem.INSTANCE.fputs(String.valueOf((char)b), POpenProcess.this.fd);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    if (this.closed) {
                        throw new IOException("Closed.");
                    }
                    CSystem.INSTANCE.fputs(new String(b), POpenProcess.this.fd);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    if (this.closed) {
                        throw new IOException("Closed.");
                    }
                    CSystem.INSTANCE.fputs(new String(b, off, len), POpenProcess.this.fd);
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        throw new IOException("Already closed.");
                    }
                    this.closed = true;
                }
            };
        }
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        if (this.builder.io() != IO.INPUT) {
            throw new IllegalStateException("Not in " + IO.INPUT + " mode.");
        }
        if (this.in == null) {
            this.in = new InputStream(){
                private boolean closed;

                @Override
                public int read() throws IOException {
                    if (this.closed) {
                        throw new IOException("Closed.");
                    }
                    Memory buffer = new Memory(1L);
                    String res = CSystem.INSTANCE.fgets(buffer, 1, POpenProcess.this.fd);
                    if (res == null || res.length() == 0) {
                        POpenProcess.this.exitValue = CSystem.INSTANCE.pclose(POpenProcess.this.fd);
                        return -1;
                    }
                    return res.getBytes()[0];
                }

                @Override
                public int read(byte[] b) throws IOException {
                    if (this.closed) {
                        throw new IOException("Closed.");
                    }
                    Memory buffer = new Memory((long)b.length);
                    String res = CSystem.INSTANCE.fgets(buffer, b.length, POpenProcess.this.fd);
                    if (res == null) {
                        POpenProcess.this.exitValue = CSystem.INSTANCE.pclose(POpenProcess.this.fd);
                        return -1;
                    }
                    System.arraycopy(res.getBytes(), 0, b, 0, res.length());
                    return res.length();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    if (this.closed) {
                        throw new IOException("Closed.");
                    }
                    Memory buffer = new Memory((long)len);
                    String res = CSystem.INSTANCE.fgets(buffer, len, POpenProcess.this.fd);
                    if (res == null) {
                        POpenProcess.this.exitValue = CSystem.INSTANCE.pclose(POpenProcess.this.fd);
                        return -1;
                    }
                    System.arraycopy(res.getBytes(), 0, b, off, res.length());
                    return res.length();
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        throw new IOException("Already closed.");
                    }
                    this.closed = true;
                }
            };
        }
        return this.in;
    }

    @Override
    public InputStream getErrorStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int waitFor() throws InterruptedException {
        if (this.exitValue == Integer.MIN_VALUE) {
            this.exitValue = CSystem.INSTANCE.pclose(this.fd);
            if (this.exitValue == -1) {
                throw new RuntimeException("Failed to close process.");
            }
        }
        return this.exitValue;
    }

    @Override
    public int exitValue() {
        if (this.exitValue == Integer.MIN_VALUE) {
            throw new IllegalStateException("Process not finished.");
        }
        return this.exitValue;
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    private void doBuildCommand(ForkerBuilder builder) {
        this.fd = CSystem.INSTANCE.popen(this.buildCommand(builder), builder.io() == IO.INPUT ? "r" : "w");
    }
}

