/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl.nonblocking;

import com.sshtools.forker.client.impl.jna.posix.LibC;
import com.sshtools.forker.client.impl.nonblocking.IEventProcessor;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingBasePosixProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcessFactory;
import com.sun.jna.ptr.IntByReference;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseEventProcessor<T extends NonBlockingBasePosixProcess>
implements IEventProcessor<T> {
    private final int lingerIterations;
    protected Map<Integer, T> pidToProcessMap;
    protected Map<Integer, T> fildesToProcessMap;
    protected volatile boolean shutdown;
    protected NonBlockingProcessFactory factory;
    private CyclicBarrier startBarrier;
    private AtomicBoolean isRunning;

    public BaseEventProcessor(NonBlockingProcessFactory factory) {
        this(factory, factory.getLingerIterations());
        this.factory = factory;
    }

    public BaseEventProcessor(NonBlockingProcessFactory factory, int lingerIterations) {
        this.lingerIterations = lingerIterations;
        this.factory = factory;
        this.pidToProcessMap = new ConcurrentHashMap<Integer, T>();
        this.fildesToProcessMap = new ConcurrentHashMap<Integer, T>();
        this.isRunning = new AtomicBoolean();
    }

    @Override
    public void run() {
        try {
            this.startBarrier.await();
            int idleCount = 0;
            while (!this.isRunning.compareAndSet(idleCount > this.lingerIterations && this.pidToProcessMap.isEmpty(), false)) {
                idleCount = !this.shutdown && this.process() ? 0 : idleCount + 1;
            }
        }
        catch (Exception e) {
            this.isRunning.set(false);
        }
    }

    @Override
    public CyclicBarrier getSpawnBarrier() {
        this.startBarrier = new CyclicBarrier(2);
        return this.startBarrier;
    }

    @Override
    public boolean checkAndSetRunning() {
        return this.isRunning.compareAndSet(false, true);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        Collection<T> processes = this.pidToProcessMap.values();
        IntByReference exitCode = new IntByReference();
        for (NonBlockingBasePosixProcess process : processes) {
            LibC.kill(process.getPID(), 15);
            process.onExit(0x7FFFFFFE);
            LibC.waitpid(process.getPID(), exitCode, 1);
        }
    }

    abstract void closeStdin(T var1);
}

