/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl.nonblocking;

import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.NonBlockingProcessListener;
import com.sshtools.forker.client.impl.jna.posix.LibC;
import com.sshtools.forker.client.impl.nonblocking.BaseEventProcessor;
import com.sshtools.forker.client.impl.nonblocking.IEventProcessor;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcessFactory;
import com.sshtools.forker.client.impl.nonblocking.ReferenceCountedFileDescriptor;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class NonBlockingBasePosixProcess
extends NonBlockingProcess {
    protected static final Logger LOGGER = Logger.getLogger(NonBlockingBasePosixProcess.class.getCanonicalName());
    private static final ByteBuffer STDIN_CLOSED_PENDING_WRITE_TOMBSTONE = ByteBuffer.allocate(1);
    protected static int processorRoundRobin;
    private int exitcode;
    protected BaseEventProcessor<NonBlockingBasePosixProcess> myProcessor;
    protected volatile int pid;
    public final AtomicBoolean cleanlyExitedBeforeProcess;
    protected AtomicBoolean userWantsWrite = new AtomicBoolean();
    private Memory outBufferMemory;
    private Memory errBufferMemory;
    private Memory inBufferMemory;
    protected ByteBuffer outBuffer;
    protected ByteBuffer errBuffer;
    protected ByteBuffer inBuffer;
    protected ReferenceCountedFileDescriptor stdin;
    protected ReferenceCountedFileDescriptor stdout;
    protected ReferenceCountedFileDescriptor stderr;
    protected volatile int stdinWidow;
    protected volatile int stdoutWidow;
    protected volatile int stderrWidow;
    protected AtomicBoolean stdinClosing;
    protected boolean outClosed = true;
    protected boolean errClosed = true;

    protected NonBlockingBasePosixProcess(ForkerBuilder builder, NonBlockingProcessFactory factory, NonBlockingProcessListener listener) {
        super(builder, factory, listener);
        this.cleanlyExitedBeforeProcess = new AtomicBoolean();
        this.stdin = new ReferenceCountedFileDescriptor(-1);
        this.stdout = new ReferenceCountedFileDescriptor(-1);
        this.stderr = new ReferenceCountedFileDescriptor(-1);
        this.stdinClosing = new AtomicBoolean();
    }

    protected boolean checkLaunch() {
        return true;
    }

    @Override
    public void destroy() {
        if (this.isRunning) {
            NonBlockingBasePosixProcess.checkReturnCode(LibC.kill(this.pid, 15), "Sending signal failed");
        }
    }

    @Override
    public Process destroyForcibly() {
        if (this.isRunning) {
            NonBlockingBasePosixProcess.checkReturnCode(LibC.kill(this.pid, 9), "Sending signal failed");
        }
        return this;
    }

    @Override
    public void wantWrite() {
        block4: {
            try {
                int fd = this.stdin.acquire();
                if (fd != -1) {
                    this.userWantsWrite.set(true);
                    this.myProcessor.queueWrite(this);
                    break block4;
                }
                throw new IllegalStateException("closeStdin() method has already been called.");
            }
            finally {
                this.stdin.release();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void closeStdin(boolean force) {
        if (force) {
            try {
                int fd = this.stdin.acquire();
                if (fd == -1) return;
                if (this.myProcessor != null) {
                    this.myProcessor.closeStdin(this);
                }
                this.stdin.close();
                return;
            }
            finally {
                this.stdin.release();
            }
        } else {
            if (!this.stdinClosing.compareAndSet(false, true)) throw new IllegalStateException("closeStdin() method has already been called.");
            this.pendingWrites.add(STDIN_CLOSED_PENDING_WRITE_TOMBSTONE);
            this.myProcessor.queueWrite(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStdin(ByteBuffer buffer) {
        block4: {
            try {
                int fd = this.stdin.acquire();
                boolean closing = this.stdinClosing.get();
                if (fd != -1 && !closing) {
                    this.pendingWrites.add(buffer);
                    this.myProcessor.queueWrite(this);
                    break block4;
                }
                throw new IllegalStateException("closeStdin() method has already been called.");
            }
            finally {
                this.stdin.release();
            }
        }
    }

    @Override
    public boolean hasPendingWrites() {
        return !this.pendingWrites.isEmpty();
    }

    @Override
    public int getPID() {
        return this.pid;
    }

    public ReferenceCountedFileDescriptor getStdin() {
        return this.stdin;
    }

    public ReferenceCountedFileDescriptor getStdout() {
        return this.stdout;
    }

    public ReferenceCountedFileDescriptor getStderr() {
        return this.stderr;
    }

    public boolean isSoftExit() {
        return this.factory.isSoftExitDetection() && this.outClosed && this.errClosed;
    }

    protected void onExit(int statusCode) {
        if (this.exitPending.getCount() == 0L) {
            return;
        }
        try {
            this.closeStdin(true);
            this.stdout.close();
            this.stderr.close();
            this.isRunning = false;
            this.exitCode.set(statusCode);
            if (this.outBuffer != null && !this.outClosed) {
                this.outBuffer.flip();
                if (this.listener != null) {
                    this.listener.onStdout(this, this.outBuffer, true);
                }
            }
            if (this.errBuffer != null && !this.errClosed) {
                this.errBuffer.flip();
                if (this.listener != null) {
                    if (this.builder.redirectErrorStream()) {
                        this.listener.onStdout(this, this.errBuffer, true);
                    } else {
                        this.listener.onStderr(this, this.errBuffer, true);
                    }
                }
            }
            if (statusCode != 0x7FFFFFFE && this.listener != null) {
                this.listener.onExit(statusCode, this);
            }
        }
        catch (Exception e) {
            if (this.listener == null) {
                LOGGER.log(Level.SEVERE, "Failed to handle exit gracefully.", e);
            } else {
                this.listener.onError(e, this, false);
            }
        }
        finally {
            this.exitPending.countDown();
            this.outBufferMemory = null;
            this.errBufferMemory = null;
            this.inBufferMemory = null;
            this.outBuffer = null;
            this.errBuffer = null;
            this.inBuffer = null;
            Memory.purge();
        }
    }

    protected void readStdout(int availability, int fd) {
        if (this.outClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.outClosed = true;
                this.outBuffer.flip();
                if (this.listener != null) {
                    this.listener.onStdout(this, this.outBuffer, true);
                }
                return;
            }
            int read = LibC.read(fd, this.outBuffer, Math.min(availability, this.outBuffer.remaining()));
            if (read == -1) {
                this.outClosed = true;
                throw new RuntimeException("Unexpected eof");
            }
            this.outBuffer.limit(this.outBuffer.position() + read);
            this.outBuffer.position(0);
            if (this.listener != null) {
                this.listener.onStdout(this, this.outBuffer, false);
            }
            this.outBuffer.compact();
        }
        catch (Exception e) {
            if (this.listener == null) {
                LOGGER.log(Level.WARNING, "Exception thrown from lsitener.", e);
            }
            this.listener.onError(e, this, false);
        }
        if (!this.outBuffer.hasRemaining()) {
            throw new RuntimeException("stdout buffer has no bytes remaining");
        }
    }

    protected void readStderr(int availability, int fd) {
        if (this.errClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.errClosed = true;
                this.errBuffer.flip();
                if (this.listener != null) {
                    if (this.builder.redirectErrorStream()) {
                        this.listener.onStdout(this, this.errBuffer, true);
                    } else {
                        this.listener.onStderr(this, this.errBuffer, true);
                    }
                }
                return;
            }
            int read = LibC.read(fd, this.errBuffer, Math.min(availability, this.errBuffer.remaining()));
            if (read == -1) {
                this.errClosed = true;
                throw new RuntimeException("Unexpected eof");
            }
            this.errBuffer.limit(this.errBuffer.position() + read);
            this.errBuffer.position(0);
            if (this.listener != null) {
                if (this.builder.redirectErrorStream()) {
                    this.listener.onStdout(this, this.errBuffer, false);
                } else {
                    this.listener.onStderr(this, this.errBuffer, false);
                }
            }
            this.errBuffer.compact();
        }
        catch (Exception e) {
            if (this.listener == null) {
                LOGGER.log(Level.WARNING, "Exception thrown from handler", e);
            }
            this.listener.onError(e, this, false);
        }
        if (!this.errBuffer.hasRemaining()) {
            throw new RuntimeException("stderr buffer has no bytes remaining");
        }
    }

    protected boolean writeStdin(int availability, int fd) {
        if (availability <= 0 || fd == -1) {
            return false;
        }
        if (this.inBuffer.hasRemaining()) {
            int wrote;
            do {
                if ((wrote = LibC.write(fd, this.inBuffer, Math.min(availability, this.inBuffer.remaining()))) >= 0) continue;
                int errno = Native.getLastError();
                if (errno == 11 || errno == 35) {
                    availability /= 4;
                    continue;
                }
                this.stdin.close();
                return false;
            } while (wrote < 0);
            availability -= wrote;
            this.inBuffer.position(this.inBuffer.position() + wrote);
            if (this.inBuffer.hasRemaining()) {
                return true;
            }
        }
        if (!this.pendingWrites.isEmpty()) {
            this.inBuffer.clear();
            ByteBuffer byteBuffer = (ByteBuffer)this.pendingWrites.peek();
            if (byteBuffer == STDIN_CLOSED_PENDING_WRITE_TOMBSTONE) {
                this.closeStdin(true);
                this.userWantsWrite.set(false);
                this.pendingWrites.clear();
                return false;
            }
            if (byteBuffer != null && byteBuffer.remaining() > BUFFER_CAPACITY) {
                ByteBuffer slice = byteBuffer.slice();
                slice.limit(BUFFER_CAPACITY);
                this.inBuffer.put(slice);
                byteBuffer.position(byteBuffer.position() + BUFFER_CAPACITY);
            } else if (byteBuffer != null) {
                this.inBuffer.put(byteBuffer);
                this.pendingWrites.poll();
            }
            this.inBuffer.flip();
            if (this.inBuffer.hasRemaining()) {
                if (availability <= 0) {
                    return true;
                }
                return this.writeStdin(availability, fd);
            }
        }
        if (!this.userWantsWrite.get()) {
            return false;
        }
        if (this.listener == null) {
            return false;
        }
        try {
            this.inBuffer.clear();
            boolean wantMore = this.listener.onStdinReady(this, this.inBuffer);
            this.userWantsWrite.set(wantMore);
            if (this.inBuffer.hasRemaining() && availability > 0) {
                return this.writeStdin(availability, fd);
            }
            return true;
        }
        catch (Exception e) {
            if (this.listener == null) {
                LOGGER.log(Level.SEVERE, "Exception thrown handling writes to stdin.", e);
            } else {
                this.listener.onError(e, this, false);
            }
            return false;
        }
    }

    protected void afterStart() {
        long testSleep = Integer.getInteger("nuprocess.test.afterStartSleep", 0).intValue();
        if (testSleep > 0L) {
            LockSupport.parkNanos(testSleep);
        }
        this.isRunning = true;
    }

    protected void initializeBuffers() {
        super.inializeBuffers();
        this.outClosed = false;
        this.errClosed = false;
        this.outBufferMemory = new Memory((long)BUFFER_CAPACITY);
        this.outBuffer = this.outBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.errBufferMemory = new Memory((long)BUFFER_CAPACITY);
        this.errBuffer = this.errBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.inBufferMemory = new Memory((long)BUFFER_CAPACITY);
        this.inBuffer = this.inBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.inBuffer.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerProcess() {
        int mySlot;
        List<IEventProcessor<? extends NonBlockingProcess>> list = this.factory.getProcessors(this);
        synchronized (list) {
            mySlot = processorRoundRobin;
            processorRoundRobin = (processorRoundRobin + 1) % this.factory.getProcessors(this).size();
        }
        this.myProcessor = (BaseEventProcessor)this.factory.getProcessors(this).get(mySlot);
        this.myProcessor.registerProcess(this);
        if (this.myProcessor.checkAndSetRunning()) {
            CyclicBarrier spawnBarrier = this.myProcessor.getSpawnBarrier();
            Thread t = new Thread(this.myProcessor, "ProcessQueue" + mySlot);
            t.setDaemon(true);
            t.start();
            try {
                spawnBarrier.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected int[] createPipes() {
        int[] in = new int[2];
        int[] out = new int[2];
        int[] err = new int[2];
        try {
            int rc = LibC.pipe(in);
            NonBlockingBasePosixProcess.checkReturnCode(rc, "Create stdin pipe() failed");
            rc = LibC.pipe(out);
            NonBlockingBasePosixProcess.checkReturnCode(rc, "Create stdout pipe() failed");
            rc = LibC.pipe(err);
            NonBlockingBasePosixProcess.checkReturnCode(rc, "Create stderr pipe() failed");
            this.setNonBlocking(in[1], out[0], err[0]);
            this.stdin = new ReferenceCountedFileDescriptor(in[1]);
            this.stdout = new ReferenceCountedFileDescriptor(out[0]);
            this.stderr = new ReferenceCountedFileDescriptor(err[0]);
            this.stdinWidow = in[0];
            this.stdoutWidow = out[1];
            this.stderrWidow = err[1];
            return new int[]{in[1], out[0], err[0]};
        }
        catch (RuntimeException e) {
            if (this.listener == null) {
                LOGGER.log(Level.SEVERE, "Error creating pipes", e);
            } else {
                this.listener.onError(e, this, true);
            }
            this.initFailureCleanup(in, out, err);
            throw e;
        }
    }

    protected void initFailureCleanup(int[] in, int[] out, int[] err) {
        HashSet<Integer> unique = new HashSet<Integer>();
        if (in != null) {
            unique.add(in[0]);
            unique.add(in[1]);
        }
        if (out != null) {
            unique.add(out[0]);
            unique.add(out[1]);
        }
        if (err != null) {
            unique.add(err[0]);
            unique.add(err[1]);
        }
        Iterator iterator = unique.iterator();
        while (iterator.hasNext()) {
            int fildes = (Integer)iterator.next();
            if (fildes == 0) continue;
            LibC.close(fildes);
        }
    }

    protected static void checkReturnCode(int rc, String failureMessage) {
        if (rc != 0) {
            throw new RuntimeException(failureMessage + ", return code: " + rc + ", last error: " + Native.getLastError());
        }
    }

    private void setNonBlocking(int in, int out, int err) {
        int rc = LibC.fcntl(in, 4, LibC.fcntl(in, 3) | LibC.O_NONBLOCK);
        NonBlockingBasePosixProcess.checkReturnCode(rc, "fnctl on stdin handle failed");
        rc = LibC.fcntl(out, 4, LibC.fcntl(out, 3) | LibC.O_NONBLOCK);
        NonBlockingBasePosixProcess.checkReturnCode(rc, "fnctl on stdout handle failed");
        rc = LibC.fcntl(err, 4, LibC.fcntl(err, 3) | LibC.O_NONBLOCK);
        NonBlockingBasePosixProcess.checkReturnCode(rc, "fnctl on stderr handle failed");
    }
}

