/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl.nonblocking;

import com.sshtools.forker.client.EffectiveUser;
import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.NonBlockingProcessListener;
import com.sshtools.forker.client.impl.jna.posix.LibAzulJava8;
import com.sshtools.forker.client.impl.jna.posix.LibC;
import com.sshtools.forker.client.impl.jna.posix.LibEpoll;
import com.sshtools.forker.client.impl.jna.posix.LibJava8;
import com.sshtools.forker.client.impl.nonblocking.IEventProcessor;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingBasePosixProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcessFactory;
import com.sshtools.forker.client.impl.nonblocking.ProcessEpoll;
import com.sun.jna.JNIEnv;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;

public class NonBlockingLinuxProcess
extends NonBlockingBasePosixProcess {
    private static final boolean isAzul = System.getProperty("java.vm.vendor", "").contains("Azul");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonBlockingLinuxProcess(ForkerBuilder builder, NonBlockingProcessFactory factory, NonBlockingProcessListener listener) throws IOException {
        super(builder, factory, listener);
        EffectiveUser effectiveUser = builder.effectiveUser();
        if (effectiveUser != null) {
            effectiveUser.elevate(builder, null, builder.getCommand());
        }
        try {
            String[] cmdarray = builder.command().toArray(new String[0]);
            byte[][] args = new byte[cmdarray.length - 1][];
            int size = args.length;
            for (int i = 0; i < args.length; ++i) {
                args[i] = cmdarray[i + 1].getBytes();
                size += args[i].length;
            }
            byte[] argBlock = new byte[size];
            int i = 0;
            for (byte[] arg : args) {
                System.arraycopy(arg, 0, argBlock, i, arg.length);
                i += arg.length + 1;
            }
            byte[] envBlock = NonBlockingLinuxProcess.toEnvironmentBlock(builder.environment());
            try {
                this.createPipes();
                int[] child_fds = new int[]{this.stdinWidow, this.stdoutWidow, this.stderrWidow};
                this.pid = isAzul ? LibAzulJava8.Java_java_lang_ProcessImpl_forkAndExec(JNIEnv.CURRENT, this, LaunchMechanism.VFORK.ordinal() + 1, NonBlockingLinuxProcess.toCString(System.getProperty("java.home") + "/lib/jspawnhelper"), NonBlockingLinuxProcess.toCString(cmdarray[0]), argBlock, args.length, envBlock, builder.environment().size(), builder.directory() != null ? NonBlockingLinuxProcess.toCString(builder.directory().toString()) : null, child_fds, (byte)0) : LibJava8.Java_java_lang_UNIXProcess_forkAndExec(JNIEnv.CURRENT, this, LaunchMechanism.VFORK.ordinal() + 1, NonBlockingLinuxProcess.toCString(System.getProperty("java.home") + "/lib/jspawnhelper"), NonBlockingLinuxProcess.toCString(cmdarray[0]), argBlock, args.length, envBlock, builder.environment().size(), builder.directory() != null ? NonBlockingLinuxProcess.toCString(builder.directory().toString()) : null, child_fds, (byte)0);
                if (this.pid == -1) {
                    throw new IOException("Process not started, no PID could be determined.");
                }
                LibC.close(this.stdinWidow);
                LibC.close(this.stdoutWidow);
                LibC.close(this.stderrWidow);
                this.initializeBuffers();
                this.afterStart();
                this.registerProcess();
            }
            catch (Exception e) {
                if (listener != null) {
                    listener.onError(e, this, true);
                } else {
                    LOGGER.log(Level.WARNING, "Failed to start process", e);
                }
                this.onExit(Integer.MIN_VALUE);
                throw new IOException("Process not started.", e);
            }
        }
        finally {
            if (effectiveUser != null) {
                effectiveUser.descend(builder, null, builder.getCommand());
            }
        }
    }

    @Override
    protected IEventProcessor<? extends NonBlockingProcess> createProcessor() {
        return new ProcessEpoll(this.factory);
    }

    @Override
    protected boolean checkLaunch() {
        boolean cleanExit;
        IntByReference ret = new IntByReference();
        int waitpidRc = LibC.waitpid(this.pid, ret, 1);
        int status = ret.getValue();
        boolean bl = cleanExit = waitpidRc == this.pid && LibC.WIFEXITED(status) && LibC.WEXITSTATUS(status) == 0;
        if (cleanExit) {
            this.cleanlyExitedBeforeProcess.set(true);
        } else if (waitpidRc != 0) {
            if (LibC.WIFEXITED(status)) {
                if ((status = LibC.WEXITSTATUS(status)) == 127) {
                    this.onExit(Integer.MIN_VALUE);
                } else {
                    this.onExit(status);
                }
            } else if (LibC.WIFSIGNALED(status)) {
                this.onExit(LibC.WTERMSIG(status));
            }
            return false;
        }
        return true;
    }

    private static byte[] toCString(String s) {
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[result.length - 1] = 0;
        return result;
    }

    private static byte[] toEnvironmentBlock(Map<String, String> environmentMap) {
        String[] environment = NonBlockingLinuxProcess.mapToArray(environmentMap);
        int count = environment.length;
        for (String entry : environment) {
            count += entry.getBytes().length;
        }
        byte[] block = new byte[count];
        int i = 0;
        for (String entry : environment) {
            byte[] bytes = entry.getBytes();
            System.arraycopy(bytes, 0, block, i, bytes.length);
            i += bytes.length + 1;
        }
        return block;
    }

    static {
        LibEpoll.sigignore(13);
    }

    private static enum LaunchMechanism {
        FORK,
        POSIX_SPAWN,
        VFORK;

    }
}

