/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl.nonblocking;

import com.sshtools.forker.client.EffectiveUser;
import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.NonBlockingProcessListener;
import com.sshtools.forker.client.impl.jna.posix.LibC;
import com.sshtools.forker.client.impl.nonblocking.IEventProcessor;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingBasePosixProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcessFactory;
import com.sshtools.forker.client.impl.nonblocking.ProcessKqueue;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;

public class NonBlockingOsxProcess
extends NonBlockingBasePosixProcess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonBlockingOsxProcess(ForkerBuilder builder, NonBlockingProcessFactory factory, NonBlockingProcessListener listener) throws IOException {
        super(builder, factory, listener);
        EffectiveUser effectiveUser = builder.effectiveUser();
        if (effectiveUser != null) {
            effectiveUser.elevate(builder, null, builder.getCommand());
        }
        try {
            String[] commands = builder.command().toArray(new String[0]);
            Pointer posix_spawn_file_actions = this.createPosixPipes();
            Pointer posix_spawnattr = this.createPosixSpawnAttributes();
            try {
                int rc = LibC.posix_spawnattr_init(posix_spawnattr);
                NonBlockingOsxProcess.checkReturnCode(rc, "Internal call to posix_spawnattr_init() failed");
                LibC.posix_spawnattr_setflags(posix_spawnattr, (short)16512);
                IntByReference restrict_pid = new IntByReference();
                StringArray commandsArray = new StringArray(commands);
                StringArray environmentArray = new StringArray(NonBlockingOsxProcess.mapToArray(builder.environment()));
                rc = builder.directory() != null ? this.spawnWithCwd(restrict_pid, commands[0], posix_spawn_file_actions, posix_spawnattr, commandsArray, (Pointer)environmentArray, builder.directory().toPath()) : LibC.posix_spawnp(restrict_pid, commands[0], posix_spawn_file_actions, posix_spawnattr, commandsArray, (Pointer)environmentArray);
                this.pid = restrict_pid.getValue();
                this.initializeBuffers();
                if (!this.checkLaunch()) {
                    throw new IOException("Process not started.");
                }
                NonBlockingOsxProcess.checkReturnCode(rc, "Invocation of posix_spawn() failed");
                this.afterStart();
                this.registerProcess();
                this.singleProcessContinue();
            }
            finally {
                LibC.posix_spawnattr_destroy(posix_spawnattr);
                LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
                LibC.close(this.stdinWidow);
                LibC.close(this.stdoutWidow);
                LibC.close(this.stderrWidow);
            }
        }
        finally {
            if (effectiveUser != null) {
                effectiveUser.descend(builder, null, builder.getCommand());
            }
        }
    }

    @Override
    protected IEventProcessor<? extends NonBlockingProcess> createProcessor() {
        return new ProcessKqueue(this.factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int spawnWithCwd(IntByReference restrict_pid, String restrict_path, Pointer file_actions, Pointer restrict_attrp, StringArray argv, Pointer envp, Path cwd) {
        int n;
        int cwdBufSize = 1024;
        long peer = Native.malloc((long)cwdBufSize);
        Pointer oldCwd = new Pointer(peer);
        LibC.getcwd(oldCwd, cwdBufSize);
        String newCwd = cwd.toAbsolutePath().toString();
        int rc = LibC.SYSCALL.syscall(348, newCwd);
        NonBlockingOsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to set current directory");
        try {
            n = LibC.posix_spawnp(restrict_pid, restrict_path, file_actions, restrict_attrp, argv, envp);
        }
        catch (Throwable throwable) {
            rc = LibC.SYSCALL.syscall(348, oldCwd);
            Native.free((long)Pointer.nativeValue((Pointer)oldCwd));
            NonBlockingOsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to restore current directory");
            throw throwable;
        }
        rc = LibC.SYSCALL.syscall(348, oldCwd);
        Native.free((long)Pointer.nativeValue((Pointer)oldCwd));
        NonBlockingOsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to restore current directory");
        return n;
    }

    private void singleProcessContinue() {
        LibC.kill(this.pid, 19);
    }

    private Pointer createPosixPipes() {
        Pointer posix_spawn_file_actions = this.createPosixSpawnFileActions();
        try {
            int[] fds = this.createPipes();
            int rc = LibC.posix_spawn_file_actions_init(posix_spawn_file_actions);
            NonBlockingOsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_init() failed");
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, this.stdinWidow, 0);
            NonBlockingOsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, fds[0]);
            NonBlockingOsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, this.stdoutWidow, 1);
            NonBlockingOsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, fds[1]);
            NonBlockingOsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, this.stderrWidow, 2);
            NonBlockingOsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, fds[2]);
            NonBlockingOsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            return posix_spawn_file_actions;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Exception creating posix pipe actions", e);
            LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
            throw e;
        }
    }

    private Pointer createPosixSpawnFileActions() {
        return new Memory((long)Pointer.SIZE);
    }

    private Pointer createPosixSpawnAttributes() {
        return new Memory((long)Pointer.SIZE);
    }

    static {
        LibC.signal(31, LibC.SIG_IGN);
    }
}

