/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl.nonblocking;

import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.ForkerProcess;
import com.sshtools.forker.client.NonBlockingProcessListener;
import com.sshtools.forker.client.impl.nonblocking.IEventProcessor;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcessFactory;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class NonBlockingProcess
extends ForkerProcess {
    public static int BUFFER_CAPACITY = 65536;
    protected volatile ForkerBuilder builder;
    protected NonBlockingProcessFactory factory;
    protected NonBlockingProcessListener listener = null;
    protected OutputStream legacyOut = null;
    protected AtomicInteger exitCode;
    protected CountDownLatch exitPending;
    protected ConcurrentLinkedQueue<ByteBuffer> pendingWrites;
    protected volatile boolean isRunning;
    private final Object lock = new Object();

    public NonBlockingProcess(ForkerBuilder builder, NonBlockingProcessFactory factory, NonBlockingProcessListener listener) {
        this.listener = listener;
        this.builder = builder;
        this.factory = factory;
        this.exitCode = new AtomicInteger();
        this.exitPending = new CountDownLatch(1);
    }

    @Override
    public int exitValue() {
        if (this.isRunning) {
            throw new IllegalThreadStateException("Still running.");
        }
        return this.exitCode.get();
    }

    @Override
    public boolean isAlive() {
        return this.isRunning;
    }

    @Override
    public int waitFor() throws InterruptedException {
        if (this.waitFor(0L, TimeUnit.MILLISECONDS)) {
            return this.exitValue();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            this.exitPending.await();
        } else if (!this.exitPending.await(timeout, unit)) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() {
        Object object = this.lock;
        synchronized (object) {
            if (this.legacyOut == null) {
                this.legacyOut = new BufferedOutputStream(new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        this.write(new byte[]{(byte)b});
                    }

                    @Override
                    public void write(byte[] b) throws IOException {
                        this.write(b, 0, b.length);
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        ByteBuffer buf = NonBlockingProcess.this.factory.isAllocateDirect() ? ByteBuffer.allocate(len) : ByteBuffer.allocate(len);
                        buf.put(b, off, len);
                        buf.flip();
                        NonBlockingProcess.this.writeStdin(buf);
                    }

                    @Override
                    public void close() throws IOException {
                        NonBlockingProcess.this.closeStdin(false);
                    }
                });
            }
        }
        return this.legacyOut;
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException("This process is a non-blocking one. Please use NonBlockProcess.listen() instead.");
    }

    @Override
    public InputStream getErrorStream() {
        throw new UnsupportedOperationException("This process is a non-blocking one. Please use NonBlockProcess.listen() instead.");
    }

    public abstract int getPID();

    protected abstract IEventProcessor<? extends NonBlockingProcess> createProcessor();

    protected void inializeBuffers() {
        this.pendingWrites = new ConcurrentLinkedQueue();
    }

    protected static String[] mapToArray(Map<String, String> map) {
        String[] environment = new String[map.size()];
        int i = 0;
        for (Map.Entry<String, String> entrySet : map.entrySet()) {
            environment[i++] = entrySet.getKey() + "=" + entrySet.getValue();
        }
        return environment;
    }
}

