/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl.nonblocking;

import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.ForkerProcess;
import com.sshtools.forker.client.ForkerProcessFactory;
import com.sshtools.forker.client.ForkerProcessListener;
import com.sshtools.forker.client.NonBlockingProcessListener;
import com.sshtools.forker.client.impl.nonblocking.IEventProcessor;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingLinuxProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingOsxProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingWindowsProcess;
import com.sshtools.forker.common.IO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.SystemUtils;

public class NonBlockingProcessFactory
implements ForkerProcessFactory {
    private int numberOfIOThreads;
    private boolean shutdownHook = true;
    private boolean softExitDetection = true;
    private boolean firstRun;
    private Object lock = new Object();
    private boolean allocateDirect;
    private int lingerTimeMs = 2500;
    private int deadPoolPollMs = 250;
    private List<IEventProcessor<? extends NonBlockingProcess>> processors = null;

    public NonBlockingProcessFactory() {
        this.numberOfIOThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    }

    public int getLingerTimeMs() {
        return this.lingerTimeMs;
    }

    public void setLingerTimeMs(int lingerTimeMs) {
        this.lingerTimeMs = lingerTimeMs;
    }

    public int getDeadPoolPollMs() {
        return this.deadPoolPollMs;
    }

    public void setDeadPoolPollMs(int deadPoolPollMs) {
        this.deadPoolPollMs = deadPoolPollMs;
    }

    public boolean isAllocateDirect() {
        return this.allocateDirect;
    }

    public void setAllocateDirect(boolean allocateDirect) {
        this.allocateDirect = allocateDirect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IEventProcessor<? extends NonBlockingProcess>> getProcessors(NonBlockingProcess process) {
        Object object = this.lock;
        synchronized (object) {
            if (this.processors == null) {
                this.processors = new ArrayList<IEventProcessor<? extends NonBlockingProcess>>(this.numberOfIOThreads);
                for (int i = 0; i < this.numberOfIOThreads; ++i) {
                    this.processors.add(process.createProcessor());
                }
            }
            return this.processors;
        }
    }

    public boolean isShutdownHook() {
        return this.shutdownHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShutdownHook(boolean shutdownHook) {
        if (this.firstRun) {
            throw new IllegalStateException("First process has been created, cannot change whether shutdown hook will be used.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.shutdownHook = shutdownHook;
        }
    }

    public int getNumberOfIOThreads() {
        return this.numberOfIOThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNumberOfIOThreads(int numberOfIOThreads) {
        if (this.firstRun) {
            throw new IllegalStateException("Cannot set number of threads after processors have been created.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.numberOfIOThreads = numberOfIOThreads;
        }
    }

    public boolean isSoftExitDetection() {
        return this.softExitDetection;
    }

    public void setSoftExitDetection(boolean softExitDetection) {
        this.softExitDetection = softExitDetection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForkerProcess createProcess(ForkerBuilder builder, ForkerProcessListener listener) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.firstRun) {
                this.firstRun = true;
                if (this.shutdownHook) {
                    Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (NonBlockingProcessFactory.this.processors != null) {
                                for (IEventProcessor processor : NonBlockingProcessFactory.this.processors) {
                                    if (processor == null) continue;
                                    processor.shutdown();
                                }
                            }
                        }
                    }));
                }
            }
        }
        if (SystemUtils.IS_OS_LINUX && builder.io() == IO.NON_BLOCKING) {
            return new NonBlockingLinuxProcess(builder, this, (NonBlockingProcessListener)listener);
        }
        if (SystemUtils.IS_OS_MAC_OSX && builder.io() == IO.NON_BLOCKING) {
            return new NonBlockingOsxProcess(builder, this, (NonBlockingProcessListener)listener);
        }
        if (SystemUtils.IS_OS_WINDOWS && builder.io() == IO.NON_BLOCKING) {
            return new NonBlockingWindowsProcess(builder, this, (NonBlockingProcessListener)listener);
        }
        return null;
    }

    public int getLingerIterations() {
        return this.lingerTimeMs / this.deadPoolPollMs;
    }
}

