/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl.nonblocking;

import com.sshtools.forker.client.EffectiveUser;
import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.NonBlockingProcessListener;
import com.sshtools.forker.client.impl.jna.win32.Kernel32;
import com.sshtools.forker.client.impl.nonblocking.IEventProcessor;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingBasePosixProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcessFactory;
import com.sshtools.forker.client.impl.nonblocking.ProcessCompletions;
import com.sshtools.forker.client.impl.nonblocking.WindowsCreateProcessEscape;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NonBlockingWindowsProcess
extends NonBlockingProcess {
    protected static final Logger LOGGER = Logger.getLogger(NonBlockingBasePosixProcess.class.getCanonicalName());
    private static final int BUFFER_SIZE = 65536;
    private static int processorRoundRobin;
    private static final String namedPipePathPrefix;
    private static final AtomicInteger namedPipeCounter;
    private volatile IEventProcessor<NonBlockingWindowsProcess> myProcessor;
    AtomicBoolean userWantsWrite = new AtomicBoolean();
    private volatile boolean writePending;
    private AtomicBoolean stdinClosing = new AtomicBoolean();
    private volatile PipeBundle stdinPipe;
    private volatile PipeBundle stdoutPipe;
    private volatile PipeBundle stderrPipe;
    private WinNT.HANDLE hStdinWidow;
    private WinNT.HANDLE hStdoutWidow;
    private WinNT.HANDLE hStderrWidow;
    private final ByteBuffer pendingWriteStdinClosedTombstone = ByteBuffer.allocate(1);
    private volatile boolean inClosed = true;
    private volatile boolean outClosed = true;
    private volatile boolean errClosed = true;
    private WinBase.PROCESS_INFORMATION processInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonBlockingWindowsProcess(ForkerBuilder builder, NonBlockingProcessFactory factory, NonBlockingProcessListener listener) throws IOException {
        super(builder, factory, listener);
        EffectiveUser effectiveUser = builder.effectiveUser();
        if (effectiveUser != null) {
            effectiveUser.elevate(builder, null, builder.getCommand());
        }
        try {
            try {
                char[] cwdChars;
                this.createPipes();
                char[] block = this.getEnvironment(NonBlockingWindowsProcess.mapToArray(builder.environment()));
                Memory env = new Memory((long)(block.length * 3));
                env.write(0L, block, 0, block.length);
                WinBase.STARTUPINFO startupInfo = new WinBase.STARTUPINFO();
                startupInfo.clear();
                startupInfo.cb = new WinDef.DWORD((long)startupInfo.size());
                startupInfo.hStdInput = this.hStdinWidow;
                startupInfo.hStdError = this.hStderrWidow;
                startupInfo.hStdOutput = this.hStdoutWidow;
                startupInfo.dwFlags = 256;
                this.processInfo = new WinBase.PROCESS_INFORMATION();
                WinDef.DWORD dwCreationFlags = new WinDef.DWORD(0x8000404L);
                char[] cArray = cwdChars = builder.directory() != null ? Native.toCharArray((String)builder.directory().toPath().toAbsolutePath().toString()) : null;
                if (!Kernel32.INSTANCE.CreateProcessW(null, this.getCommandLine(builder.command()), null, null, true, dwCreationFlags, (Pointer)env, cwdChars, startupInfo, this.processInfo)) {
                    int lastError = Native.getLastError();
                    throw new IOException("CreateProcessW() failed, error: " + lastError);
                }
                this.initializeBuffers();
                this.registerProcess();
                Kernel32.INSTANCE.ResumeThread(this.processInfo.hThread);
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(this.hStdinWidow);
                Kernel32.INSTANCE.CloseHandle(this.hStdoutWidow);
                Kernel32.INSTANCE.CloseHandle(this.hStderrWidow);
            }
        }
        finally {
            if (effectiveUser != null) {
                effectiveUser.descend(builder, null, builder.getCommand());
            }
        }
    }

    @Override
    protected IEventProcessor<? extends NonBlockingProcess> createProcessor() {
        return new ProcessCompletions(this.factory);
    }

    @Override
    public void wantWrite() {
        if (this.hStdinWidow != null && !WinNT.INVALID_HANDLE_VALUE.getPointer().equals((Object)this.hStdinWidow.getPointer())) {
            this.userWantsWrite.set(true);
            this.myProcessor.wantWrite(this);
        }
    }

    @Override
    public synchronized void writeStdin(ByteBuffer buffer) {
        if (this.hStdinWidow != null && !WinNT.INVALID_HANDLE_VALUE.getPointer().equals((Object)this.hStdinWidow.getPointer())) {
            this.pendingWrites.add(buffer);
            if (!this.writePending) {
                this.myProcessor.wantWrite(this);
            }
        } else {
            throw new IllegalStateException("closeStdin() method has already been called.");
        }
    }

    @Override
    public void closeStdin(boolean force) {
        if (force) {
            this.stdinClose();
        } else if (this.stdinClosing.compareAndSet(false, true)) {
            this.pendingWrites.add(this.pendingWriteStdinClosedTombstone);
            if (!this.writePending) {
                this.myProcessor.wantWrite(this);
            }
        } else {
            throw new IllegalStateException("closeStdin() method has already been called.");
        }
    }

    @Override
    public boolean hasPendingWrites() {
        return !this.pendingWrites.isEmpty();
    }

    @Override
    public void destroy() {
        Kernel32.INSTANCE.TerminateProcess(this.processInfo.hProcess, Integer.MAX_VALUE);
    }

    @Override
    public int getPID() {
        return Kernel32.INSTANCE.GetProcessId(this.getPidHandle());
    }

    WinNT.HANDLE getPidHandle() {
        return this.processInfo.hProcess;
    }

    PipeBundle getStdinPipe() {
        return this.stdinPipe;
    }

    PipeBundle getStdoutPipe() {
        return this.stdoutPipe;
    }

    PipeBundle getStderrPipe() {
        return this.stderrPipe;
    }

    void readStdout(int transferred) {
        if (this.outClosed) {
            return;
        }
        try {
            if (transferred < 0) {
                this.outClosed = true;
                this.stdoutPipe.buffer.flip();
                if (this.listener != null) {
                    this.listener.onStdout(this, this.stdoutPipe.buffer, true);
                }
                return;
            }
            if (transferred == 0) {
                return;
            }
            ByteBuffer buffer = this.stdoutPipe.buffer;
            buffer.limit(buffer.position() + transferred);
            buffer.position(0);
            if (this.listener != null) {
                this.listener.onStdout(this, buffer, false);
            }
            buffer.compact();
        }
        catch (Exception e) {
            if (this.listener == null) {
                LOGGER.log(Level.WARNING, "Exception thrown from handler", e);
            }
            this.listener.onError(e, this, false);
        }
        if (!this.stdoutPipe.buffer.hasRemaining()) {
            throw new RuntimeException("stdout buffer has no bytes remaining");
        }
    }

    void readStderr(int transferred) {
        if (this.errClosed) {
            return;
        }
        try {
            if (transferred < 0) {
                this.errClosed = true;
                this.stderrPipe.buffer.flip();
                if (this.listener != null) {
                    if (this.builder.redirectErrorStream()) {
                        this.listener.onStdout(this, this.stderrPipe.buffer, true);
                    } else {
                        this.listener.onStderr(this, this.stderrPipe.buffer, true);
                    }
                }
                return;
            }
            if (transferred == 0) {
                return;
            }
            ByteBuffer buffer = this.stderrPipe.buffer;
            buffer.limit(buffer.position() + transferred);
            buffer.position(0);
            if (this.listener != null) {
                if (this.builder.redirectErrorStream()) {
                    this.listener.onStdout(this, buffer, false);
                } else {
                    this.listener.onStderr(this, buffer, false);
                }
            }
            buffer.compact();
        }
        catch (Exception e) {
            if (this.listener == null) {
                LOGGER.log(Level.WARNING, "Exception thrown from handler", e);
            }
            this.listener.onError(e, this, false);
        }
        if (!this.stderrPipe.buffer.hasRemaining()) {
            throw new RuntimeException("stderr buffer has no bytes remaining");
        }
    }

    boolean writeStdin(int transferred) {
        if (this.writePending && transferred == 0) {
            return false;
        }
        this.stdinPipe.buffer.position(this.stdinPipe.buffer.position() + transferred);
        if (this.stdinPipe.buffer.hasRemaining()) {
            Kernel32.INSTANCE.WriteFile(this.stdinPipe.pipeHandle, this.stdinPipe.buffer, this.stdinPipe.buffer.remaining(), null, this.stdinPipe.overlapped);
            this.writePending = true;
            return false;
        }
        this.writePending = false;
        if (!this.pendingWrites.isEmpty()) {
            this.stdinPipe.buffer.clear();
            ByteBuffer byteBuffer = (ByteBuffer)this.pendingWrites.peek();
            if (byteBuffer == this.pendingWriteStdinClosedTombstone) {
                this.closeStdin(true);
                this.userWantsWrite.set(false);
                this.pendingWrites.clear();
                return false;
            }
            if (byteBuffer.remaining() > BUFFER_CAPACITY) {
                ByteBuffer slice = byteBuffer.slice();
                slice.limit(BUFFER_CAPACITY);
                this.stdinPipe.buffer.put(slice);
                byteBuffer.position(byteBuffer.position() + BUFFER_CAPACITY);
            } else {
                this.stdinPipe.buffer.put(byteBuffer);
                this.pendingWrites.poll();
            }
            this.stdinPipe.buffer.flip();
            if (this.stdinPipe.buffer.hasRemaining()) {
                return true;
            }
        }
        if (this.userWantsWrite.compareAndSet(true, false)) {
            try {
                ByteBuffer buffer = this.stdinPipe.buffer;
                buffer.clear();
                if (this.listener != null) {
                    this.userWantsWrite.set(this.listener.onStdinReady(this, buffer));
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    void onExit(int statusCode) {
        if (this.exitPending.getCount() == 0L) {
            return;
        }
        try {
            this.isRunning = false;
            this.exitCode.set(statusCode);
            if (this.stdoutPipe != null && this.stdoutPipe.buffer != null && !this.outClosed) {
                this.stdoutPipe.buffer.flip();
                if (this.listener != null) {
                    this.listener.onStdout(this, this.stdoutPipe.buffer, true);
                }
            }
            if (this.stderrPipe != null && this.stderrPipe.buffer != null && !this.errClosed) {
                this.stderrPipe.buffer.flip();
                if (this.listener != null) {
                    if (this.builder.redirectErrorStream()) {
                        this.listener.onStdout(this, this.stderrPipe.buffer, true);
                    } else {
                        this.listener.onStderr(this, this.stderrPipe.buffer, true);
                    }
                }
            }
            if (statusCode != 0x7FFFFFFE && this.listener != null) {
                this.listener.onExit(statusCode, this);
            }
        }
        catch (Exception e) {
            if (this.listener == null) {
                LOGGER.log(Level.SEVERE, "Failed to handle exit gracefully.", e);
            } else {
                this.listener.onError(e, this, true);
            }
        }
        finally {
            this.exitPending.countDown();
            if (this.stdinPipe != null) {
                if (!this.inClosed) {
                    Kernel32.INSTANCE.CloseHandle(this.stdinPipe.pipeHandle);
                }
                this.stdinPipe.buffer = null;
            }
            if (this.stdoutPipe != null) {
                Kernel32.INSTANCE.CloseHandle(this.stdoutPipe.pipeHandle);
                this.stdoutPipe.buffer = null;
            }
            if (this.stderrPipe != null) {
                Kernel32.INSTANCE.CloseHandle(this.stderrPipe.pipeHandle);
                this.stderrPipe.buffer = null;
            }
            if (this.processInfo != null) {
                Kernel32.INSTANCE.CloseHandle(this.processInfo.hThread);
                Kernel32.INSTANCE.CloseHandle(this.processInfo.hProcess);
            }
            this.stderrPipe = null;
            this.stdoutPipe = null;
            this.stdinPipe = null;
        }
    }

    boolean isSoftExit() {
        return this.outClosed && this.errClosed && this.factory.isSoftExitDetection();
    }

    void stdinClose() {
        if (!this.inClosed && this.stdinPipe != null) {
            Kernel32.INSTANCE.CloseHandle(this.stdinPipe.pipeHandle);
        }
        this.inClosed = true;
    }

    private void createPipes() {
        WinBase.SECURITY_ATTRIBUTES sattr = new WinBase.SECURITY_ATTRIBUTES();
        sattr.dwLength = new WinDef.DWORD((long)sattr.size());
        sattr.bInheritHandle = true;
        sattr.lpSecurityDescriptor = null;
        long ioCompletionKey = namedPipeCounter.getAndIncrement();
        WString pipeName = new WString(namedPipePathPrefix + ioCompletionKey);
        this.hStdoutWidow = Kernel32.INSTANCE.CreateNamedPipeW(pipeName, 1, 0, 1, 65536, 65536, 0, sattr);
        this.checkHandleValidity(this.hStdoutWidow);
        WinNT.HANDLE stdoutHandle = Kernel32.INSTANCE.CreateFile(pipeName, Integer.MIN_VALUE, 1, null, 3, 0x40000080, null);
        this.checkHandleValidity(stdoutHandle);
        this.stdoutPipe = new PipeBundle(stdoutHandle, ioCompletionKey);
        this.checkPipeConnected(Kernel32.INSTANCE.ConnectNamedPipe(this.hStdoutWidow, null));
        ioCompletionKey = namedPipeCounter.getAndIncrement();
        pipeName = new WString(namedPipePathPrefix + ioCompletionKey);
        this.hStderrWidow = Kernel32.INSTANCE.CreateNamedPipeW(pipeName, 1, 0, 1, 65536, 65536, 0, sattr);
        this.checkHandleValidity(this.hStderrWidow);
        WinNT.HANDLE stderrHandle = Kernel32.INSTANCE.CreateFile(pipeName, Integer.MIN_VALUE, 1, null, 3, 0x40000080, null);
        this.checkHandleValidity(stderrHandle);
        this.stderrPipe = new PipeBundle(stderrHandle, ioCompletionKey);
        this.checkPipeConnected(Kernel32.INSTANCE.ConnectNamedPipe(this.hStderrWidow, null));
        ioCompletionKey = namedPipeCounter.getAndIncrement();
        pipeName = new WString(namedPipePathPrefix + ioCompletionKey);
        this.hStdinWidow = Kernel32.INSTANCE.CreateNamedPipeW(pipeName, 2, 0, 1, 65536, 65536, 0, sattr);
        this.checkHandleValidity(this.hStdinWidow);
        WinNT.HANDLE stdinHandle = Kernel32.INSTANCE.CreateFile(pipeName, 0x40000000, 2, null, 3, 0x40000080, null);
        this.checkHandleValidity(stdinHandle);
        this.stdinPipe = new PipeBundle(stdinHandle, ioCompletionKey);
        this.checkPipeConnected(Kernel32.INSTANCE.ConnectNamedPipe(this.hStdinWidow, null));
    }

    protected void initializeBuffers() {
        super.inializeBuffers();
        this.pendingWrites = new ConcurrentLinkedQueue();
        this.outClosed = false;
        this.errClosed = false;
        this.inClosed = false;
        this.isRunning = true;
        this.stdoutPipe.buffer = ByteBuffer.allocateDirect(BUFFER_CAPACITY);
        this.stderrPipe.buffer = ByteBuffer.allocateDirect(BUFFER_CAPACITY);
        this.stdinPipe.buffer = ByteBuffer.allocateDirect(BUFFER_CAPACITY);
        this.stdinPipe.buffer.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProcess() {
        int mySlot = 0;
        List<IEventProcessor<? extends NonBlockingProcess>> list = this.factory.getProcessors(this);
        synchronized (list) {
            mySlot = processorRoundRobin;
            processorRoundRobin = (processorRoundRobin + 1) % this.factory.getProcessors(this).size();
        }
        this.myProcessor = this.factory.getProcessors(this).get(mySlot);
        this.myProcessor.registerProcess(this);
        if (this.myProcessor.checkAndSetRunning()) {
            CyclicBarrier spawnBarrier = this.myProcessor.getSpawnBarrier();
            Thread t = new Thread(this.myProcessor, "ProcessIoCompletion" + mySlot);
            t.setDaemon(true);
            t.start();
            try {
                spawnBarrier.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private char[] getCommandLine(List<String> commands) {
        StringBuilder sb = new StringBuilder();
        boolean isFirstCommand = true;
        for (String command : commands) {
            if (isFirstCommand) {
                isFirstCommand = false;
            } else {
                sb.append(' ');
            }
            WindowsCreateProcessEscape.quote(sb, command);
        }
        return Native.toCharArray((String)sb.toString());
    }

    private char[] getEnvironment(String[] environment) {
        HashMap<String, String> env = new HashMap<String, String>();
        String SYSTEMROOT = "SystemRoot";
        String systemRootValue = System.getenv("SystemRoot");
        if (systemRootValue != null) {
            env.put("SystemRoot", systemRootValue);
        }
        for (String entry : environment) {
            int ndx = entry.indexOf(61);
            if (ndx == -1) continue;
            env.put(entry.substring(0, ndx), ndx < entry.length() ? entry.substring(ndx + 1) : "");
        }
        return this.getEnvironmentBlock(env).toCharArray();
    }

    private String getEnvironmentBlock(Map<String, String> env) {
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(env.entrySet());
        Collections.sort(list, new EntryComparator());
        StringBuilder sb = new StringBuilder(32 * env.size());
        for (Map.Entry entry : list) {
            sb.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('\u0000');
        }
        sb.append('\u0000').append('\u0000');
        return sb.toString();
    }

    private void checkHandleValidity(WinNT.HANDLE handle) {
        if (WinNT.INVALID_HANDLE_VALUE.getPointer().equals((Object)handle)) {
            throw new RuntimeException("Unable to create pipe, error " + Native.getLastError());
        }
    }

    private void checkPipeConnected(boolean status) {
        int lastError;
        if (!status && (lastError = Native.getLastError()) != 535) {
            throw new RuntimeException("Unable to connect pipe, error: " + lastError);
        }
    }

    static {
        namedPipePathPrefix = "\\\\.\\pipe\\Forker-" + UUID.randomUUID().toString() + "-";
        namedPipeCounter = new AtomicInteger(100);
    }

    static final class PipeBundle {
        final WinBase.OVERLAPPED overlapped;
        final long ioCompletionKey;
        final WinNT.HANDLE pipeHandle;
        ByteBuffer buffer;
        boolean registered;

        PipeBundle(WinNT.HANDLE pipeHandle, long ioCompletionKey) {
            this.pipeHandle = pipeHandle;
            this.ioCompletionKey = ioCompletionKey;
            this.overlapped = new WinBase.OVERLAPPED();
        }
    }

    private static final class EntryComparator
    implements Comparator<Map.Entry<String, String>> {
        static NameComparator nameComparator = new NameComparator();

        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
            return nameComparator.compare(e1.getKey(), e2.getKey());
        }
    }

    private static final class NameComparator
    implements Comparator<String> {
        private NameComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int len1 = s1.length();
            int len2 = s2.length();
            for (int i = 0; i < Math.min(len1, len2); ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }
    }
}

