/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl.nonblocking;

import com.sshtools.forker.client.impl.jna.win32.Kernel32;
import com.sshtools.forker.client.impl.nonblocking.IEventProcessor;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcess;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcessFactory;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingWindowsProcess;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ProcessCompletions
implements IEventProcessor<NonBlockingWindowsProcess> {
    private static final int DEADPOOL_POLL_INTERVAL;
    private static final int LINGER_ITERATIONS;
    private static final int STDOUT = 0;
    private static final int STDERR = 1;
    private WinNT.HANDLE ioCompletionPort;
    private List<NonBlockingWindowsProcess> deadPool;
    private BlockingQueue<NonBlockingWindowsProcess> pendingPool;
    private BlockingQueue<NonBlockingWindowsProcess> wantsWrite;
    private Map<Long, NonBlockingWindowsProcess> completionKeyToProcessMap;
    private volatile CyclicBarrier startBarrier;
    private volatile boolean shutdown;
    private AtomicBoolean isRunning;
    private IntByReference numberOfBytes;
    private BaseTSD.ULONG_PTRByReference completionKey;
    private PointerByReference lpOverlapped;
    private NonBlockingProcessFactory factory;

    ProcessCompletions(NonBlockingProcessFactory factory) {
        this.factory = factory;
        this.completionKeyToProcessMap = new HashMap<Long, NonBlockingWindowsProcess>();
        this.wantsWrite = new ArrayBlockingQueue<NonBlockingWindowsProcess>(512);
        this.pendingPool = new LinkedBlockingQueue<NonBlockingWindowsProcess>();
        this.deadPool = new LinkedList<NonBlockingWindowsProcess>();
        this.isRunning = new AtomicBoolean();
        this.numberOfBytes = new IntByReference();
        this.completionKey = new BaseTSD.ULONG_PTRByReference();
        this.lpOverlapped = new PointerByReference();
        this.initCompletionPort();
    }

    @Override
    public void run() {
        try {
            this.startBarrier.await();
            int idleCount = 0;
            while (!this.isRunning.compareAndSet(idleCount > LINGER_ITERATIONS && this.deadPool.isEmpty() && this.completionKeyToProcessMap.isEmpty(), false)) {
                idleCount = !this.shutdown && this.process() ? 0 : idleCount + 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process() {
        try {
            if (!Kernel32.INSTANCE.GetQueuedCompletionStatus(this.ioCompletionPort, this.numberOfBytes, this.completionKey, this.lpOverlapped, DEADPOOL_POLL_INTERVAL) && this.lpOverlapped.getValue() == null) {
                this.checkWaitWrites();
                this.checkPendingPool();
                boolean bl = false;
                return bl;
            }
            long key = this.completionKey.getValue().longValue();
            if (key == 0L) {
                this.checkWaitWrites();
                this.checkPendingPool();
                boolean bl = true;
                return bl;
            }
            NonBlockingWindowsProcess process = this.completionKeyToProcessMap.get(key);
            if (process == null) {
                boolean bl = true;
                return bl;
            }
            int transferred = this.numberOfBytes.getValue();
            if (process.getStdoutPipe() != null && process.getStdoutPipe().ioCompletionKey == key) {
                if (transferred > 0) {
                    process.readStdout(transferred);
                    this.queueRead(process, process.getStdoutPipe(), 0);
                } else {
                    process.readStdout(-1);
                }
            } else if (process.getStdinPipe() != null && process.getStdinPipe().ioCompletionKey == key) {
                if (process.writeStdin(transferred)) {
                    this.queueWrite(process);
                }
            } else if (process.getStderrPipe() != null && process.getStderrPipe().ioCompletionKey == key) {
                if (transferred > 0) {
                    process.readStderr(transferred);
                    this.queueRead(process, process.getStderrPipe(), 1);
                } else {
                    process.readStderr(-1);
                }
            }
            if (process.isSoftExit()) {
                this.cleanupProcess(process);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.checkDeadPool();
        }
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        Collection<NonBlockingWindowsProcess> processes = this.completionKeyToProcessMap.values();
        for (NonBlockingWindowsProcess process : processes) {
            Kernel32.INSTANCE.TerminateProcess(process.getPidHandle(), 0x7FFFFFFE);
            process.onExit(0x7FFFFFFE);
        }
    }

    @Override
    public CyclicBarrier getSpawnBarrier() {
        this.startBarrier = new CyclicBarrier(2);
        return this.startBarrier;
    }

    @Override
    public boolean checkAndSetRunning() {
        return this.isRunning.compareAndSet(false, true);
    }

    @Override
    public void wantWrite(NonBlockingProcess process) {
        try {
            this.wantsWrite.put((NonBlockingWindowsProcess)process);
            Kernel32.INSTANCE.PostQueuedCompletionStatus(this.ioCompletionPort, 0, new BaseTSD.ULONG_PTR(0L).toPointer(), null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void registerProcess(NonBlockingWindowsProcess process) {
        if (this.shutdown) {
            return;
        }
        try {
            this.pendingPool.put(process);
            Kernel32.INSTANCE.PostQueuedCompletionStatus(this.ioCompletionPort, 0, new BaseTSD.ULONG_PTR(0L).toPointer(), null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void queueWrite(NonBlockingWindowsProcess process) {
        if (this.shutdown) {
            return;
        }
        NonBlockingWindowsProcess.PipeBundle stdinPipe = process.getStdinPipe();
        if (!stdinPipe.registered) {
            WinNT.HANDLE completionPort = Kernel32.INSTANCE.CreateIoCompletionPort(stdinPipe.pipeHandle, this.ioCompletionPort, new BaseTSD.ULONG_PTR(stdinPipe.ioCompletionKey).toPointer(), this.factory.getNumberOfIOThreads());
            if (!this.ioCompletionPort.equals((Object)completionPort)) {
                throw new RuntimeException("CreateIoCompletionPort() failed, error code: " + Native.getLastError());
            }
            this.completionKeyToProcessMap.put(stdinPipe.ioCompletionKey, process);
            stdinPipe.registered = true;
        }
        if (Kernel32.INSTANCE.WriteFile(stdinPipe.pipeHandle, stdinPipe.buffer, 0, null, stdinPipe.overlapped) == 0 && Native.getLastError() != 997) {
            process.stdinClose();
        }
    }

    private void queueRead(NonBlockingWindowsProcess process, NonBlockingWindowsProcess.PipeBundle pipe, int stdX) {
        if (!pipe.buffer.hasRemaining()) {
            throw new RuntimeException("stdout / stderr buffer has no bytes remaining");
        }
        if (Kernel32.INSTANCE.ReadFile(pipe.pipeHandle, pipe.buffer, pipe.buffer.remaining(), null, pipe.overlapped) == 0) {
            int lastError = Native.getLastError();
            switch (lastError) {
                case 0: 
                case 997: {
                    break;
                }
                case 109: 
                case 233: {
                    if (stdX == 0) {
                        process.readStdout(-1);
                        break;
                    }
                    process.readStderr(-1);
                    break;
                }
                default: {
                    System.err.println("Some other error occurred reading the pipe: " + lastError);
                }
            }
        }
    }

    private void checkPendingPool() {
        NonBlockingWindowsProcess process;
        while ((process = (NonBlockingWindowsProcess)this.pendingPool.poll()) != null) {
            WinNT.HANDLE completionPort1 = Kernel32.INSTANCE.CreateIoCompletionPort(process.getStdoutPipe().pipeHandle, this.ioCompletionPort, new BaseTSD.ULONG_PTR(process.getStdoutPipe().ioCompletionKey).toPointer(), this.factory.getNumberOfIOThreads());
            if (!this.ioCompletionPort.equals((Object)completionPort1)) {
                throw new RuntimeException("CreateIoCompletionPort() failed, error code: " + Native.getLastError());
            }
            WinNT.HANDLE completionPort2 = Kernel32.INSTANCE.CreateIoCompletionPort(process.getStderrPipe().pipeHandle, this.ioCompletionPort, new BaseTSD.ULONG_PTR(process.getStderrPipe().ioCompletionKey).toPointer(), this.factory.getNumberOfIOThreads());
            if (!this.ioCompletionPort.equals((Object)completionPort2)) {
                throw new RuntimeException("CreateIoCompletionPort() failed, error code: " + Native.getLastError());
            }
            this.completionKeyToProcessMap.put(process.getStdoutPipe().ioCompletionKey, process);
            this.completionKeyToProcessMap.put(process.getStderrPipe().ioCompletionKey, process);
            this.queueRead(process, process.getStdoutPipe(), 0);
            this.queueRead(process, process.getStderrPipe(), 1);
        }
    }

    private void checkWaitWrites() {
        NonBlockingWindowsProcess process;
        while ((process = (NonBlockingWindowsProcess)this.wantsWrite.poll()) != null) {
            this.queueWrite(process);
        }
    }

    private void checkDeadPool() {
        if (this.deadPool.isEmpty()) {
            return;
        }
        IntByReference exitCode = new IntByReference();
        Iterator<NonBlockingWindowsProcess> iterator = this.deadPool.iterator();
        while (iterator.hasNext()) {
            NonBlockingWindowsProcess process = iterator.next();
            if (!Kernel32.INSTANCE.GetExitCodeProcess(process.getPidHandle(), exitCode) || exitCode.getValue() == 259) continue;
            iterator.remove();
            process.onExit(exitCode.getValue());
        }
    }

    private void cleanupProcess(NonBlockingWindowsProcess process) {
        this.completionKeyToProcessMap.remove(process.getStdinPipe().ioCompletionKey);
        this.completionKeyToProcessMap.remove(process.getStdoutPipe().ioCompletionKey);
        this.completionKeyToProcessMap.remove(process.getStderrPipe().ioCompletionKey);
        IntByReference exitCode = new IntByReference();
        if (Kernel32.INSTANCE.GetExitCodeProcess(process.getPidHandle(), exitCode) && exitCode.getValue() != 259) {
            process.onExit(exitCode.getValue());
        } else {
            this.deadPool.add(process);
        }
    }

    private void initCompletionPort() {
        this.ioCompletionPort = Kernel32.INSTANCE.CreateIoCompletionPort(WinNT.INVALID_HANDLE_VALUE, null, new BaseTSD.ULONG_PTR(0L).toPointer(), this.factory.getNumberOfIOThreads());
        if (this.ioCompletionPort == null) {
            throw new RuntimeException("CreateIoCompletionPort() failed, error code: " + Native.getLastError());
        }
    }

    static {
        int lingerTimeMs = Math.max(1000, Integer.getInteger("com.zaxxer.nuprocess.lingerTimeMs", 2500));
        DEADPOOL_POLL_INTERVAL = Math.min(lingerTimeMs, Math.max(100, Integer.getInteger("com.zaxxer.nuprocess.deadPoolPollMs", 250)));
        LINGER_ITERATIONS = lingerTimeMs / DEADPOOL_POLL_INTERVAL;
    }
}

