/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl.nonblocking;

import com.sshtools.forker.client.impl.jna.posix.LibC;
import com.sun.jna.LastErrorException;
import java.io.Closeable;

public class ReferenceCountedFileDescriptor
implements Closeable {
    private int fd;
    private int fdRefCount;
    private boolean closePending;

    public ReferenceCountedFileDescriptor(int fd) {
        this.fd = fd;
        this.fdRefCount = 0;
        this.closePending = false;
    }

    protected void finalize() {
        this.close();
    }

    public synchronized int acquire() {
        ++this.fdRefCount;
        return this.fd;
    }

    public synchronized void release() {
        --this.fdRefCount;
        if (this.fdRefCount == 0 && this.closePending && this.fd != -1) {
            this.doClose();
        }
    }

    @Override
    public synchronized void close() {
        if (this.fd == -1 || this.closePending) {
            return;
        }
        if (this.fdRefCount == 0) {
            this.doClose();
        } else {
            this.closePending = true;
        }
    }

    private void doClose() {
        try {
            LibC.close(this.fd);
            this.fd = -1;
        }
        catch (LastErrorException e) {
            throw new RuntimeException(e);
        }
    }
}

