/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.lightapi.util;

import com.taobao.hsf.lightapi.ServiceFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;

public class ReportUtil {
    private static volatile String IP;
    private static volatile String version;
    private static final String UNKNOWN_VERSION = "unknown";

    public static String getVersion() {
        if (version == null) {
            version = ReportUtil.getLightApiVersion();
        }
        return version;
    }

    public static String getIP() {
        if (IP == null) {
            IP = ReportUtil.getInetAddress();
        }
        return IP;
    }

    private static String getInetAddress() {
        try {
            String ip = System.getProperty("hsf.server.ip");
            if (StringUtils.isNotEmpty((String)ip)) {
                return ip;
            }
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                    return address.getHostAddress();
                }
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String getLightApiVersion() {
        String hackVersion = System.getProperty("hack.version");
        if (hackVersion != null) {
            return hackVersion;
        }
        Class<ServiceFactory> clazz = ServiceFactory.class;
        String jarName = UNKNOWN_VERSION;
        if (clazz.getProtectionDomain() != null && clazz.getProtectionDomain().getCodeSource() != null && clazz.getProtectionDomain().getCodeSource().getLocation() != null) {
            jarName = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        }
        if (!jarName.endsWith(".jar")) {
            return UNKNOWN_VERSION;
        }
        String jarDirectory = jarName.substring(0, jarName.lastIndexOf("/"));
        String version = jarDirectory.substring(jarDirectory.lastIndexOf("/") + 1, jarDirectory.length());
        return "LightApi-" + version;
    }

    public static void main(String[] args) {
        ReportUtil.getLightApiVersion();
    }
}

