/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.standalone;

import com.taobao.hsf.standalone.HSFMiniContainer;
import com.taobao.hsf.standalone.HSFStarter;
import com.taobao.hsf.standalone.sar.HSFSarUtil;
import com.taobao.hsf.standalone.util.Constant;
import com.taobao.hsf.standalone.util.IOUtil;
import java.io.File;
import java.util.Map;

public class HSFEasyStarter {
    public static final String DEFAULT_LIGHTAPI_HOME = System.getProperty("user.home") + "/lightapi";
    public static final String DEFAULT_RELEASE_PATH = DEFAULT_LIGHTAPI_HOME + "/release";

    @Deprecated
    public static void start() {
        HSFEasyStarter.startWithVersionAndIdentifier(Constant.version.get(), "default");
    }

    public static void start(String releasePath, String version) {
        if (releasePath == null || version == null) {
            throw new IllegalArgumentException("releasePath or version can't be null");
        }
        if (releasePath.trim().length() == 0) {
            releasePath = DEFAULT_RELEASE_PATH;
        }
        String sarBasePath = IOUtil.buildDirPath(releasePath, version);
        String sarPath = null;
        try {
            sarPath = HSFSarUtil.prepareHSFSar(sarBasePath, version);
            if (sarPath == null) {
                throw new RuntimeException("Prepare taobao-hsf.sar[" + version + "] under path[" + sarBasePath + "] failed");
            }
            HSFMiniContainer.start(sarPath);
        }
        catch (Exception e) {
            throw new RuntimeException("HSFMiniContainer.start(sarPath) fail, please check your sar under path: " + sarPath, e);
        }
    }

    public static void startFromPath(String releasePath) {
        HSFEasyStarter.start(releasePath, "");
    }

    public static void startWithVersion(String version) {
        HSFEasyStarter.startWithVersionAndIdentifier(version, "default");
    }

    @Deprecated
    public static void startWithIdentifier(String identifier) {
        HSFEasyStarter.startWithVersionAndIdentifier("", identifier);
    }

    public static void startWithVersionAndIdentifier(String version, String identifier) {
        String standaloneHome = DEFAULT_LIGHTAPI_HOME;
        String releasePath = DEFAULT_RELEASE_PATH;
        HSFEasyStarter.multiProcess(standaloneHome, identifier);
        HSFEasyStarter.start(releasePath, version);
    }

    public static void startWithVersionAndIdentifier(String version, String identifier, int port) {
        String standaloneHome = DEFAULT_LIGHTAPI_HOME;
        String releasePath = DEFAULT_RELEASE_PATH;
        HSFEasyStarter.multiProcess(standaloneHome, identifier);
        if (port != -1) {
            System.setProperty("hsf.server.port", Integer.toString(port));
        }
        HSFEasyStarter.start(releasePath, version);
    }

    private static void multiProcess(String standaloneHome, String identifier) {
        String osgiDir = standaloneHome + "/osgidir/" + identifier;
        String logsDir = standaloneHome + "/logs/" + identifier;
        String pandoraDir = standaloneHome + "/pandora/" + identifier;
        System.setProperty("hsf.configuration.dir", osgiDir);
        System.setProperty("HSF.LOG.PATH", logsDir);
        System.setProperty("com.taobao.pandora.tmp_path", pandoraDir);
        System.setProperty("pandora.qos.port", "0");
        Runtime.getRuntime().addShutdownHook(new TmpDirCleaner(osgiDir, pandoraDir));
    }

    @Deprecated
    public static Object getRemotingServiceWithoutSpring(String interfaceName, String serviceVersion, String group) {
        return HSFStarter.getRemotingServiceWithoutSpring(interfaceName, serviceVersion, group);
    }

    @Deprecated
    public static Object createProviderWithoutSpring(String interfaceName, String serviceVersion, Object serviceInstance, Map<String, String> stringSetterParam) {
        return HSFStarter.createProviderWithoutSpring(interfaceName, serviceVersion, serviceInstance, stringSetterParam);
    }

    public static void setDownloadUrl(String downloadUrl) {
        if (downloadUrl == null || downloadUrl.trim().length() == 0) {
            throw new IllegalArgumentException("downloadUrl cannot be null or empty");
        }
        Constant.perferDownloadUrl.set(downloadUrl);
    }

    public static void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version cannot be null");
        }
        Constant.version.set(version);
    }

    private static class TmpDirCleaner
    extends Thread {
        private String osgiDirPath;
        private String pandoraDirPath;

        public TmpDirCleaner(String osgiDirPath, String pandoraDirPath) {
            this.osgiDirPath = osgiDirPath;
            this.pandoraDirPath = pandoraDirPath;
        }

        @Override
        public void run() {
            IOUtil.deleteDir(new File(this.osgiDirPath));
            IOUtil.deleteDir(new File(this.pandoraDirPath));
        }
    }
}

