/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.standalone;

import com.taobao.hsf.standalone.sar.HSFSarUtil;
import com.taobao.hsf.standalone.util.Constant;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;

public class HSFStarter {
    private static Map<String, Class<?>> exportedClassMap;

    public static void startFromPropertyValue(String propertyName) {
        String sarPath = System.getProperty(propertyName);
        if (sarPath == null) {
            sarPath = System.getenv(propertyName);
        }
        if (sarPath == null) {
            throw new RuntimeException("\u6ca1\u6709\u8bbe\u5b9a\u53d8\u91cf[" + propertyName + "]\u7684\u503c");
        }
        try {
            HSFStarter.start(sarPath);
        }
        catch (Exception e) {
            throw new RuntimeException("start hsf fail.", e);
        }
    }

    public static void startFromHsfHome() {
        String sarPath = System.getProperty("user.home") + "/.hsf/release/";
        try {
            HSFStarter.start(sarPath);
        }
        catch (Exception e) {
            throw new RuntimeException("start hsf fail.", e);
        }
    }

    public static void start(String sarPath) throws Exception {
        HSFStarter.start(sarPath, HSFStarter.class.getClassLoader());
    }

    public static void start(String sarPath, ClassLoader bizClassLoader) throws Exception {
        URL[] sarJars = HSFSarUtil.listSarJar(sarPath);
        if (sarJars == null || sarJars.length == 0) {
            throw new RuntimeException("Build jars from sar failed.Please delete the directory of taobao-hsf.sar and re-start.");
        }
        HSFStarter.decideVersion(sarJars);
        URLClassLoader hsfParentLoader = new URLClassLoader(sarJars, HSFStarter.class.getClassLoader()){

            @Override
            public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Class<?> clazz = null;
                clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                if (name.startsWith("org.eclipse") || name.startsWith("org.osgi")) {
                    try {
                        clazz = this.findClass(name);
                        if (clazz != null) {
                            if (resolve) {
                                this.resolveClass(clazz);
                            }
                            return clazz;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                return super.loadClass(name, resolve);
            }
        };
        Class<?> containerClass = Class.forName("com.taobao.hsf.container.HSFContainer", true, hsfParentLoader);
        Method startMethod = containerClass.getMethod("start", String[].class);
        startMethod.invoke(null, new Object[]{new String[]{sarPath}});
        Method setThirdContainerClassLoaderMethod = containerClass.getMethod("setThirdContainerClassLoader", ClassLoader.class);
        setThirdContainerClassLoaderMethod.invoke(null, bizClassLoader);
        Thread.sleep(5000L);
        Method getExportedClassesMethod = containerClass.getMethod("getExportedClasses", null);
        exportedClassMap = (Map)getExportedClassesMethod.invoke(null, (Object[])null);
        if (exportedClassMap.size() < 5) {
            System.out.println("hsfstarter.log:exportedClassMap.size() < 5 !");
        }
        ClassLoader osgiLoader = exportedClassMap.get("com.taobao.hsf.app.spring.util.HSFSpringConsumerBean").getClassLoader();
        if (Constant.main_version == 1) {
            Class<?> serviceHolderClazz = Class.forName("com.taobao.hsf.app.spring.util.HSFServiceHolderComponent", true, osgiLoader);
            long startTime = System.currentTimeMillis();
            Object processService = HSFStarter.invokeStaticMethodWithoutParam(serviceHolderClazz, "getProcessService");
            while (processService == null) {
                Thread.sleep(200L);
                if (System.currentTimeMillis() - startTime > 3000L) break;
                processService = HSFStarter.invokeStaticMethodWithoutParam(serviceHolderClazz, "getProcessService");
            }
            if (processService == null) {
                throw new IllegalStateException("HSFServiceHolderComponent.getProcessService() return null");
            }
            startTime = System.currentTimeMillis();
            Object configService = HSFStarter.invokeReadField(processService, "configService");
            while (configService == null) {
                Thread.sleep(200L);
                if (System.currentTimeMillis() - startTime > 3000L) break;
                configService = HSFStarter.invokeReadField(processService, "configService");
            }
            if (configService != null) {
                HSFStarter.setConfigServiceRunModeToTest(configService);
            }
        } else {
            Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, osgiLoader);
        }
    }

    public static Class<?> getHSFSpringConsumerBean() {
        return exportedClassMap.get("com.taobao.hsf.app.spring.util.HSFSpringConsumerBean");
    }

    public static Class<?> getHSFSpringProviderBean() {
        return exportedClassMap.get("com.taobao.hsf.app.spring.util.HSFSpringProviderBean");
    }

    @Deprecated
    public static Object getRemotingServiceWithoutSpring(String interfaceName, String version, String group) {
        Class<?> realConsumerClass = HSFStarter.getHSFSpringConsumerBean();
        try {
            Object realConsumer = realConsumerClass.newInstance();
            Method stringSetter = realConsumerClass.getMethod("setInterfaceName", String.class);
            stringSetter.invoke(realConsumer, interfaceName);
            stringSetter = realConsumerClass.getMethod("setVersion", String.class);
            stringSetter.invoke(realConsumer, version);
            if (group != null) {
                stringSetter = realConsumerClass.getMethod("setGroup", String.class);
                stringSetter.invoke(realConsumer, group);
            }
            Method noParamMethod = realConsumerClass.getMethod("init", new Class[0]);
            noParamMethod.invoke(realConsumer, new Object[0]);
            noParamMethod = realConsumerClass.getMethod("getObject", new Class[0]);
            return noParamMethod.invoke(realConsumer, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("get service[" + interfaceName + "-" + version + "] fail", e);
        }
    }

    @Deprecated
    public static Object createProviderWithoutSpring(String interfaceName, String serviceVersion, Object serviceInstance, Map<String, String> stringSetterParam) {
        Class<?> providerBean = HSFStarter.getHSFSpringProviderBean();
        try {
            Object realProvider = providerBean.newInstance();
            Method stringSetter = providerBean.getMethod("setServiceInterface", String.class);
            stringSetter.invoke(realProvider, interfaceName);
            stringSetter = providerBean.getMethod("setServiceVersion", String.class);
            stringSetter.invoke(realProvider, serviceVersion);
            if (stringSetterParam != null) {
                for (String methodName : stringSetterParam.keySet()) {
                    stringSetter = providerBean.getMethod(methodName, String.class);
                    stringSetter.invoke(realProvider, stringSetterParam.get(methodName));
                }
            }
            Method objSetter = providerBean.getMethod("setTarget", Object.class);
            objSetter.invoke(realProvider, serviceInstance);
            Method noParamMethod = providerBean.getMethod("init", new Class[0]);
            noParamMethod.invoke(realProvider, new Object[0]);
            return realProvider;
        }
        catch (Exception e) {
            throw new RuntimeException("create service[" + interfaceName + "] fail", e);
        }
    }

    private static Object invokeStaticMethodWithoutParam(Class clazz, String methodName) throws Exception {
        Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method.invoke(null, null);
    }

    private static Object invokeReadField(Object instance, String fieldName) throws Exception {
        Class<?> clazz = instance.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    private static void setConfigServiceRunModeToTest(Object configService) throws Exception {
        Method method = configService.getClass().getDeclaredMethod("setRunmode", Integer.TYPE);
        method.setAccessible(true);
        method.invoke(configService, 0);
    }

    private static void decideVersion(URL[] sarJars) {
        for (URL url : sarJars) {
            if (!url.toString().contains("pandora")) continue;
            Constant.main_version = 2;
            return;
        }
    }
}

