/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import de.flapdoodle.embed.process.io.StreamProcessor;

public class StreamToLineProcessor
implements StreamProcessor {
    private final StreamProcessor destination;
    private final StringBuilder buffer = new StringBuilder();

    public StreamToLineProcessor(StreamProcessor destination) {
        this.destination = destination;
    }

    @Override
    public void process(String block) {
        int newLineEnd = block.indexOf(10);
        if (newLineEnd == -1) {
            this.buffer.append(block);
        } else {
            this.buffer.append(block.substring(0, newLineEnd + 1));
            this.destination.process(this.getAndClearBuffer());
            do {
                int lastEnd = newLineEnd;
                if ((newLineEnd = block.indexOf(10, newLineEnd + 1)) != -1) {
                    this.destination.process(block.substring(lastEnd + 1, newLineEnd + 1));
                    continue;
                }
                this.buffer.append(block.substring(lastEnd + 1));
            } while (newLineEnd != -1);
        }
    }

    private String getAndClearBuffer() {
        String ret = this.buffer.toString();
        this.buffer.setLength(0);
        return ret;
    }

    @Override
    public void onProcessed() {
        if (this.buffer.length() > 0) {
            this.destination.process(this.getAndClearBuffer());
        }
        this.destination.onProcessed();
    }

    public static StreamProcessor wrap(StreamProcessor destination) {
        return new StreamToLineProcessor(destination);
    }
}

