/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloAddable;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarType;
import ilog.concert.IloObjectiveSense;
import ilog.concert.IloQuadNumExpr;
import ilog.concert.IloRange;
import ilog.cplex.ByteArray;
import ilog.cplex.CachedArray;
import ilog.cplex.Cplex;
import ilog.cplex.CplexIndex;
import ilog.cplex.CplexInitializer;
import ilog.cplex.CpxAnd;
import ilog.cplex.CpxAsyncTab;
import ilog.cplex.CpxAsyncTabC;
import ilog.cplex.CpxBranchCallbackFunction;
import ilog.cplex.CpxCallback;
import ilog.cplex.CpxDeleteNodeCallbackFunction;
import ilog.cplex.CpxException;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxFailGoal;
import ilog.cplex.CpxGC;
import ilog.cplex.CpxGoalBranchCallback;
import ilog.cplex.CpxGoalIncumbentCallback;
import ilog.cplex.CpxGoalLazyConstraintCallback;
import ilog.cplex.CpxGoalNodeCallback;
import ilog.cplex.CpxGoalUserCutCallback;
import ilog.cplex.CpxHeuristicCallbackFunction;
import ilog.cplex.CpxIncumbentCallbackFunction;
import ilog.cplex.CpxIntSet;
import ilog.cplex.CpxIntSetCardVar;
import ilog.cplex.CpxIntSetVar;
import ilog.cplex.CpxLPCallbackFunction;
import ilog.cplex.CpxLPMatrix;
import ilog.cplex.CpxLazyConstraintCallbackFunction;
import ilog.cplex.CpxLinearNumExpr;
import ilog.cplex.CpxMIPCallbackFunction;
import ilog.cplex.CpxMIPInfoCallbackFunction;
import ilog.cplex.CpxNetCallbackFunction;
import ilog.cplex.CpxNode;
import ilog.cplex.CpxNodeCallbackFunction;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxNumVarBound;
import ilog.cplex.CpxObjective;
import ilog.cplex.CpxOrder;
import ilog.cplex.CpxQextractor;
import ilog.cplex.CpxRange;
import ilog.cplex.CpxSOS;
import ilog.cplex.CpxSOS1;
import ilog.cplex.CpxSOS2;
import ilog.cplex.CpxSolveCallbackFunction;
import ilog.cplex.CpxSubVar;
import ilog.cplex.CpxTuningCallbackFunction;
import ilog.cplex.CpxUserCutCallbackFunction;
import ilog.cplex.DoubleArray;
import ilog.cplex.IloCplex;
import ilog.cplex.IloCplexModeler;
import ilog.cplex.IndexManager;
import ilog.cplex.IntArray;
import ilog.cplex.NullOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class CplexI
extends Cplex {
    static final String IBM_COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5725-A06 5725-A29 5724-Y48 5724-Y49 5724-Y54 5724-Y55 5655-Y21\nCopyright IBM Corp. 2001, 2015 All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static final String encoding = "UTF8";
    private final CpxAsyncTab asynctab;
    private static CplexInitializer _cpxinit = null;
    private IloCplexModeler _modeler = null;
    private PrintStream _printOut;
    private PrintStream _printWarn;
    private OutputStream _out;
    private OutputStream _warn;
    private OutputStream _null;
    public static final double Infinity = 1.0E20;
    double bigReal;
    long _env;
    long _lp;
    int _status;
    String _error;
    boolean _fixBasis;
    int _registerAdd = -1;
    private static final boolean[] mayChangeNodeData = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false};
    private CpxCallback[] _cb = new CpxCallback[24];
    private boolean _installedDeleteNodeCB = false;
    private int[] _reduce = new int[1];
    private int[] _prelinear = new int[1];
    private int[] _mipcbredlp = new int[1];
    private int[] _advind = new int[1];
    private IndexManager[] _gcs;
    private IndexManager _rows;
    private IndexManager _qcs;
    private IndexManager _soss;
    private IndexManager _cols;
    private IndexManager _filters;
    private CpxOrder _ord;
    private int[] tmplen;
    private byte[] tmptype;
    private double[] tmplb;
    private double[] tmpub;
    static final int maxJNINames = 1000000;
    private double[] _xCache = null;
    private CachedArray _slack = new CachedArray();
    private CachedArray _qcslack = new CachedArray();
    private CachedArray _solnpoolX = new CachedArray();
    private CachedArray _solnpoolSlack = new CachedArray();
    private CachedArray _solnpoolQCSlack = new CachedArray();
    HashMap _grpMap;
    private IloCplex.Goal _lastGoal;
    private IloCplex.Goal _rootGoal;
    private CpxNode _rootNode;
    private ArrayList[] _globalCuts;
    private boolean _usesEval;
    Vector rowNameIndices = new Vector();
    Vector colNameIndices = new Vector();
    private boolean isRemoteEnv = false;
    Vector _filter = new Vector();
    private AborterI _abort;
    private InfoHandler infoHandler = null;

    static final byte[] getBytes(String string) {
        if (string != null) {
            byte[] byArray = null;
            try {
                byArray = string.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            if (byArray != null) {
                int n = byArray.length;
                byte[] byArray2 = new byte[n + 1];
                for (int i = 0; i < n; ++i) {
                    byArray2[i] = byArray[i];
                }
                byArray2[n] = 0;
                return byArray2;
            }
        }
        return null;
    }

    static final String getString(byte[] byArray) {
        int n = 0;
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        try {
            return new String(byArray, 0, n, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, 0, n);
        }
    }

    final void setIloCplex(IloCplex iloCplex) {
        this._modeler = iloCplex;
    }

    final IloCplexModeler getModeler() {
        return this._modeler;
    }

    final void checkCplexI(CpxExtractable cpxExtractable) throws IloException {
        if (cpxExtractable._cplexi != null && cpxExtractable._cplexi != this) {
            throw new IloCplex.MultipleUseException();
        }
    }

    final long getEnv() {
        return this._env;
    }

    final long getLP() {
        return this._lp;
    }

    private void output(String string) {
        try {
            if (this.output() != null) {
                this.output().write(CplexI.getBytes(string));
            }
        }
        catch (Exception exception) {
            System.err.println("WARNING: Could not print message: " + string);
            System.err.println("to IloCplex.output() due to exception " + exception);
        }
    }

    private void warn(String string) {
        try {
            if (this.warning() != null) {
                this.warning().write(CplexI.getBytes(string));
            }
        }
        catch (Exception exception) {
            System.err.println("WARNING: Could not print warning message: " + string);
            System.err.println("to IloCplex.warn() due to exception " + exception);
        }
    }

    final void initCallbacks() throws IloException {
        int n;
        int n2 = CplexI.CPXEgetmaxthreads(this._env);
        CplexI.CPXgetintparam(this._env, 1001, this._advind);
        CplexI.CPXgetintparam(this._env, 2055, this._mipcbredlp);
        CplexI.CPXgetintparam(this._env, 1057, this._reduce);
        CplexI.CPXgetintparam(this._env, 1058, this._prelinear);
        if (this._rootGoal != null || this._lastGoal != null) {
            CplexI.CPXsetintparam(this._env, 1001, 0);
        }
        this._lastGoal = this._rootGoal;
        boolean bl = false;
        for (n = 0; n < this._cb.length; ++n) {
            bl = bl || mayChangeNodeData[n] && this._cb[n] != null;
        }
        if (bl) {
            if (!this._installedDeleteNodeCB) {
                this.CALL(CplexI.CPXsetdeletenodecallbackfunc(this._env, new CpxDeleteNodeCallbackFunction(), this));
                this._installedDeleteNodeCB = true;
            }
        } else if (this._installedDeleteNodeCB) {
            this.CALL(CplexI.CPXsetdeletenodecallbackfunc(this._env, null, null));
            this._installedDeleteNodeCB = false;
        }
        n = 1;
        boolean bl2 = false;
        for (int i = 0; i < this._cb.length; ++i) {
            if (this._cb[i] == null) continue;
            this._cb[i]._abort = false;
            this._cb[i]._exception = null;
            n |= this._cb[i].initThreads(n2, this.getNcols());
            bl2 = true;
        }
        if (n == 0) {
            this.warning().print("Could not initialize callbacks for multi-threading; switching back to sequential CPLEX");
            this.setIntParam(1067, 1);
        }
        if (bl2) {
            CplexI.CPXsetintparam(this._env, 2055, 0);
        }
        if (this._cb[15] != null) {
            CplexI.CPXsetintparam(this._env, 1058, 0);
        }
    }

    final void finitCallbacks() {
        CplexI.CPXsetintparam(this._env, 1001, this._advind[0]);
        CplexI.CPXsetintparam(this._env, 1057, this._reduce[0]);
        CplexI.CPXsetintparam(this._env, 1058, this._prelinear[0]);
        CplexI.CPXsetintparam(this._env, 2055, this._mipcbredlp[0]);
    }

    final void checkCallbacks() throws IloException {
        for (int i = 0; i < this._cb.length; ++i) {
            if (this._cb[i] == null) continue;
            this._cb[i].checkException();
        }
    }

    void setCallback(CpxCallback cpxCallback) throws IloException {
        int n = cpxCallback.getCBType();
        int n2 = 0;
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                n2 = CplexI.CPXsetlpcallbackfunc(this.getEnv(), new CpxLPCallbackFunction(), this);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = CplexI.CPXsetmipcallbackfunc(this.getEnv(), new CpxMIPCallbackFunction(), this);
                break;
            }
            case 5: {
                n2 = CplexI.CPXsetnetcallbackfunc(this.getEnv(), new CpxNetCallbackFunction(), this);
                break;
            }
            case 11: {
                CpxBranchCallbackFunction cpxBranchCallbackFunction = new CpxBranchCallbackFunction();
                n2 = CplexI.CPXsetbranchcallbackfunc(this.getEnv(), cpxBranchCallbackFunction, this);
                if (n2 != 0) {
                    throw new CpxException(n2, this._getErrorMessage(n2));
                }
                n2 = CplexI.CPXsetbranchnosolncallbackfunc(this.getEnv(), cpxBranchCallbackFunction, this);
                CplexI.CPXsetintparam(this._env, 1057, 1);
                CplexI.CPXsetintparam(this._env, 1058, 0);
                break;
            }
            case 12: {
                n2 = CplexI.CPXsetusercutcallbackfunc(this.getEnv(), new CpxUserCutCallbackFunction(), this);
                break;
            }
            case 13: {
                n2 = CplexI.CPXsetlazyconstraintcallbackfunc(this.getEnv(), new CpxLazyConstraintCallbackFunction(), this);
                break;
            }
            case 15: {
                n2 = CplexI.CPXsetheuristiccallbackfunc(this.getEnv(), new CpxHeuristicCallbackFunction(), this);
                break;
            }
            case 16: {
                n2 = CplexI.CPXsetincumbentcallbackfunc(this.getEnv(), new CpxIncumbentCallbackFunction(), this);
                break;
            }
            case 14: {
                n2 = CplexI.CPXsetnodecallbackfunc(this.getEnv(), new CpxNodeCallbackFunction(), this);
                break;
            }
            case 17: {
                n2 = CplexI.CPXsetsolvecallbackfunc(this.getEnv(), new CpxSolveCallbackFunction(), this);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = CplexI.CPXsetinfocallbackfunc(this.getEnv(), new CpxMIPInfoCallbackFunction(), this);
                break;
            }
            case 23: {
                n2 = CplexI.CPXsettuningcallbackfunc(this.getEnv(), new CpxTuningCallbackFunction(), this);
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if (n2 != 0) {
            throw new CpxException(n2, this._getErrorMessage(n2));
        }
        if (n == -1) {
            this._cb[1] = cpxCallback;
            this._cb[2] = cpxCallback;
        } else {
            this._cb[n] = cpxCallback;
        }
    }

    void clearCallbacks() {
        for (int i = 0; i < this._cb.length; ++i) {
            if (this._cb[i] == null) continue;
            this._cb[i].setCplex(null);
            this._cb[i] = null;
        }
        CplexI.CPXsetlpcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetmipcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetnetcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetbranchcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetbranchnosolncallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetusercutcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetlazyconstraintcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetheuristiccallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetincumbentcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetnodecallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetsolvecallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetinfocallbackfunc(this.getEnv(), null, null);
    }

    CpxCallback getCallback(int n, int n2) {
        CpxCallback cpxCallback = this._cb[n];
        for (int i = 0; i < n2; ++i) {
            if (cpxCallback == null) {
                return null;
            }
            cpxCallback = cpxCallback._next;
        }
        return cpxCallback;
    }

    void callFinit() {
        if (this._env != 0L) {
            CplexI.lockILM(this);
        }
        this._env = 0L;
    }

    protected void finalize() {
        this.callFinit();
    }

    public CplexI(boolean bl) {
        this._env = 0L;
        this._lp = 0L;
        this._null = null;
        this._out = null;
        this._warn = null;
        this._printOut = null;
        this._printWarn = null;
        this.infoHandler = null;
        this._cb = null;
        this._gcs = null;
        this._rows = null;
        this._qcs = null;
        this._soss = null;
        this._cols = null;
        this._filters = null;
        this._ord = null;
        this.asynctab = null;
    }

    public CplexI() throws IloException {
        this(false, null, null);
    }

    public CplexI(boolean bl, String string, String[] stringArray) throws IloException {
        if (bl) {
            this.init(string, stringArray);
        } else {
            this.init();
        }
        this.tmplen = new int[2];
        this.tmptype = new byte[1];
        this.tmplb = new double[1];
        this.tmpub = new double[1];
        this._gcs = new IndexManager[27];
        for (int i = 0; i < 27; ++i) {
            this._gcs[i] = new IndexManager();
        }
        this._rows = this._gcs[3];
        this._qcs = this._gcs[4];
        this._soss = this._gcs[5];
        this._cols = new IndexManager();
        this._filters = new IndexManager();
        this._ord = new CpxOrder();
        this.asynctab = bl ? new CpxAsyncTabC() : null;
        this.infoHandler = null;
        this._null = new NullOutput();
        this._out = System.out;
        this._warn = System.err;
        this._printOut = new PrintStream(this._out);
        this._printWarn = new PrintStream(this._warn);
    }

    public PrintStream output() {
        return this._printOut;
    }

    public PrintStream warning() {
        return this._printWarn;
    }

    public void setOut(OutputStream outputStream) {
        this._out = outputStream != null ? outputStream : this._null;
        this._printOut = new PrintStream(this._out);
    }

    public void setWarning(OutputStream outputStream) {
        this._warn = outputStream != null ? outputStream : this._null;
        this._printWarn = new PrintStream(this._warn);
    }

    private final String probName() {
        String string = null;
        String string2 = "ilog.cplex";
        if (this._modeler == null || this._modeler._model == null) {
            return string2;
        }
        try {
            string = this._modeler._model.getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            string = string2;
        }
        return string;
    }

    final boolean isQC(CpxRange cpxRange) {
        return this._qcs.getObject(cpxRange.getIndexValue()) == cpxRange;
    }

    public boolean isMIP() {
        int n = this.getProbType();
        return n == 1 || n == 7 || n == 11 || n == 3 || n == 8 || n == 4 || n == 9 || n == 12;
    }

    public boolean isQO() {
        int n = this.getProbType();
        if (this.isQC()) {
            return this._modeler._model._obj != null && this._modeler._model._obj._expr != null && this._modeler._model._obj._expr.getQuadNum() > 0;
        }
        return n == 5 || n == 7 || n == 8 || n == 9;
    }

    public boolean isQC() {
        int n = this.getProbType();
        return n == 10 || n == 11 || n == 12;
    }

    void exportModel(String string, IloCplex iloCplex) throws IloException {
        this.flushNames();
        this._writeModel(string);
    }

    static void importModel(String string, IloCplex iloCplex) throws IloException {
        int n;
        Serializable serializable;
        Object[] objectArray;
        int n2;
        Object object;
        int[] nArray;
        Object[] objectArray2;
        Object object2;
        Object object3;
        Object object4;
        int n3;
        iloCplex.clearModel();
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloCplex.addLPMatrix(string);
        CplexI cplexI = cpxLPMatrix.getCplexI();
        cplexI._readModel(string);
        int n4 = cplexI._getNrows();
        CpxRange[] cpxRangeArray = new CpxRange[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            object4 = new CplexIndex(n3);
            cpxRangeArray[n3] = new CpxRange((CplexIndex)object4, null);
            cplexI._rows.addIndex((CplexIndex)object4, cpxRangeArray[n3]);
            cpxRangeArray[n3].setCplexI(cplexI);
        }
        cpxLPMatrix.addRows(cpxRangeArray, n4);
        n3 = cplexI._getNcols();
        object4 = new double[n3];
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        byte[] byArray = new byte[n3];
        cplexI._getVariables(n3, (double[])object4, dArray, dArray2, byArray);
        IloNumVar[] iloNumVarArray = new CpxNumVar[n3];
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] == 67) {
                iloNumVarArray[i] = (CpxNumVar)iloCplex.numVar(dArray[i], dArray2[i]);
                continue;
            }
            if (byArray[i] == 66) {
                iloNumVarArray[i] = (CpxNumVar)iloCplex.numVar(dArray[i], dArray2[i], IloNumVarType.Bool, null);
                continue;
            }
            if (byArray[i] == 73) {
                iloNumVarArray[i] = (CpxNumVar)iloCplex.numVar(dArray[i], dArray2[i], IloNumVarType.Int, null);
                continue;
            }
            if (byArray[i] == 83) {
                iloNumVarArray[i] = (CpxNumVar)((Object)iloCplex.semiContVar(dArray[i], dArray2[i], IloNumVarType.Float));
                continue;
            }
            if (byArray[i] == 78) {
                iloNumVarArray[i] = (CpxNumVar)((Object)iloCplex.semiContVar(dArray[i], dArray2[i], IloNumVarType.Int));
                continue;
            }
            throw new CpxException(-1, "CPLEX error in importModel(): unsupported variable type");
        }
        Vector<IloConstraint> vector = new Vector<IloConstraint>();
        int n5 = cplexI._getNinds();
        if (n5 > 0) {
            int n6;
            int[] nArray2 = new int[]{-1};
            object3 = new int[]{-1};
            double[] dArray3 = new double[]{0.0};
            byte[] byArray2 = new byte[]{69};
            object2 = new int[]{-1};
            objectArray2 = new int[]{-1};
            nArray = new int[]{-1};
            object = new boolean[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                object[n6] = 0;
                n2 = CplexI.CPXEgetindicator(cplexI._env, cplexI._lp, nArray2, (int[])object3, (int[])object2, dArray3, byArray2, null, null, 0, (int[])objectArray2, nArray, n6);
                if (n2 != 0 && n2 != 1207) {
                    cplexI.CALL(n2);
                }
                if (objectArray2[0] > 0 || nArray2[0] < 0 || object3[0] != false || nArray[0] != 3) continue;
                double d = Double.MAX_VALUE;
                double d2 = -1.7976931348623157E308;
                if (byArray2[0] == 76) {
                    d = dArray3[0];
                } else {
                    d2 = byArray2[0] == 71 ? dArray3[0] : (d = dArray3[0]);
                }
                int[] nArray3 = new int[]{0};
                String string2 = CplexI.CPXgetindconstrname(cplexI._env, cplexI._lp, n6, nArray3);
                if (nArray3[0] != 0) {
                    string2 = null;
                }
                if (string2 == null) {
                    string2 = "IloI" + n6;
                }
                if (iloNumVarArray[nArray2[0]] instanceof CpxRange) continue;
                CpxRange cpxRange = (CpxRange)iloCplex.range(d2, d, string2);
                cpxRange.incrementRefCnt(cplexI._getColumnNZnum(nArray2[0], nArray2[0]) + 1);
                iloNumVarArray[nArray2[0]] = cpxRange;
                object[n6] = 1;
            }
            for (n6 = n5 - 1; n6 >= 0; --n6) {
                n2 = CplexI.CPXEgetindicator(cplexI._env, cplexI._lp, nArray2, (int[])object3, (int[])object2, dArray3, byArray2, null, null, 0, (int[])objectArray2, nArray, n6);
                if (n2 != 0 && n2 != 1207) {
                    cplexI.CALL(n2);
                }
                if (objectArray2[0] > 0) continue;
                double d = -objectArray2[0];
                objectArray = new int[d];
                double[] dArray4 = new double[d];
                cplexI.CALL(CplexI.CPXEgetindicator(cplexI._env, cplexI._lp, nArray2, (int[])object3, (int[])object2, dArray3, byArray2, objectArray, dArray4, (int)d, (int[])objectArray2, nArray, n6));
                serializable = (CpxLinearNumExpr)iloCplex.linearNumExpr();
                for (int i = 0; i < object2[0]; ++i) {
                    serializable.addTerm(dArray4[i], iloNumVarArray[objectArray[i]]);
                }
                if (object3[0] == false && nArray2[0] >= 0 && object[n6] != 0 && nArray[0] == 3) {
                    CpxRange cpxRange = (CpxRange)iloNumVarArray[nArray2[0]];
                    cpxRange.setExpr((IloNumExpr)((Object)serializable));
                    continue;
                }
                double d3 = Double.MAX_VALUE;
                double d4 = -1.7976931348623157E308;
                if (byArray2[0] == 76) {
                    d3 = dArray3[0];
                } else {
                    d4 = byArray2[0] == 71 ? dArray3[0] : (d3 = dArray3[0]);
                }
                int[] nArray4 = new int[]{0};
                String string3 = CplexI.CPXgetindconstrname(cplexI._env, cplexI._lp, n6, nArray4);
                if (nArray4[0] != 0) {
                    string3 = null;
                }
                if (string3 == null) {
                    string3 = "IloI" + n6;
                }
                CpxRange cpxRange = (CpxRange)iloCplex.range(d4, (IloNumExpr)((Object)serializable), d3, string3);
                if (nArray2[0] < 0) {
                    if ((nArray[0] & 1) != 0) {
                        if (object3[0] != false) {
                            vector.add(cpxRange);
                        } else {
                            vector.add(iloCplex.not(cpxRange));
                        }
                    } else if (object3[0] != false) {
                        vector.add(iloCplex.not(cpxRange));
                    } else {
                        vector.add(cpxRange);
                    }
                } else {
                    double d5 = object3[0] == false ? 1.0 : 0.0;
                    IloNumVar iloNumVar = iloNumVarArray[nArray2[0]];
                    if ((nArray[0] & 1) != 0) {
                        vector.add(iloCplex.ifThen(iloCplex.eq((IloNumExpr)iloNumVar, d5), cpxRange));
                    }
                    if ((nArray[0] & 2) != 0) {
                        vector.add(iloCplex.ifThen(cpxRange, iloCplex.eq((IloNumExpr)iloNumVar, d5)));
                    }
                }
                cplexI.CALL(CplexI.CPXdelindconstrs(cplexI._env, cplexI._lp, n6, n6));
            }
            n5 = cplexI._getNinds();
            for (n6 = 0; n6 < n5; ++n6) {
                n2 = CplexI.CPXEgetindicator(cplexI._env, cplexI._lp, nArray2, (int[])object3, (int[])object2, dArray3, byArray2, null, null, 0, (int[])objectArray2, nArray, n6);
                if (n2 != 0 && n2 != 1207) {
                    cplexI.CALL(n2);
                }
                CpxRange cpxRange = (CpxRange)iloNumVarArray[nArray2[0]];
                cpxRange._data = new CpxRange.RangeData();
                cpxRange._data._gcindex = new CplexIndex(n6);
                cplexI._gcs[6].addIndex(cpxRange._data._gcindex, cpxRange);
            }
        }
        for (int i = 0; i < n3; ++i) {
            object3 = new CplexIndex(i);
            cplexI._cols.addIndex((CplexIndex)object3, (CpxExtractable)((Object)iloNumVarArray[i]));
            ((CpxNumVar)iloNumVarArray[i]).setIndex((CplexIndex)object3, cplexI);
        }
        cpxLPMatrix.addVars((CpxNumVar[])iloNumVarArray, n3);
        IloNumExpr iloNumExpr = iloCplex.scalProd(iloNumVarArray, (double[])object4);
        double d = cplexI._getObjOffset();
        if (d != 0.0) {
            iloNumExpr = iloCplex.sum(iloNumExpr, d);
        }
        if ((n = cplexI._getQPNZnum()) > 0) {
            int n7 = cplexI._getNcols();
            objectArray2 = new double[n];
            nArray = new int[n];
            object = new int[n7 + 1];
            cplexI._getQP((int[])object, nArray, (double[])objectArray2);
            IloQuadNumExpr iloQuadNumExpr = iloCplex.quadNumExpr();
            for (n2 = 0; n2 < n7; ++n2) {
                for (int i = object[n2]; i < object[n2 + 1]; ++i) {
                    iloQuadNumExpr.addTerm(0.5 * objectArray2[i], iloNumVarArray[nArray[i]], iloNumVarArray[n2]);
                    if (iloNumVarArray[n2] instanceof CpxSubVar) {
                        ((CpxSubVar)iloNumVarArray[n2]).incrementRefCnt();
                    }
                    if (!(iloNumVarArray[nArray[i]] instanceof CpxSubVar)) continue;
                    ((CpxSubVar)iloNumVarArray[nArray[i]]).incrementRefCnt();
                }
            }
            iloNumExpr = iloCplex.sum(iloNumExpr, (IloNumExpr)iloQuadNumExpr);
        }
        object2 = null;
        object2 = cplexI._getSense() == 1 ? (Object)((CpxObjective)iloCplex.addMinimize(iloNumExpr)) : (Object)((CpxObjective)iloCplex.addMaximize(iloNumExpr));
        if (iloCplex.isQC()) {
            int n8 = cplexI._getNQCs();
            for (int i = 0; i < n8; ++i) {
                object = new CplexIndex(i);
                CpxRange cpxRange = new CpxRange((CplexIndex)object, cplexI._getDelQCname(i));
                cplexI._qcs.addIndex((CplexIndex)object, cpxRange);
                cpxRange.setCplexI(cplexI);
                iloCplex._model._range.add(cpxRange);
            }
        }
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        object = new String[n3];
        Object[] objectArray3 = new String[n4];
        cplexI._getProbName(stringArray);
        iloCplex.setName(stringArray[0]);
        cplexI._getObjName(stringArray2);
        ((CpxObjective)object2)._name = stringArray2[0];
        cplexI._getColNames((String[])object, 0, n3 - 1);
        for (n2 = 0; n2 < n3; ++n2) {
            ((CpxNumVar)iloNumVarArray[n2])._name = (String)object[n2];
        }
        cplexI._getRowNames((String[])objectArray3, 0, n4 - 1);
        for (n2 = 0; n2 < n4; ++n2) {
            cpxRangeArray[n2]._name = objectArray3[n2];
        }
        if (iloCplex.isMIP()) {
            int n9;
            int n10 = cplexI._getNSOSs();
            if (n10 > 0) {
                int n11 = cplexI._getSOSNZnum(0, n10 - 1);
                object = new byte[n10];
                objectArray3 = new int[n10 + 1];
                int[] nArray5 = new int[n11];
                double[] dArray5 = new double[n11];
                objectArray = new String[n10];
                cplexI._getSOSs(0, n10 - 1, (byte[])object, (int[])objectArray3, nArray5, dArray5);
                cplexI._getSOSNames((String[])objectArray, 0, n10 - 1);
                for (int i = 0; i < n10; ++i) {
                    CpxSOS cpxSOS;
                    serializable = new CplexIndex(i);
                    if (object[i] == 49) {
                        cpxSOS = new CpxSOS1(cplexI, (CplexIndex)serializable, (String)objectArray[i]);
                        iloCplex._model._sos1.add(cpxSOS);
                    } else {
                        cpxSOS = new CpxSOS2(cplexI, (CplexIndex)serializable, (String)objectArray[i]);
                        iloCplex._model._sos2.add(cpxSOS);
                    }
                    cplexI._soss.addIndex((CplexIndex)serializable, cpxSOS);
                }
            }
            if ((n9 = cplexI._getOrderNum()) > 0) {
                object = new int[n9];
                objectArray3 = new int[n9];
                int[] nArray6 = new int[n9];
                cplexI._getOrder((int[])object, (int[])objectArray3, nArray6);
                for (int i = 0; i < n9; ++i) {
                    cplexI._ord.addOrder(((CpxNumVar)iloNumVarArray[object[i]]).getVarIndex(), (int)objectArray3[i], nArray6[i]);
                }
            }
        }
        if (n5 > 0) {
            cplexI.unUseVars((CpxNumVar[])iloNumVarArray, 0, n3);
        }
        for (int i = 0; i < vector.size(); ++i) {
            iloCplex.add((IloAddable)vector.elementAt(i));
        }
    }

    final void useVars(CpxNumVar[] cpxNumVarArray, int n, int n2, boolean bl) throws IloException {
        int n3;
        CpxNumVar[] cpxNumVarArray2 = null;
        int n4 = 0;
        int n5 = n + n2;
        int n6 = this.getNcols();
        for (n3 = n; n3 < n5; ++n3) {
            if (cpxNumVarArray[n3]._varIndex != null) continue;
            cpxNumVarArray[n3].setIndex(this._cols.addIndex(new CplexIndex(n6 + n4), cpxNumVarArray[n3]), this);
            if (n4 == 0) {
                cpxNumVarArray2 = new CpxNumVar[n2];
            }
            cpxNumVarArray2[n4++] = cpxNumVarArray[n3];
        }
        if (n4 > 0) {
            double[] dArray = new double[n4];
            double[] dArray2 = new double[n4];
            byte[] byArray = new byte[n4];
            String[] stringArray = new String[n4];
            for (int i = 0; i < n4; ++i) {
                dArray[i] = cpxNumVarArray2[i].getCpxLB();
                if (dArray[i] < -1.0E20) {
                    dArray[i] = -1.0E20;
                }
                dArray2[i] = cpxNumVarArray2[i].getCpxUB();
                if (dArray2[i] > 1.0E20) {
                    dArray2[i] = 1.0E20;
                }
                byArray[i] = cpxNumVarArray2[i].getCpxType();
                stringArray[i] = cpxNumVarArray2[i].getName();
            }
            this._newColumns(n4, dArray, dArray2, byArray, stringArray);
        }
        if (bl) {
            for (n3 = n; n3 < n5; ++n3) {
                if (!(cpxNumVarArray[n3] instanceof CpxSubVar)) continue;
                ((CpxSubVar)cpxNumVarArray[n3]).userInstall(this._modeler);
            }
        }
    }

    final void unUseVars(CpxNumVar[] cpxNumVarArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (!(cpxNumVarArray[i] instanceof CpxSubVar)) continue;
            ((CpxSubVar)cpxNumVarArray[i]).userUninstall(this._modeler);
        }
    }

    final void unUseVar(CpxNumVar cpxNumVar) throws IloException {
        if (cpxNumVar instanceof CpxSubVar) {
            ((CpxSubVar)cpxNumVar).userUninstall(this._modeler);
        }
    }

    final void useVar(CpxNumVar cpxNumVar, boolean bl) throws IloException {
        if (cpxNumVar._varIndex == null) {
            double[] dArray = new double[]{cpxNumVar.getCpxLB()};
            double[] dArray2 = new double[]{cpxNumVar.getCpxUB()};
            byte[] byArray = new byte[]{cpxNumVar.getCpxType()};
            String[] stringArray = new String[]{cpxNumVar.getName()};
            if (dArray[0] < -1.0E20) {
                dArray[0] = -1.0E20;
            }
            if (dArray2[0] > 1.0E20) {
                dArray2[0] = 1.0E20;
            }
            this._newColumns(1, dArray, dArray2, byArray, stringArray);
            cpxNumVar.setIndex(this._cols.addIndex(new CplexIndex(this.getNcols()), cpxNumVar), this);
        }
        if (bl && cpxNumVar instanceof CpxSubVar) {
            ((CpxSubVar)cpxNumVar).userInstall(this._modeler);
        }
    }

    void setObjective(IloObjectiveSense iloObjectiveSense, int n, CplexIndex[] cplexIndexArray, double[] dArray, int n2, double[] dArray2, CplexIndex[] cplexIndexArray2, CplexIndex[] cplexIndexArray3, double d) throws IloException {
        this.origProbType();
        this.invalidate();
        this.setSense(iloObjectiveSense.getValue());
        double[] dArray3 = new double[this.getNcols()];
        for (int i = 0; i < n; ++i) {
            int n3 = cplexIndexArray[i]._index;
            dArray3[n3] = dArray3[n3] + dArray[i];
        }
        this._setObjective(dArray3, d);
        if (n2 > 0) {
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                int n4 = cplexIndexArray2[i]._index;
                int n5 = cplexIndexArray3[i]._index;
                if (n4 <= n5) {
                    nArray[i] = n4;
                    nArray2[i] = n5;
                    continue;
                }
                nArray[i] = n5;
                nArray2[i] = n4;
            }
            this._setQ(n2, (double[])dArray2.clone(), nArray, nArray2);
        } else {
            switch (CplexI.CPXgetprobtype(this._env, this._lp)) {
                case 1: {
                    break;
                }
                case 7: {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 1));
                    break;
                }
                case 10: 
                case 11: {
                    this._setQ(0, null, null, null);
                    break;
                }
                default: {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 0));
                }
            }
        }
    }

    public final double objFromX(double[] dArray) {
        return CplexI.CPXEobjfromx(this._lp, dArray);
    }

    public final int getNcols() {
        return this._cols.getNum();
    }

    public final int getNrows() {
        return this._rows.getNum();
    }

    public final int getNQCs() {
        return this._qcs.getNum();
    }

    public final int getNSOSs() {
        return this._soss.getNum();
    }

    public final int getNGCs(int n) {
        return this._gcs[n].getNum();
    }

    CpxNumVar getVariable(int n) {
        return (CpxNumVar)this._cols.getObject(n);
    }

    CpxRange getRange(int n) {
        return (CpxRange)this._rows.getObject(n);
    }

    public void setLBs(CplexIndex[] cplexIndexArray, double[] dArray) throws IloException {
        int[] nArray = new int[cplexIndexArray.length];
        double[] dArray2 = new double[cplexIndexArray.length];
        for (int i = 0; i < cplexIndexArray.length; ++i) {
            nArray[i] = cplexIndexArray[i]._index;
            dArray2[i] = dArray[i] <= -1.0E20 ? -1.0E20 : dArray[i];
        }
        this._setLbs(nArray, dArray2);
    }

    public void setLB(CplexIndex cplexIndex, double d) throws IloException {
        if (d <= -1.0E20) {
            d = -1.0E20;
        }
        this._setLb(cplexIndex._index, d);
    }

    public void setUB(CplexIndex cplexIndex, double d) throws IloException {
        if (d > 1.0E20) {
            d = 1.0E20;
        }
        this._setUb(cplexIndex._index, d);
    }

    public void setType(CplexIndex cplexIndex, byte by) throws IloException {
        this._setType(cplexIndex._index, by);
    }

    public void setTypes(CplexIndex[] cplexIndexArray, byte[] byArray) throws IloException {
        int[] nArray = new int[cplexIndexArray.length];
        for (int i = 0; i < cplexIndexArray.length; ++i) {
            nArray[i] = cplexIndexArray[i]._index;
        }
        this._setTypes(nArray, byArray);
    }

    public CplexIndex addQC(CpxRange cpxRange, double d, double d2, int n, double[] dArray, int[] nArray, int n2, double[] dArray2, int[] nArray2, int[] nArray3, String string) throws IloException {
        int n3;
        double d3;
        int n4 = this.getNQCs();
        if (d <= -1.0E20) {
            d3 = d2;
            n3 = 76;
        } else if (d2 >= 1.0E20) {
            d3 = d;
            n3 = 71;
        } else if (d == d2) {
            d3 = d;
            n3 = 69;
        } else {
            d3 = d;
            n3 = 82;
        }
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXaddqconstr(this._env, this._lp, n, n2, d3, n3, nArray, dArray, nArray2, nArray3, dArray2, string));
        return this._qcs.addIndex(new CplexIndex(n4), cpxRange);
    }

    public CplexIndex addRow(CpxRange cpxRange, double d, double d2, int n, int[] nArray, double[] dArray, String string) throws IloException {
        int n2 = this.getNrows();
        String[] stringArray = new String[]{string};
        this.tmplb[0] = d;
        this.tmpub[0] = d2;
        this.tmplen[0] = 0;
        this.tmplen[1] = n;
        this._addRows(1, this.tmplb, this.tmpub, this.tmplen, nArray, dArray, stringArray);
        return this._rows.addIndex(new CplexIndex(n2), cpxRange);
    }

    public CplexIndex[] addRows(int n, CpxRange[] cpxRangeArray, double[] dArray, double[] dArray2, int[] nArray, CplexIndex[] cplexIndexArray, double[] dArray3, String[] stringArray) throws IloException {
        int n2 = this.getNrows();
        int n3 = nArray[n];
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = cplexIndexArray[i]._index;
        }
        this._addRows(n, dArray, dArray2, nArray, nArray2, dArray3, stringArray);
        CplexIndex[] cplexIndexArray2 = new CplexIndex[n];
        for (int i = 0; i < n; ++i) {
            cplexIndexArray2[i] = this._rows.addIndex(new CplexIndex(n2++), cpxRangeArray[i]);
        }
        return cplexIndexArray2;
    }

    void addCuts(IloRange[] iloRangeArray, int n, int n2, int n3) throws IloException {
        Object object;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int[] nArray = new int[n2 + 1];
        CpxObjective[] cpxObjectiveArray = new CpxObjective[n2];
        CpxQextractor[] cpxQextractorArray = new CpxQextractor[n2];
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            object = (CpxRange)iloRangeArray[i + n];
            dArray[i] = ((CpxRange)object).getLB();
            dArray2[i] = ((CpxRange)object).getUB();
            cpxObjectiveArray[i] = new CpxObjective(IloObjectiveSense.Minimize, null, null);
            cpxQextractorArray[i] = new CpxQextractor(cpxObjectiveArray[i]);
            stringArray[i] = ((CpxExtractable)object).getName();
            CpxNumExpr cpxNumExpr = ((CpxRange)object).getCpxExpr();
            cpxNumExpr.accept(cpxQextractorArray[i]);
            nArray[i + 1] = nArray[i] + cpxObjectiveArray[i]._expr.getLinearNum();
        }
        int[] nArray2 = new int[nArray[n2]];
        object = new double[nArray[n2]];
        for (int i = 0; i < n2; ++i) {
            int n4 = cpxObjectiveArray[i]._expr.getLinearNum();
            int n5 = nArray[i];
            System.arraycopy(cpxObjectiveArray[i]._expr.getLinearVals(), 0, object, n5, n4);
            CpxNumVar[] cpxNumVarArray = cpxObjectiveArray[i]._expr.getLinearVars();
            this.useVars(cpxNumVarArray, 0, n4, true);
            int n6 = 0;
            while (n6 < n4) {
                nArray2[n5] = cpxNumVarArray[n6].getVarIndexValue();
                ++n6;
                ++n5;
            }
        }
        this._addCuts(n2, dArray, dArray2, nArray, nArray2, (double[])object, stringArray, n3);
    }

    void delCuts(int n) throws IloException {
        this._delCuts(n);
    }

    public CplexIndex addSOS(CpxExtractable cpxExtractable, byte by, int n, int n2, CpxNumVar[] cpxNumVarArray, double[] dArray, String string) throws IloException {
        int n3 = this.getNSOSs();
        int n4 = n + n2;
        byte[] byArray = new byte[]{by};
        int[] nArray = new int[]{0};
        String[] stringArray = new String[]{string};
        int[] nArray2 = new int[n4];
        for (int i = n; i < n4; ++i) {
            nArray2[i] = cpxNumVarArray[i].getVarIndexValue();
        }
        this.tmplen[0] = n;
        this.tmplen[1] = n4;
        this._addSOSs(1, byArray, this.tmplen, nArray2, dArray, (String[])(string != null ? stringArray : null));
        return this._soss.addIndex(new CplexIndex(n3), cpxExtractable);
    }

    public void deleteGC(CplexIndex cplexIndex, int n) throws IloException {
        this._gcs[n].deleteIndices(cplexIndex, cplexIndex);
        this.CALL(CplexI.CPXEdelgconstrs(this._env, this._lp, n, cplexIndex.getIndex(), cplexIndex.getIndex()));
    }

    public CplexIndex addIndicator(CpxExtractable cpxExtractable, CplexIndex cplexIndex, int n, double[] dArray, CpxNumVar[] cpxNumVarArray, char c, double d, String string) throws IloException {
        int n2 = this.getNGCs(6);
        int[] nArray = null;
        if (string == null) {
            string = "IloI" + n2;
        }
        if (n > 0) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = cpxNumVarArray[i].getVarIndexValue();
            }
        }
        this.CALL(CplexI.CPXEaddindconstr(this._env, this._lp, cplexIndex.getValue(), 0, n, d, c, nArray, dArray, 3, string));
        return this._gcs[6].addIndex(new CplexIndex(n2), cpxExtractable);
    }

    public CplexIndex addAbs(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(9);
        this.CALL(CplexI.CPXEaddabs(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[9].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public CplexIndex addMin(CpxExtractable cpxExtractable, CplexIndex cplexIndex, double d, int n, int[] nArray, double[] dArray, CpxNumVar[] cpxNumVarArray, String string) throws IloException {
        int n2 = this.getNGCs(7);
        int[] nArray2 = null;
        int n3 = nArray.length;
        if (n3 > 0) {
            nArray2 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray2[i] = cpxNumVarArray[i].getVarIndexValue();
            }
        }
        double d2 = d > 1.0E20 ? 1.0E20 : d;
        this.CALL(CplexI.CPXEaddminexpr(this._env, this._lp, cplexIndex.getValue(), d2, n, n3, nArray, nArray2, dArray, string));
        return this._gcs[7].addIndex(new CplexIndex(n2), cpxExtractable);
    }

    public CplexIndex addMax(CpxExtractable cpxExtractable, CplexIndex cplexIndex, double d, int n, int[] nArray, double[] dArray, CpxNumVar[] cpxNumVarArray, String string) throws IloException {
        int n2 = this.getNGCs(8);
        int[] nArray2 = null;
        int n3 = nArray.length;
        if (n3 > 0) {
            nArray2 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray2[i] = cpxNumVarArray[i].getVarIndexValue();
            }
        }
        double d2 = d < -1.0E20 ? -1.0E20 : d;
        this.CALL(CplexI.CPXEaddmaxexpr(this._env, this._lp, cplexIndex.getValue(), d2, n, n3, nArray, nArray2, dArray, string));
        return this._gcs[8].addIndex(new CplexIndex(n2), cpxExtractable);
    }

    public CplexIndex addPWL(CpxExtractable cpxExtractable, CplexIndex cplexIndex, double[] dArray, double[] dArray2, double d, double d2, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(9);
        this.CALL(CplexI.CPXEaddpwl(this._env, this._lp, cplexIndex.getValue(), dArray.length, dArray, dArray2.length, dArray2, d, d2, cplexIndex2.getValue(), string));
        return this._gcs[9].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public CplexIndex addSetVar(CpxIntSetVar cpxIntSetVar, String string) throws IloException {
        int n;
        int n2 = this.getNGCs(12);
        int n3 = cpxIntSetVar._possible.size();
        int[] nArray = cpxIntSetVar.getPossibleArray();
        double[] dArray = new double[n3];
        int n4 = cpxIntSetVar._required.size();
        int[] nArray2 = cpxIntSetVar.getRequiredArray();
        double[] dArray2 = new double[n4];
        for (n = 0; n < n3; ++n) {
            dArray[n] = nArray[n];
        }
        for (n = 0; n < n4; ++n) {
            dArray2[n] = nArray2[n];
        }
        this.CALL(CplexI.CPXEaddsetvar(this._env, this._lp, n3, dArray, n4, dArray2, string));
        return this._gcs[12].addIndex(new CplexIndex(n2), cpxIntSetVar);
    }

    public void changeSetVar(CpxIntSetVar cpxIntSetVar) throws IloException {
        int n;
        int n2 = cpxIntSetVar._possible.size();
        int[] nArray = cpxIntSetVar.getPossibleArray();
        double[] dArray = new double[n2];
        int n3 = cpxIntSetVar._required.size();
        int[] nArray2 = cpxIntSetVar.getRequiredArray();
        double[] dArray2 = new double[n3];
        for (n = 0; n < n2; ++n) {
            dArray[n] = nArray[n];
        }
        for (n = 0; n < n3; ++n) {
            dArray2[n] = nArray2[n];
        }
        this.CALL(CplexI.CPXEchgsetvar(this._env, this._lp, cpxIntSetVar._gcIndex.getValue(), n2, dArray, n3, dArray2));
    }

    CpxIntSet getIntSetValue(CpxIntSetVar cpxIntSetVar) throws IloException {
        int n = cpxIntSetVar._possible.size();
        int[] nArray = cpxIntSetVar.getPossibleArray();
        int[] nArray2 = new int[n];
        this.CALL(CplexI.CPXEgetsetvarvalues(this._env, this._lp, cpxIntSetVar._gcIndex.getValue(), n, nArray, nArray2));
        CpxIntSet cpxIntSet = new CpxIntSet();
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] != 1) continue;
            cpxIntSet.add(nArray[i]);
        }
        return cpxIntSet;
    }

    public CplexIndex addSetVarCard(CpxIntSetCardVar cpxIntSetCardVar, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(14);
        this.CALL(CplexI.CPXEaddsetvarcard(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[14].addIndex(new CplexIndex(n), cpxIntSetCardVar);
    }

    public CplexIndex addSetVarMember(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, int n, String string) throws IloException {
        int n2 = this.getNGCs(13);
        this.CALL(CplexI.CPXEaddsetvarmember(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), n, string));
        return this._gcs[13].addIndex(new CplexIndex(n2), cpxExtractable);
    }

    public CplexIndex addSetVarSum(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, double[] dArray, String string) throws IloException {
        int n = this.getNGCs(15);
        this.CALL(CplexI.CPXEaddsetvarsum(this._env, this._lp, cplexIndex2.getValue(), cplexIndex.getValue(), dArray.length, dArray, string));
        return this._gcs[15].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public CplexIndex addSetVarMin(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, double[] dArray, String string) throws IloException {
        int n = this.getNGCs(16);
        this.CALL(CplexI.CPXEaddsetvarmin(this._env, this._lp, cplexIndex2.getValue(), cplexIndex.getValue(), dArray.length, dArray, string));
        return this._gcs[16].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public CplexIndex addSetVarMax(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, double[] dArray, String string) throws IloException {
        int n = this.getNGCs(17);
        this.CALL(CplexI.CPXEaddsetvarmax(this._env, this._lp, cplexIndex2.getValue(), cplexIndex.getValue(), dArray.length, dArray, string));
        return this._gcs[17].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public CplexIndex addSetVarSubset(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, boolean bl, String string) throws IloException {
        int n = this.getNGCs(18);
        this.CALL(CplexI.CPXEaddsetvarsubset(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), bl ? 1 : 0, string));
        return this._gcs[18].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarDomain(CpxExtractable cpxExtractable, CplexIndex cplexIndex, int[] nArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) throws IloException {
        int n = this.getNGCs(19);
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = nArray[i];
        }
        this.CALL(CplexI.CPXEaddsetvardomain(this._env, this._lp, cplexIndex.getValue(), n2, dArray, bl ? 1 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, string));
        return this._gcs[19].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarUnion(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, CplexIndex cplexIndex3, String string) throws IloException {
        int n = this.getNGCs(20);
        this.CALL(CplexI.CPXEaddsetvarunion(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), cplexIndex3.getValue(), string));
        return this._gcs[20].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarIntersection(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, CplexIndex cplexIndex3, String string) throws IloException {
        int n = this.getNGCs(21);
        this.CALL(CplexI.CPXEaddsetvarintersection(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), cplexIndex3.getValue(), string));
        return this._gcs[21].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarNullIntersect(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(22);
        this.CALL(CplexI.CPXEaddsetvarnullintersect(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[22].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarIntersect(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(23);
        this.CALL(CplexI.CPXEaddsetvarintersect(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[23].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarEq(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(24);
        this.CALL(CplexI.CPXEaddsetvareq(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[24].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarNEq(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(25);
        this.CALL(CplexI.CPXEaddsetvarneq(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[25].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarNEqCst(CpxExtractable cpxExtractable, CplexIndex cplexIndex, int[] nArray, String string) throws IloException {
        int n = this.getNGCs(26);
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = nArray[i];
        }
        this.CALL(CplexI.CPXEaddsetvarneqcst(this._env, this._lp, cplexIndex.getValue(), n2, dArray, string));
        return this._gcs[26].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public void setLHS(CplexIndex cplexIndex, double d) throws IloException {
        if (d <= -1.0E20) {
            d = -1.0E20;
        }
        this._setLHS(cplexIndex._index, d);
    }

    public void setRHS(CplexIndex cplexIndex, double d) throws IloException {
        if (d >= 1.0E20) {
            d = 1.0E20;
        }
        this._setRHS(cplexIndex._index, d);
    }

    public void setLRHS(CplexIndex cplexIndex, double d, double d2) throws IloException {
        if (d <= -1.0E20) {
            d = -1.0E20;
        }
        if (d2 >= 1.0E20) {
            d2 = 1.0E20;
        }
        this._setLRHS(cplexIndex._index, d, d2);
    }

    public void addNZs(int[] nArray, int[] nArray2, double[] dArray, int n) throws IloException {
        this._addNZs(n, nArray, nArray2, dArray);
    }

    public void addNZ(CplexIndex cplexIndex, CplexIndex cplexIndex2, double d) throws IloException {
        double[] dArray = new double[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        nArray[0] = cplexIndex._index;
        nArray2[0] = cplexIndex2._index;
        dArray[0] = d;
        this._addNZs(1, nArray, nArray2, dArray);
    }

    public void delColumn(CplexIndex cplexIndex) throws IloException {
        this.flushNames();
        this._cols.deleteIndices(cplexIndex, cplexIndex);
        this._ord.deleteColumn(cplexIndex);
        this.removeFromFilters(cplexIndex);
        this._delColumns(cplexIndex.getValue(), cplexIndex.getValue());
    }

    public void delColumns(CpxNumVar[] cpxNumVarArray, int n, int n2) throws IloException {
        this.flushNames();
        int[] nArray = new int[this.getNcols()];
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (cpxNumVarArray[i] == null || cpxNumVarArray[i].getVarIndex() == null || cpxNumVarArray[i].getVarIndexValue() < 0) continue;
            nArray[cpxNumVarArray[i].getVarIndexValue()] = 1;
            cpxNumVarArray[i].setIndex(null, null);
        }
        this._cols.deleteIndices(nArray);
        this._ord.deleteColumns(nArray);
        this.removeFromFilters(nArray);
        this._delColumns(nArray);
    }

    public void delRows(CplexIndex cplexIndex) throws IloException {
        this.flushNames();
        this._rows.deleteIndices(cplexIndex._index, cplexIndex._index);
        this._delRows(cplexIndex._index, cplexIndex._index);
    }

    public void delRows(CplexIndex[] cplexIndexArray, int n, int n2) throws IloException {
        this.flushNames();
        int n3 = n + n2;
        int[] nArray = new int[this.getNrows()];
        for (int i = n; i < n3; ++i) {
            nArray[cplexIndexArray[i].getValue()] = 1;
        }
        this._rows.deleteIndices(nArray);
        this._delRows(nArray);
    }

    public void delRows(CpxRange[] cpxRangeArray, int n, int n2) throws IloException {
        this.flushNames();
        int n3 = n + n2;
        int[] nArray = new int[this.getNrows()];
        for (int i = n; i < n3; ++i) {
            nArray[cpxRangeArray[i].getIndexValue()] = 1;
        }
        this._rows.deleteIndices(nArray);
        this._delRows(nArray);
    }

    public void delQC(CplexIndex cplexIndex) throws IloException {
        this.invalidate();
        this._qcs.deleteIndices(cplexIndex._index, cplexIndex._index);
        this._delQCs(cplexIndex._index, cplexIndex._index);
        if (this.getNQCs() <= 0) {
            if (this.isMIP()) {
                if (this.isQO()) {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 7));
                } else {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 1));
                }
            } else if (this.isQO()) {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 5));
            } else {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 0));
            }
        }
    }

    public void delSOSs(CplexIndex[] cplexIndexArray, int n, int n2) throws IloException {
        int[] nArray = new int[this.getNSOSs()];
        n2 += n;
        for (int i = n; i < n2; ++i) {
            if (cplexIndexArray[i]._index < 0) continue;
            nArray[cplexIndexArray[i]._index] = 1;
        }
        this._soss.deleteIndices(nArray);
        this._delSOSs(nArray);
    }

    void clearModel() throws IloException {
        int n = this._cols.getNum();
        for (int i = 0; i < n; ++i) {
            ((CpxNumVar)this._cols.getObject((int)i))._varIndex = null;
        }
        this._clearModel();
        this._soss.clear();
        this._rows.clear();
        this._qcs.clear();
        this._cols.clear();
        this._filter.clear();
        this._filters.clear();
        this._ord.clear();
        this._status = 0;
    }

    void endModel() throws IloException {
        this._clearModel();
        for (int i = 0; i < 27; ++i) {
            this._gcs[i] = new IndexManager();
        }
        this._rows = this._gcs[3];
        this._qcs = this._gcs[4];
        this._soss = this._gcs[5];
        this._cols = new IndexManager();
        this._filter = new Vector();
        this._filters = new IndexManager();
        this._ord = new CpxOrder();
    }

    public void setNZ(CplexIndex cplexIndex, CplexIndex cplexIndex2, double d) throws IloException {
        this._setNZ(cplexIndex._index, cplexIndex2._index, d);
    }

    void setNZs(int[] nArray, int[] nArray2, double[] dArray, int n) throws IloException {
        this._setNZs(n, nArray, nArray2, dArray);
    }

    public void setNZs(CplexIndex[] cplexIndexArray, CplexIndex[] cplexIndexArray2, double[] dArray, int n, int n2) throws IloException {
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = cplexIndexArray[i + n]._index;
            nArray2[i] = cplexIndexArray2[i + n]._index;
        }
        if (n == 0) {
            this._setNZs(n2, nArray, nArray2, dArray);
        } else {
            double[] dArray2 = new double[n2];
            System.arraycopy(dArray, n, dArray2, 0, n2);
            this._setNZs(n2, nArray, nArray2, dArray2);
        }
    }

    public void setObjCoef(CplexIndex cplexIndex, double d) throws IloException {
        this._setObjCoef(cplexIndex._index, d);
    }

    public void setObjQCoef(CplexIndex cplexIndex, CplexIndex cplexIndex2, double d) throws IloException {
        this._setObjQCoef(cplexIndex._index, cplexIndex2._index, d);
    }

    public void setObjCoefs(CplexIndex[] cplexIndexArray, double[] dArray, int n, int n2) throws IloException {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = cplexIndexArray[i + n].getIndex();
        }
        if (n > 0) {
            double[] dArray2 = new double[n2];
            System.arraycopy(dArray, n, dArray2, 0, n2);
            this._setObjCoefs(n2, nArray, dArray2);
        } else {
            this._setObjCoefs(n2, nArray, dArray);
        }
    }

    CpxNumVar[] getVars(int[] nArray, int n, int n2) {
        CpxNumVar[] cpxNumVarArray = new CpxNumVar[n2];
        for (int i = 0; i < n2; ++i) {
            cpxNumVarArray[i] = (CpxNumVar)this._cols.getObject(nArray[i + n]);
        }
        return cpxNumVarArray;
    }

    public void getQC(CpxRange cpxRange, double[] dArray, double[] dArray2, int[][] nArray, double[][] dArray3, int[][] nArray2, int[][] nArray3, double[][] dArray4) throws IloException {
        this.getQC(cpxRange.getIndexValue(), dArray, dArray2, nArray, dArray3, nArray2, nArray3, dArray4);
    }

    public void getQC(int n, double[] dArray, double[] dArray2, int[][] nArray, double[][] dArray3, int[][] nArray2, int[][] nArray3, double[][] dArray4) throws IloException {
        int n2 = 0;
        int n3 = 0;
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        double[] dArray5 = new double[]{0.0};
        byte[] byArray = new byte[]{0};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{0};
        int n4 = CplexI.CPXgetqconstr(this._env, this._lp, nArray4, nArray5, dArray5, byArray, null, null, 0, nArray6, null, null, null, 0, nArray7, n);
        if (n4 != 0 && n4 != 1207) {
            this.CALL(n4);
        }
        this.clearErrorMessage();
        if (nArray != null || dArray3 != null || nArray2 != null || nArray3 != null || dArray4 != null) {
            int[] nArray8 = null;
            int[] nArray9 = null;
            int[] nArray10 = null;
            double[] dArray6 = null;
            double[] dArray7 = null;
            n2 = -nArray6[0];
            n3 = -nArray7[0];
            if (n2 > 0 && nArray != null && dArray3 != null) {
                nArray[0] = new int[n2];
                nArray8 = nArray[0];
                dArray3[0] = new double[n2];
                dArray6 = dArray3[0];
            }
            if (n3 > 0 && nArray2 != null && nArray3 != null && dArray4 != null) {
                nArray2[0] = new int[n3];
                nArray9 = nArray2[0];
                nArray3[0] = new int[n3];
                nArray10 = nArray3[0];
                dArray4[0] = new double[n3];
                dArray7 = dArray4[0];
            }
            this.CALL(CplexI.CPXgetqconstr(this._env, this._lp, nArray4, nArray5, dArray5, byArray, nArray8, dArray6, n2, nArray6, nArray9, nArray10, dArray7, n3, nArray7, n));
        }
        if (byArray[0] == 76) {
            if (dArray != null) {
                dArray[0] = -1.7976931348623157E308;
            }
            if (dArray2 != null) {
                dArray2[0] = dArray5[0];
            }
        } else if (byArray[0] == 71) {
            if (dArray != null) {
                dArray[0] = dArray5[0];
            }
            if (dArray2 != null) {
                dArray2[0] = Double.MAX_VALUE;
            }
        } else {
            if (dArray != null) {
                dArray[0] = dArray5[0];
            }
            if (dArray2 != null) {
                dArray2[0] = dArray5[0];
            }
        }
    }

    public void getCpxQC(CpxRange cpxRange, double[] dArray, double[] dArray2, CpxNumVar[][] cpxNumVarArray, double[][] dArray3, CpxNumVar[][] cpxNumVarArray2, CpxNumVar[][] cpxNumVarArray3, double[][] dArray4) throws IloException {
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        if (cpxNumVarArray != null && dArray3 != null) {
            object = new int[1][];
        }
        if (cpxNumVarArray2 != null && cpxNumVarArray3 != null && dArray3 != null) {
            object2 = new int[1][];
            object3 = new int[1][];
        }
        this.getQC(cpxRange, dArray, dArray2, (int[][])object, dArray3, (int[][])object2, (int[][])object3, dArray4);
        if (object != null && object[0] != null) {
            cpxNumVarArray[0] = this.getVars(object[0], 0, object[0].length);
        }
        if (object2 != null && object2[0] != null) {
            cpxNumVarArray2[0] = this.getVars(object2[0], 0, object2[0].length);
        }
        if (object3 != null && object3[0] != null) {
            cpxNumVarArray3[0] = this.getVars(object3[0], 0, object3[0].length);
        }
    }

    public void getRows(CpxRange[] cpxRangeArray, int n, int n2, double[] dArray, double[] dArray2, int[][] nArray, double[][] dArray3) throws IloException {
        int n3;
        int n4;
        int n5 = this.getNrows();
        int n6 = -1;
        int n7 = n + n2;
        for (int i = n; i < n7; ++i) {
            int n8 = cpxRangeArray[i].getIndexValue();
            if (n8 < 0) continue;
            if (n8 < n5) {
                n5 = n8;
            }
            if (n8 <= n6) continue;
            n6 = n8;
        }
        double[] dArray4 = null;
        double[] dArray5 = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        double[] dArray6 = null;
        if (dArray != null || dArray2 != null) {
            dArray4 = new double[n6 - n5 + 1];
            dArray5 = new double[n6 - n5 + 1];
        }
        if (nArray != null && dArray3 != null) {
            n4 = this._getRowNZnum(n5, n6);
            nArray2 = new int[n6 - n5 + 2];
            nArray3 = new int[n4];
            dArray6 = new double[n4];
        }
        this._getRows(n5, n6, dArray4, dArray5, nArray2, nArray3, dArray6);
        if (dArray != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue();
                dArray[n4 - n] = dArray4[n3 - n5];
            }
        }
        if (dArray2 != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue();
                dArray2[n4 - n] = dArray5[n3 - n5];
            }
        }
        if (nArray != null && dArray3 != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue() - n5;
                int n9 = nArray2[n3];
                int n10 = nArray2[n3 + 1] - n9;
                dArray3[n4 - n] = new double[n10];
                System.arraycopy(dArray6, n9, dArray3[n4 - n], 0, n10);
                nArray[n4 - n] = new int[n10];
                for (int i = 0; i < n10; ++i) {
                    nArray[n4 - n][i] = nArray3[i + n9];
                }
            }
        }
    }

    public void getCpxRows(CpxRange[] cpxRangeArray, int n, int n2, double[] dArray, double[] dArray2, CpxNumVar[][] cpxNumVarArray, double[][] dArray3) throws IloException {
        int n3;
        int n4;
        int n5 = this.getNrows();
        int n6 = -1;
        int n7 = n + n2;
        for (int i = n; i < n7; ++i) {
            int n8 = cpxRangeArray[i].getIndexValue();
            if (n8 < 0) continue;
            if (n8 < n5) {
                n5 = n8;
            }
            if (n8 <= n6) continue;
            n6 = n8;
        }
        double[] dArray4 = null;
        double[] dArray5 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        double[] dArray6 = null;
        if (dArray2 != null || dArray != null) {
            dArray4 = new double[n6 - n5 + 1];
            dArray5 = new double[n6 - n5 + 1];
        }
        if (cpxNumVarArray != null && dArray3 != null) {
            n4 = this._getRowNZnum(n5, n6);
            nArray = new int[n6 - n5 + 2];
            nArray2 = new int[n4];
            dArray6 = new double[n4];
        }
        this._getRows(n5, n6, dArray4, dArray5, nArray, nArray2, dArray6);
        if (dArray != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue();
                dArray[n4 - n] = dArray4[n3 - n5];
            }
        }
        if (dArray2 != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue();
                dArray2[n4 - n] = dArray5[n3 - n5];
            }
        }
        if (cpxNumVarArray != null && dArray3 != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue() - n5;
                int n9 = nArray[n3];
                int n10 = nArray[n3 + 1] - n9;
                dArray3[n4] = new double[n10];
                System.arraycopy(dArray6, n9, dArray3[n4], 0, n10);
                cpxNumVarArray[n4] = new CpxNumVar[n10];
                for (int i = 0; i < n10; ++i) {
                    cpxNumVarArray[n4][i] = (CpxNumVar)this._cols.getObject(nArray2[i + n9]);
                }
            }
        }
    }

    void getColumns(int n, int n2, int[] nArray, int[][] nArray2, double[][] dArray) throws IloException {
        int n3 = this._getColumnNZnum(n, n2);
        nArray2[0] = new int[n3];
        dArray[0] = new double[n3];
        this._getColumns(n, n2, nArray, nArray2[0], dArray[0]);
    }

    void getSOSs(int n, int n2, byte[] byArray, int[] nArray, int[][] nArray2, double[][] dArray) throws IloException {
        int n3 = this._getSOSNZnum(n, n2);
        nArray2[0] = new int[n3];
        dArray[0] = new double[n3];
        this._getSOSs(n, n2, byArray, nArray, nArray2[0], dArray[0]);
    }

    void getCpxSOSs(int n, int n2, byte[] byArray, CpxNumVar[][] cpxNumVarArray, double[][] dArray) throws IloException {
        int n3 = n2 - n + 1;
        int[] nArray = new int[n3 + 1];
        int[][] nArrayArray = new int[1][];
        double[][] dArrayArray = new double[1][];
        this.getSOSs(n, n2, byArray, nArray, nArrayArray, dArrayArray);
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i + 1] - nArray[i];
            if (dArray != null) {
                dArray[i] = new double[n4];
                System.arraycopy(dArrayArray[0], nArray[i], dArray[i], 0, n4);
            }
            if (cpxNumVarArray == null) continue;
            cpxNumVarArray[i] = new CpxNumVar[n4];
            for (int j = 0; j < n4; ++j) {
                cpxNumVarArray[i][j] = (CpxNumVar)this._cols.getObject(nArrayArray[0][nArray[i] + j]);
            }
        }
    }

    public int getParamType(int n) throws IloException {
        int[] nArray = new int[1];
        this._getParamType(n, nArray);
        return nArray[0];
    }

    void setIntParam(int n, int n2) throws IloException {
        if (n == 1062) {
            if (n2 == 5) {
                this._setIntParam(1062, 5);
                this._setIntParam(1063, 0);
                this._setIntParam(2025, 5);
            } else if (n2 == 6) {
                this._setIntParam(1062, 6);
                this._setIntParam(1063, 0);
                this._setIntParam(2025, 0);
            } else {
                this._setIntParam(1062, n2);
                this._setIntParam(1063, n2);
                this._setIntParam(2025, n2);
            }
        } else {
            this._setIntParam(n, n2);
        }
    }

    int getIntParam(int n) throws IloException {
        int[] nArray = new int[1];
        this._getIntParam(n, nArray);
        return nArray[0];
    }

    int minIntParam(int n) throws IloException {
        int[] nArray = new int[1];
        this._minIntParam(n, nArray);
        return nArray[0];
    }

    int maxIntParam(int n) throws IloException {
        int[] nArray = new int[1];
        this._maxIntParam(n, nArray);
        return nArray[0];
    }

    int defIntParam(int n) throws IloException {
        int[] nArray = new int[1];
        this._defIntParam(n, nArray);
        return nArray[0];
    }

    void setLongParam(int n, long l) throws IloException {
        this._setLongParam(n, l);
    }

    long getLongParam(int n) throws IloException {
        long[] lArray = new long[1];
        this._getLongParam(n, lArray);
        return lArray[0];
    }

    long minLongParam(int n) throws IloException {
        long[] lArray = new long[1];
        this._minLongParam(n, lArray);
        return lArray[0];
    }

    long maxLongParam(int n) throws IloException {
        long[] lArray = new long[1];
        this._maxLongParam(n, lArray);
        return lArray[0];
    }

    long defLongParam(int n) throws IloException {
        long[] lArray = new long[1];
        this._defLongParam(n, lArray);
        return lArray[0];
    }

    void setDoubleParam(int n, double d) throws IloException {
        this._setDoubleParam(n, d);
    }

    double getDoubleParam(int n) throws IloException {
        double[] dArray = new double[1];
        this._getDoubleParam(n, dArray);
        return dArray[0];
    }

    double minDoubleParam(int n) throws IloException {
        double[] dArray = new double[1];
        this._minDoubleParam(n, dArray);
        return dArray[0];
    }

    double maxDoubleParam(int n) throws IloException {
        double[] dArray = new double[1];
        this._maxDoubleParam(n, dArray);
        return dArray[0];
    }

    double defDoubleParam(int n) throws IloException {
        double[] dArray = new double[1];
        this._defDoubleParam(n, dArray);
        return dArray[0];
    }

    void setStringParam(int n, String string) throws IloException {
        this._setStringParam(n, string);
    }

    String getStringParam(int n) throws IloException {
        String[] stringArray = new String[1];
        this._getStringParam(n, stringArray);
        return stringArray[0];
    }

    String defStringParam(int n) throws IloException {
        String[] stringArray = new String[1];
        this._defStringParam(n, stringArray);
        return stringArray[0];
    }

    IloCplex.ParameterSet getParameterSet() throws IloException {
        IloCplex.ParameterSet parameterSet = new IloCplex.ParameterSet();
        parameterSet.extractFrom(this);
        return parameterSet;
    }

    void setParameterSet(IloCplex.ParameterSet parameterSet) throws IloException {
        parameterSet.applyTo(this);
    }

    void fillXcache() throws IloException {
        double[] dArray = new double[]{0.0};
        String string = this._error;
        if (CplexI.CPXgetobjval(this._env, this._lp, dArray) == 0) {
            int n = this.getNcols();
            if (this._xCache == null || this._xCache.length < n) {
                this._xCache = new double[n];
            }
            this.CALL(CplexI.CPXgetx(this._env, this._lp, this._xCache, 0, n - 1));
        }
        this._error = string;
    }

    double[] getXcache() throws IloException {
        double[] dArray = new double[]{0.0};
        this.CALL(CplexI.CPXgetobjval(this._env, this._lp, dArray));
        return this._xCache;
    }

    private void invalidate() {
        this._slack.invalidate();
        this._qcslack.invalidate();
        this._solnpoolX.invalidate();
        this._solnpoolSlack.invalidate();
        this._solnpoolQCSlack.invalidate();
    }

    private double[] getSlackArray() throws IloException {
        if (!this._slack.isValid(-1)) {
            int n = this.getNrows();
            this._slack.resize(n + 1);
            this.CALL(CplexI.CPXgetslack(this._env, this._lp, this._slack.getArray(), 0, n - 1));
            this._slack.validate(-1);
        }
        return this._slack.getArray();
    }

    private double[] getQCSlackArray() throws IloException {
        if (!this._qcslack.isValid(-1)) {
            int n = this.getNQCs();
            this._qcslack.resize(n + 1);
            this.CALL(CplexI.CPXgetqconstrslack(this._env, this._lp, this._qcslack.getArray(), 0, n - 1));
            this._qcslack.validate(-1);
        }
        return this._qcslack.getArray();
    }

    private double[] getSolnPoolXArray(int n) throws IloException {
        if (!this._solnpoolX.isValid(n)) {
            int n2 = this.getNcols();
            this._solnpoolX.resize(n2 + 1);
            this.CALL(CplexI.CPXgetsolnpoolx(this._env, this._lp, n, this._solnpoolX.getArray(), 0, n2 - 1));
            this._solnpoolX.validate(n);
        }
        return this._solnpoolX.getArray();
    }

    private double[] getSolnPoolSlackArray(int n) throws IloException {
        if (!this._solnpoolSlack.isValid(n)) {
            int n2 = this.getNrows();
            this._solnpoolSlack.resize(n2 + 1);
            this.CALL(CplexI.CPXgetsolnpoolslack(this._env, this._lp, n, this._solnpoolSlack.getArray(), 0, n2 - 1));
            this._solnpoolSlack.validate(n);
        }
        return this._solnpoolSlack.getArray();
    }

    private double[] getSolnPoolQCSlackArray(int n) throws IloException {
        if (!this._solnpoolQCSlack.isValid(n)) {
            int n2 = this.getNQCs();
            this._solnpoolQCSlack.resize(n2 + 1);
            this.CALL(CplexI.CPXgetsolnpoolqconstrslack(this._env, this._lp, n, this._solnpoolQCSlack.getArray(), 0, n2 - 1));
            this._solnpoolQCSlack.validate(n);
        }
        return this._solnpoolQCSlack.getArray();
    }

    private final boolean getStatusAfterSolve() throws IloException {
        return this.isPfeas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void solve() throws IloException {
        SolveHandle solveHandle = new SolveHandle(this, false);
        try {
            solveHandle.start();
            solveHandle.stop();
        }
        finally {
            solveHandle.finit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populate() throws IloException {
        PopulateHandle populateHandle = new PopulateHandle(this, false);
        try {
            populateHandle.start();
            populateHandle.stop();
        }
        finally {
            populateHandle.finit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void solveFixed(int n) throws IloException {
        SolveFixedHandle solveFixedHandle = new SolveFixedHandle(this, false);
        try {
            solveFixedHandle.start(n);
            solveFixedHandle.stop();
        }
        finally {
            solveFixedHandle.finit();
        }
    }

    static int truncateLong(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tuneParam(IloCplex.ParameterSet parameterSet) throws IloException {
        TuneParamHandle tuneParamHandle = new TuneParamHandle(this, false);
        try {
            tuneParamHandle.start(parameterSet);
            int n = tuneParamHandle.stop();
            return n;
        }
        finally {
            tuneParamHandle.finit();
        }
    }

    int tuneParam(String[] stringArray, IloCplex.ParameterSet parameterSet) throws IloException {
        Object object;
        Object object2;
        Object object3;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (parameterSet != null) {
            object3 = parameterSet.iterator();
            while (object3.hasNext()) {
                object2 = (IloCplex.Parameter)object3.next();
                switch (((IloCplex.Parameter)object2).getType()) {
                    case 1: {
                        ++n;
                        break;
                    }
                    case 0: {
                        ++n2;
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 3: {
                        ++n3;
                    }
                }
            }
        }
        object3 = new int[n + 1];
        object2 = new double[n + 1];
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n2 + 1];
        int[] nArray3 = new int[n2 + 1];
        byte[][] byArrayArray = new byte[n3 + 1][];
        n = 0;
        n2 = 0;
        n3 = 0;
        if (parameterSet != null) {
            Iterator iterator = parameterSet.iterator();
            while (iterator.hasNext()) {
                object = (IloCplex.Parameter)iterator.next();
                switch (((IloCplex.Parameter)object).getType()) {
                    case 1: {
                        object3[n] = ((IloCplex.DoubleParameter)object).getKey().getValue();
                        object2[n] = ((IloCplex.DoubleParameter)object).getValue();
                        ++n;
                        break;
                    }
                    case 0: {
                        nArray[n2] = ((IloCplex.IntParameter)object).getKey().getValue();
                        nArray2[n2] = ((IloCplex.IntParameter)object).getValue();
                        ++n2;
                        break;
                    }
                    case 2: {
                        nArray[n2] = ((IloCplex.BooleanParameter)object).getKey().getValue();
                        nArray[n2] = ((IloCplex.BooleanParameter)object).getValue() ? 1 : 0;
                        ++n2;
                        break;
                    }
                    case 3: {
                        nArray3[n3] = ((IloCplex.StringParameter)object).getKey().getValue();
                        byArrayArray[n3] = CplexI.getBytes(((IloCplex.StringParameter)object).getValue());
                        ++n3;
                    }
                }
            }
        }
        int n4 = stringArray.length;
        object = new byte[n4][];
        for (int i = 0; i < n4; ++i) {
            object[i] = CplexI.getBytes(stringArray[i]);
        }
        int[] nArray4 = new int[1];
        this.CALL(CplexI.CPXtuneparamprobset(this._env, n4, (byte[][])object, null, n2, nArray, nArray2, n, (int[])object3, (double[])object2, n3, nArray3, byArrayArray, nArray4));
        return nArray4[0];
    }

    public double getObjValue() throws IloException {
        double[] dArray = new double[1];
        this._getObjValue(dArray);
        return dArray[0];
    }

    public double getBestObjValue() throws IloException {
        double[] dArray = new double[1];
        this._getBestObjValue(dArray);
        return dArray[0];
    }

    public double getMIPRelativeGap() throws IloException {
        double[] dArray = new double[1];
        this._getMIPRelativeGap(dArray);
        return dArray[0];
    }

    public double getCutoff() throws IloException {
        double[] dArray = new double[1];
        this._getCutoff(dArray);
        return dArray[0];
    }

    public double[] getX(int n, int n2) throws IloException {
        double[] dArray = this.getXcache();
        double[] dArray2 = new double[n2 - n + 1];
        System.arraycopy(dArray, n, dArray2, 0, n2 - n + 1);
        return dArray2;
    }

    public double[] getPi(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getPi(n, n2, dArray);
        return dArray;
    }

    public double[] getRowInfeasibilities(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getRowInfeasibilities(n, n2, dArray);
        return dArray;
    }

    public double[] getQCInfeasibilities(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getQCInfeasibilities(n, n2, dArray);
        return dArray;
    }

    public double[] getIndInfeasibilities(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getIndInfeasibilities(n, n2, dArray);
        return dArray;
    }

    public double[] getSOSInfeasibilities(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getSOSInfeasibilities(n, n2, dArray);
        return dArray;
    }

    public double[] getColInfeasibilities(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getColInfeasibilities(n, n2, dArray);
        return dArray;
    }

    public double[] getInfeasibilities(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        double[] dArray = new double[n2];
        int n3 = this.getNrows();
        double[] dArray2 = this.getRowInfeasibilities(0, n3 - 1);
        for (int i = 0; i < n2; ++i) {
            int n4 = i + n;
            IntArray intArray = new IntArray();
            ByteArray byteArray = new ByteArray();
            this.fillGroup(iloConstraintArray[n4], intArray, byteArray);
            int n5 = intArray.getSize();
            dArray[i] = 0.0;
            double[] dArray3 = new double[]{0.0};
            for (int j = 0; j < n5; ++j) {
                if (byteArray.getArray()[j] == 1 || byteArray.getArray()[j] == 2) {
                    dArray3 = this.getColInfeasibilities(intArray.getArray()[j], intArray.getArray()[j]);
                } else if (byteArray.getArray()[j] == 3) {
                    dArray3[0] = dArray2[intArray.getArray()[j]];
                } else if (byteArray.getArray()[j] == 4) {
                    dArray3 = this.getQCInfeasibilities(intArray.getArray()[j], intArray.getArray()[j]);
                } else if (byteArray.getArray()[j] == 5) {
                    dArray3 = this.getSOSInfeasibilities(intArray.getArray()[j], intArray.getArray()[j]);
                } else if (byteArray.getArray()[j] == 6) {
                    dArray3 = this.getIndInfeasibilities(intArray.getArray()[j], intArray.getArray()[j]);
                }
                dArray[i] = n5 > 1 ? Math.max(Math.abs(dArray3[0]), dArray[i]) : dArray3[0];
            }
        }
        return dArray;
    }

    public double[] getReducedCosts(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getReducedCosts(n, n2, dArray);
        return dArray;
    }

    public double[] getAX(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getAX(n, n2, dArray);
        return dArray;
    }

    public IloCplex.BasisStatus getColumnBasis(CplexIndex cplexIndex) throws IloException {
        int[] nArray = new int[this.getNcols()];
        this._getBase(nArray, null);
        switch (nArray[cplexIndex.getIndex()]) {
            case 0: {
                return IloCplex.BasisStatus.AtLower;
            }
            case 1: {
                return IloCplex.BasisStatus.Basic;
            }
            case 2: {
                return IloCplex.BasisStatus.AtUpper;
            }
            case 3: {
                return IloCplex.BasisStatus.FreeOrSuperbasic;
            }
        }
        return IloCplex.BasisStatus.NotABasicStatus;
    }

    public IloCplex.BasisStatus[] getColumnBasis(CplexIndex[] cplexIndexArray, int n, int n2) throws IloException {
        int[] nArray = new int[this.getNcols()];
        this._getBase(nArray, null);
        IloCplex.BasisStatus[] basisStatusArray = new IloCplex.BasisStatus[n2];
        block6: for (int i = 0; i < n2; ++i) {
            switch (nArray[cplexIndexArray[i + n].getIndex()]) {
                case 0: {
                    basisStatusArray[i] = IloCplex.BasisStatus.AtLower;
                    continue block6;
                }
                case 1: {
                    basisStatusArray[i] = IloCplex.BasisStatus.Basic;
                    continue block6;
                }
                case 2: {
                    basisStatusArray[i] = IloCplex.BasisStatus.AtUpper;
                    continue block6;
                }
                case 3: {
                    basisStatusArray[i] = IloCplex.BasisStatus.FreeOrSuperbasic;
                    continue block6;
                }
                default: {
                    basisStatusArray[i] = IloCplex.BasisStatus.NotABasicStatus;
                }
            }
        }
        return basisStatusArray;
    }

    public IloCplex.BasisStatus getRowBasis(CplexIndex cplexIndex) throws IloException {
        int[] nArray = new int[this.getNrows()];
        this._getBase(null, nArray);
        switch (nArray[cplexIndex.getIndex()]) {
            case 0: {
                return IloCplex.BasisStatus.AtLower;
            }
            case 1: {
                return IloCplex.BasisStatus.Basic;
            }
            case 2: {
                return IloCplex.BasisStatus.AtUpper;
            }
            case 3: {
                return IloCplex.BasisStatus.FreeOrSuperbasic;
            }
        }
        return IloCplex.BasisStatus.NotABasicStatus;
    }

    public IloCplex.BasisStatus[] getRowBasis(CpxRange[] cpxRangeArray, int n, int n2) throws IloException {
        int[] nArray = new int[this.getNrows()];
        this._getBase(null, nArray);
        IloCplex.BasisStatus[] basisStatusArray = new IloCplex.BasisStatus[n2];
        block6: for (int i = 0; i < n2; ++i) {
            switch (nArray[cpxRangeArray[i + n].getIndexValue()]) {
                case 0: {
                    basisStatusArray[i] = IloCplex.BasisStatus.AtLower;
                    continue block6;
                }
                case 1: {
                    basisStatusArray[i] = IloCplex.BasisStatus.Basic;
                    continue block6;
                }
                case 2: {
                    basisStatusArray[i] = IloCplex.BasisStatus.AtUpper;
                    continue block6;
                }
                case 3: {
                    basisStatusArray[i] = IloCplex.BasisStatus.FreeOrSuperbasic;
                    continue block6;
                }
                default: {
                    basisStatusArray[i] = IloCplex.BasisStatus.NotABasicStatus;
                }
            }
        }
        return basisStatusArray;
    }

    public void setBasis(CplexIndex[] cplexIndexArray, IloCplex.BasisStatus[] basisStatusArray, int n, int n2, CplexIndex[] cplexIndexArray2, IloCplex.BasisStatus[] basisStatusArray2, int n3, int n4) throws IloException {
        int n5;
        int n6;
        int n7;
        int[] nArray;
        int n8 = this.getNcols();
        int[] nArray2 = new int[n8];
        if (CplexI.CPXgetbase(this._env, this._lp, nArray2, nArray = new int[n7 = this.getNrows()]) != 0) {
            for (n6 = 0; n6 < n7; ++n6) {
                nArray[n6] = 1;
            }
            for (n6 = 0; n6 < n8; ++n6) {
                nArray2[n6] = 0;
            }
        }
        n6 = n + n2;
        for (n5 = n; n5 < n6; ++n5) {
            nArray2[cplexIndexArray[n5].getIndex()] = basisStatusArray[n5]._stat;
        }
        n5 = n3 + n4;
        for (int i = n3; i < n5; ++i) {
            nArray[cplexIndexArray2[i].getIndex()] = basisStatusArray2[i]._stat;
        }
        this._setBase(nArray2, nArray);
    }

    void setVectors(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, int n, int n2, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray, int n3, int n4) throws IloException {
        int n5;
        int n6 = n + n2;
        int[] nArray = new int[n6];
        for (n5 = n; n5 < n6; ++n5) {
            nArray[n5] = ((CpxNumVar)iloNumVarArray[n5]).getVarIndexValue();
        }
        n5 = n3 + n4;
        int[] nArray2 = new int[n5];
        for (int i = n3; i < n5; ++i) {
            nArray2[i] = ((CpxRange)iloRangeArray[i]).getIndexValue();
        }
        this._copyStartMIP(dArray, dArray2, nArray, n, n2, dArray3, dArray4, nArray2, n3, n4);
    }

    void setStart(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, int n, int n2, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray, int n3, int n4) throws IloException {
        int n5;
        int n6 = n + n2;
        int[] nArray = new int[n6];
        for (n5 = n; n5 < n6; ++n5) {
            nArray[n5] = ((CpxNumVar)iloNumVarArray[n5]).getVarIndexValue();
        }
        n5 = n3 + n4;
        int[] nArray2 = new int[n5];
        for (int i = n3; i < n5; ++i) {
            nArray2[i] = ((CpxRange)iloRangeArray[i]).getIndexValue();
        }
        this._copyStart(dArray, dArray2, nArray, n, n2, dArray3, dArray4, nArray2, n3, n4);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2, IloCplex.MIPStartEffort mIPStartEffort, String string) throws IloException {
        int n3 = this.getNMIPStarts();
        double[] dArray2 = new double[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{mIPStartEffort._value};
        for (int i = 0; i < n2; ++i) {
            nArray[i] = ((CpxNumVar)iloNumVarArray[n + i]).getVarIndexValue();
            dArray2[i] = dArray[n + i];
        }
        if (string != null) {
            String[] stringArray = new String[]{string};
            this.CALL(CplexI.CPXaddmipstarts(this._env, this._lp, 1, n2, nArray2, nArray, dArray2, nArray3, stringArray));
        } else {
            this.CALL(CplexI.CPXaddmipstarts(this._env, this._lp, 1, n2, nArray2, nArray, dArray2, nArray3, null));
        }
        return n3;
    }

    public void changeMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray, int n2, int n3) throws IloException {
        double[] dArray2 = new double[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{n};
        for (int i = 0; i < n3; ++i) {
            nArray[i] = ((CpxNumVar)iloNumVarArray[n2 + i]).getVarIndexValue();
            dArray2[i] = dArray[n2 + i];
        }
        this.CALL(CplexI.CPXchgmipstarts(this._env, this._lp, 1, nArray3, n3, nArray2, nArray, dArray2, null));
    }

    public void changeMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray, int n2, int n3, IloCplex.MIPStartEffort mIPStartEffort) throws IloException {
        double[] dArray2 = new double[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{mIPStartEffort._value};
        int[] nArray4 = new int[]{n};
        for (int i = 0; i < n3; ++i) {
            nArray[i] = ((CpxNumVar)iloNumVarArray[n2 + i]).getVarIndexValue();
            dArray2[i] = dArray[n2 + i];
        }
        this.CALL(CplexI.CPXchgmipstarts(this._env, this._lp, 1, nArray4, n3, nArray2, nArray, dArray2, nArray3));
    }

    public void deleteMIPStarts(int n, int n2) throws IloException {
        int n3 = n + n2 - 1;
        if (n3 >= this.getNMIPStarts()) {
            n3 = this.getNMIPStarts() - 1;
        }
        this.CALL(CplexI.CPXdelmipstarts(this._env, this._lp, n, n3));
    }

    public int getNMIPStarts() throws IloException {
        return CplexI.CPXgetnummipstarts(this._env, this._lp);
    }

    public String getMIPStartName(int n) throws IloException {
        int[] nArray = new int[]{0};
        String[] stringArray = CplexI.CPXgetmipstartname(this._env, this._lp, n, n, nArray);
        return stringArray[0];
    }

    public int getMIPStartIndex(String string) throws IloException {
        int[] nArray = new int[]{0};
        this.CALL(CplexI.CPXgetmipstartindex(this._env, this._lp, string, nArray));
        return nArray[0];
    }

    public IloCplex.MIPStartEffort getMIPStart(int n, CplexIndex[] cplexIndexArray, double[] dArray, boolean[] blArray) throws IloException {
        int n2;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        CplexI.CPXgetmipstarts(this._env, this._lp, nArray, null, null, null, null, 0, nArray2, n, n);
        int[] nArray4 = new int[]{0};
        double[] dArray2 = new double[-nArray2[0]];
        int[] nArray5 = new int[-nArray2[0]];
        this.CALL(CplexI.CPXgetmipstarts(this._env, this._lp, nArray, nArray4, nArray5, dArray2, nArray3, nArray5.length, nArray2, n, n));
        int n3 = this.getNcols();
        double[] dArray3 = new double[n3];
        boolean[] blArray2 = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray2[n2] = false;
        }
        for (n2 = 0; n2 < nArray[0]; ++n2) {
            dArray3[nArray5[n2]] = dArray2[n2];
            blArray2[nArray5[n2]] = true;
        }
        if (cplexIndexArray != null) {
            for (n2 = 0; n2 < cplexIndexArray.length; ++n2) {
                int n4 = cplexIndexArray[n2].getIndex();
                if (n4 >= 0 && blArray2[n4]) {
                    dArray[n2] = dArray3[n4];
                    if (blArray == null) continue;
                    blArray[n2] = true;
                    continue;
                }
                dArray[n2] = 0.0;
                if (blArray == null) continue;
                blArray[n2] = false;
            }
        }
        switch (nArray3[0]) {
            case 1: {
                return IloCplex.MIPStartEffort.CheckFeas;
            }
            case 2: {
                return IloCplex.MIPStartEffort.SolveFixed;
            }
            case 3: {
                return IloCplex.MIPStartEffort.SolveMIP;
            }
            case 4: {
                return IloCplex.MIPStartEffort.Repair;
            }
        }
        return IloCplex.MIPStartEffort.Auto;
    }

    public IloNumVar[] getMIPStartVars(int n) throws IloException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        CplexI.CPXgetmipstarts(this._env, this._lp, nArray, null, null, null, null, 0, nArray2, n, n);
        int[] nArray3 = new int[]{0};
        double[] dArray = new double[-nArray2[0]];
        int[] nArray4 = new int[-nArray2[0]];
        this.CALL(CplexI.CPXgetmipstarts(this._env, this._lp, nArray, nArray3, nArray4, dArray, null, nArray4.length, nArray2, n, n));
        IloNumVar[] iloNumVarArray = new IloNumVar[nArray4.length];
        for (int i = 0; i < nArray4.length; ++i) {
            iloNumVarArray[i] = (IloNumVar)((Object)this._cols.getObject(nArray4[i]));
        }
        return iloNumVarArray;
    }

    public double[] getMIPStartValues(int n) throws IloException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        CplexI.CPXgetmipstarts(this._env, this._lp, nArray, null, null, null, null, 0, nArray2, n, n);
        int[] nArray3 = new int[]{0};
        double[] dArray = new double[-nArray2[0]];
        int[] nArray4 = new int[-nArray2[0]];
        this.CALL(CplexI.CPXgetmipstarts(this._env, this._lp, nArray, nArray3, nArray4, dArray, null, nArray4.length, nArray2, n, n));
        return dArray;
    }

    public void getRangeSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, CpxRange[] cpxRangeArray, int n, int n2) throws IloException {
        int n3;
        int n4 = this.getNrows();
        double[] dArray5 = new double[n4];
        double[] dArray6 = new double[n4];
        double[] dArray7 = new double[n4];
        double[] dArray8 = new double[n4];
        this._rangesa(0, n4 - 1, dArray5, dArray6, dArray7, dArray8);
        int n5 = n + n2;
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray[n3 - n] = dArray5[cpxRangeArray[n3].getIndexValue()];
            }
        }
        if (dArray2 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray2[n3 - n] = dArray6[cpxRangeArray[n3].getIndexValue()];
            }
        }
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray3[n3 - n] = dArray7[cpxRangeArray[n3].getIndexValue()];
            }
        }
        if (dArray4 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray4[n3 - n] = dArray8[cpxRangeArray[n3].getIndexValue()];
            }
        }
    }

    public void getRHSSA(double[] dArray, double[] dArray2, CpxRange[] cpxRangeArray, int n, int n2) throws IloException {
        int n3;
        int n4 = this.getNrows();
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        this._rhssa(0, n4 - 1, dArray3, dArray4);
        int n5 = n + n2;
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray[n3 - n] = dArray3[cpxRangeArray[n3].getIndexValue()];
            }
        }
        if (dArray2 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray2[n3 - n] = dArray4[cpxRangeArray[n3].getIndexValue()];
            }
        }
    }

    public void getBoundSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, CplexIndex[] cplexIndexArray, int n, int n2) throws IloException {
        int n3;
        int n4 = this.getNcols();
        double[] dArray5 = new double[n4];
        double[] dArray6 = new double[n4];
        double[] dArray7 = new double[n4];
        double[] dArray8 = new double[n4];
        this._boundsa(0, n4 - 1, dArray5, dArray6, dArray7, dArray8);
        int n5 = n + n2;
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray[n3 - n] = dArray5[cplexIndexArray[n3].getIndex()];
            }
        }
        if (dArray3 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray3[n3 - n] = dArray7[cplexIndexArray[n3].getIndex()];
            }
        }
        if (dArray2 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray2[n3 - n] = dArray6[cplexIndexArray[n3].getIndex()];
            }
        }
        if (dArray4 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray4[n3 - n] = dArray8[cplexIndexArray[n3].getIndex()];
            }
        }
    }

    public void getObjSA(double[] dArray, double[] dArray2, CplexIndex[] cplexIndexArray, int n, int n2) throws IloException {
        int n3;
        int n4 = this.getNcols();
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        this._objsa(0, n4 - 1, dArray3, dArray4);
        int n5 = n + n2;
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray[n3 - n] = dArray3[cplexIndexArray[n3].getIndex()];
            }
        }
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray2[n3 - n] = dArray4[cplexIndexArray[n3].getIndex()];
            }
        }
    }

    boolean isSoln() {
        int n = CplexI.CPXgetstat(this._env, this._lp);
        return n == 1 || n == 5 || n == 6 || n == 23 || n == 127 || n == 15 || n == 14 || n == 17 || n == 16 || n == 19 || n == 18 || n == 12 || n == 101 || n == 102 || n == 115 || n == 105 || n == 107 || n == 131 || n == 109 || n == 111 || n == 113 || n == 126 || n == 121 || n == 120 || n == 123 || n == 122 || n == 125 || n == 124 || n == 116;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean feasOpt(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        FeasoptExtHandle feasoptExtHandle = new FeasoptExtHandle(this, false);
        try {
            feasoptExtHandle.start(iloConstraintArray, dArray);
            boolean bl = feasoptExtHandle.stop();
            return bl;
        }
        finally {
            feasoptExtHandle.finit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean feasOpt(IloRange[] iloRangeArray, double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, double[] dArray3, double[] dArray4) throws IloException {
        EFeasoptHandle eFeasoptHandle = new EFeasoptHandle(this, false);
        try {
            eFeasoptHandle.start(iloRangeArray, dArray, dArray2, iloNumVarArray, dArray3, dArray4);
            boolean bl = eFeasoptHandle.stop();
            return bl;
        }
        finally {
            eFeasoptHandle.finit();
        }
    }

    void getIIS(IloCplex.IIS.Status[][] statusArray, IloNumVar[][] iloNumVarArray, IloCplex.IIS.Status[][] statusArray2, IloConstraint[][] iloConstraintArray) throws IloException {
        int n;
        int[] nArray = new int[2];
        this._getIISsize(nArray);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        this._getIIS(nArray4, nArray5, nArray2, nArray3);
        IloCplex.IIS.Status[] statusArray3 = new IloCplex.IIS.Status[]{IloCplex.IIS.Status.AtLower, IloCplex.IIS.Status.Fixed, IloCplex.IIS.Status.AtUpper};
        iloNumVarArray[0] = new CpxNumVar[n3];
        iloConstraintArray[0] = new CpxRange[n2];
        statusArray[0] = new IloCplex.IIS.Status[n3];
        statusArray2[0] = new IloCplex.IIS.Status[n2];
        for (n = 0; n < n3; ++n) {
            iloNumVarArray[0][n] = (CpxNumVar)this._cols.getObject(nArray2[n]);
            statusArray[0][n] = statusArray3[nArray3[n]];
        }
        for (n = 0; n < n2; ++n) {
            iloConstraintArray[0][n] = (CpxRange)this._rows.getObject(nArray4[n]);
            statusArray2[0][n] = statusArray3[nArray5[n]];
        }
    }

    private void fillElement(Object object, IntArray intArray, ByteArray byteArray) throws IloException {
        if (object instanceof CpxRange) {
            int n = ((CpxRange)object).getIndexValue();
            if (n >= 0) {
                intArray.add(n);
                if (((CpxRange)object).isQC()) {
                    byteArray.add((byte)4);
                } else {
                    byteArray.add((byte)3);
                }
            }
        } else if (object instanceof CpxNumVarBound) {
            int n = ((CpxNumVarBound)object).getCpxVar().getVarIndexValue();
            if (n >= 0) {
                intArray.add(n);
                byteArray.add((byte)((CpxNumVarBound)object).getCpxType());
            }
        } else if (object instanceof CpxSOS) {
            int n = ((CpxSOS)object).getIndexValue();
            if (n >= 0) {
                intArray.add(n);
                byteArray.add((byte)5);
            }
        } else if (object instanceof CpxGC) {
            if (((CpxGC)object).getGCIndex() != null) {
                intArray.add(((CpxGC)object).getGCIndex().getValue());
                byteArray.add((byte)((CpxGC)object).getGCExtractedType());
            }
        } else if (object instanceof CpxLPMatrix) {
            CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)object;
            int n = cpxLPMatrix.getNrows();
            for (int i = 0; i < n; ++i) {
                this.fillElement(cpxLPMatrix._row[i], intArray, byteArray);
            }
        }
    }

    private void fillGroup(Object object, IntArray intArray, ByteArray byteArray) throws IloException {
        if (object instanceof CpxAnd && ((CpxAnd)object).getCplexI() != this) {
            Iterator iterator = ((CpxAnd)object).iterator();
            while (iterator.hasNext()) {
                this.fillGroup((CpxExtractable)iterator.next(), intArray, byteArray);
            }
        } else {
            this.fillElement(object, intArray, byteArray);
        }
    }

    boolean refineConflict(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        if (iloConstraintArray.length != dArray.length) {
            throw new IloException("IloCplex.refineConflict : constraint and preference arrays must have the same size.");
        }
        return this.refineConflict(iloConstraintArray, dArray, 0, iloConstraintArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refineConflict(IloConstraint[] iloConstraintArray, double[] dArray, int n, int n2) throws IloException {
        RefineConflictHandle refineConflictHandle = new RefineConflictHandle(this, false);
        try {
            refineConflictHandle.start(iloConstraintArray, dArray, n, n2);
            boolean bl = refineConflictHandle.stop();
            return bl;
        }
        finally {
            refineConflictHandle.finit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refineMIPStartConflict(int n, IloConstraint[] iloConstraintArray, double[] dArray, int n2, int n3) throws IloException {
        RefineMIPStartConflictHandle refineMIPStartConflictHandle = new RefineMIPStartConflictHandle(this, false);
        try {
            refineMIPStartConflictHandle.start(n, iloConstraintArray, dArray, n2, n3);
            boolean bl = refineMIPStartConflictHandle.stop();
            return bl;
        }
        finally {
            refineMIPStartConflictHandle.finit();
        }
    }

    IloCplex.ConflictStatus[] getConflict(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        this.CALL(CplexI.CPXgetconflict(this.getEnv(), this.getLP(), null, null, null, null, null, null, null));
        IloCplex.ConflictStatus[] conflictStatusArray = new IloCplex.ConflictStatus[n2];
        int n3 = n + n2;
        int[] nArray = new int[]{0};
        for (int i = n; i < n3; ++i) {
            int n4 = (Integer)this._grpMap.get(iloConstraintArray[i]);
            this.CALL(CplexI.CPXgetconflictext(this.getEnv(), this.getLP(), nArray, n4, n4));
            conflictStatusArray[i - n] = IloCplex.ConflictStatus.make(nArray[0]);
        }
        return conflictStatusArray;
    }

    CpxLinearNumExpr getRay() throws IloException {
        int n = this.getNcols();
        double[] dArray = new double[n];
        this._getRay(dArray);
        CpxLinearNumExpr cpxLinearNumExpr = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
        cpxLinearNumExpr.makeSpace(n);
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == 0.0) continue;
            cpxLinearNumExpr.addTerm(dArray[i], (IloNumVar)((Object)this._cols.getObject(i)));
        }
        return cpxLinearNumExpr;
    }

    IloCopyable getDiverging() throws IloException {
        int[] nArray = new int[]{-1};
        int[] nArray2 = new int[]{-1};
        this.CALL(CplexI.CPXgetijdiv(this._env, this._lp, nArray, nArray2));
        if (nArray2[0] >= 0) {
            return this._cols.getObject(nArray2[0]);
        }
        if (nArray[0] >= 0) {
            return this._rows.getObject(nArray[0]);
        }
        return null;
    }

    double dualFarkas(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        int n = this.getNrows();
        if (dArray == null) {
            dArray = new double[n];
        }
        double[] dArray2 = new double[1];
        this._dualFarkas(dArray, dArray2);
        if (iloConstraintArray != null) {
            for (int i = 0; i < n; ++i) {
                iloConstraintArray[i] = (IloConstraint)((Object)this._rows.getObject(i));
            }
        }
        return dArray2[0];
    }

    void qpIndefCertificate(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this._qpIndefCertificate(dArray);
        int n = this.getNcols();
        for (int i = 0; i < n; ++i) {
            iloNumVarArray[i] = (IloNumVar)((Object)this._cols.getObject(i));
        }
    }

    void protectVariables(IloNumVar[] iloNumVarArray, int n, int n2) throws IloCplex.UnknownObjectException, IloException {
        int n3 = n + n2;
        int[] nArray = new int[n2];
        int n4 = 0;
        for (int i = n; i < n3; ++i) {
            CpxNumVar cpxNumVar = (CpxNumVar)iloNumVarArray[i];
            if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
                throw new IloCplex.UnknownObjectException(cpxNumVar);
            }
            nArray[n4++] = cpxNumVar.getVarIndexValue();
        }
        this.CALL(CplexI.CPXcopyprotected(this._env, this._lp, n4, nArray));
    }

    public IloCplex.Quality getQuality(int n, int n2) throws IloException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        double[] dArray = new double[1];
        IloCplex.Quality quality = new IloCplex.Quality();
        this._getQuality(n, nArray, nArray2, nArray3, dArray, n2);
        quality.var = null;
        quality.rng = null;
        if (nArray2[0] >= 0) {
            quality.rng = (CpxRange)this._rows.getObject(nArray2[0]);
        } else if (nArray3[0] >= 0) {
            quality.rng = (CpxRange)this._qcs.getObject(nArray3[0]);
        } else if (nArray[0] >= 0) {
            quality.var = (CpxNumVar)this._cols.getObject(nArray[0]);
        }
        quality.value = dArray[0];
        return quality;
    }

    final void setPriority(CplexIndex cplexIndex, int n) {
        this._ord.setPriority(cplexIndex, n);
    }

    final void setPriorities(CplexIndex[] cplexIndexArray, int[] nArray, int n, int n2) {
        this._ord.setPriorities(cplexIndexArray, nArray, n, n2);
    }

    final void setDirection(CplexIndex cplexIndex, int n) {
        this._ord.setDirection(cplexIndex, n);
    }

    final void setDirections(CplexIndex[] cplexIndexArray, int[] nArray, int n, int n2) {
        this._ord.setDirections(cplexIndexArray, nArray, n, n2);
    }

    final int getPriority(CplexIndex cplexIndex) {
        return this._ord.getPriority(cplexIndex);
    }

    final int getDirection(CplexIndex cplexIndex) {
        return this._ord.getDirection(cplexIndex);
    }

    final void getPriorities(int[] nArray, CplexIndex[] cplexIndexArray, int n, int n2) {
        this._ord.getPriorities(cplexIndexArray, nArray, n, n2);
    }

    final void getDirections(int[] nArray, CplexIndex[] cplexIndexArray, int n, int n2) {
        this._ord.getDirections(cplexIndexArray, nArray, n, n2);
    }

    public void copyOrder(int[] nArray, int[] nArray2, int[] nArray3) throws IloException {
        this._copyOrder(nArray, nArray2, nArray3);
    }

    void writeOrder(String string) throws IloException {
        this.flushNames();
        this._ord.install(this);
        this._writeOrder(string);
    }

    void writeConflict(String string) throws IloException {
        this.flushNames();
        this._ord.install(this);
        this._writeConflict(string);
    }

    void writeParam(String string) throws IloException {
        this.CALL(CplexI.CPXEwriteparam(this._env, CplexI.getBytes(string)));
    }

    void writeBasis(String string) throws IloException {
        this.flushNames();
        this.CALL(CplexI.CPXmbasewrite(this._env, this._lp, CplexI.getBytes(string)));
    }

    void writeVectors(String string) throws IloException {
        this.flushNames();
        this.CALL(CplexI.CPXvecwrite(this._env, this._lp, CplexI.getBytes(string)));
    }

    void writeSolution(String string, int n) throws IloException {
        this.flushNames();
        this.CALL(CplexI.CPXsolwritesolnpool(this._env, this._lp, n, CplexI.getBytes(string)));
    }

    void writeSolutions(String string) throws IloException {
        this.flushNames();
        this.CALL(CplexI.CPXsolwritesolnpoolall(this._env, this._lp, CplexI.getBytes(string)));
    }

    void writeTextSolution(String string) throws IloException {
        this.flushNames();
        this.CALL(CplexI.CPXtxtsolwrite(this._env, this._lp, CplexI.getBytes(string)));
    }

    void writeMIPStart(String string, int n) throws IloException {
        this.flushNames();
        this.CALL(CplexI.CPXwritemipstarts(this._env, this._lp, CplexI.getBytes(string), n, n));
    }

    void writeMIPStarts(String string, int n, int n2) throws IloException {
        int n3 = n + n2 - 1;
        int n4 = this.getNMIPStarts();
        this.flushNames();
        if (n3 >= n4) {
            n3 = n4 - 1;
        }
        this.CALL(CplexI.CPXwritemipstarts(this._env, this._lp, CplexI.getBytes(string), n, n3));
    }

    void readOrder(String string) throws IloException {
        this.CALL(CplexI.CPXreadcopyorder(this._env, this._lp, CplexI.getBytes(string)));
        this._ord.read(this);
    }

    void readParam(String string) throws IloException {
        this.CALL(CplexI.CPXreadcopyparam(this._env, CplexI.getBytes(string)));
    }

    void readBasis(String string) throws IloException {
        this.CALL(CplexI.CPXreadcopybase(this._env, this._lp, CplexI.getBytes(string)));
    }

    void readSolution(String string) throws IloException {
        this.CALL(CplexI.CPXreadcopysol(this._env, this._lp, CplexI.getBytes(string)));
    }

    void readVectors(String string) throws IloException {
        this.CALL(CplexI.CPXreadcopyvec(this._env, this._lp, CplexI.getBytes(string)));
    }

    void readMIPStart(String string) throws IloException {
        this.CALL(CplexI.CPXreadcopymipstarts(this._env, this._lp, CplexI.getBytes(string)));
        int n = CplexI.CPXgetnummipstarts(this._env, this._lp);
        if (n > 1) {
            this.CALL(CplexI.CPXdelmipstarts(this._env, this._lp, 1, n - 1));
        }
    }

    void readMIPStarts(String string) throws IloException {
        this.CALL(CplexI.CPXreadcopymipstarts(this._env, this._lp, CplexI.getBytes(string)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void solve(IloCplex iloCplex, IloCplex.Goal goal) throws IloException {
        block15: {
            int n = CplexI.CPXEgetmaxthreads(this._env);
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            CpxCallback cpxCallback = null;
            CpxCallback cpxCallback2 = null;
            CpxCallback cpxCallback3 = null;
            CpxCallback cpxCallback4 = null;
            CpxCallback cpxCallback5 = null;
            this.flushNames();
            if (goal != null) {
                this._globalCuts = new ArrayList[n];
                for (int i = 0; i < this._globalCuts.length; ++i) {
                    this._globalCuts[i] = new ArrayList();
                }
                this.initGoals(nArray, nArray2);
                cpxCallback = this._cb[11];
                cpxCallback2 = this._cb[14];
                cpxCallback3 = this._cb[16];
                cpxCallback4 = this._cb[12];
                cpxCallback5 = this._cb[13];
                iloCplex.use(new CpxGoalBranchCallback(this));
                iloCplex.use(new CpxGoalNodeCallback(this));
                iloCplex.use(new CpxGoalIncumbentCallback(this, this.getDoubleParam(1016)));
                iloCplex.use(new CpxGoalLazyConstraintCallback(this));
                iloCplex.use(new CpxGoalUserCutCallback(this));
                this._rootNode = new CpxNode(iloCplex, 1.0E20);
                this._rootNode._nId = new IloCplex.NodeId(0L);
                this._rootNode.addGoalStack(goal);
            }
            try {
                this._rootGoal = goal;
                this.solve();
                this._rootGoal = null;
                Object var13_12 = null;
                if (goal == null) break block15;
                this._globalCuts = null;
                this._rootNode = null;
                this._cb[11] = null;
                this._cb[14] = null;
                this._cb[16] = null;
                this._cb[12] = null;
                this._cb[13] = null;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (goal != null) {
                    this._globalCuts = null;
                    this._rootNode = null;
                    this._cb[11] = null;
                    this._cb[14] = null;
                    this._cb[16] = null;
                    this._cb[12] = null;
                    this._cb[13] = null;
                    CplexI.CPXsetbranchcallbackfunc(this.getEnv(), null, null);
                    CplexI.CPXsetincumbentcallbackfunc(this.getEnv(), null, null);
                    CplexI.CPXsetnodecallbackfunc(this.getEnv(), null, null);
                    CplexI.CPXsetusercutcallbackfunc(this.getEnv(), null, null);
                    CplexI.CPXsetlazyconstraintcallbackfunc(this.getEnv(), null, null);
                    if (cpxCallback != null) {
                        this.setCallback(cpxCallback);
                    }
                    if (cpxCallback2 != null) {
                        this.setCallback(cpxCallback2);
                    }
                    if (cpxCallback3 != null) {
                        this.setCallback(cpxCallback3);
                    }
                    if (cpxCallback4 != null) {
                        this.setCallback(cpxCallback4);
                    }
                    if (cpxCallback5 != null) {
                        this.setCallback(cpxCallback5);
                    }
                    this.finitGoals(nArray[0], nArray2[0]);
                }
                throw throwable;
            }
            CplexI.CPXsetbranchcallbackfunc(this.getEnv(), null, null);
            CplexI.CPXsetincumbentcallbackfunc(this.getEnv(), null, null);
            CplexI.CPXsetnodecallbackfunc(this.getEnv(), null, null);
            CplexI.CPXsetusercutcallbackfunc(this.getEnv(), null, null);
            CplexI.CPXsetlazyconstraintcallbackfunc(this.getEnv(), null, null);
            if (cpxCallback != null) {
                this.setCallback(cpxCallback);
            }
            if (cpxCallback2 != null) {
                this.setCallback(cpxCallback2);
            }
            if (cpxCallback3 != null) {
                this.setCallback(cpxCallback3);
            }
            if (cpxCallback4 != null) {
                this.setCallback(cpxCallback4);
            }
            if (cpxCallback5 != null) {
                this.setCallback(cpxCallback5);
            }
            this.finitGoals(nArray[0], nArray2[0]);
            {
            }
        }
    }

    public final IloCplex.Goal failGoal() {
        return new CpxFailGoal();
    }

    final CpxNode getRootNode() {
        return this._rootNode;
    }

    final void setRootNode(CpxNode cpxNode) {
        this._rootNode = cpxNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGlobalCuts(ArrayList arrayList, int n) {
        ArrayList arrayList2 = this._globalCuts[n];
        synchronized (arrayList2) {
            this._globalCuts[n].addAll(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postGlobalCuts(CpxGoalLazyConstraintCallback cpxGoalLazyConstraintCallback) throws IloException {
        for (int i = 0; i < this._globalCuts.length; ++i) {
            ArrayList arrayList = this._globalCuts[i];
            synchronized (arrayList) {
                for (int j = 0; j < this._globalCuts[i].size(); ++j) {
                    cpxGoalLazyConstraintCallback.addGlobalCut((IloRange)this._globalCuts[i].get(j));
                }
                this._globalCuts[i].clear();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postGlobalCuts(CpxGoalUserCutCallback cpxGoalUserCutCallback) throws IloException {
        for (int i = 0; i < this._globalCuts.length; ++i) {
            ArrayList arrayList = this._globalCuts[i];
            synchronized (arrayList) {
                for (int j = 0; j < this._globalCuts[i].size(); ++j) {
                    cpxGoalUserCutCallback.addGlobalCut((IloRange)this._globalCuts[i].get(j));
                }
                this._globalCuts[i].clear();
                continue;
            }
        }
    }

    public final boolean useDefaultSearch() {
        return !this._usesEval;
    }

    public final void setDefaultSearch(boolean bl) {
        this._usesEval = !bl;
    }

    final void CALL(int n) throws IloException {
        if (n == 1002) {
            throw new IloCplex.CplexEndedException();
        }
        if (n != 0) {
            String string = this._getErrorMessage(n);
            if (string == null || string.replaceAll(" ", "").length() == 0) {
                try {
                    byte[] byArray = new byte[1024];
                    if (Cplex.CPXgeterrorstring(this.getEnv(), n, byArray) != 0L) {
                        string = CplexI.getString(byArray);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new CpxException(n, string);
        }
    }

    final void disableOutput() throws IloException {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long[] lArray3 = new long[1];
        long[] lArray4 = new long[1];
        CplexI.CleanChannels(this._env);
        this.CALL(CplexI.CPXgetchannels(this._env, lArray3, lArray2, lArray, lArray4));
        this.CALL(CplexI.CPXdisconnectchannel(this._env, lArray[0]));
        this.CALL(CplexI.CPXdisconnectchannel(this._env, lArray2[0]));
        this.CALL(CplexI.CPXdisconnectchannel(this._env, lArray3[0]));
        this.CALL(CplexI.CPXdisconnectchannel(this._env, lArray4[0]));
    }

    final void enableOutput() throws IloException {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long[] lArray3 = new long[1];
        long[] lArray4 = new long[1];
        this.CALL(CplexI.CPXgetchannels(this._env, lArray3, lArray2, lArray, lArray4));
        this.CALL(CplexI.CPXaddfuncdest(this._env, lArray[0], this, new ErrorChannelFunction()));
        this.CALL(CplexI.CPXaddfuncdest(this._env, lArray2[0], this, new WarnChannelFunction()));
        this.CALL(CplexI.CPXaddfuncdest(this._env, lArray3[0], this, new OutChannelFunction()));
        this.CALL(CplexI.CPXaddfuncdest(this._env, lArray4[0], this, new OutChannelFunction()));
    }

    public final int getNNZs() {
        return CplexI.CPXgetnumnz(this._env, this._lp);
    }

    public final int getNNZs(int[] nArray) {
        return CplexI.CPXEgetnumrownz(this._env, this._lp, nArray);
    }

    public final int getNintVars() {
        return CplexI.CPXgetnumint(this._env, this._lp);
    }

    public final int getNbinVars() {
        return CplexI.CPXgetnumbin(this._env, this._lp);
    }

    public final int getNsemiContVars() {
        return CplexI.CPXgetnumsemicont(this._env, this._lp);
    }

    public final int getNsemiIntVars() {
        return CplexI.CPXgetnumsemiint(this._env, this._lp);
    }

    public final long getNiterations() {
        if (this.isMIP()) {
            return CplexI.CPXSgetmipitcnt(this._env, this._lp);
        }
        long l = CplexI.CPXSgetsiftitcnt(this._env, this._lp);
        if (l > 0L) {
            return l;
        }
        l = CplexI.CPXSgetbaritcnt(this._env, this._lp);
        if (l > 0L) {
            return l;
        }
        return CplexI.CPXSgetitcnt(this._env, this._lp);
    }

    public final long getNbarrierIterations() {
        return CplexI.CPXSgetbaritcnt(this._env, this._lp);
    }

    public final long getNsiftingIterations() {
        return CplexI.CPXSgetsiftitcnt(this._env, this._lp);
    }

    public final long getNsiftingPhaseOneIterations() {
        return CplexI.CPXSgetsiftphase1cnt(this._env, this._lp);
    }

    public final long getNphaseOneIterations() {
        return CplexI.CPXSgetphase1cnt(this._env, this._lp);
    }

    public final long getNcrossDExch() {
        return CplexI.CPXSgetcrossdexchcnt(this._env, this._lp);
    }

    public final long getNcrossDPush() {
        return CplexI.CPXSgetcrossdpushcnt(this._env, this._lp);
    }

    public final long getNcrossPExch() {
        return CplexI.CPXSgetcrosspexchcnt(this._env, this._lp);
    }

    public final long getNcrossPPush() {
        return CplexI.CPXSgetcrossppushcnt(this._env, this._lp);
    }

    public final int getNdualSuperbasics() {
        return CplexI.CPXgetdsbcnt(this._env, this._lp);
    }

    public final int getNprimalSuperbasics() {
        return CplexI.CPXgetpsbcnt(this._env, this._lp);
    }

    public final long getNnodes() {
        return CplexI.CPXSgetnodecnt(this._env, this._lp);
    }

    public final long getNnodesLeft() {
        return CplexI.CPXSgetnodeleftcnt(this._env, this._lp);
    }

    public final int getNcuts(int n) throws IloException {
        int[] nArray = new int[1];
        this.CALL(CplexI.CPXgetnumcuts(this._env, this._lp, n, nArray));
        return nArray[0];
    }

    public final long getIncumbentNode() {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            return CplexI.CPXgetnodeint(this._env, this._lp);
        }
        return 0L;
    }

    public final int getCplexStatus() {
        return this._status;
    }

    public final int getCplexSubStatus() {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            return CplexI.CPXgetsubstat(this._env, this._lp);
        }
        return 0;
    }

    public final int getMethod() {
        return CplexI.CPXgetmethod(this._env, this._lp);
    }

    public final int getSubMethod() {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            return CplexI.CPXgetsubmethod(this._env, this._lp);
        }
        return -1;
    }

    public final void setSense(int n) throws IloException {
        this.invalidate();
        this.CALL(CplexI.CPXchgobjsen(this._env, this._lp, n));
    }

    final void _getParamType(int n, int[] nArray) throws IloException {
        this.CALL(CplexI.CPXgetparamtype(this._env, n, nArray));
    }

    public final void _setIntParam(int n, int n2) throws IloException {
        this.CALL(CplexI.CPXsetintparam(this._env, n, n2));
    }

    public final void _getIntParam(int n, int[] nArray) throws IloException {
        this.CALL(CplexI.CPXgetintparam(this._env, n, nArray));
    }

    public final void _minIntParam(int n, int[] nArray) throws IloException {
        this.CALL(CplexI.CPXinfointparam(this._env, n, null, nArray, null));
    }

    public final void _maxIntParam(int n, int[] nArray) throws IloException {
        this.CALL(CplexI.CPXinfointparam(this._env, n, null, null, nArray));
    }

    public final void _defIntParam(int n, int[] nArray) throws IloException {
        this.CALL(CplexI.CPXinfointparam(this._env, n, nArray, null, null));
    }

    public final void _setLongParam(int n, long l) throws IloException {
        this.CALL(CplexI.CPXsetlongparam(this._env, n, l));
    }

    public final void _getLongParam(int n, long[] lArray) throws IloException {
        this.CALL(CplexI.CPXgetlongparam(this._env, n, lArray));
    }

    public final void _minLongParam(int n, long[] lArray) throws IloException {
        this.CALL(CplexI.CPXinfolongparam(this._env, n, null, lArray, null));
    }

    public final void _maxLongParam(int n, long[] lArray) throws IloException {
        this.CALL(CplexI.CPXinfolongparam(this._env, n, null, null, lArray));
    }

    public final void _defLongParam(int n, long[] lArray) throws IloException {
        this.CALL(CplexI.CPXinfolongparam(this._env, n, lArray, null, null));
    }

    public final void _setDoubleParam(int n, double d) throws IloException {
        this.CALL(CplexI.CPXsetdblparam(this._env, n, d));
    }

    public final void _getDoubleParam(int n, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetdblparam(this._env, n, dArray));
    }

    public final void _minDoubleParam(int n, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXinfodblparam(this._env, n, null, dArray, null));
    }

    public final void _maxDoubleParam(int n, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXinfodblparam(this._env, n, null, null, dArray));
    }

    public final void _defDoubleParam(int n, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXinfodblparam(this._env, n, dArray, null, null));
    }

    public final void _setStringParam(int n, String string) throws IloException {
        this.CALL(CplexI.CPXsetstrparam(this._env, n, CplexI.getBytes(string)));
    }

    public final void _getStringParam(int n, String[] stringArray) throws IloException {
        byte[] byArray = new byte[512];
        this.CALL(CplexI.CPXgetstrparam(this._env, n, byArray));
        stringArray[0] = CplexI.getString(byArray);
    }

    public final void _defStringParam(int n, String[] stringArray) throws IloException {
        byte[] byArray = new byte[512];
        this.CALL(CplexI.CPXinfostrparam(this._env, n, byArray));
        stringArray[0] = CplexI.getString(byArray);
    }

    public final void setDefaults() throws IloException {
        this.CALL(CplexI.CPXsetdefaults(this._env));
        this.CALL(CplexI.CPXsetstrparam(this._env, 1130, CplexI.getBytes(encoding)));
    }

    public final String getVersion() {
        return CplexI.getString(CplexI.CPXversion(this._env));
    }

    public final int getVersionNumber() throws IloException {
        int[] nArray = new int[1];
        this.CALL(CplexI.CPXversionnumber(this._env, nArray));
        return nArray[0];
    }

    final String getErrorMessage(int n) {
        byte[] byArray = new byte[1024];
        CplexI.CPXgeterrorstring(this.getEnv(), n, byArray);
        return CplexI.getString(byArray);
    }

    final void readVMConfig(String string) throws IloException {
        byte[] byArray = CplexI.getBytes(string);
        this.CALL(CplexI.CPXreadcopyvmconfig(this._env, byArray));
    }

    final void copyVMConfig(String string) throws IloException {
        this.CALL(CplexI.CPXcopyvmconfig(this._env, string));
    }

    final void delVMConfig() throws IloException {
        this.CALL(CplexI.CPXdelvmconfig(this._env));
    }

    final boolean hasVMConfig() throws IloException {
        int[] nArray = new int[1];
        this.CALL(CplexI.CPXEhasvmconfig(this._env, nArray));
        return nArray[0] != 0;
    }

    final String _getErrorMessage(int n) {
        if (this._error != null) {
            return this._error;
        }
        return this.getErrorMessage(n);
    }

    final void clearErrorMessage() {
        this._error = null;
    }

    final void _readModel(String string) throws IloException {
        this.flushNames();
        this.invalidate();
        byte[] byArray = CplexI.getBytes(string);
        this.CALL(CplexI.CPXreadcopyprob(this._env, this._lp, byArray, null));
        int n = CplexI.CPXgetnumrows(this._env, this._lp);
        byte[] byArray2 = new byte[n];
        this.CALL(CplexI.CPXgetsense(this._env, this._lp, byArray2, 0, n - 1));
        for (int i = 0; i < n; ++i) {
            if (byArray2[i] != 82) continue;
            int[] nArray = new int[n];
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            byte[] byArray3 = new byte[]{76};
            byte[] byArray4 = new byte[]{71};
            int[] nArray2 = new int[]{0};
            this.CALL(CplexI.CPXgetrngval(this._env, this._lp, dArray, 0, n - 1));
            this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray2, 0, n - 1));
            int n2 = 0;
            while (i < n) {
                if (byArray2[i] == 82) {
                    nArray2[0] = i;
                    if (dArray[i] <= -1.0E20) {
                        this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray2, byArray3));
                    } else if (dArray[i] >= 1.0E20) {
                        this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray2, byArray4));
                    } else if (dArray[i] < 0.0) {
                        nArray[n2] = i;
                        dArray2[n2] = dArray2[i] + dArray[i];
                        dArray[n2] = -dArray[i];
                        ++n2;
                    }
                }
                ++i;
            }
            if (n2 <= 0) continue;
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, n2, nArray, dArray2));
            this.CALL(CplexI.CPXchgrngval(this._env, this._lp, n2, nArray, dArray));
        }
    }

    final void _writeModel(String string) throws IloException {
        this.flushNames();
        this.CALL(CplexI.CPXwriteprob(this._env, this._lp, CplexI.getBytes(string), null));
    }

    final void _clearModel() throws IloException {
        this.flushNames();
        this.invalidate();
        long[] lArray = new long[]{this._lp};
        this.CALL(CplexI.CPXfreeprob(this._env, lArray));
        this._lp = 0L;
        int[] nArray = new int[1];
        String string = this.probName();
        this._lp = CplexI.CPXcreateprob(this._env, nArray, string);
        this.CALL(nArray[0]);
    }

    final double _getObjOffset() throws IloException {
        double[] dArray = new double[]{0.0};
        this.CALL(CplexI.CPXgetobjoffset(this._env, this._lp, dArray));
        return dArray[0];
    }

    final int _getSense() {
        return CplexI.CPXgetobjsen(this._env, this._lp);
    }

    final int _getNcols() {
        return CplexI.CPXgetnumcols(this._env, this._lp);
    }

    final int _getNinds() {
        return CplexI.CPXgetnumindconstrs(this._env, this._lp);
    }

    final int _getNLCs() {
        return CplexI.CPXgetnumlazyconstraints(this._env, this._lp);
    }

    final int _getNUCs() {
        return CplexI.CPXgetnumusercuts(this._env, this._lp);
    }

    final int _getNrows() {
        return CplexI.CPXgetnumrows(this._env, this._lp);
    }

    final int _getNQCs() {
        return CplexI.CPXgetnumqconstrs(this._env, this._lp);
    }

    final int _getNSOSs() {
        return CplexI.CPXgetnumsos(this._env, this._lp);
    }

    private final void origProbType() throws IloException {
        switch (CplexI.CPXgetprobtype(this._env, this._lp)) {
            case 3: {
                this._status = 0;
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 1));
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                int[] nArray = new int[1];
                CplexI.CPXgetintparam(this._env, 1148, nArray);
                this._status = 0;
                if (this.isMIP() || this.isQO() && nArray[0] == 3) {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 7));
                    break;
                }
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 5));
                break;
            }
        }
    }

    private final void checkStillMIP() throws IloException {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 3 || n == 8 || n == 11 || n == 7 || n == 1) {
            if (CplexI.CPXgetnumint(this._env, this._lp) > 0) {
                return;
            }
            if (CplexI.CPXgetnumbin(this._env, this._lp) > 0) {
                return;
            }
            if (CplexI.CPXgetnumsos(this._env, this._lp) > 0) {
                return;
            }
            if (CplexI.CPXgetnumsemicont(this._env, this._lp) > 0) {
                return;
            }
            if (CplexI.CPXgetnumsemiint(this._env, this._lp) > 0) {
                return;
            }
            for (int i = 5; i < 27; ++i) {
                if (CplexI.CPXEgetnumgconstrs(this._env, this._lp, i) <= 0) continue;
                return;
            }
            if (n == 11) {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 10));
            } else if (n == 7 || n == 8) {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 5));
            } else {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 0));
            }
        }
    }

    final void _addRows(int n, double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, double[] dArray3, String[] stringArray) throws IloException {
        byte[] byArray = new byte[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        int[] nArray3 = new int[n];
        int n2 = CplexI.CPXgetnumrows(this._env, this._lp);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (dArray2[i] >= 1.0E20) {
                byArray[i] = 71;
                dArray4[i] = dArray[i];
                continue;
            }
            if (dArray[i] <= -1.0E20) {
                byArray[i] = 76;
                dArray4[i] = dArray2[i];
                continue;
            }
            if (dArray[i] == dArray2[i]) {
                byArray[i] = 69;
                dArray4[i] = dArray2[i];
                continue;
            }
            byArray[i] = 82;
            dArray4[i] = dArray[i];
            dArray5[n3] = dArray2[i] - dArray[i];
            nArray3[n3] = i + n2;
            ++n3;
        }
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXaddrows(this._env, this._lp, 0, n, nArray[n], dArray4, byArray, nArray, nArray2, dArray3, null, stringArray));
        if (n3 > 0) {
            this.CALL(CplexI.CPXchgrngval(this._env, this._lp, n3, nArray3, dArray5));
        }
    }

    final void _delQCs(int n, int n2) throws IloException {
        this.origProbType();
        this.invalidate();
        if (n > n2) {
            return;
        }
        this.CALL(CplexI.CPXdelqconstrs(this._env, this._lp, n, n2));
        this.checkStillMIP();
    }

    final void _delRows(int n, int n2) throws IloException {
        this.origProbType();
        this.invalidate();
        if (n > n2) {
            return;
        }
        if (this._fixBasis && CplexI.CPXEcangetbase(this._env, this._lp) != 0) {
            int n3 = n2 - n + 1;
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = n + i;
            }
            this.CALL(CplexI.CPXpivotin(this._env, this._lp, nArray, n3));
        }
        this.CALL(CplexI.CPXdelrows(this._env, this._lp, n, n2));
        this.checkStillMIP();
    }

    final void _delRows(int[] nArray) throws IloException {
        this.origProbType();
        this.invalidate();
        if (this._fixBasis && CplexI.CPXEcangetbase(this._env, this._lp) != 0) {
            int n = CplexI.CPXgetnumrows(this._env, this._lp);
            int n2 = 0;
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == 0) continue;
                nArray2[n2++] = i;
            }
            this.CALL(CplexI.CPXpivotin(this._env, this._lp, nArray2, n2));
        }
        this.CALL(CplexI.CPXdelsetrows(this._env, this._lp, nArray));
        this.checkStillMIP();
    }

    final void _newColumns(int n, double[] dArray, double[] dArray2, byte[] byArray, String[] stringArray) throws IloException {
        int n2;
        this.origProbType();
        this.invalidate();
        boolean bl = false;
        for (n2 = 0; n2 < n; ++n2) {
            if (byArray[n2] == 67) continue;
            bl = true;
            break;
        }
        if (bl) {
            n2 = CplexI.CPXgetprobtype(this._env, this._lp);
            if (n2 != 1 && n2 != 7 && n2 != 11) {
                if (n2 == 5) {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 7));
                } else if (n2 == 10) {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 11));
                } else if (n2 != 1) {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 1));
                }
            }
            int n3 = CplexI.CPXgetnumcols(this._env, this._lp);
            int[] nArray = new int[n];
            int n4 = n3 - n;
            for (int i = 0; i < n; ++i) {
                nArray[i] = n4++;
            }
            this.CALL(CplexI.CPXnewcols(this._env, this._lp, n, null, dArray, dArray2, byArray, stringArray));
        } else {
            this.CALL(CplexI.CPXnewcols(this._env, this._lp, n, null, dArray, dArray2, null, stringArray));
        }
    }

    final void _delColumns(int n, int n2) throws IloException {
        this.origProbType();
        this.invalidate();
        if (n > n2) {
            return;
        }
        if (this._fixBasis && CplexI.CPXEcangetbase(this._env, this._lp) != 0) {
            int n3 = n2 - n + 1;
            int[] nArray = new int[n3];
            double[] dArray = new double[n3];
            byte[] byArray = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = n + i;
                byArray[i] = 66;
            }
            this.CALL(CplexI.CPXchgbds(this._env, this._lp, n3, nArray, byArray, dArray));
            this.CALL(CplexI.CPXpivotout(this._env, this._lp, nArray, n3));
        }
        this.CALL(CplexI.CPXdelcols(this._env, this._lp, n, n2));
        this.checkStillMIP();
    }

    final void _delColumns(int[] nArray) throws IloException {
        this.origProbType();
        this.flushNames();
        this.invalidate();
        if (this._fixBasis && CplexI.CPXEcangetbase(this._env, this._lp) != 0) {
            int n = CplexI.CPXgetnumcols(this._env, this._lp);
            int[] nArray2 = new int[n];
            double[] dArray = new double[n];
            byte[] byArray = new byte[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == 0) continue;
                byArray[n2] = 66;
                nArray2[n2++] = i;
            }
            this.CALL(CplexI.CPXchgbds(this._env, this._lp, n2, nArray2, byArray, dArray));
            this.CALL(CplexI.CPXpivotout(this._env, this._lp, nArray2, n2));
        }
        this.CALL(CplexI.CPXdelsetcols(this._env, this._lp, nArray));
        this.checkStillMIP();
    }

    final void _addSOSs(int n, byte[] byArray, int[] nArray, int[] nArray2, double[] dArray, String[] stringArray) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXaddsos(this._env, this._lp, n, nArray[n], byArray, nArray, nArray2, dArray, stringArray));
    }

    final void _delSOSs(int[] nArray) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXdelsetsos(this._env, this._lp, nArray));
        this.checkStillMIP();
    }

    final int _getSOSNZnum(int n, int n2) throws IloException {
        int[] nArray = new int[1];
        int n3 = CplexI.CPXgetsos(this._env, this._lp, null, null, null, null, null, 0, nArray, n, n2);
        if (n3 != 0 && n3 != 1207) {
            this.CALL(n3);
        }
        this.clearErrorMessage();
        return -nArray[0];
    }

    final void _getSOSs(int n, int n2, byte[] byArray, int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        this.CALL(CplexI.CPXgetsos(this._env, this._lp, nArray3, byArray, nArray, nArray2, dArray, nArray2.length, nArray4, n, n2));
        nArray[n2 - n + 1] = nArray3[0];
    }

    final void _addNZs(int n, int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        this.origProbType();
        this.invalidate();
        int[] nArray3 = new int[1];
        CplexI.CPXgetintparam(this._env, IloCplex.BooleanParam.DataCheck.getValue(), nArray3);
        if (this.isRemoteEnv || nArray3[0] != 0) {
            this.CALL(CplexI.CPXchgcoeflist(this._env, this._lp, n, nArray, nArray2, dArray));
        } else {
            this.CALL(CplexI.CPXEcacheNewNZsByNZ(this._env, this._lp, n, nArray, nArray2, dArray));
        }
    }

    final void _addCuts(int n, double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, double[] dArray3, String[] stringArray, int n2) throws IloException {
        byte[] byArray = new byte[n];
        double[] dArray4 = new double[n];
        this.invalidate();
        int n3 = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n3 == 5 || n3 == 7) {
            this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 7));
        } else {
            this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 1));
        }
        for (int i = 0; i < n; ++i) {
            if (dArray2[i] >= 1.0E20) {
                byArray[i] = 71;
                dArray4[i] = dArray[i];
                continue;
            }
            if (dArray[i] <= -1.0E20) {
                byArray[i] = 76;
                dArray4[i] = dArray2[i];
                continue;
            }
            if (dArray[i] == dArray2[i]) {
                byArray[i] = 69;
                dArray4[i] = dArray2[i];
                continue;
            }
            byArray[i] = 71;
            dArray4[i] = dArray[i];
            double[] dArray5 = new double[1];
            int[] nArray3 = new int[1];
            byte[] byArray2 = new byte[1];
            dArray5[0] = dArray2[i];
            byArray2[0] = 76;
            if (n2 != 0) {
                this.CALL(CplexI.CPXaddlazyconstraints(this._env, this._lp, 1, nArray[i + 1] - nArray[i], dArray5, byArray2, nArray3, nArray2, dArray3, stringArray));
                continue;
            }
            this.CALL(CplexI.CPXaddusercuts(this._env, this._lp, 1, nArray[i + 1] - nArray[i], dArray5, byArray2, nArray3, nArray2, dArray3, stringArray));
        }
        if (n2 != 0) {
            this.CALL(CplexI.CPXaddlazyconstraints(this._env, this._lp, n, nArray[n], dArray4, byArray, nArray, nArray2, dArray3, stringArray));
            this.CALL(Cplex.CPXsetintparam(this._env, 1057, 1));
        } else {
            this.CALL(CplexI.CPXaddusercuts(this._env, this._lp, n, nArray[n], dArray4, byArray, nArray, nArray2, dArray3, stringArray));
            this.CALL(CplexI.CPXsetintparam(this._env, 1058, 0));
        }
    }

    final void _delCuts(int n) throws IloException {
        if (n != 0) {
            this.invalidate();
            this.CALL(CplexI.CPXfreelazyconstraints(this._env, this._lp));
        } else {
            this.invalidate();
            this.CALL(CplexI.CPXfreeusercuts(this._env, this._lp));
        }
        this.checkStillMIP();
    }

    final void _setObjective(double[] dArray, double d) throws IloException {
        int n = dArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgobj(this._env, this._lp, n, nArray, dArray));
        this.CALL(CplexI.CPXchgobjoffset(this._env, this._lp, d));
    }

    static int sortQ(int n, double[] dArray, int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        if (n < 2) {
            return n;
        }
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = 0; j < n - i; ++j) {
                n2 = n3 + i;
                for (n3 = j; n3 >= 0 && (nArray[n3] > nArray[n2] || nArray[n3] == nArray[n2] && nArray2[n3] > nArray2[n2]); n3 -= i) {
                    double d = dArray[n3];
                    dArray[n3] = dArray[n2];
                    dArray[n2] = d;
                    int n4 = nArray[n3];
                    nArray[n3] = nArray[n2];
                    nArray[n2] = n4;
                    n4 = nArray2[n3];
                    nArray2[n3] = nArray2[n2];
                    nArray2[n2] = n4;
                    n2 = n3;
                }
            }
        }
        n2 = 0;
        for (n3 = 1; n3 < n; ++n3) {
            if (nArray2[n3] != nArray2[n2] || nArray[n3] != nArray[n2]) {
                dArray[++n2] = dArray[n3];
                nArray[n2] = nArray[n3];
                nArray2[n2] = nArray2[n3];
                continue;
            }
            int n5 = n2;
            dArray[n5] = dArray[n5] + dArray[n3];
        }
        return n2 + 1;
    }

    final void _setQ(int n, double[] dArray, int[] nArray, int[] nArray2) throws IloException {
        int n2;
        int n3;
        int n4;
        int n5 = CplexI.sortQ(n, dArray, nArray, nArray2);
        int n6 = CplexI.CPXgetnumcols(this._env, this._lp);
        double[] dArray2 = new double[2 * n5];
        int[] nArray3 = new int[2 * n5];
        int[] nArray4 = new int[n6];
        int[] nArray5 = new int[n6];
        for (n4 = 0; n4 < n5; ++n4) {
            int n7 = n3 = nArray[n4];
            nArray4[n7] = nArray4[n7] + 1;
            n2 = nArray2[n4];
            if (n3 == n2) continue;
            int n8 = n2;
            nArray4[n8] = nArray4[n8] + 1;
        }
        nArray5[0] = 0;
        for (n4 = 1; n4 < n6; ++n4) {
            nArray5[n4] = nArray5[n4 - 1] + nArray4[n4 - 1];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray[n4];
            n2 = nArray2[n4];
            if (n3 == n2) {
                dArray2[nArray5[n3]] = 2.0 * dArray[n4];
                nArray3[nArray5[n3]] = n3;
                int n9 = n3;
                nArray5[n9] = nArray5[n9] + 1;
                continue;
            }
            dArray2[nArray5[n3]] = dArray[n4];
            nArray3[nArray5[n3]] = n2;
            int n10 = n3;
            nArray5[n10] = nArray5[n10] + 1;
            dArray2[nArray5[n2]] = dArray[n4];
            nArray3[nArray5[n2]] = n3;
            int n11 = n2;
            nArray5[n11] = nArray5[n11] + 1;
        }
        for (n4 = 0; n4 < n6; ++n4) {
            int n12 = n4;
            nArray5[n12] = nArray5[n12] - nArray4[n4];
        }
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXcopyquad(this._env, this._lp, nArray5, nArray4, nArray3, dArray2));
    }

    final void _setLb(int n, double d) throws IloException {
        this.origProbType();
        this.invalidate();
        int[] nArray = new int[]{n};
        byte[] byArray = new byte[]{76};
        double[] dArray = new double[]{d};
        this.CALL(CplexI.CPXchgbds(this._env, this._lp, 1, nArray, byArray, dArray));
    }

    final void _setLbs(int[] nArray, double[] dArray) throws IloException {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = 76;
        }
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgbds(this._env, this._lp, nArray.length, nArray, byArray, dArray));
    }

    final void _setUb(int n, double d) throws IloException {
        this.origProbType();
        this.invalidate();
        int[] nArray = new int[]{n};
        byte[] byArray = new byte[]{85};
        double[] dArray = new double[]{d};
        this.CALL(CplexI.CPXchgbds(this._env, this._lp, 1, nArray, byArray, dArray));
    }

    final void _setUbs(int[] nArray, double[] dArray) throws IloException {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = 85;
        }
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgbds(this._env, this._lp, nArray.length, nArray, byArray, dArray));
    }

    final void _setType(int n, byte by) throws IloException {
        this.origProbType();
        this.invalidate();
        int[] nArray = new int[]{n};
        byte[] byArray = new byte[]{by};
        this.CALL(CplexI.CPXchgctype(this._env, this._lp, 1, nArray, byArray));
        this.checkStillMIP();
    }

    final void _setTypes(int[] nArray, byte[] byArray) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgctype(this._env, this._lp, nArray.length, nArray, byArray));
        this.checkStillMIP();
    }

    final void _setLHS(int n, double d) throws IloException {
        byte[] byArray = new byte[1];
        int[] nArray = new int[]{n};
        double[] dArray = new double[]{d};
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXgetsense(this._env, this._lp, byArray, n, n));
        if (byArray[0] == 71) {
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
        } else if (byArray[0] == 76) {
            if (d > -1.0E20) {
                double[] dArray2 = new double[1];
                this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray2, n, n));
                if (d == dArray2[0]) {
                    byArray[0] = 69;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                } else {
                    byArray[0] = 82;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
                    double[] dArray3 = new double[]{dArray2[0] - d};
                    this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray3));
                }
            }
        } else if (byArray[0] == 69) {
            if (d <= -1.0E20) {
                byArray[0] = 76;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            } else {
                double[] dArray4 = new double[1];
                this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray4, n, n));
                if (dArray4[0] != d) {
                    byArray[0] = 82;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
                    double[] dArray5 = new double[]{dArray4[0] - d};
                    this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray5));
                }
            }
        } else {
            double[] dArray6 = new double[1];
            double[] dArray7 = new double[1];
            this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray6, n, n));
            this.CALL(CplexI.CPXgetrngval(this._env, this._lp, dArray7, n, n));
            if (d <= -1.0E20) {
                byArray[0] = 76;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                dArray6[0] = dArray6[0] + dArray7[0];
                this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray6));
            } else if (dArray6[0] != d) {
                double d2 = dArray6[0] + dArray7[0];
                if (d == d2) {
                    byArray[0] = 69;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
                } else {
                    dArray7[0] = d2 - d;
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
                    this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray7));
                }
            }
        }
    }

    final void _setRHS(int n, double d) throws IloException {
        byte[] byArray = new byte[1];
        int[] nArray = new int[]{n};
        double[] dArray = new double[]{d};
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXgetsense(this._env, this._lp, byArray, n, n));
        if (byArray[0] == 76) {
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
        } else if (byArray[0] == 71) {
            if (d < 1.0E20) {
                double[] dArray2 = new double[1];
                this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray2, n, n));
                if (dArray2[0] == d) {
                    byArray[0] = 69;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                } else if (dArray2[0] <= -1.0E20) {
                    byArray[0] = 76;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    dArray2[0] = d;
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray2));
                } else {
                    byArray[0] = 82;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray2));
                    double[] dArray3 = new double[]{d - dArray2[0]};
                    this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray3));
                }
            }
        } else if (byArray[0] == 69) {
            if (d >= 1.0E20) {
                byArray[0] = 71;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            } else {
                double[] dArray4 = new double[1];
                this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray4, n, n));
                if (dArray4[0] != d) {
                    byArray[0] = 82;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray4));
                    double[] dArray5 = new double[]{d - dArray4[0]};
                    this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray5));
                }
            }
        } else if (d >= 1.0E20) {
            byArray[0] = 71;
            this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
        } else {
            double[] dArray6 = new double[1];
            this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray6, n, n));
            double[] dArray7 = new double[]{d - dArray6[0]};
            if (dArray7[0] == 0.0) {
                byArray[0] = 69;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            } else {
                this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray7));
            }
        }
    }

    final void _setLRHS(int n, double d, double d2) throws IloException {
        byte[] byArray = new byte[1];
        int[] nArray = new int[]{n};
        double[] dArray = new double[]{d};
        double[] dArray2 = new double[]{d2};
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXgetsense(this._env, this._lp, byArray, n, n));
        if (d == d2) {
            if (byArray[0] != 69) {
                byArray[0] = 69;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            }
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
        } else if (d2 >= 1.0E20) {
            if (byArray[0] != 71) {
                byArray[0] = 71;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            }
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
        } else if (d <= -1.0E20) {
            if (byArray[0] != 76) {
                byArray[0] = 76;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            }
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray2));
        } else {
            if (byArray[0] != 82) {
                byArray[0] = 82;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            }
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
            double[] dArray3 = new double[]{d2 - d};
            this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray3));
        }
    }

    final void _setObjCoef(int n, double d) throws IloException {
        this.origProbType();
        this.invalidate();
        int[] nArray = new int[]{n};
        double[] dArray = new double[]{d};
        this.CALL(CplexI.CPXchgobj(this._env, this._lp, 1, nArray, dArray));
    }

    final void _setObjCoefs(int n, int[] nArray, double[] dArray) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgobj(this._env, this._lp, n, nArray, dArray));
    }

    final void _setObjQCoef(int n, int n2, double d) throws IloException {
        this.origProbType();
        this.invalidate();
        if (!this.isQO() && !this.isQC()) {
            if (this.isMIP()) {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 7));
            } else {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 5));
            }
        }
        if (n == n2) {
            this.CALL(CplexI.CPXchgqpcoef(this._env, this._lp, n, n2, 2.0 * d));
        } else {
            this.CALL(CplexI.CPXchgqpcoef(this._env, this._lp, n, n2, d));
        }
    }

    final void _setNZ(int n, int n2, double d) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgcoef(this._env, this._lp, n, n2, d));
    }

    final void _setNZs(int n, int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgcoeflist(this._env, this._lp, n, nArray, nArray2, dArray));
    }

    final int _getQPNZnum() throws IloException {
        this.disableOutput();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = CplexI.CPXgetquad(this._env, this._lp, nArray, null, null, null, 0, nArray2, 0, CplexI.CPXgetnumcols(this._env, this._lp) - 1);
        this.enableOutput();
        if (n != 0 && n != 1207) {
            this.CALL(n);
        }
        this.clearErrorMessage();
        return -nArray2[0];
    }

    final void _getQP(int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int n = CplexI.CPXgetnumcols(this._env, this._lp);
        this.CALL(CplexI.CPXgetquad(this._env, this._lp, nArray3, nArray, nArray2, dArray, nArray2.length, nArray4, 0, n - 1));
        nArray[0] = 0;
        nArray[n] = nArray3[0];
    }

    final int _getRowNZnum(int n, int n2) throws IloException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n3 = CplexI.CPXgetrows(this._env, this._lp, nArray, null, null, null, 0, nArray2, n, n2);
        if (n3 != 0 && n3 != 1207) {
            this.CALL(n3);
        }
        this.clearErrorMessage();
        return -nArray2[0];
    }

    final void _getRows(int n, int n2, double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, double[] dArray3) throws IloException {
        Object[] objectArray;
        Object[] objectArray2;
        int n3 = n2 - n + 1;
        if (nArray != null && nArray2 != null && dArray3 != null) {
            objectArray2 = new int[1];
            objectArray = new int[1];
            this.CALL(CplexI.CPXgetrows(this._env, this._lp, objectArray2, nArray, nArray2, dArray3, nArray2.length, objectArray, n, n2));
            nArray[0] = 0;
            nArray[n3] = objectArray2[0];
        }
        if (dArray != null && dArray2 != null) {
            objectArray2 = new double[n3];
            objectArray = new byte[n3];
            this.CALL(CplexI.CPXgetsense(this._env, this._lp, (byte[])objectArray, n, n2));
            this.CALL(CplexI.CPXgetrhs(this._env, this._lp, objectArray2, n, n2));
            for (int i = 0; i < n3; ++i) {
                if (objectArray[i] == 69) {
                    int n4 = objectArray2[i];
                    dArray2[i] = n4;
                    dArray[i] = n4;
                    continue;
                }
                if (objectArray[i] == 76) {
                    dArray[i] = -1.0E20;
                    dArray2[i] = objectArray2[i];
                    continue;
                }
                if (objectArray[i] == 71) {
                    dArray[i] = objectArray2[i];
                    dArray2[i] = 1.0E20;
                    continue;
                }
                double[] dArray4 = new double[1];
                this.CALL(CplexI.CPXgetrngval(this._env, this._lp, dArray4, i + n, i + n));
                dArray[i] = objectArray2[i];
                dArray2[i] = objectArray2[i] + dArray4[0];
            }
        }
    }

    final int _getColumnNZnum(int n, int n2) throws IloException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n3 = CplexI.CPXgetcols(this._env, this._lp, nArray, null, null, null, 0, nArray2, n, n2);
        if (n3 != 0 && n3 != 1207) {
            this.CALL(n3);
        }
        this.clearErrorMessage();
        return -nArray2[0];
    }

    final void _getColumns(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        this.CALL(CplexI.CPXgetcols(this._env, this._lp, nArray3, nArray, nArray2, dArray, nArray2.length, nArray4, n, n2));
        nArray[0] = 0;
        nArray[n2 - n + 1] = nArray3[0];
    }

    final void _getVariables(int n, double[] dArray, double[] dArray2, double[] dArray3, byte[] byArray) throws IloException {
        this.CALL(CplexI.CPXgetobj(this._env, this._lp, dArray, 0, n - 1));
        this.CALL(CplexI.CPXgetlb(this._env, this._lp, dArray2, 0, n - 1));
        this.CALL(CplexI.CPXgetub(this._env, this._lp, dArray3, 0, n - 1));
        int n2 = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n2 == 1 || n2 == 7 || n2 == 11 || n2 == 3) {
            this.CALL(CplexI.CPXgetctype(this._env, this._lp, byArray, 0, n - 1));
        } else {
            for (int i = 0; i < n; ++i) {
                byArray[i] = 67;
            }
        }
    }

    private final void setStatus(int n) throws IloException {
        this._status = 0;
        if (n == 1101) {
            this._status = 4;
            n = 0;
        } else {
            this._status = CplexI.CPXgetstat(this._env, this._lp);
            if (this._status == 101) {
                this._status = 1;
            } else if (this._status == 127) {
                this._status = 23;
            } else if (this._status == 103) {
                this._status = 3;
            } else if (this._status == 107) {
                this._status = 11;
            } else if (this._status == 108) {
                this._status = 11;
            } else if (this._status == 131) {
                this._status = 25;
            } else if (this._status == 132) {
                this._status = 25;
            } else if (this._status == 113) {
                this._status = 13;
            } else if (this._status == 114) {
                this._status = 13;
            } else if (this._status == 115) {
                this._status = 5;
            } else if (this._status == 121) {
                this._status = 15;
            } else if (this._status == 120) {
                this._status = 14;
            } else if (this._status == 123) {
                this._status = 17;
            } else if (this._status == 122) {
                this._status = 16;
            } else if (this._status == 125) {
                this._status = 19;
            } else if (this._status == 124) {
                this._status = 18;
            }
        }
        this.CALL(n);
    }

    final void _getObjValue(double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetobjval(this._env, this._lp, dArray));
    }

    final void _getBestObjValue(double[] dArray) throws IloException {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            this.CALL(CplexI.CPXgetbestobjval(this._env, this._lp, dArray));
        } else {
            dArray[0] = CplexI.CPXgetobjsen(this._env, this._lp) == 1 ? this.bigReal : -this.bigReal;
        }
    }

    final void _getMIPRelativeGap(double[] dArray) throws IloException {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            this.CALL(CplexI.CPXgetmiprelgap(this._env, this._lp, dArray));
        } else {
            dArray[0] = this.bigReal;
        }
    }

    final void _getCutoff(double[] dArray) throws IloException {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            this.CALL(CplexI.CPXgetcutoff(this._env, this._lp, dArray));
        } else {
            dArray[0] = CplexI.CPXgetobjsen(this._env, this._lp) == 1 ? this.bigReal : -this.bigReal;
        }
    }

    final void _getAX(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetax(this._env, this._lp, dArray, n, n2));
    }

    final void _getPi(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetpi(this._env, this._lp, dArray, n, n2));
    }

    final void _getRowInfeasibilities(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetrowinfeas(this._env, this._lp, null, dArray, n, n2));
    }

    final void _getQCInfeasibilities(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetqconstrinfeas(this._env, this._lp, null, dArray, n, n2));
    }

    final void _getIndInfeasibilities(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetindconstrinfeas(this._env, this._lp, null, dArray, n, n2));
    }

    final void _getSOSInfeasibilities(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetsosinfeas(this._env, this._lp, null, dArray, n, n2));
    }

    final void _getColInfeasibilities(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetcolinfeas(this._env, this._lp, null, dArray, n, n2));
    }

    final void _getReducedCosts(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetdj(this._env, this._lp, dArray, n, n2));
    }

    final CpxLinearNumExpr getQCDSlack(int n) throws IloException {
        int n2 = this.getNcols();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[n2];
        double[] dArray = new double[n2];
        this.CALL(CplexI.CPXgetqconstrdslack(this._env, this._lp, n, nArray, nArray3, dArray, n2, nArray2));
        CpxLinearNumExpr cpxLinearNumExpr = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
        cpxLinearNumExpr.makeSpace(nArray[0]);
        for (int i = 0; i < nArray[0]; ++i) {
            cpxLinearNumExpr.addTerm(dArray[i], (IloNumVar)((Object)this._cols.getObject(nArray3[i])));
        }
        return cpxLinearNumExpr;
    }

    final boolean isDfeas() {
        int[] nArray = new int[1];
        if (CplexI.CPXsolninfo(this._env, this._lp, null, null, null, nArray) != 0) {
            return false;
        }
        return nArray[0] != 0;
    }

    final boolean isPfeas() {
        int[] nArray = new int[1];
        if (CplexI.CPXsolninfo(this._env, this._lp, null, null, nArray, null) != 0) {
            return false;
        }
        return nArray[0] != 0;
    }

    final void _getBase(int[] nArray, int[] nArray2) throws IloException {
        this.CALL(CplexI.CPXgetbase(this._env, this._lp, nArray, nArray2));
    }

    final void _setBase(int[] nArray, int[] nArray2) throws IloException {
        this.CALL(CplexI.CPXcopybase(this._env, this._lp, nArray, nArray2));
    }

    final void _rangesa(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) throws IloException {
        this.CALL(CplexI.CPXErangesa(this._env, this._lp, n, n2, dArray, dArray2, dArray3, dArray4));
    }

    final void _rhssa(int n, int n2, double[] dArray, double[] dArray2) throws IloException {
        this.CALL(CplexI.CPXrhssa(this._env, this._lp, n, n2, dArray, dArray2));
    }

    final void _boundsa(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) throws IloException {
        this.CALL(CplexI.CPXboundsa(this._env, this._lp, n, n2, dArray, dArray2, dArray3, dArray4));
    }

    final void _objsa(int n, int n2, double[] dArray, double[] dArray2) throws IloException {
        this.CALL(CplexI.CPXobjsa(this._env, this._lp, n, n2, dArray, dArray2));
    }

    final void _getQuality(int n, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray, int n2) throws IloException {
        double[] dArray2 = new double[]{0.0};
        double[] dArray3 = new double[]{0.0};
        nArray2[0] = -1;
        nArray[0] = -1;
        nArray3[0] = -1;
        switch (n) {
            case 27: 
            case 28: {
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray2, n));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray, n));
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray3, 47));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 47));
                if (dArray2[0] > dArray[0]) {
                    dArray[0] = dArray2[0];
                    nArray2[0] = -1;
                    break;
                }
                nArray3[0] = -1;
                break;
            }
            case 1: 
            case 2: {
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray, n));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray, n));
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray3, 45));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 45));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray3, 49));
                if (dArray3[0] > dArray[0] && dArray3[0] > dArray2[0]) {
                    dArray[0] = dArray2[0];
                    nArray[0] = -1;
                    nArray2[0] = -1;
                    nArray3[0] = -1;
                    break;
                }
                if (dArray2[0] > dArray[0]) {
                    dArray[0] = dArray2[0];
                    nArray[0] = -1;
                    break;
                }
                nArray3[0] = -1;
                if (nArray[0] >= 0) break;
                nArray2[0] = -nArray[0] - 1;
                nArray[0] = -1;
                break;
            }
            case 11: 
            case 12: {
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray, n));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray, n));
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray3, 43));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 43));
                if (dArray2[0] > dArray[0]) {
                    dArray[0] = dArray2[0];
                    nArray[0] = -1;
                    break;
                }
                nArray3[0] = -1;
                if (nArray[0] >= 0) break;
                nArray2[0] = -nArray[0] - 1;
                nArray[0] = -1;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray, n));
                if (nArray[0] > -1) break;
                nArray2[0] = -nArray[0] - 1;
                nArray[0] = -1;
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.CALL(CplexI.CPXgetdblquality(this._env, this._lp, dArray, n));
                break;
            }
            default: {
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray, n));
                if (n == 35 || n == 36) {
                    this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 48));
                    dArray[0] = dArray[0] + dArray2[0];
                }
                if (n == 3 || n == 4) {
                    this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 46));
                    dArray[0] = dArray[0] + dArray2[0];
                    this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 50));
                    dArray[0] = dArray[0] + dArray2[0];
                }
                if (n != 13 && n != 14) break;
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 44));
                dArray[0] = dArray[0] + dArray2[0];
            }
        }
    }

    final void _getIISsize(int[] nArray) throws IloException {
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n = CplexI.CPXfindiis(this._env, this._lp, nArray2, nArray3);
        if (n != 0) {
            if (n != 1101 && CplexI.CPXgetstat(this._env, this._lp) != 3) {
                this.CALL(n);
            }
            int[] nArray4 = new int[1];
            this.CALL(CplexI.CPXgetintparam(this._env, IloCplex.BooleanParam.PreInd.getValue(), nArray4));
            if (nArray4[0] == 0) {
                this.CALL(n);
            }
            this.CALL(CplexI.CPXsetintparam(this._env, IloCplex.BooleanParam.PreInd.getValue(), 0));
            n = CplexI.CPXlpopt(this._env, this._lp);
            this.CALL(CplexI.CPXsetintparam(this._env, IloCplex.BooleanParam.PreInd.getValue(), nArray4[0]));
            this.CALL(n);
            this.CALL(CplexI.CPXfindiis(this._env, this._lp, nArray2, nArray3));
        }
        nArray[0] = nArray2[0];
        nArray[1] = nArray3[0];
    }

    final void _getIIS(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) throws IloException {
        this.CALL(CplexI.CPXgetiis(this._env, this._lp, null, nArray, nArray2, null, nArray3, nArray4, null));
    }

    final void _getRay(double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetray(this._env, this._lp, dArray));
    }

    final void _dualFarkas(double[] dArray, double[] dArray2) throws IloException {
        this.CALL(CplexI.CPXdualfarkas(this._env, this._lp, dArray, dArray2));
    }

    final void _qpIndefCertificate(double[] dArray) throws IloException {
        this.CALL(CplexI.CPXqpindefcertificate(this._env, this._lp, dArray));
    }

    final String _getDelQCname(int n) throws IloException {
        int[] nArray = new int[]{0};
        String string = CplexI.CPXgetqconstrname(this._env, this._lp, n, nArray);
        if (nArray[0] != 1219) {
            this.CALL(nArray[0]);
        }
        return string;
    }

    final void _getSOSNames(String[] stringArray, int n, int n2) throws IloException {
        if (stringArray != null) {
            int[] nArray = new int[]{0};
            String[] stringArray2 = CplexI.CPXgetsosname(this._env, this._lp, n, n2, nArray);
            if (nArray[0] != 1219) {
                this.CALL(nArray[0]);
            }
            if (stringArray2 != null) {
                System.arraycopy(stringArray2, 0, stringArray, n, stringArray2.length);
            }
        }
    }

    final void setProbName(String string) {
        CplexI.CPXchgprobname(this._env, this._lp, string);
    }

    final void setObjName(String string) {
        CplexI.CPXcopyobjname(this._env, this._lp, string);
    }

    final void setRowName(CplexIndex cplexIndex, String string) {
        if (cplexIndex._index >= 0) {
            this.rowNameIndices.add(cplexIndex);
        }
    }

    final void setColName(CplexIndex cplexIndex, String string) {
        this.colNameIndices.add(cplexIndex);
    }

    final void flushRowNames() throws IloException {
        int n = 0;
        int n2 = this.rowNameIndices.size();
        if (n2 == 0) {
            return;
        }
        int[] nArray = new int[n2];
        String[] stringArray = new String[n2];
        int n3 = 0;
        Iterator iterator = this.rowNameIndices.iterator();
        while (iterator.hasNext()) {
            nArray[n3] = ((CplexIndex)iterator.next())._index;
            CpxRange cpxRange = this.getRange(nArray[n3]);
            String string = cpxRange.getName();
            if (string == null) continue;
            stringArray[n3] = string;
            cpxRange._name = null;
            ++n3;
        }
        n2 = n3;
        this.rowNameIndices.clear();
        n = CplexI.CPXchgrowname(this._env, this._lp, n2, nArray, stringArray);
        for (n3 = 0; n3 < n2; ++n3) {
            this.getRange((int)nArray[n3])._name = stringArray[n3];
        }
        this.CALL(n);
    }

    final void flushColNames() throws IloException {
        int n = 0;
        int n2 = this.colNameIndices.size();
        if (n2 == 0) {
            return;
        }
        int[] nArray = new int[n2];
        String[] stringArray = new String[n2];
        int n3 = 0;
        Iterator iterator = this.colNameIndices.iterator();
        while (iterator.hasNext()) {
            nArray[n3] = ((CplexIndex)iterator.next())._index;
            CpxNumVar cpxNumVar = this.getVariable(nArray[n3]);
            String string = cpxNumVar.getName();
            if (string == null) continue;
            stringArray[n3] = string;
            cpxNumVar._name = null;
            ++n3;
        }
        n2 = n3;
        this.colNameIndices.clear();
        n = CplexI.CPXchgcolname(this._env, this._lp, n2, nArray, stringArray);
        for (n3 = 0; n3 < n2; ++n3) {
            this.getVariable((int)nArray[n3])._name = stringArray[n3];
        }
        this.CALL(n);
    }

    final void flushNames() throws IloException {
        this.flushRowNames();
        this.flushColNames();
    }

    final void setQCname(CplexIndex cplexIndex, String string) {
        String[] stringArray = new String[]{string};
        int[] nArray = new int[]{cplexIndex._index};
        CplexI.CPXEchgqcname(this._env, this._lp, 1, nArray, stringArray);
    }

    final void setSOSname(CplexIndex cplexIndex, String string) {
        String[] stringArray = new String[]{string};
        int[] nArray = new int[]{cplexIndex._index};
        CplexI.CPXEchgsosname(this._env, this._lp, 1, nArray, stringArray);
    }

    final void _getProbName(String[] stringArray) {
        if (CplexI.CPXgetprobname(this._env, this._lp, stringArray) != 0) {
            stringArray[0] = null;
        }
    }

    final void _getObjName(String[] stringArray) {
        if (CplexI.CPXgetobjname(this._env, this._lp, stringArray) != 0) {
            stringArray[0] = null;
        }
    }

    final void _getRowNames(String[] stringArray, int n, int n2) {
        int[] nArray = new int[]{0};
        String[] stringArray2 = CplexI.CPXgetrowname(this._env, this._lp, n, n2, nArray);
        if (stringArray2 != null) {
            System.arraycopy(stringArray2, 0, stringArray, n, stringArray2.length);
        }
    }

    final void _getColNames(String[] stringArray, int n, int n2) {
        int[] nArray = new int[]{0};
        String[] stringArray2 = CplexI.CPXgetcolname(this._env, this._lp, n, n2, nArray);
        if (stringArray2 != null) {
            System.arraycopy(stringArray2, 0, stringArray, n, stringArray2.length);
        }
    }

    final int _getOrderNum() throws IloException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n = CplexI.CPXgetorder(this._env, this._lp, nArray, nArray2, nArray2, nArray2, 0, nArray3);
        if (n == 3016) {
            this.clearErrorMessage();
            return 0;
        }
        if (n == 1207) {
            this.clearErrorMessage();
            return -nArray3[0];
        }
        this.CALL(n);
        return 0;
    }

    final void _getOrder(int[] nArray, int[] nArray2, int[] nArray3) throws IloException {
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        this.CALL(CplexI.CPXgetorder(this._env, this._lp, nArray4, nArray, nArray2, nArray3, nArray.length, nArray5));
    }

    final void _copyOrder(int[] nArray, int[] nArray2, int[] nArray3) throws IloException {
        this.CALL(CplexI.CPXcopyorder(this._env, this._lp, nArray.length, nArray, nArray2, nArray3));
    }

    final void _writeOrder(String string) throws IloException {
        this.flushNames();
        this.CALL(CplexI.CPXordwrite(this._env, this._lp, CplexI.getBytes(string)));
    }

    final void _writeConflict(String string) throws IloException {
        this.flushNames();
        this.CALL(CplexI.CPXclpwrite(this._env, this._lp, CplexI.getBytes(string)));
    }

    final int getProbType() {
        return CplexI.CPXgetprobtype(this._env, this._lp);
    }

    final void setFixBasis(boolean bl) {
        this._fixBasis = bl;
    }

    final void _copyStartMIP(double[] dArray, double[] dArray2, int[] nArray, int n, int n2, double[] dArray3, double[] dArray4, int[] nArray2, int n3, int n4) throws IloException {
        this.origProbType();
        int n5 = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n5 == 1 || n5 == 7 || n5 == 11) {
            if (nArray != null && dArray != null) {
                int[] nArray3 = nArray;
                double[] dArray5 = dArray;
                if (n > 0) {
                    dArray5 = new double[n2];
                    nArray3 = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        nArray3[i] = nArray[i + n];
                        dArray5[i] = dArray[i + n];
                    }
                }
                int[] nArray4 = new int[]{0};
                if (CplexI.CPXgetnummipstarts(this._env, this._lp) == 0) {
                    this.CALL(CplexI.CPXaddmipstarts(this._env, this._lp, 1, n2, nArray4, nArray3, dArray5, null, null));
                } else {
                    this.CALL(CplexI.CPXchgmipstarts(this._env, this._lp, 1, nArray4, n2, nArray4, nArray3, dArray5, null));
                }
            }
        } else {
            int n6;
            int n7 = CplexI.CPXgetnumrows(this._env, this._lp);
            int n8 = CplexI.CPXgetnumcols(this._env, this._lp);
            int n9 = n + n2;
            int n10 = n3 + n4;
            double[] dArray6 = null;
            double[] dArray7 = null;
            double[] dArray8 = null;
            double[] dArray9 = null;
            if (nArray != null && dArray != null) {
                dArray6 = new double[n8];
                dArray7 = new double[n7];
                CplexI.CPXgetx(this._env, this._lp, dArray6, 0, n8 - 1);
                for (n6 = n; n6 < n9; ++n6) {
                    dArray6[nArray[n6]] = dArray[n6];
                }
                if (nArray2 != null && dArray3 != null) {
                    CplexI.CPXgetslack(this._env, this._lp, dArray7, 0, n7 - 1);
                    for (n6 = n3; n6 < n10; ++n6) {
                        dArray7[nArray2[n6]] = dArray3[n6];
                    }
                } else {
                    dArray7 = null;
                }
            }
            if (nArray2 != null && dArray4 != null) {
                dArray8 = new double[n8];
                dArray9 = new double[n7];
                CplexI.CPXgetpi(this._env, this._lp, dArray9, 0, n7 - 1);
                for (n6 = n3; n6 < n10; ++n6) {
                    dArray9[nArray2[n6]] = dArray4[n6];
                }
                if (nArray != null && dArray2 != null) {
                    CplexI.CPXgetdj(this._env, this._lp, dArray8, 0, n8 - 1);
                    for (n6 = n; n6 < n9; ++n6) {
                        dArray8[nArray[n6]] = dArray2[n6];
                    }
                } else {
                    dArray8 = null;
                }
            }
            this.CALL(CplexI.CPXcopystart(this._env, this._lp, null, null, dArray6, dArray7, dArray8, dArray9));
        }
    }

    final void _copyStart(double[] dArray, double[] dArray2, int[] nArray, int n, int n2, double[] dArray3, double[] dArray4, int[] nArray2, int n3, int n4) throws IloException {
        int n5;
        this.origProbType();
        int n6 = CplexI.CPXgetnumrows(this._env, this._lp);
        int n7 = CplexI.CPXgetnumcols(this._env, this._lp);
        int n8 = n + n2;
        int n9 = n3 + n4;
        double[] dArray5 = null;
        double[] dArray6 = null;
        double[] dArray7 = null;
        double[] dArray8 = null;
        if (nArray != null && dArray != null) {
            dArray5 = new double[n7];
            dArray6 = new double[n6];
            CplexI.CPXgetx(this._env, this._lp, dArray5, 0, n7 - 1);
            for (n5 = n; n5 < n8; ++n5) {
                dArray5[nArray[n5]] = dArray[n5];
            }
            if (nArray2 != null && dArray3 != null) {
                CplexI.CPXgetslack(this._env, this._lp, dArray6, 0, n6 - 1);
                for (n5 = n3; n5 < n9; ++n5) {
                    dArray6[nArray2[n5]] = dArray3[n5];
                }
            } else {
                dArray6 = null;
            }
        }
        if (nArray2 != null && dArray4 != null) {
            dArray7 = new double[n7];
            dArray8 = new double[n6];
            CplexI.CPXgetpi(this._env, this._lp, dArray8, 0, n6 - 1);
            for (n5 = n3; n5 < n9; ++n5) {
                dArray8[nArray2[n5]] = dArray4[n5];
            }
            if (nArray != null && dArray2 != null) {
                CplexI.CPXgetdj(this._env, this._lp, dArray7, 0, n7 - 1);
                for (n5 = n; n5 < n8; ++n5) {
                    dArray7[nArray[n5]] = dArray2[n5];
                }
            } else {
                dArray7 = null;
            }
        }
        this.CALL(CplexI.CPXcopystart(this._env, this._lp, null, null, dArray5, dArray6, dArray7, dArray8));
    }

    public void deleteNames() throws IloException {
        this.flushNames();
        this.CALL(CplexI.CPXdelnames(this._env, this._lp));
        this._cols.deleteNames();
        this._rows.deleteNames();
        this._qcs.deleteNames();
        this._soss.deleteNames();
        for (int i = 0; i < 27; ++i) {
            this._gcs[i].deleteNames();
        }
    }

    private static synchronized void init_cpxinit() {
        if (_cpxinit == null) {
            _cpxinit = new CplexInitializer();
        }
    }

    private final void init() throws IloException {
        CplexI.init_cpxinit();
        int[] nArray = new int[1];
        this._env = CplexI.CPXopenCPLEX(nArray);
        this.CALL(nArray[0]);
        this.init2();
    }

    private final void init(String string, String[] stringArray) throws IloException {
        CplexI.init_cpxinit();
        int[] nArray = new int[1];
        this._env = CplexI.CPXSopenCPLEXremote(string, stringArray, nArray);
        this.isRemoteEnv = string != null && string.length() > 0;
        this.CALL(nArray[0]);
        this.init2();
    }

    private final void init2() throws IloException {
        int[] nArray = new int[1];
        this.CALL(Cplex.threadInit(this._env));
        this.CALL(CplexI.CPXsetstrparam(this._env, 1130, CplexI.getBytes(encoding)));
        this._lp = CplexI.CPXcreateprob(this._env, nArray, this.probName());
        this.CALL(nArray[0]);
        this._status = 0;
        this.bigReal = CplexI.CPXEgetbigreal(this._env);
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long[] lArray3 = new long[1];
        long[] lArray4 = new long[1];
        this.CALL(CplexI.CPXgetchannels(this._env, lArray3, lArray2, lArray, lArray4));
        this.disableOutput();
        this.enableOutput();
    }

    final void finit() {
        long[] lArray;
        if (this._lp != 0L) {
            lArray = new long[]{this._lp};
            CplexI.CPXfreeprob(this._env, lArray);
        }
        try {
            this.removeRemoteInfoHandler();
        }
        catch (IloException iloException) {
            // empty catch block
        }
        lArray = new long[]{this._env};
        CplexI.CPXcloseCPLEX(lArray);
    }

    final void initGoals(int[] nArray, int[] nArray2) throws IloException {
        this.CALL(CplexI.CPXgetintparam(this._env, 2070, nArray));
        this.CALL(CplexI.CPXsetintparam(this._env, 2070, 1));
        this.CALL(CplexI.CPXgetintparam(this._env, 1001, nArray2));
        this.CALL(CplexI.CPXsetintparam(this._env, 1001, 0));
    }

    final void finitGoals(int n, int n2) throws IloException {
        this.CALL(CplexI.CPXsetintparam(this._env, 2070, n));
        this.CALL(CplexI.CPXsetintparam(this._env, 1001, n2));
    }

    static synchronized int lockILM(CplexI cplexI) {
        cplexI.finit();
        return 0;
    }

    static int putenv(String string) {
        CplexI.init_cpxinit();
        return CplexI.CPXEputenv(CplexI.getBytes(string));
    }

    public double getSolnPoolMeanObjValue() throws IloException {
        double[] dArray = new double[1];
        this.CALL(CplexI.CPXgetsolnpoolmeanobjval(this._env, this._lp, dArray));
        return dArray[0];
    }

    public int getSolnPoolNsolns() {
        return CplexI.CPXgetsolnpoolnumsolns(this._env, this._lp);
    }

    public int getSolnPoolNreplaced() {
        return CplexI.CPXgetsolnpoolnumreplaced(this._env, this._lp);
    }

    public void delSolnPoolSolns(int n, int n2) throws IloException {
        if (n2 > 0) {
            this.CALL(CplexI.CPXdelsolnpoolsolns(this._env, this._lp, n, n + n2 - 1));
            this._solnpoolX.invalidate();
            this._solnpoolSlack.invalidate();
            this._solnpoolQCSlack.invalidate();
        }
    }

    public double getObjValue(int n) throws IloException {
        double[] dArray = new double[1];
        this.CALL(CplexI.CPXgetsolnpoolobjval(this._env, this._lp, n, dArray));
        return dArray[0];
    }

    public void getValuesForExpr(double[] dArray, int n) throws IloException {
        int n2 = this.getNcols();
        this.CALL(CplexI.CPXgetsolnpoolx(this._env, this._lp, n, dArray, 0, n2 - 1));
    }

    public double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2, int n3) throws IloCplex.UnknownObjectException, IloException {
        int n4 = this.getNcols();
        double[] dArray = this.getSolnPoolXArray(n3);
        double[] dArray2 = new double[n2];
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            CpxNumVar cpxNumVar = (CpxNumVar)iloNumVarArray[i];
            if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
                throw new IloCplex.UnknownObjectException(cpxNumVar);
            }
            dArray2[i - n] = dArray[cpxNumVar.getVarIndexValue()];
        }
        return dArray2;
    }

    public double getQCSlack(int n, int n2) throws IloException {
        double[] dArray = new double[]{0.0};
        if (n2 == -1) {
            double[] dArray2 = this.getQCSlackArray();
            dArray[0] = dArray2[n];
        } else {
            double[] dArray3 = this.getSolnPoolQCSlackArray(n2);
            dArray[0] = dArray3[n];
        }
        return dArray[0];
    }

    public double[] getSlacks(int n, int n2, int n3) throws IloException {
        int n4 = n2 - n + 1;
        double[] dArray = new double[n4];
        if (n3 == -1) {
            double[] dArray2 = this.getSlackArray();
            System.arraycopy(dArray2, n, dArray, 0, n4);
        } else {
            double[] dArray3 = this.getSolnPoolSlackArray(n3);
            System.arraycopy(dArray3, n, dArray, 0, n4);
        }
        return dArray;
    }

    private void removeFromFilters(CplexIndex cplexIndex) {
        int n = 0;
        block0: for (int i = this._filter.size(); n < i; ++i) {
            Filter filter = (Filter)this._filter.elementAt(n);
            for (int j = 0; j < filter._var.length; ++j) {
                double[] dArray;
                if (filter._var[j] != cplexIndex) continue;
                CplexIndex[] cplexIndexArray = new CplexIndex[filter._var.length - 1];
                System.arraycopy(filter._var, 0, cplexIndexArray, 0, j);
                System.arraycopy(filter._var, j + 1, cplexIndexArray, j, cplexIndexArray.length - j);
                filter._var = cplexIndexArray;
                if (filter._weight != null) {
                    dArray = new double[filter._weight.length - 1];
                    System.arraycopy(filter._weight, 0, dArray, 0, j);
                    System.arraycopy(filter._weight, j + 1, dArray, j, dArray.length - j);
                    filter._weight = dArray;
                }
                if (filter._refval == null) continue block0;
                dArray = new double[filter._refval.length - 1];
                System.arraycopy(filter._refval, 0, dArray, 0, j);
                System.arraycopy(filter._refval, j + 1, dArray, j, dArray.length - j);
                filter._refval = dArray;
                continue block0;
            }
        }
    }

    void removeFromFilters(int[] nArray) {
        int n = 0;
        for (int i = this._filter.size(); n < i; ++i) {
            double[] dArray;
            Filter filter = (Filter)this._filter.elementAt(n);
            int n2 = filter._var.length;
            for (int j = n2 - 1; j >= 0; --j) {
                if (nArray[filter._var[j].getIndex()] == 0) continue;
                filter._var[j] = filter._var[--n2];
                if (filter._weight != null) {
                    filter._weight[j] = filter._weight[n2];
                }
                if (filter._refval == null) continue;
                filter._refval[j] = filter._refval[n2];
            }
            if (n2 == filter._var.length) continue;
            CplexIndex[] cplexIndexArray = new CplexIndex[n2];
            System.arraycopy(filter._var, 0, cplexIndexArray, 0, n2);
            filter._var = cplexIndexArray;
            if (filter._weight != null) {
                dArray = new double[n2];
                System.arraycopy(filter._weight, 0, dArray, 0, n2);
                filter._weight = dArray;
            }
            if (filter._refval == null) continue;
            dArray = new double[n2];
            System.arraycopy(filter._refval, 0, dArray, 0, n2);
            filter._refval = dArray;
        }
    }

    public void delFilter(IloCplex.FilterIndex filterIndex) throws IloException {
        this._filter.remove(filterIndex.getIndex());
        this._filters.deleteIndices(filterIndex, filterIndex);
        this.delFiltersFromLP();
    }

    public void delFilters() throws IloException {
        this._filter.removeAllElements();
        this._filters.clear();
        this.delFiltersFromLP();
    }

    private void delFiltersFromLP() throws IloException {
        int n = CplexI.CPXgetsolnpoolnumfilters(this._env, this._lp);
        if (n != 0) {
            this.CALL(CplexI.CPXdelsolnpoolfilters(this._env, this._lp, 0, n - 1));
        }
    }

    public IloCplex.FilterIndex[] readFilters(String string) throws IloException {
        this.delFiltersFromLP();
        this._filters.clear();
        this.CALL(CplexI.CPXreadcopysolnpoolfilters(this._env, this._lp, CplexI.getBytes(string)));
        int n = CplexI.CPXgetsolnpoolnumfilters(this._env, this._lp);
        IloCplex.FilterIndex[] filterIndexArray = new IloCplex.FilterIndex[n];
        for (int i = 0; i < n; ++i) {
            int[] nArray = new int[]{0};
            int n2 = CplexI.CPXEgetsolnpoolfilter(this._env, this._lp, null, null, null, null, null, null, null, 0, nArray, i);
            if (n2 != 0 && n2 != 1207) {
                this.CALL(n2);
            }
            this.clearErrorMessage();
            nArray[0] = -nArray[0];
            int[] nArray2 = new int[]{0};
            double[] dArray = new double[]{0.0};
            double[] dArray2 = new double[]{0.0};
            int[] nArray3 = new int[nArray[0]];
            double[] dArray3 = new double[nArray[0]];
            double[] dArray4 = new double[nArray[0]];
            int[] nArray4 = new int[]{0};
            this.CALL(CplexI.CPXEgetsolnpoolfilter(this._env, this._lp, nArray2, dArray, dArray2, null, nArray3, dArray3, dArray4, nArray[0], nArray4, i));
            int[] nArray5 = new int[]{0};
            this._filter.add(new Filter(this, nArray2[0], dArray[0], dArray2[0], nArray3, dArray3, dArray4, CplexI.CPXgetsolnpoolfiltername(this._env, this._lp, i, nArray5)));
            filterIndexArray[i] = (IloCplex.FilterIndex)this._filters.addIndex(new IloCplex.FilterIndex(i), null);
        }
        return filterIndexArray;
    }

    private void flushFilters() throws IloException {
        int n;
        int n2 = this._filter.size();
        if (n2 > (n = CplexI.CPXgetsolnpoolnumfilters(this._env, this._lp))) {
            int[] nArray = new int[this.getNcols()];
            for (int i = n; i < n2; ++i) {
                Filter filter = (Filter)this._filter.elementAt(i);
                for (int j = 0; j < filter._var.length; ++j) {
                    nArray[j] = filter._var[j].getIndex();
                }
                if (filter._type == 1) {
                    this.CALL(CplexI.CPXaddsolnpooldivfilter(this._env, this._lp, filter._lb, filter._ub, filter._var.length, nArray, filter._weight, filter._refval, filter._name));
                    continue;
                }
                this.CALL(CplexI.CPXaddsolnpoolrngfilter(this._env, this._lp, filter._lb, filter._ub, filter._var.length, nArray, filter._weight, filter._name));
            }
        }
    }

    public void writeFilters(String string) throws IloException {
        this.flushNames();
        this.flushFilters();
        this.CALL(CplexI.CPXfltwrite(this._env, this._lp, CplexI.getBytes(string)));
    }

    public IloCplex.FilterIndex addDiversityFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2, String string) {
        this._filter.add(new Filter(this, 1, d, d2, iloNumVarArray, dArray, dArray2, string));
        return (IloCplex.FilterIndex)this._filters.addIndex(new IloCplex.FilterIndex(this._filters.getNum()), null);
    }

    public IloCplex.FilterIndex getFilterIndex(String string) throws IloException {
        for (int i = 0; i < this._filter.size(); ++i) {
            if (!string.equals(((Filter)this._filter.elementAt((int)i))._name)) continue;
            return (IloCplex.FilterIndex)this._filters.getIndex(i);
        }
        throw new CpxException(-1, "unknown filter name");
    }

    public int getNfilters() {
        return this._filter.size();
    }

    public double getFilterLowerBound(IloCplex.FilterIndex filterIndex) {
        return ((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._lb;
    }

    public double getFilterUpperBound(IloCplex.FilterIndex filterIndex) {
        return ((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._ub;
    }

    public int getFilterType(IloCplex.FilterIndex filterIndex) {
        return ((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._type;
    }

    public IloNumVar[] getFilterVars(IloCplex.FilterIndex filterIndex) {
        CplexIndex[] cplexIndexArray = ((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._var;
        int n = cplexIndexArray.length;
        IloNumVar[] iloNumVarArray = new IloNumVar[n];
        for (int i = 0; i < n; ++i) {
            iloNumVarArray[i] = (IloNumVar)((Object)this._cols.getObject(cplexIndexArray[i]));
        }
        return iloNumVarArray;
    }

    public double[] getFilterWeights(IloCplex.FilterIndex filterIndex) {
        return (double[])((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._weight.clone();
    }

    public double[] getFilterRefVals(IloCplex.FilterIndex filterIndex) {
        return (double[])((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._refval.clone();
    }

    public IloCplex.FilterIndex addRangeFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, String string) {
        this._filter.add(new Filter(this, 2, d, d2, iloNumVarArray, dArray, null, string));
        return (IloCplex.FilterIndex)this._filters.addIndex(new IloCplex.FilterIndex(this._filters.getNum()), null);
    }

    public double getCplexTime() throws IloException {
        double[] dArray = new double[1];
        this.CALL(CplexI.CPXgettime(this._env, dArray));
        return dArray[0];
    }

    public double getDetTime() throws IloException {
        double[] dArray = new double[1];
        this.CALL(CplexI.CPXgetdettime(this._env, dArray));
        return dArray[0];
    }

    public int getNumCores() throws IloException {
        int[] nArray = new int[1];
        this.CALL(CplexI.CPXgetnumcores(this._env, nArray));
        return nArray[0];
    }

    public void use(AborterI aborterI) throws IloException {
        this.CALL(Cplex.CPXsetterminate(this._env, aborterI._p));
        aborterI.registerCplexI(this);
        this._abort = aborterI;
    }

    public void remove(AborterI aborterI) throws IloException {
        if (this._abort == aborterI) {
            if (this._env != 0L) {
                this.CALL(Cplex.CPXsetterminate(this._env, 0L));
            }
            aborterI.unregisterCplexI(this);
        }
    }

    public AborterI getAborter() {
        return this._abort;
    }

    IloCplex.RefineMIPStartConflictHandle refineMIPStartConflict(int n, IloConstraint[] iloConstraintArray, double[] dArray, int n2, int n3, boolean bl) throws IloException {
        RefineMIPStartConflictHandle refineMIPStartConflictHandle = new RefineMIPStartConflictHandle(this, bl);
        try {
            refineMIPStartConflictHandle.start(n, iloConstraintArray, dArray, n2, n3);
            if (!bl) {
                refineMIPStartConflictHandle.stop();
            }
            return refineMIPStartConflictHandle;
        }
        catch (IloException iloException) {
            refineMIPStartConflictHandle.finit();
            throw iloException;
        }
    }

    IloCplex.RefineConflictHandle refineConflict(IloConstraint[] iloConstraintArray, double[] dArray, int n, int n2, boolean bl) throws IloException {
        RefineConflictHandle refineConflictHandle = new RefineConflictHandle(this, bl);
        try {
            refineConflictHandle.start(iloConstraintArray, dArray, n, n2);
            if (!bl) {
                refineConflictHandle.stop();
            }
            return refineConflictHandle;
        }
        catch (IloException iloException) {
            refineConflictHandle.finit();
            throw iloException;
        }
    }

    IloCplex.RefineConflictHandle refineConflict(IloConstraint[] iloConstraintArray, double[] dArray, boolean bl) throws IloException {
        if (iloConstraintArray.length != dArray.length) {
            throw new IloException("IloCplex.refineConflict : constraint and preference arrays must have the same size.");
        }
        return this.refineConflict(iloConstraintArray, dArray, 0, iloConstraintArray.length, bl);
    }

    IloCplex.FeasOptHandle feasOpt(IloConstraint[] iloConstraintArray, double[] dArray, boolean bl) throws IloException {
        FeasoptExtHandle feasoptExtHandle = new FeasoptExtHandle(this, bl);
        try {
            feasoptExtHandle.start(iloConstraintArray, dArray);
            if (!bl) {
                feasoptExtHandle.stop();
            }
            return feasoptExtHandle;
        }
        catch (IloException iloException) {
            feasoptExtHandle.finit();
            throw iloException;
        }
    }

    IloCplex.FeasOptHandle feasOpt(IloRange[] iloRangeArray, double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, double[] dArray3, double[] dArray4, boolean bl) throws IloException {
        EFeasoptHandle eFeasoptHandle = new EFeasoptHandle(this, bl);
        try {
            eFeasoptHandle.start(iloRangeArray, dArray, dArray2, iloNumVarArray, dArray3, dArray4);
            if (!bl) {
                eFeasoptHandle.stop();
            }
            return eFeasoptHandle;
        }
        catch (IloException iloException) {
            eFeasoptHandle.finit();
            throw iloException;
        }
    }

    IloCplex.TuneParamHandle tuneParam(IloCplex.ParameterSet parameterSet, boolean bl) throws IloException {
        TuneParamHandle tuneParamHandle = new TuneParamHandle(this, bl);
        try {
            tuneParamHandle.start(parameterSet);
            if (!bl) {
                tuneParamHandle.stop();
            }
            return tuneParamHandle;
        }
        catch (IloException iloException) {
            tuneParamHandle.finit();
            throw iloException;
        }
    }

    IloCplex.SolveHandle solve(boolean bl) throws IloException {
        SolveHandle solveHandle = new SolveHandle(this, bl);
        try {
            solveHandle.start();
            if (!bl) {
                solveHandle.stop();
            }
            return solveHandle;
        }
        catch (IloException iloException) {
            solveHandle.finit();
            throw iloException;
        }
    }

    IloCplex.SolveFixedHandle solveFixed(int n, boolean bl) throws IloException {
        SolveFixedHandle solveFixedHandle = new SolveFixedHandle(this, bl);
        try {
            solveFixedHandle.start(n);
            if (!bl) {
                solveFixedHandle.stop();
            }
            return solveFixedHandle;
        }
        catch (IloException iloException) {
            solveFixedHandle.finit();
            throw iloException;
        }
    }

    IloCplex.PopulateHandle populate(boolean bl) throws IloException {
        PopulateHandle populateHandle = new PopulateHandle(this, bl);
        try {
            populateHandle.start();
            if (!bl) {
                populateHandle.stop();
            }
            return populateHandle;
        }
        catch (IloException iloException) {
            populateHandle.finit();
            throw iloException;
        }
    }

    IloCplex.RemoteInfoHandler setRemoteInfoHandler(IloCplex.RemoteInfoHandler remoteInfoHandler) throws IloException {
        IloCplex.RemoteInfoHandler remoteInfoHandler2 = this.removeRemoteInfoHandler();
        if (remoteInfoHandler != null) {
            InfoHandler infoHandler = new InfoHandler(remoteInfoHandler);
            if (this.asynctab != null) {
                this.CALL(this.asynctab.setInfoHandler(this._env, infoHandler));
            }
            this.infoHandler = infoHandler;
        }
        return remoteInfoHandler2;
    }

    IloCplex.RemoteInfoHandler getRemoteInfoHandler() {
        return this.infoHandler != null ? this.infoHandler.handler : null;
    }

    IloCplex.RemoteInfoHandler removeRemoteInfoHandler() throws IloException {
        IloCplex.RemoteInfoHandler remoteInfoHandler = this.getRemoteInfoHandler();
        this.infoHandler = null;
        if (this.asynctab != null) {
            this.CALL(this.asynctab.setInfoHandler(this._env, null));
        }
        return remoteInfoHandler;
    }

    public int userfunction(int n, int n2, byte[] byArray, int n3, int[] nArray, byte[] byArray2) throws IloException {
        if (this.asynctab == null) {
            throw new CpxException(1811, "user functions not supported for this instance");
        }
        return this.asynctab.userfunction(this._env, n, n2, byArray, n3, nArray, byArray2);
    }

    public int transportctrl(int n, int[] nArray) throws IloException {
        if (this.asynctab == null) {
            throw new CpxException(1811, "transportctrl() not supported for this instance");
        }
        return this.asynctab.transportctrl(this._env, n, nArray);
    }

    public int transportctrl(int n, long[] lArray) throws IloException {
        if (this.asynctab == null) {
            throw new CpxException(1811, "transportctrl() not supported for this instance");
        }
        return this.asynctab.transportctrl(this._env, n, lArray);
    }

    public int transportctrl(int n, double[] dArray) throws IloException {
        if (this.asynctab == null) {
            throw new CpxException(1811, "transportctrl() not supported for this instance");
        }
        return this.asynctab.transportctrl(this._env, n, dArray);
    }

    class InfoHandler
    implements CpxAsyncTab.InfoHandler {
        public final IloCplex.RemoteInfoHandler handler;

        public InfoHandler(IloCplex.RemoteInfoHandler remoteInfoHandler) {
            this.handler = remoteInfoHandler;
        }

        public void info(long l, int n, Object object, Object object2) {
            this.handler.main((Class)object, n, object2);
        }
    }

    public static class AborterI {
        long _p;
        Vector _cplexList = new Vector();

        public AborterI() {
            CplexI.init_cpxinit();
            this._p = Cplex.newNativeInt();
        }

        void registerCplexI(CplexI cplexI) {
            this._cplexList.add(cplexI);
        }

        void unregisterCplexI(CplexI cplexI) {
            this._cplexList.remove(cplexI);
        }

        protected void finalize() throws IloException {
            while (this._cplexList.size() > 0) {
                ((CplexI)this._cplexList.elementAt(0)).remove(this);
            }
        }

        public void abort() {
            Cplex.setNativeInt(this._p, 1);
        }

        public void clear() {
            Cplex.setNativeInt(this._p, 0);
        }

        public boolean isAborted() {
            return Cplex.getNativeInt(this._p) != 0;
        }
    }

    private static class Filter {
        public int _type;
        public double _lb;
        public double _ub;
        public double[] _weight;
        public CplexIndex[] _var;
        public double[] _refval;
        public String _name;

        Filter(CplexI cplexI, int n, double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2, String string) {
            this._type = n;
            this._lb = d;
            this._ub = d2;
            if (iloNumVarArray.length != 0) {
                this._var = new CplexIndex[iloNumVarArray.length];
                for (int i = 0; i < iloNumVarArray.length; ++i) {
                    this._var[i] = ((CpxNumVar)iloNumVarArray[i]).getVarIndex();
                }
                if (dArray != null) {
                    this._weight = (double[])dArray.clone();
                }
                if (dArray2 != null) {
                    this._refval = (double[])dArray2.clone();
                }
                this._name = string;
            }
        }

        Filter(CplexI cplexI, int n, double d, double d2, int[] nArray, double[] dArray, double[] dArray2, String string) {
            this._type = n;
            this._lb = d;
            this._ub = d2;
            if (nArray.length != 0) {
                this._var = new CplexIndex[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    this._var[i] = ((CpxNumVar)cplexI._cols.getObject(nArray[i])).getVarIndex();
                }
                if (dArray != null) {
                    this._weight = (double[])dArray.clone();
                }
                if (dArray2 != null) {
                    this._refval = (double[])dArray2.clone();
                }
                this._name = string;
            }
        }
    }

    private class OutChannelFunction
    implements Cplex.MsgFunction {
        private OutChannelFunction() {
        }

        public void callIt(Object object, String string) {
            CplexI cplexI = (CplexI)object;
            cplexI.output().print(string);
        }
    }

    private class WarnChannelFunction
    implements Cplex.MsgFunction {
        private WarnChannelFunction() {
        }

        public void callIt(Object object, String string) {
            CplexI cplexI = (CplexI)object;
            cplexI.warning().print(string);
        }
    }

    private class ErrorChannelFunction
    implements Cplex.MsgFunction {
        private ErrorChannelFunction() {
        }

        public void callIt(Object object, String string) {
            CplexI cplexI = (CplexI)object;
            cplexI._error = string;
        }
    }

    class GoalStack {
        public IloCplex.Goal _goal;
        public GoalStack _prev;

        public GoalStack(IloCplex.Goal goal, GoalStack goalStack) {
            this._goal = goal;
            this._prev = goalStack;
        }
    }

    final class RefineMIPStartConflictHandle
    extends DefaultAsyncHandle
    implements IloCplex.RefineMIPStartConflictHandle {
        private boolean result;
        private int callStatus;

        public RefineMIPStartConflictHandle(CplexI cplexI2, boolean bl) {
            super(cplexI2, bl);
            this.result = false;
            this.callStatus = 0;
        }

        public void start(int n, IloConstraint[] iloConstraintArray, double[] dArray, int n2, int n3) throws IloException {
            if (this.isAsync && this.cpx.asynctab == null) {
                throw new CpxException(1811, "Asynchronous invocation not supported for this instance");
            }
            IntArray intArray = new IntArray();
            IntArray intArray2 = new IntArray();
            DoubleArray doubleArray = new DoubleArray();
            ByteArray byteArray = new ByteArray();
            this.cpx._grpMap = new HashMap();
            for (int i = 0; i < n3; ++i) {
                int n4 = i + n2;
                if (iloConstraintArray[n4] == null || this.cpx._grpMap.containsKey(iloConstraintArray[n4])) continue;
                intArray.add(intArray2.getSize());
                doubleArray.add(dArray[n4]);
                this.cpx.fillGroup(iloConstraintArray[n4], intArray2, byteArray);
                this.cpx._grpMap.put(iloConstraintArray[n4], new Integer(intArray.getSize() - 1));
            }
            this.cpx.flushNames();
            this.cpx.invalidate();
            this.init(1);
            if (this.isAsync) {
                long[] lArray = new long[]{0L};
                this.callStatus = this.cpx.asynctab.refinemipstartconflictext_async(this.cpx.getEnv(), this.cpx.getLP(), n, intArray.getSize(), intArray2.getSize(), doubleArray.getArray(), intArray.getArray(), intArray2.getArray(), byteArray.getArray(), lArray);
                this.cpx.CALL(this.callStatus);
                this.handle = lArray;
            } else {
                this.callStatus = Cplex.CPXrefinemipstartconflictext(this.cpx.getEnv(), this.cpx.getLP(), n, intArray.getSize(), intArray2.getSize(), doubleArray.getArray(), intArray.getArray(), intArray2.getArray(), byteArray.getArray());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stop() throws IloException {
            if (this.isAsync) {
                try {
                    int n = this.cpx.asynctab.refinemipstartconflictext_join(this.handle);
                    this.cpx.CALL(n);
                }
                finally {
                    this.finit();
                }
            }
            this.finit();
            this.cpx.CALL(this.callStatus);
            this.cpx.setStatus(0);
            this.cpx.checkCallbacks();
            this.result = Cplex.CPXgetstat(this.cpx.getEnv(), this.cpx.getLP()) != 30;
            return this.result;
        }

        public void join() throws IloException {
            this.joinRefineMIPStartConflict();
        }

        public boolean joinRefineMIPStartConflict() throws IloException {
            if (this.isAsync) {
                return this.stop();
            }
            return this.result;
        }
    }

    final class RefineConflictHandle
    extends DefaultAsyncHandle
    implements IloCplex.RefineConflictHandle {
        private boolean result;
        private int callStatus;

        public RefineConflictHandle(CplexI cplexI2, boolean bl) {
            super(cplexI2, bl);
            this.result = false;
            this.callStatus = 0;
        }

        public void start(IloConstraint[] iloConstraintArray, double[] dArray, int n, int n2) throws IloException {
            if (this.isAsync && this.cpx.asynctab == null) {
                throw new CpxException(1811, "Asynchronous invocation not supported for this instance");
            }
            IntArray intArray = new IntArray();
            IntArray intArray2 = new IntArray();
            DoubleArray doubleArray = new DoubleArray();
            ByteArray byteArray = new ByteArray();
            this.cpx._grpMap = new HashMap();
            for (int i = 0; i < n2; ++i) {
                int n3 = i + n;
                if (iloConstraintArray[n3] == null || this.cpx._grpMap.containsKey(iloConstraintArray[n3])) continue;
                intArray.add(intArray2.getSize());
                doubleArray.add(dArray[n3]);
                this.cpx.fillGroup(iloConstraintArray[n3], intArray2, byteArray);
                this.cpx._grpMap.put(iloConstraintArray[n3], new Integer(intArray.getSize() - 1));
            }
            this.cpx.flushNames();
            this.cpx.invalidate();
            this.init(1);
            if (this.isAsync) {
                long[] lArray = new long[]{0L};
                this.callStatus = this.cpx.asynctab.refineconflictext_async(this.cpx.getEnv(), this.cpx.getLP(), intArray.getSize(), intArray2.getSize(), doubleArray.getArray(), intArray.getArray(), intArray2.getArray(), byteArray.getArray(), lArray);
                this.cpx.CALL(this.callStatus);
                this.handle = lArray;
            } else {
                this.callStatus = Cplex.CPXrefineconflictext(this.cpx.getEnv(), this.cpx.getLP(), intArray.getSize(), intArray2.getSize(), doubleArray.getArray(), intArray.getArray(), intArray2.getArray(), byteArray.getArray());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stop() throws IloException {
            try {
                if (this.isAsync) {
                    int n = this.cpx.asynctab.refineconflictext_join(this.checkHandle());
                    this.cpx.CALL(n);
                }
                this.finit();
                this.cpx.setStatus(this.callStatus);
                this.cpx.checkCallbacks();
                this.result = Cplex.CPXgetstat(this.cpx.getEnv(), this.cpx.getLP()) != 30;
            }
            finally {
                this.finit();
            }
            return this.result;
        }

        public void join() throws IloException {
            this.joinRefineConflict();
        }

        public boolean joinRefineConflict() throws IloException {
            if (this.isAsync) {
                return this.stop();
            }
            return this.result;
        }
    }

    final class EFeasoptHandle
    extends DefaultAsyncHandle
    implements IloCplex.FeasOptHandle {
        private boolean result;
        private int callStatus;

        public EFeasoptHandle(CplexI cplexI2, boolean bl) {
            super(cplexI2, bl);
            this.result = false;
            this.callStatus = 0;
        }

        public void start(IloRange[] iloRangeArray, double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, double[] dArray3, double[] dArray4) throws IloException {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.isAsync && this.cpx.asynctab == null) {
                throw new CpxException(1811, "Asynchronous invocation not supported for this instance");
            }
            int n5 = this.cpx.getNrows();
            int n6 = this.cpx.getNcols();
            double[] dArray5 = null;
            double[] dArray6 = null;
            double[] dArray7 = null;
            double[] dArray8 = null;
            double[] dArray9 = null;
            byte[] byArray = null;
            int n7 = 0;
            int[] nArray = null;
            byte[] byArray2 = null;
            double[] dArray10 = null;
            if (iloRangeArray != null && (n4 = iloRangeArray.length) > 0 && (dArray != null || dArray2 != null)) {
                nArray = new int[n5 + 1];
                byArray2 = new byte[n5 + 1];
                dArray10 = new double[n5 + 1];
                byArray = new byte[n5 + 1];
                this.cpx.CALL(Cplex.CPXgetsense(this.cpx._env, this.cpx._lp, byArray, 0, n5 - 1));
                dArray5 = new double[n5];
                if (dArray != null) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (iloRangeArray[n3] == null) continue;
                        n2 = ((CpxRange)iloRangeArray[n3]).getIndexValue();
                        if (((CpxRange)iloRangeArray[n3]).isQC()) {
                            byte[] byArray3 = new byte[]{0};
                            int[] nArray2 = new int[]{0};
                            Cplex.CPXgetqconstr(this.cpx._env, this.cpx._lp, null, null, null, byArray3, null, null, 0, nArray2, null, null, null, 0, nArray2, n2);
                            if (dArray9 == null) {
                                dArray9 = new double[this.cpx._getNQCs()];
                            }
                            if (byArray3[0] == 76) {
                                dArray9[n2] = dArray2[n3];
                                continue;
                            }
                            dArray9[n2] = dArray[n3];
                            continue;
                        }
                        if (byArray[n2] == 76) continue;
                        if (byArray[n2] == 69) {
                            byArray[n2] = 82;
                            nArray[n7] = n2;
                            byArray2[n7] = 82;
                            dArray10[n7] = 0.0;
                            ++n7;
                        }
                        dArray5[n2] = dArray[n3];
                    }
                }
                if (dArray2 != null) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (((CpxRange)iloRangeArray[n3]).isQC() || byArray[n2 = ((CpxRange)iloRangeArray[n3]).getIndexValue()] == 71) continue;
                        if (byArray[n2] == 76) {
                            dArray5[n2] = dArray2[n3];
                            continue;
                        }
                        if (byArray[n2] == 69) {
                            byArray[n2] = 82;
                            nArray[n7] = n2;
                            byArray2[n7] = 82;
                            dArray10[n7] = 0.0;
                            ++n7;
                        }
                        if (dArray6 == null) {
                            dArray6 = new double[n5];
                        }
                        dArray6[n2] = dArray2[n3];
                    }
                }
                if (n7 > 0) {
                    this.cpx.CALL(Cplex.CPXchgsense(this.cpx._env, this.cpx._lp, n7, nArray, byArray2));
                    this.cpx.CALL(Cplex.CPXchgrngval(this.cpx._env, this.cpx._lp, n7, nArray, dArray10));
                }
            }
            if (iloNumVarArray != null && (n = iloNumVarArray.length) > 0) {
                if (dArray3 != null) {
                    dArray7 = new double[n6];
                    for (n3 = 0; n3 < n; ++n3) {
                        n2 = ((CpxNumVar)iloNumVarArray[n3]).getVarIndexValue();
                        dArray7[n2] = dArray3[n3];
                    }
                }
                if (dArray4 != null) {
                    dArray8 = new double[n6];
                    for (n3 = 0; n3 < n; ++n3) {
                        n2 = ((CpxNumVar)iloNumVarArray[n3]).getVarIndexValue();
                        dArray8[n2] = dArray4[n3];
                    }
                }
            }
            this.cpx.invalidate();
            this.init(1);
            if (this.isAsync) {
                long[] lArray = new long[]{0L};
                this.callStatus = this.cpx.asynctab.efeasopt_async(this.cpx._env, this.cpx._lp, dArray5, dArray6, dArray7, dArray8, dArray9, lArray);
                this.cpx.CALL(this.callStatus);
                this.handle = lArray;
            } else {
                this.callStatus = Cplex.CPXEfeasopt(this.cpx._env, this.cpx._lp, dArray5, dArray6, dArray7, dArray8, dArray9);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stop() throws IloException {
            try {
                if (this.isAsync) {
                    int n = this.cpx.asynctab.efeasopt_join(this.checkHandle());
                    this.cpx.CALL(n);
                }
                this.finit();
                this.cpx.fillXcache();
                this.cpx.setStatus(this.callStatus);
                this.cpx.checkCallbacks();
            }
            finally {
                this.finit();
            }
            this.result = this.cpx.isSoln();
            return this.result;
        }

        public void join() throws IloException {
            this.joinFeasOpt();
        }

        public boolean joinFeasOpt() throws IloException {
            if (this.isAsync) {
                return this.stop();
            }
            return this.result;
        }
    }

    final class FeasoptExtHandle
    extends DefaultAsyncHandle
    implements IloCplex.FeasOptHandle {
        private boolean result;
        private int callStatus;

        public FeasoptExtHandle(CplexI cplexI2, boolean bl) {
            super(cplexI2, bl);
            this.result = false;
            this.callStatus = 0;
        }

        public void start(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
            if (this.isAsync && this.cpx.asynctab == null) {
                throw new CpxException(1811, "Asynchronous invocation not supported for this instance");
            }
            IntArray intArray = new IntArray();
            IntArray intArray2 = new IntArray();
            ByteArray byteArray = new ByteArray();
            for (int i = 0; i < iloConstraintArray.length; ++i) {
                int n = i;
                if (iloConstraintArray[n] == null) continue;
                intArray.add(intArray2.getSize());
                this.cpx.fillGroup(iloConstraintArray[n], intArray2, byteArray);
            }
            this.cpx.invalidate();
            this.init(1);
            if (this.isAsync) {
                long[] lArray = new long[]{0L};
                this.callStatus = this.cpx.asynctab.feasoptext_async(this.cpx.getEnv(), this.cpx.getLP(), intArray.getSize(), intArray2.getSize(), dArray, intArray.getArray(), intArray2.getArray(), byteArray.getArray(), lArray);
                this.cpx.CALL(this.callStatus);
                this.handle = lArray;
            } else {
                this.callStatus = Cplex.CPXfeasoptext(this.cpx.getEnv(), this.cpx.getLP(), intArray.getSize(), intArray2.getSize(), dArray, intArray.getArray(), intArray2.getArray(), byteArray.getArray());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stop() throws IloException {
            try {
                if (this.isAsync) {
                    int n = this.cpx.asynctab.feasoptext_join(this.checkHandle());
                    this.cpx.CALL(n);
                }
                this.finit();
                this.cpx.fillXcache();
                this.cpx.setStatus(this.callStatus);
                this.cpx.checkCallbacks();
            }
            finally {
                this.finit();
            }
            this.result = this.cpx.isSoln();
            return this.result;
        }

        public void join() throws IloException {
            this.joinFeasOpt();
        }

        public boolean joinFeasOpt() throws IloException {
            if (this.isAsync) {
                return this.stop();
            }
            return this.result;
        }
    }

    final class TuneParamHandle
    extends DefaultAsyncHandle
    implements IloCplex.TuneParamHandle {
        private int result;
        private final int[] tunestat;
        private int callStatus;

        public TuneParamHandle(CplexI cplexI2, boolean bl) {
            super(cplexI2, bl);
            this.result = 0;
            this.tunestat = new int[1];
            this.callStatus = 0;
        }

        public void start(IloCplex.ParameterSet parameterSet) throws IloException {
            Object object;
            Object object2;
            Object object3;
            if (this.isAsync && this.cpx.asynctab == null) {
                throw new CpxException(1811, "Asynchronous invocation not supported for this instance");
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (parameterSet != null) {
                object3 = parameterSet.iterator();
                while (object3.hasNext()) {
                    object2 = (IloCplex.Parameter)object3.next();
                    switch (((IloCplex.Parameter)object2).getType()) {
                        case 1: {
                            ++n;
                            break;
                        }
                        case 0: {
                            ++n2;
                            break;
                        }
                        case 4: {
                            ++n2;
                            break;
                        }
                        case 2: {
                            ++n2;
                            break;
                        }
                        case 3: {
                            ++n3;
                        }
                    }
                }
            }
            object3 = new int[n + 1];
            object2 = new double[n + 1];
            int[] nArray = new int[n2 + 1];
            int[] nArray2 = new int[n2 + 1];
            int[] nArray3 = new int[n3 + 1];
            byte[][] byArrayArray = new byte[n3 + 1][];
            n = 0;
            n2 = 0;
            n3 = 0;
            if (parameterSet != null) {
                object = parameterSet.iterator();
                while (object.hasNext()) {
                    IloCplex.Parameter parameter = (IloCplex.Parameter)object.next();
                    switch (parameter.getType()) {
                        case 1: {
                            object3[n] = ((IloCplex.DoubleParameter)parameter).getKey().getValue();
                            object2[n] = ((IloCplex.DoubleParameter)parameter).getValue();
                            ++n;
                            break;
                        }
                        case 0: {
                            nArray[n2] = ((IloCplex.IntParameter)parameter).getKey().getValue();
                            nArray2[n2] = ((IloCplex.IntParameter)parameter).getValue();
                            ++n2;
                            break;
                        }
                        case 4: {
                            nArray[n2] = ((IloCplex.LongParameter)parameter).getKey().getValue();
                            nArray2[n2] = CplexI.truncateLong(((IloCplex.LongParameter)parameter).getValue());
                            ++n2;
                            break;
                        }
                        case 2: {
                            nArray[n2] = ((IloCplex.BooleanParameter)parameter).getKey().getValue();
                            nArray2[n2] = ((IloCplex.BooleanParameter)parameter).getValue() ? 1 : 0;
                            ++n2;
                            break;
                        }
                        case 3: {
                            nArray3[n3] = ((IloCplex.StringParameter)parameter).getKey().getValue();
                            byArrayArray[n3] = CplexI.getBytes(((IloCplex.StringParameter)parameter).getValue());
                            ++n3;
                        }
                    }
                }
            }
            if (this.isAsync) {
                if (n3 > 0) {
                    throw new CpxException(1811, "Asynchronous tuning of string parameters not supported");
                }
                object = new long[]{0L};
                this.callStatus = this.cpx.asynctab.tuneparam_async(this.cpx._env, this.cpx._lp, n2, nArray, nArray2, n, (int[])object3, (double[])object2, n3, nArray3, null, (long[])object);
                this.cpx.CALL(this.callStatus);
                this.handle = (long[])object;
            } else {
                this.callStatus = Cplex.CPXtuneparam(this.cpx._env, this.cpx._lp, n2, nArray, nArray2, n, (int[])object3, (double[])object2, n3, nArray3, byArrayArray, this.tunestat);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int stop() throws IloException {
            try {
                if (this.isAsync) {
                    int n = this.cpx.asynctab.tuneparam_join(this.checkHandle(), this.tunestat);
                    this.cpx.CALL(n);
                }
                this.finit();
                this.cpx.CALL(this.callStatus);
            }
            finally {
                this.finit();
            }
            this.result = this.tunestat[0];
            return this.result;
        }

        public void join() throws IloException {
            this.joinTuneParam();
        }

        public int joinTuneParam() throws IloException {
            if (this.isAsync) {
                return this.stop();
            }
            return this.result;
        }
    }

    final class SolveFixedHandle
    extends DefaultAsyncHandle
    implements IloCplex.SolveFixedHandle {
        private boolean result;
        private int probtype;
        private int callStatus;

        public SolveFixedHandle(CplexI cplexI2, boolean bl) {
            super(cplexI2, bl);
            this.result = false;
            this.probtype = -1;
            this.callStatus = 0;
        }

        public void start(int n) throws IloException {
            if (this.isAsync && this.cpx.asynctab == null) {
                throw new CpxException(1811, "Asynchronous invocation not supported for this instance");
            }
            this.cpx.invalidate();
            this.cpx.initCallbacks();
            if (this.cpx.isQC()) {
                throw new CpxException(-1, "solveFixed not allowed for models with quadratic constraints");
            }
            if (this.cpx.isQO()) {
                this.cpx.CALL(Cplex.CPXchgprobtypesolnpool(this.cpx._env, this.cpx._lp, 8, n));
            } else {
                this.cpx.CALL(Cplex.CPXchgprobtypesolnpool(this.cpx._env, this.cpx._lp, 3, n));
            }
            this.probtype = Cplex.CPXgetprobtype(this.cpx._env, this.cpx._lp);
            if (this.probtype == 8) {
                if (this.isAsync) {
                    long[] lArray = new long[1];
                    this.callStatus = this.cpx.asynctab.qpopt_async(this.cpx._env, this.cpx._lp, lArray);
                    this.cpx.CALL(this.callStatus);
                    this.handle = lArray;
                } else {
                    this.callStatus = Cplex.CPXqpopt(this.cpx._env, this.cpx._lp);
                }
            } else if (this.isAsync) {
                long[] lArray = new long[1];
                this.callStatus = this.cpx.asynctab.lpopt_async(this.cpx._env, this.cpx._lp, lArray);
                this.cpx.CALL(this.callStatus);
                this.handle = lArray;
            } else {
                this.callStatus = Cplex.CPXlpopt(this.cpx._env, this.cpx._lp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stop() throws IloException {
            try {
                if (this.isAsync) {
                    int n = 0;
                    n = this.probtype == 8 ? this.cpx.asynctab.qpopt_join(this.checkHandle()) : this.cpx.asynctab.lpopt_join(this.checkHandle());
                    this.cpx.CALL(n);
                }
                this.finit();
                this.cpx.finitCallbacks();
                this.cpx.fillXcache();
                this.cpx.setStatus(this.callStatus);
                this.cpx.checkCallbacks();
            }
            finally {
                this.finit();
            }
            this.result = this.cpx.getStatusAfterSolve();
            return this.result;
        }

        public void join() throws IloException {
            this.joinSolveFixed();
        }

        public boolean joinSolveFixed() throws IloException {
            if (this.isAsync) {
                return this.stop();
            }
            return this.result;
        }
    }

    final class PopulateHandle
    extends DefaultAsyncHandle
    implements IloCplex.PopulateHandle {
        private boolean result;
        private int callStatus;

        public PopulateHandle(CplexI cplexI2, boolean bl) {
            super(cplexI2, bl);
            this.result = false;
            this.callStatus = 0;
        }

        public void start() throws IloException {
            if (this.isAsync && this.cpx.asynctab == null) {
                throw new CpxException(1811, "Asynchronous invocation not supported for this instance");
            }
            this.cpx.invalidate();
            this.init(1);
            this.cpx._ord.install(this.cpx);
            this.cpx.flushFilters();
            this.cpx.origProbType();
            if (this.isAsync) {
                long[] lArray = new long[]{0L};
                this.callStatus = this.cpx.asynctab.populate_async(this.cpx._env, this.cpx._lp, lArray);
                this.cpx.CALL(this.callStatus);
                this.handle = lArray;
            } else {
                this.callStatus = Cplex.CPXpopulate(this.cpx._env, this.cpx._lp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stop() throws IloException {
            try {
                if (this.isAsync) {
                    int n = this.cpx.asynctab.populate_join(this.checkHandle());
                    this.cpx.CALL(n);
                }
                this.finit();
                this.cpx.fillXcache();
                this.cpx.setStatus(this.callStatus);
                this.cpx.checkCallbacks();
            }
            finally {
                this.finit();
            }
            this.result = this.cpx.getStatusAfterSolve();
            return this.result;
        }

        public void join() throws IloException {
            this.joinPopulate();
        }

        public boolean joinPopulate() throws IloException {
            if (this.isAsync) {
                return this.stop();
            }
            return this.result;
        }
    }

    final class SolveHandle
    extends DefaultAsyncHandle
    implements IloCplex.SolveHandle {
        private boolean result;
        private int what;
        private int callStatus;
        private boolean distmip;
        private static final int JOIN_LPOPT = 1;
        private static final int JOIN_QPOPT = 2;
        private static final int JOIN_MIPOPT = 3;
        private static final int JOIN_HYBBAROPT = 4;

        public SolveHandle(CplexI cplexI2, boolean bl) {
            super(cplexI2, bl);
            this.result = false;
            this.what = 0;
            this.callStatus = 0;
            this.distmip = false;
        }

        public void start() throws IloException {
            if (this.isAsync && this.cpx.asynctab == null) {
                throw new CpxException(1811, "Asynchronous invocation not supported for this instance");
            }
            this.cpx.flushNames();
            this.cpx.invalidate();
            this.cpx.origProbType();
            this.init(1);
            this.cpx._ord.install(this.cpx);
            this.cpx.flushFilters();
            boolean bl = false;
            int n = Cplex.CPXgetprobtype(this.cpx._env, this.cpx._lp);
            if (n == 1 || n == 7 || n == 11) {
                if (this.isAsync) {
                    long[] lArray = new long[1];
                    this.what = 3;
                    if (CplexI.this.hasVMConfig()) {
                        this.callStatus = this.cpx.asynctab.distmipopt_async(this.cpx._env, this.cpx._lp, lArray);
                        this.distmip = true;
                    } else {
                        this.callStatus = this.cpx.asynctab.mipopt_async(this.cpx._env, this.cpx._lp, lArray);
                    }
                    this.cpx.CALL(this.callStatus);
                    this.handle = lArray;
                } else {
                    this.callStatus = this.cpx.hasVMConfig() ? Cplex.CPXdistmipopt(this.cpx._env, this.cpx._lp) : Cplex.CPXmipopt(this.cpx._env, this.cpx._lp);
                }
            } else if (n == 5) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                Cplex.CPXgetintparam(this.cpx._env, 1062, nArray2);
                Cplex.CPXgetintparam(this.cpx._env, 1063, nArray);
                this.undoParam(1063, nArray[0]);
                if (nArray2[0] == 5) {
                    Cplex.CPXgetintparam(this.cpx._env, IloCplex.IntParam.SiftAlg.getValue(), nArray3);
                    Cplex.CPXsetintparam(this.cpx._env, 1063, nArray3[0]);
                }
                if (this.isAsync) {
                    long[] lArray = new long[]{0L};
                    this.what = 2;
                    this.callStatus = this.cpx.asynctab.qpopt_async(this.cpx._env, this.cpx._lp, lArray);
                    this.cpx.CALL(this.callStatus);
                    this.handle = lArray;
                } else {
                    this.callStatus = Cplex.CPXqpopt(this.cpx._env, this.cpx._lp);
                }
            } else if (n == 10) {
                int[] nArray = new int[1];
                Cplex.CPXgetintparam(this.cpx._env, 1062, nArray);
                if (nArray[0] == 4 || nArray[0] == 0) {
                    if (this.isAsync) {
                        long[] lArray = new long[]{0L};
                        this.what = 4;
                        this.callStatus = this.cpx.asynctab.hybbaropt_async(this.cpx._env, this.cpx._lp, -1, lArray);
                        this.cpx.CALL(this.callStatus);
                        this.handle = lArray;
                    } else {
                        this.callStatus = Cplex.CPXhybbaropt(this.cpx._env, this.cpx._lp, -1);
                    }
                } else if (this.isAsync) {
                    long[] lArray = new long[]{0L};
                    this.what = 2;
                    this.callStatus = this.cpx.asynctab.qpopt_async(this.cpx._env, this.cpx._lp, lArray);
                    this.cpx.CALL(this.callStatus);
                    this.handle = lArray;
                } else {
                    this.callStatus = Cplex.CPXqpopt(this.cpx._env, this.cpx._lp);
                }
            } else if (this.isAsync) {
                long[] lArray = new long[]{0L};
                this.what = 1;
                this.callStatus = this.cpx.asynctab.lpopt_async(this.cpx._env, this.cpx._lp, lArray);
                this.cpx.CALL(this.callStatus);
                this.handle = lArray;
            } else {
                this.callStatus = Cplex.CPXlpopt(this.cpx._env, this.cpx._lp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stop() throws IloException {
            try {
                if (this.isAsync) {
                    int n = 0;
                    switch (this.what) {
                        case 1: {
                            n = this.cpx.asynctab.lpopt_join(this.checkHandle());
                            break;
                        }
                        case 2: {
                            n = this.cpx.asynctab.qpopt_join(this.checkHandle());
                            break;
                        }
                        case 3: {
                            n = this.distmip ? this.cpx.asynctab.distmipopt_join(this.checkHandle()) : this.cpx.asynctab.mipopt_join(this.checkHandle());
                            break;
                        }
                        case 4: {
                            n = this.cpx.asynctab.hybbaropt_join(this.checkHandle());
                            break;
                        }
                        default: {
                            throw new CpxException(1003, "Invalid state");
                        }
                    }
                    this.cpx.CALL(n);
                }
                this.finit();
                this.cpx.fillXcache();
                this.cpx.setStatus(this.callStatus);
                this.cpx.checkCallbacks();
            }
            finally {
                this.finit();
            }
            this.result = this.cpx.getStatusAfterSolve();
            return this.result;
        }

        public void join() throws IloException {
            this.joinSolve();
        }

        public boolean joinSolve() throws IloException {
            if (this.isAsync) {
                return this.stop();
            }
            return this.result;
        }
    }

    static abstract class DefaultAsyncHandle
    implements IloCplex.AsyncHandle {
        protected final CplexI cpx;
        private int state;
        protected long[] handle;
        private final int[] pnum;
        private final int[] pval;
        private int pcnt;
        protected final boolean isAsync;
        public static final int Callbacks = 1;

        protected DefaultAsyncHandle(CplexI cplexI, boolean bl) {
            this.cpx = cplexI;
            this.state = 0;
            this.pnum = new int[1];
            this.pval = new int[1];
            this.pcnt = 0;
            this.isAsync = bl;
        }

        protected long[] checkHandle() throws IloException {
            if (this.handle == null || this.handle[0] == 0L) {
                throw new CpxException(1003, "Cannot join a null handle");
            }
            return this.handle;
        }

        public boolean test() throws IloException {
            if (this.isAsync) {
                int[] nArray = new int[1];
                int n = this.cpx.asynctab.asynctest(this.checkHandle()[0], nArray);
                this.cpx.CALL(n);
                return nArray[0] != 0;
            }
            return false;
        }

        public void kill() throws IloException {
            if (this.isAsync) {
                int n = this.cpx.asynctab.kill(this.checkHandle()[0]);
                this.cpx.CALL(n);
            }
        }

        public abstract void join() throws IloException;

        public synchronized void init(int n) throws IloException {
            if ((n & 1) != 0) {
                this.cpx.initCallbacks();
                this.state |= 1;
            }
        }

        public synchronized void undoParam(int n, int n2) {
            this.pnum[this.pcnt] = n;
            this.pval[this.pcnt] = n2;
            ++this.pcnt;
        }

        public synchronized void finit() throws IloException {
            for (int i = 0; i < this.pcnt; ++i) {
                Cplex.CPXsetintparam(this.cpx._env, this.pnum[i], this.pval[i]);
            }
            this.pcnt = 0;
            if ((this.state & 1) != 0) {
                this.cpx.finitCallbacks();
                this.state &= 0xFFFFFFFE;
            }
        }
    }
}

