/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloColumn;
import ilog.concert.IloColumnArray;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloLPMatrix;
import ilog.concert.IloMPModeler;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarType;
import ilog.concert.IloRange;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxException;
import ilog.cplex.CpxLinearExpr;
import ilog.cplex.CpxLinearNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxQLExpr;
import ilog.cplex.CpxRange;
import ilog.cplex.CpxSubVar;
import ilog.cplex.IloCplexModeler;
import ilog.cplex.NumVarAlreadyInLPMatrixException;

public class CpxLPMatrix
extends CpxSubVar
implements IloLPMatrix {
    private static final long serialVersionUID = 12060300L;
    int _nvars;
    CpxNumVar[] _var = new CpxNumVar[128];
    int _nrows;
    CpxRange[] _row = new CpxRange[128];

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        if (iloCopyManager.getModeler() instanceof IloMPModeler) {
            IloMPModeler iloMPModeler = (IloMPModeler)iloCopyManager.getModeler();
            IloLPMatrix iloLPMatrix = iloMPModeler.LPMatrix(this.getName());
            IloRange[] iloRangeArray = new IloRange[this._nrows];
            for (int i = 0; i < this._nrows; ++i) {
                iloRangeArray[i] = (IloRange)iloCopyManager.getCopy(this._row[i]);
            }
            iloLPMatrix.addRows(iloRangeArray);
            return iloLPMatrix;
        }
        throw new UnsupportedOperationException();
    }

    void end() throws IloException {
        if (this.isInstalledExt() && this._nrows > 0) {
            CpxRange.end(this._row, this._nrows);
        }
        super.end();
    }

    void uninstallCon() throws IloException {
        if (this.isInstalledExt() && this._nrows > 0) {
            CpxRange.uninstallRows(this._row, this._nrows);
            this.setCplexI(null);
        }
    }

    void installCon(CplexI cplexI) throws IloException {
        cplexI.checkCplexI(this);
        if (this.isInstalledExt()) {
            return;
        }
        for (int i = 0; i < this._nrows; ++i) {
            this._row[i].installCon(cplexI);
        }
        cplexI.useVars(this._var, 0, this._nvars, false);
        this.setCplexI(cplexI);
    }

    void installVar(IloCplexModeler iloCplexModeler) throws IloException {
        System.err.println("not implemented");
    }

    void uninstallVar(IloCplexModeler iloCplexModeler) throws IloException {
        System.err.println("not implemented");
    }

    void removeVars(CplexIndex cplexIndex) {
        int n = 0;
        for (int i = 0; i < this._nvars; ++i) {
            if (this._var[i]._varIndex == cplexIndex) continue;
            this._var[n] = this._var[i];
            ++n;
        }
        this._nvars = n;
    }

    public int getNcols() throws IloException {
        return this._nvars;
    }

    public int getNrows() throws IloException {
        return this._nrows;
    }

    public int getNNZs() throws IloException {
        int n = 0;
        if (this.isInstalledExt()) {
            int[] nArray = new int[this.getCplexI()._getNrows()];
            for (int i = 0; i < this._nrows; ++i) {
                nArray[this._row[i].getIndex().getIndex()] = 1;
            }
            n = this.getCplexI().getNNZs(nArray);
        } else {
            for (int i = 0; i < this._nrows; ++i) {
                n += ((CpxQLExpr)this._row[i].getCpxExpr()).getLinearNum();
            }
        }
        return n;
    }

    void getCols(int[] nArray, int n, int n2, int[] nArray2, int[] nArray3, int[][] nArray4, double[][] dArray) throws IloException {
        if (this.isInstalledExt()) {
            int n3;
            int n4;
            int n5 = n + n2;
            int n6 = this.getCplexI().getNcols();
            int n7 = 0;
            int[] nArray5 = new int[nArray.length];
            for (n4 = n; n4 < n5; ++n4) {
                int n8;
                nArray5[n4] = n8 = this._var[nArray[n4]].getVarIndexValue();
                if (n6 > n8) {
                    n6 = n8;
                }
                if (n7 >= n8) continue;
                n7 = n8;
            }
            n4 = n7 - n6 + 1;
            int[] nArray6 = new int[n4 + 1];
            this.getCplexI().getColumns(n6, n7, nArray6, nArray4, dArray);
            int n9 = this.getCplexI().getNrows();
            int[] nArray7 = new int[n9];
            for (n3 = 0; n3 < n9; ++n3) {
                nArray7[n3] = -1;
            }
            for (n3 = 0; n3 < this._nrows; ++n3) {
                nArray7[this._row[n3].getIndexValue()] = n3;
            }
            for (n3 = n; n3 < n5; ++n3) {
                int n10 = 0;
                int n11 = nArray5[n3];
                int n12 = nArray6[n11 - n6];
                int n13 = nArray6[n11 - n6 + 1];
                for (int i = n12; i < n13; ++i) {
                    int n14 = nArray7[nArray4[0][i]];
                    if (n14 < 0) continue;
                    nArray4[0][n12 + n10] = n14;
                    dArray[0][n12 + n10] = dArray[0][i];
                    ++n10;
                }
                nArray2[n3 - n] = n12;
                nArray3[n3 - n] = n12 + n10;
            }
        } else {
            this.getColumnsExt(nArray, n, n2, nArray2, nArray3, nArray4, dArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getColumnsExt(int[] nArray, int n, int n2, int[] nArray2, int[] nArray3, int[][] nArray4, double[][] dArray) throws IloException {
        int n3;
        int n4 = n + n2;
        NonZero[] nonZeroArray = new NonZero[n4];
        for (n3 = n; n3 < n4; ++n3) {
            this._var[nArray[n3]].mark(n3);
        }
        try {
            Object object;
            int n5;
            n3 = 0;
            int n6 = 0;
            for (n5 = 0; n5 < this._nrows; ++n5) {
                CpxQLExpr cpxQLExpr = (CpxQLExpr)this._row[n5].getCpxExpr();
                object = new CpxLinearExpr.LinIterator(cpxQLExpr._lin);
                while (((CpxLinearExpr.LinIterator)object).hasNext()) {
                    CpxNumVar cpxNumVar = ((CpxLinearExpr.LinIterator)object).nextCpxVar();
                    if (!cpxNumVar.isMarked()) continue;
                    n6 = cpxNumVar.getVarIndexValue();
                    if (nonZeroArray[n6] != null && nonZeroArray[n6]._row == n5) {
                        nonZeroArray[n6]._val += ((CpxLinearExpr.LinIterator)object).getCpxValue();
                        continue;
                    }
                    nonZeroArray[n6] = new NonZero(nonZeroArray[n6], n5, ((CpxLinearExpr.LinIterator)object).getCpxValue());
                    ++n3;
                }
            }
            nArray4[0] = new int[n3];
            dArray[0] = new double[n3];
            n6 = 0;
            for (n5 = n; n5 < n4; ++n5) {
                nArray2[n5 - n] = n6;
                object = nonZeroArray[n5];
                while (object != null) {
                    nArray4[0][n6] = ((NonZero)object)._row;
                    dArray[0][n6] = ((NonZero)object)._val;
                    ++n6;
                    object = ((NonZero)object)._prev;
                }
                nArray3[n5 - n] = n6;
            }
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            for (int i = n; i < n4; ++i) {
                this._var[nArray[i]].unmark();
            }
            throw throwable;
        }
        for (int i = n; i < n4; ++i) {
            this._var[nArray[i]].unmark();
        }
    }

    void getCols(int[] nArray, int n, int n2, int[][] nArray2, double[][] dArray) throws IloException {
        int n3 = n + n2;
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[][] nArrayArray = new int[1][];
        double[][] dArrayArray = new double[1][];
        this.getCols(nArray, n, n2, nArray3, nArray4, nArrayArray, dArrayArray);
        for (int i = n; i < n3; ++i) {
            int n4 = nArray3[i - n];
            int n5 = nArray4[i - n];
            nArray2[i - n] = new int[n5 - n4];
            dArray[i - n] = new double[n5 - n4];
            System.arraycopy(nArrayArray[0], n4, nArray2[i - n], 0, n5 - n4);
            System.arraycopy(dArrayArray[0], n4, dArray[i - n], 0, n5 - n4);
        }
    }

    public void getCols(int n, int n2, int[][] nArray, double[][] dArray) throws IloException {
        int n3 = n + n2;
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n3 > this._nvars) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        int[] nArray2 = new int[n3];
        for (int i = n; i < n3; ++i) {
            nArray2[i - n] = i;
        }
        this.getCols(nArray2, 0, n2, nArray, dArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRows(int n, int n2, double[] dArray, double[] dArray2, int[][] nArray, double[][] dArray3) throws IloException {
        block11: {
            int n3;
            block10: {
                int n4;
                n3 = n + n2;
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException(n);
                }
                if (n3 > this._nrows) {
                    throw new ArrayIndexOutOfBoundsException(n3);
                }
                if (!this.isInstalledExt()) break block10;
                this.getCplexI().getRows(this._row, n, n2, dArray, dArray2, nArray, dArray3);
                int n5 = this.getCplexI().getNcols();
                int[] nArray2 = new int[n5];
                for (n4 = 0; n4 < n5; ++n4) {
                    nArray2[n4] = -1;
                }
                for (n4 = 0; n4 < this._nvars; ++n4) {
                    nArray2[this._var[n4].getVarIndexValue()] = n4;
                }
                if (nArray == null) break block11;
                for (n4 = 0; n4 < n2; ++n4) {
                    int n6 = nArray[n4].length;
                    for (int i = 0; i < n6; ++i) {
                        nArray[n4][i] = nArray2[nArray[n4][i]];
                    }
                }
                break block11;
            }
            this.markVars();
            try {
                for (int i = n; i < n3; ++i) {
                    dArray[i - n] = this._row[i].getLB();
                    dArray2[i - n] = this._row[i].getUB();
                    CpxQLExpr cpxQLExpr = (CpxQLExpr)this._row[i].getCpxExpr();
                    CpxNumVar[] cpxNumVarArray = cpxQLExpr.getLinearVars();
                    double[] dArray4 = cpxQLExpr.getLinearVals();
                    int n7 = cpxQLExpr.getLinearNum();
                    nArray[i - n] = new int[n7];
                    dArray3[i - n] = new double[n7];
                    for (int j = 0; j < n7; ++j) {
                        nArray[i - n][j] = cpxNumVarArray[j].getVarIndexValue();
                        dArray3[i - n][j] = dArray4[j];
                    }
                }
                Object var15_19 = null;
                this.unmarkVars();
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                this.unmarkVars();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getNZ(int n, int n2) throws IloException {
        this.markVars();
        try {
            CpxQLExpr cpxQLExpr = (CpxQLExpr)this._row[n].getCpxExpr();
            CpxNumVar[] cpxNumVarArray = cpxQLExpr.getLinearVars();
            int n3 = cpxQLExpr.getLinearNum();
            for (int i = 0; i < n3; ++i) {
                if (cpxNumVarArray[i].getVarIndexValue() != n2) continue;
                double d = cpxQLExpr.getLinearVals()[i];
                Object var10_8 = null;
                this.unmarkVars();
                return d;
            }
            Object var10_9 = null;
            this.unmarkVars();
            return 0.0;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.unmarkVars();
            throw throwable;
        }
    }

    public int getIndex(IloRange iloRange) {
        for (int i = 0; i < this._nrows; ++i) {
            if (this._row[i] != iloRange) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(IloNumVar iloNumVar) {
        for (int i = 0; i < this._nvars; ++i) {
            if (this._var[i] != iloNumVar) continue;
            return i;
        }
        return -1;
    }

    public IloRange getRange(int n) {
        return this._row[n];
    }

    public IloRange[] getRanges() {
        IloRange[] iloRangeArray = new IloRange[this._nrows];
        System.arraycopy(this._row, 0, iloRangeArray, 0, this._nrows);
        return iloRangeArray;
    }

    public IloNumVar getNumVar(int n) throws IloException {
        return this._var[n];
    }

    public IloNumVar[] getNumVars() throws IloException {
        IloNumVar[] iloNumVarArray = new IloNumVar[this._nvars];
        System.arraycopy(this._var, 0, iloNumVarArray, 0, this._nvars);
        return iloNumVarArray;
    }

    public int addRow(double d, double d2, int[] nArray, double[] dArray) throws IloException {
        int n = this.getNrows();
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (dArray == null) {
            dArray = new double[]{};
        }
        this.makeRowSpace(1);
        if (this.isInstalledExt()) {
            if (d <= -1.7976931348623157E308) {
                d = -1.0E20;
            }
            if (d2 >= Double.MAX_VALUE) {
                d2 = 1.0E20;
            }
            if (d2 < d) {
                throw new CpxException(-1, "IloLPMatrix row has incompatible bounds");
            }
            CpxRange cpxRange = new CpxRange(null, null);
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this._var[nArray[i]].getVarIndexValue();
            }
            cpxRange.setIndex(this.getCplexI().addRow(cpxRange, d, d2, nArray2.length, nArray2, dArray, null));
            this._row[this._nrows++] = cpxRange;
            cpxRange.setCplexI(this.getCplexI());
        } else {
            CpxLinearNumExpr cpxLinearNumExpr = new CpxLinearNumExpr();
            for (int i = 0; i < nArray.length; ++i) {
                cpxLinearNumExpr.addTerm(dArray[i], (IloNumVar)this._var[nArray[i]]);
            }
            this._row[this._nrows++] = new CpxRange(null, d, cpxLinearNumExpr, d2, null);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRow(IloRange iloRange) throws IloException {
        CpxRange cpxRange = (CpxRange)iloRange;
        CpxQLExpr cpxQLExpr = (CpxQLExpr)cpxRange.getCpxExpr();
        CpxNumVar[] cpxNumVarArray = cpxQLExpr.getLinearVars();
        int n = cpxQLExpr.getLinearNum();
        int n2 = 0;
        CpxNumVar[] cpxNumVarArray2 = null;
        this.markVars();
        try {
            for (int i = 0; i < n; ++i) {
                if (cpxNumVarArray[i].isMarked()) continue;
                cpxNumVarArray[i].mark(this._nvars + n2);
                if (n2 == 0) {
                    cpxNumVarArray2 = new CpxNumVar[n - i];
                }
                cpxNumVarArray2[n2++] = cpxNumVarArray[i];
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            for (int i = 0; i < n2; ++i) {
                cpxNumVarArray2[i].unmark();
            }
            this.unmarkVars();
            throw throwable;
        }
        for (int i = 0; i < n2; ++i) {
            cpxNumVarArray2[i].unmark();
        }
        {
        }
        this.unmarkVars();
        if (n2 > 0) {
            this.addCols(cpxNumVarArray2, 0, n2);
        }
        this.makeRowSpace(1);
        this._row[this._nrows++] = cpxRange;
        if (this.isInstalledExt()) {
            cpxRange.installCon(this.getCplexI());
        }
        return this._nrows - 1;
    }

    public int addRows(IloRange[] iloRangeArray) throws IloException {
        return this.addRows(iloRangeArray, 0, iloRangeArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRows(IloRange[] iloRangeArray, int n, int n2) throws IloException {
        CpxRange cpxRange;
        int n3;
        int n4 = n + n2;
        int n5 = 0;
        CpxNumVar[] cpxNumVarArray = null;
        this.markVars();
        try {
            for (n3 = n; n3 < n4; ++n3) {
                cpxRange = (CpxRange)iloRangeArray[n3];
                CpxQLExpr cpxQLExpr = (CpxQLExpr)cpxRange.getCpxExpr();
                CpxNumVar[] cpxNumVarArray2 = cpxQLExpr.getLinearVars();
                int n6 = cpxQLExpr.getLinearNum();
                for (int i = 0; i < n6; ++i) {
                    if (cpxNumVarArray2[i].isMarked()) continue;
                    cpxNumVarArray2[i].mark(this._nvars);
                    if (n5 == 0) {
                        cpxNumVarArray = new CpxNumVar[n6];
                    }
                    if (n5 == cpxNumVarArray.length) {
                        CpxNumVar[] cpxNumVarArray3 = new CpxNumVar[n5 + n6];
                        System.arraycopy(cpxNumVarArray, 0, cpxNumVarArray3, 0, n5);
                        cpxNumVarArray = cpxNumVarArray3;
                    }
                    cpxNumVarArray[n5++] = cpxNumVarArray2[i];
                }
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            for (int i = 0; i < n5; ++i) {
                cpxNumVarArray[i].unmark();
            }
            this.unmarkVars();
            throw throwable;
        }
        for (int i = 0; i < n5; ++i) {
            cpxNumVarArray[i].unmark();
        }
        {
        }
        this.unmarkVars();
        if (n5 > 0) {
            this.addCols(cpxNumVarArray, 0, n5);
        }
        this.makeRowSpace(n2);
        for (n3 = n; n3 < n4; ++n3) {
            cpxRange = (CpxRange)iloRangeArray[n3];
            this._row[this._nrows++] = cpxRange;
            if (!this.isInstalledExt()) continue;
            cpxRange.installCon(this.getCplexI());
        }
        return this._nrows - n2;
    }

    public int addRows(double[] dArray, double[] dArray2, int[][] nArray, double[][] dArray3) throws IloException {
        int n;
        int n2;
        int n3 = this.getNrows();
        int n4 = dArray.length;
        int[] nArray2 = new int[n4 + 1];
        int n5 = 0;
        CplexIndex[] cplexIndexArray = null;
        double[] dArray4 = null;
        if (nArray != null) {
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                nArray2[n6] = nArray[n6].length;
                n5 += nArray2[n6];
            }
            cplexIndexArray = new CplexIndex[n5];
            dArray4 = new double[n5];
            n6 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < nArray2[n2]; ++n) {
                    cplexIndexArray[n6 + n] = this._var[nArray[n2][n]].getVarIndex();
                }
                System.arraycopy(dArray3[n2], 0, dArray4, n6, nArray2[n2]);
                nArray2[n2] = n6;
                n6 += nArray[n2].length;
            }
            nArray2[n4] = n6;
        }
        this.makeRowSpace(n4);
        if (this.isInstalledExt()) {
            CpxRange[] cpxRangeArray = new CpxRange[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                if (dArray[n2] <= -1.7976931348623157E308) {
                    dArray[n2] = -1.0E20;
                }
                if (dArray2[n2] >= Double.MAX_VALUE) {
                    dArray2[n2] = 1.0E20;
                }
                if (dArray2[n2] < dArray[n2]) {
                    throw new CpxException(-1, "IloLPMatrix row has incompatible bounds");
                }
                cpxRangeArray[n2] = new CpxRange(null, null);
            }
            CplexIndex[] cplexIndexArray2 = this.getCplexI().addRows(n4, cpxRangeArray, dArray, dArray2, nArray2, cplexIndexArray, dArray4, null);
            for (n = 0; n < n4; ++n) {
                cpxRangeArray[n].setIndex(cplexIndexArray2[n]);
                this._row[n3 + n] = cpxRangeArray[n];
                cpxRangeArray[n].setCplexI(this.getCplexI());
            }
            this._nrows += n4;
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                if (nArray != null && nArray[n2].length > 0) {
                    n = nArray[n2].length;
                    IloNumVar[] iloNumVarArray = new CpxNumVar[n];
                    for (int i = 0; i < n; ++i) {
                        iloNumVarArray[i] = this._var[nArray[n2][i]];
                    }
                    CpxLinearNumExpr cpxLinearNumExpr = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
                    cpxLinearNumExpr.addTerms(dArray3[n2], iloNumVarArray);
                    this._row[n3 + n2] = new CpxRange(null, dArray[n2], cpxLinearNumExpr, dArray2[n2], null);
                    continue;
                }
                this._row[n3 + n2] = new CpxRange(null, dArray[n2], dArray2[n2], null);
            }
            this._nrows += n4;
        }
        return n3;
    }

    public int addColumn(IloNumVar iloNumVar, int[] nArray, double[] dArray) throws IloException, NumVarAlreadyInLPMatrixException {
        return this.addColumn(iloNumVar, nArray, dArray, 0, nArray.length);
    }

    int addNewColumn(IloNumVar iloNumVar, int[] nArray, double[] dArray) throws IloException {
        return this.addNewColumn(iloNumVar, nArray, dArray, 0, nArray.length);
    }

    public int addColumn(IloNumVar iloNumVar, int[] nArray, double[] dArray, int n, int n2) throws IloException, NumVarAlreadyInLPMatrixException {
        this.addColumn(iloNumVar);
        return this.doAddColumn(iloNumVar, nArray, dArray, n, n2);
    }

    int addNewColumn(IloNumVar iloNumVar, int[] nArray, double[] dArray, int n, int n2) throws IloException {
        this.addNewColumn(iloNumVar);
        return this.doAddColumn(iloNumVar, nArray, dArray, n, n2);
    }

    int doAddColumn(IloNumVar iloNumVar, int[] nArray, double[] dArray, int n, int n2) throws IloException {
        if (n2 > 0) {
            int n3 = n + n2;
            if (this.isInstalledExt()) {
                int[] nArray2 = new int[n2];
                int[] nArray3 = new int[n2];
                int n4 = this._var[this._nvars - 1].getVarIndexValue();
                for (int i = n; i < n3; ++i) {
                    nArray2[i - n] = this._row[nArray[i]].getIndexValue();
                    nArray3[i - n] = n4;
                }
                if (n == 0) {
                    this.getCplexI().addNZs(nArray2, nArray3, dArray, n2);
                } else {
                    double[] dArray2 = new double[n2];
                    System.arraycopy(dArray, n, dArray2, 0, n2);
                    this.getCplexI().addNZs(nArray2, nArray3, dArray2, n2);
                }
            } else {
                for (int i = n; i < n3; ++i) {
                    this._row[nArray[i]].setLinearCoef(iloNumVar, dArray[i]);
                }
            }
        }
        return this._nvars - 1;
    }

    public int addColumn(IloNumVar iloNumVar) throws IloException, NumVarAlreadyInLPMatrixException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        for (int i = 0; i < this._nvars; ++i) {
            if (this._var[i] != cpxNumVar) continue;
            throw new NumVarAlreadyInLPMatrixException(iloNumVar);
        }
        return this.addNewColumn(iloNumVar);
    }

    int addNewColumn(IloNumVar iloNumVar) throws IloException {
        this.makeColSpace(1);
        this._var[this._nvars++] = (CpxNumVar)iloNumVar;
        if (this.isInstalledExt()) {
            this.getCplexI().useVar(this._var[this._nvars - 1], false);
        }
        return this._nvars - 1;
    }

    public int addCols(IloNumVar[] iloNumVarArray, int[][] nArray, double[][] dArray) throws IloException, NumVarAlreadyInLPMatrixException {
        int n = this.addCols(iloNumVarArray);
        return this.doAddCols(n, iloNumVarArray, nArray, dArray);
    }

    int addNewCols(IloNumVar[] iloNumVarArray, int[][] nArray, double[][] dArray) throws IloException, NumVarAlreadyInLPMatrixException {
        int n = this.addNewCols(iloNumVarArray);
        return this.doAddCols(n, iloNumVarArray, nArray, dArray);
    }

    int doAddCols(int n, IloNumVar[] iloNumVarArray, int[][] nArray, double[][] dArray) throws IloException {
        if (this.isInstalledExt()) {
            if (nArray != null && dArray != null) {
                int n2 = iloNumVarArray.length;
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    n3 += nArray[i].length;
                }
                int[] nArray2 = new int[n3];
                int[] nArray3 = new int[n3];
                double[] dArray2 = new double[n3];
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n5 = this._var[n + i].getVarIndexValue();
                    int n6 = nArray[i].length;
                    for (int j = 0; j < n6; ++j) {
                        nArray3[n4] = n5;
                        nArray2[n4] = this._row[nArray[i][j]].getIndexValue();
                        dArray2[n4] = dArray[i][j];
                        ++n4;
                    }
                }
                this.getCplexI().addNZs(nArray2, nArray3, dArray2, n3);
            }
        } else if (nArray != null && dArray != null) {
            for (int i = 0; i < iloNumVarArray.length; ++i) {
                for (int j = 0; j < nArray[i].length; ++j) {
                    this._row[nArray[i][j]].setLinearCoef(iloNumVarArray[i], dArray[i][j]);
                }
            }
        }
        return n;
    }

    public int addCols(IloNumVar[] iloNumVarArray) throws IloException, NumVarAlreadyInLPMatrixException {
        return this.addCols(iloNumVarArray, 0, iloNumVarArray.length);
    }

    int addNewCols(IloNumVar[] iloNumVarArray) throws IloException {
        return this.addNewCols(iloNumVarArray, 0, iloNumVarArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCols(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException, NumVarAlreadyInLPMatrixException {
        this.markVars();
        try {
            for (int i = 0; i < n2; ++i) {
                if (!((CpxNumVar)iloNumVarArray[n + i]).isMarked()) continue;
                throw new NumVarAlreadyInLPMatrixException(iloNumVarArray[n + i]);
            }
            Object var6_5 = null;
            this.unmarkVars();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.unmarkVars();
            throw throwable;
        }
        return this.addNewCols(iloNumVarArray, n, n2);
    }

    int addNewCols(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        this.makeColSpace(n2);
        int n3 = this._nvars;
        for (int i = 0; i < n2; ++i) {
            this._var[n3 + i] = (CpxNumVar)iloNumVarArray[n + i];
        }
        if (this.isInstalledExt()) {
            this.getCplexI().useVars(this._var, n3, n2, false);
        }
        this._nvars += n2;
        return n3;
    }

    public int addCols(CpxNumVar[] cpxNumVarArray, int n, int n2) throws IloException {
        this.makeColSpace(n2);
        int n3 = this._nvars;
        System.arraycopy(cpxNumVarArray, n, this._var, n3, n2);
        if (this.isInstalledExt()) {
            this.getCplexI().useVars(this._var, n3, n2, false);
        }
        this._nvars += n2;
        return n3;
    }

    public void removeColumn(int n) throws IloException {
        this.removeCols(n, 1);
    }

    public void removeCols(int n, int n2) throws IloException {
        if (n2 <= 0) {
            return;
        }
        if (n < 0 || n + n2 > this._nvars) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n + i;
        }
        this.removeCols(nArray, 0, n2);
    }

    public void removeCols(int[] nArray) throws IloException {
        this.removeCols(nArray, 0, nArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeCols(int[] nArray, int n, int n2) throws IloException {
        int n4 = n + n2;
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.isInstalledExt()) {
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            int[][] nArrayArray = new int[1][];
            double[][] dArrayArray = new double[1][];
            this.getCols(nArray, n, n2, nArray2, nArray3, nArrayArray, dArrayArray);
            int n5 = 0;
            for (int i = n; i < n4; n5 += nArray3[i - n] - nArray2[i - n], ++i) {
            }
            int[] nArray4 = new int[n5];
            int[] nArray5 = new int[n5];
            double[] dArray = dArrayArray[0];
            n5 = 0;
            for (int i = n; i < n4; ++i) {
                int n6 = nArray2[i - n];
                int n7 = nArray3[i - n];
                for (int j = n6; j < n7; ++n5, ++j) {
                    nArray5[n5] = this._var[nArray[i]].getVarIndexValue();
                    nArray4[n5] = this._row[nArrayArray[0][j]].getIndexValue();
                    dArray[n5] = 0.0;
                }
            }
            this.getCplexI().setNZs(nArray4, nArray5, dArray, n5);
        } else {
            int n8;
            int n3 = n + n2;
            for (n8 = n; n8 < n3; ++n8) {
                this._var[nArray[n8]].mark(n8);
            }
            try {
                for (n8 = 0; n8 < this._nrows; ++n8) {
                    if (this._row[n8].isInstalledCon()) continue;
                    this._row[n8].removeMarked();
                }
                Object var18_20 = null;
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                int i = n;
                while (true) {
                    if (i >= n3) {
                        throw throwable;
                    }
                    this._var[nArray[i]].unmark();
                    ++i;
                }
            }
            for (int i = n; i < n3; ++i) {
                this._var[nArray[i]].unmark();
            }
        }
        this.deleteCols(nArray, n, n2);
    }

    public void removeRow(int n) throws IloException {
        if (n < 0 || n >= this._nrows) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.isInstalledExt()) {
            this._row[n].uninstallCon();
        }
        int n2 = --this._nrows;
        for (int i = n; i < n2; ++i) {
            this._row[i] = this._row[i + 1];
        }
    }

    public void removeRows(int n, int n2) throws IloException {
        if (n2 <= 0) {
            return;
        }
        if (n2 == 1) {
            this.removeRow(n);
            return;
        }
        if (n < 0 || n >= this._nrows) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n3 = n + n2;
        if (n3 < 0 || n3 > this._nrows) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        if (this.isInstalledExt()) {
            for (int i = n; i < n3; ++i) {
                this._row[i].uninstallCon();
            }
        }
        while (n3 < this._nrows) {
            this._row[n] = this._row[n3];
            ++n;
            ++n3;
        }
        this._nrows = n;
        while (n < n3) {
            this._row[n] = null;
            ++n;
        }
    }

    public void removeRows(int[] nArray) throws IloException {
        this.removeRows(nArray, 0, nArray.length);
    }

    public void removeRows(int[] nArray, int n, int n2) throws IloException {
        int n3;
        int n4 = n2 + n;
        if (n4 >= this._nrows) {
            throw new ArrayIndexOutOfBoundsException(n4);
        }
        if (this.isInstalledExt()) {
            for (n3 = n; n3 < n4; ++n3) {
                this._row[nArray[n3]].uninstallCon();
            }
        }
        for (n3 = n; n3 < n4; ++n3) {
            this._row[nArray[n3]] = null;
        }
        int n5 = 0;
        for (n3 = 0; n3 < this._nrows; ++n3) {
            if (this._row[n3] == null) continue;
            this._row[n5++] = this._row[n3];
        }
        for (n3 = n5; n3 < this._nrows; ++n3) {
            this._row[n3] = null;
        }
        this._nrows = n5;
    }

    public void clear() throws IloException {
        this.removeCols(0, this.getNcols() - 1);
        this.removeRows(0, this.getNrows() - 1);
    }

    public void setNZ(int n, int n2, double d) throws IloException {
        if (n2 < 0 || n2 >= this._nvars) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (this.isInstalledExt()) {
            this.getCplexI().setNZ(this._row[n].getIndex(), this._var[n2].getVarIndex(), d);
        } else {
            this._row[n].setLinearCoef(this._var[n2], d);
        }
    }

    public void setNZs(int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        int n = nArray.length;
        double d = dArray[n - 1];
        if (this.isInstalledExt()) {
            CplexIndex[] cplexIndexArray = new CplexIndex[n];
            CplexIndex[] cplexIndexArray2 = new CplexIndex[n];
            for (int i = 0; i < n; ++i) {
                if (nArray2[i] < 0 || nArray2[i] >= this._nvars) {
                    throw new ArrayIndexOutOfBoundsException(nArray2[i]);
                }
                if (nArray[i] < 0 || nArray[i] >= this._nrows) {
                    throw new ArrayIndexOutOfBoundsException(nArray[i]);
                }
                cplexIndexArray[i] = this._row[nArray[i]].getIndex();
                cplexIndexArray2[i] = this._var[nArray2[i]].getVarIndex();
            }
            this.getCplexI().setNZs(cplexIndexArray, cplexIndexArray2, dArray, 0, n);
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this._row[nArray[i]].setLinearCoef(this._var[nArray2[i]], dArray[i]);
            }
        }
    }

    public IloColumn makeColumn(int[] nArray, double[] dArray, int n, int n2) {
        if (nArray == null || dArray == null) {
            return new LPColumn(this, null, null, 0, 0);
        }
        return new LPColumn(this, (int[])nArray.clone(), (double[])dArray.clone(), n, n2);
    }

    public IloColumn makeColumn() {
        return this.makeColumn(null, null, 0, 0);
    }

    public IloColumnArray makeColumnArray(int n, int[][] nArray, double[][] dArray) {
        return new LPColumnArray(this, n, nArray, dArray);
    }

    protected CpxLPMatrix(CplexI cplexI, String string) throws IloException {
        super(0.0, 1.0, IloNumVarType.Bool, string);
        if (cplexI != null) {
            this.installCon(cplexI);
        }
    }

    private void makeColSpace(int n) {
        int n2 = this._var.length;
        if (this._nvars + n > n2) {
            while (n2 < this._nvars + n) {
                n2 *= 2;
            }
            CpxNumVar[] cpxNumVarArray = new CpxNumVar[n2];
            System.arraycopy(this._var, 0, cpxNumVarArray, 0, this._nvars);
            this._var = cpxNumVarArray;
        }
    }

    private void makeRowSpace(int n) {
        int n2 = this._row.length;
        if (this._nrows + n > n2) {
            while (n2 < this._nrows + n) {
                n2 *= 2;
            }
            CpxRange[] cpxRangeArray = new CpxRange[n2];
            System.arraycopy(this._row, 0, cpxRangeArray, 0, this._nrows);
            this._row = cpxRangeArray;
        }
    }

    void markVars() {
        for (int i = 0; i < this._nvars; ++i) {
            this._var[i].mark(i);
        }
    }

    void unmarkVars() {
        for (int i = 0; i < this._nvars; ++i) {
            this._var[i].unmark();
        }
    }

    public void deleteCols(int[] nArray, int n, int n2) throws IloException {
        int n3;
        int n4;
        int n5 = n + n2;
        for (n4 = n; n4 < n5; ++n4) {
            this._var[nArray[n4]] = null;
        }
        n4 = 0;
        for (n3 = 0; n3 < this._nvars; ++n3) {
            if (this._var[n3] == null) continue;
            this._var[n4++] = this._var[n3];
        }
        for (n3 = n4; n3 < this._nvars; ++n3) {
            this._var[n3] = null;
        }
        this._nvars = n4;
    }

    public void deleteRows(int n) throws IloException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this._nrows; ++n2) {
            if (this._row[n2]._conUseCnt == n) continue;
            this._row[n3++] = this._row[n2];
        }
        for (n2 = n3; n2 < this._nrows; ++n2) {
            this._row[n2] = null;
        }
        this._nrows = n3;
    }

    public void deleteCols(CpxNumVar[] cpxNumVarArray, int n, int n2) throws IloException {
        int n3;
        int n4;
        int n5 = n + n2;
        for (n4 = n; n4 < n5; ++n4) {
            cpxNumVarArray[n4].mark(n4);
        }
        n4 = 0;
        for (n3 = 0; n3 < this._nvars; ++n3) {
            if (this._var[n3].isMarked()) continue;
            this._var[n4++] = this._var[n3];
        }
        for (n3 = n4; n3 < this._nvars; ++n3) {
            this._var[n3] = null;
        }
        this._nvars = n4;
        for (n3 = n; n3 < n5; ++n3) {
            cpxNumVarArray[n3].unmark();
        }
    }

    void deleteColumn(CpxNumVar cpxNumVar) throws IloException {
        for (int i = 0; i < this._nvars; ++i) {
            if (this._var[i] != cpxNumVar) continue;
            this.deleteColumn(i);
            break;
        }
    }

    void deleteColumn(int n) throws IloException {
        --this._nvars;
        for (int i = n; i < this._nvars; ++i) {
            this._var[i] = this._var[i + 1];
        }
        this._var[this._nvars] = null;
    }

    void addRows(CpxRange[] cpxRangeArray, int n) {
        this.makeRowSpace(n);
        System.arraycopy(cpxRangeArray, 0, this._row, this._nrows, n);
        this._nrows += n;
    }

    void addVars(CpxNumVar[] cpxNumVarArray, int n) {
        this.makeColSpace(n);
        System.arraycopy(cpxNumVarArray, 0, this._var, this._nvars, n);
        this._nvars += n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IloLPMatrix ");
        if (this.getName() != null) {
            stringBuffer.append(this.getName());
        }
        stringBuffer.append(" {\n");
        for (int i = 0; i < this._nrows; ++i) {
            stringBuffer.append("  ");
            stringBuffer.append(this.getRange(i).toString());
            stringBuffer.append('\n');
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private class LPColumnArray
    extends IloColumnArray {
        CpxLPMatrix _matrix;
        int[][] _ind;
        double[][] _val;
        int _num;

        LPColumnArray(CpxLPMatrix cpxLPMatrix2, int n, int[][] nArray, double[][] dArray) {
            this._matrix = cpxLPMatrix2;
            this._ind = nArray;
            this._val = dArray;
            this._num = n;
        }

        public void install(IloNumVar[] iloNumVarArray) throws IloException {
            this._matrix.addNewCols(iloNumVarArray, this._ind, this._val);
        }

        public int getSize() {
            return this._num;
        }
    }

    private class LPColumn
    extends IloColumn {
        CpxLPMatrix _matrix;
        int[] _ind;
        double[] _val;
        int _start;
        int _num;

        LPColumn(CpxLPMatrix cpxLPMatrix2, int[] nArray, double[] dArray, int n, int n2) {
            this._matrix = cpxLPMatrix2;
            this._ind = nArray;
            this._val = dArray;
            this._start = n;
            this._num = n2;
        }

        public void install(IloNumVar iloNumVar) throws IloException {
            this._matrix.addNewColumn(iloNumVar, this._ind, this._val, this._start, this._num);
        }
    }

    private class NonZero {
        NonZero _prev;
        int _row;
        double _val;

        NonZero(NonZero nonZero, int n, double d) {
            this._prev = nonZero;
            this._row = n;
            this._val = d;
        }
    }
}

