/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.cplex.Cplex;
import ilog.cplex.CplexI;
import ilog.cplex.CpxOptimizationCallback;
import ilog.cplex.IloCplex;

class CpxMIPInfoCallback
extends CpxOptimizationCallback {
    protected CpxMIPInfoCallback(IloCplex.Callback callback) {
        super(callback);
    }

    int getCBType() {
        return 18;
    }

    int getIntNodeInfo(int n, long l) throws IloException {
        this.CALL(Cplex.CPXSgetcallbacknodeinfo(this.getEnv(), this.getCBdata(), this.getWherefrom(), l, n, this._intAux));
        return CplexI.truncateLong(this._intAux[0]);
    }

    long getLongNodeInfo(int n, long l) throws IloException {
        this.CALL(Cplex.CPXSgetcallbacknodeinfo(this.getEnv(), this.getCBdata(), this.getWherefrom(), l, n, this._longAux));
        return this._longAux[0];
    }

    int getIntSeqInfo(int n, long l) throws IloException {
        this.CALL(Cplex.CPXSgetcallbackseqinfo(this.getEnv(), this.getCBdata(), this.getWherefrom(), l, n, this._intAux));
        return CplexI.truncateLong(this._intAux[0]);
    }

    long getLongSeqInfo(int n, long l) throws IloException {
        this.CALL(Cplex.CPXSgetcallbackseqinfo(this.getEnv(), this.getCBdata(), this.getWherefrom(), l, n, this._longAux));
        return this._longAux[0];
    }

    Object getObjectNodeInfo(int n, long l) throws IloException {
        this._objectAux[0] = null;
        this.CALL(Cplex.CPXSgetcallbacknodeinfo(this.getEnv(), this.getCBdata(), this.getWherefrom(), l, n, this._objectAux));
        return this._objectAux[0];
    }

    Object getObjectSeqInfo(int n, long l) throws IloException {
        this._objectAux[0] = null;
        this.CALL(Cplex.CPXSgetcallbackseqinfo(this.getEnv(), this.getCBdata(), this.getWherefrom(), l, n, this._objectAux));
        return this._objectAux[0];
    }

    final int getMyThreadNum() throws IloException {
        return this.getIntInfo(123);
    }

    final boolean hasIncumbent() throws IloException {
        return this.getIntInfo(109) == 1;
    }

    final double getBestObjValue() throws IloException {
        return this.getDoubleInfo(102);
    }

    final double getMIPRelativeGap() throws IloException {
        return this.getDoubleInfo(125);
    }

    final double getCutoff() throws IloException {
        return this.getDoubleInfo(106);
    }

    final double getIncumbentObjValue() throws IloException {
        return this.getDoubleInfo(101);
    }

    final double getIncumbentValue(int n) {
        try {
            this.CALL(Cplex.CPXgetcallbackincumbent(this.getEnv(), this.getCBdata(), this.getWherefrom(), this._doubleAux, n, n));
            return this._doubleAux[0];
        }
        catch (IloException iloException) {
            return 0.0;
        }
    }

    final void getIncumbentValues(double[] dArray, int[] nArray) {
        try {
            int n;
            int n2 = nArray[0];
            int n3 = nArray[0];
            int n4 = nArray.length;
            for (n = 1; n < n4; ++n) {
                if (nArray[n] > n2) {
                    n2 = nArray[n];
                    continue;
                }
                if (nArray[n] >= n3) continue;
                n3 = nArray[n];
            }
            double[] dArray2 = new double[n2 - n3 + 1];
            this.CALL(Cplex.CPXgetcallbackincumbent(this.getEnv(), this.getCBdata(), this.getWherefrom(), dArray2, n3, n2));
            for (n = 0; n < n4; ++n) {
                dArray[n] = dArray2[nArray[n] - n3];
            }
        }
        catch (IloException iloException) {
            // empty catch block
        }
    }

    double[] getIncumbentX() throws IloException {
        int n = this.getNcols();
        double[] dArray = new double[n];
        this.CALL(Cplex.CPXgetcallbackincumbent(this.getEnv(), this.getCBdata(), this.getWherefrom(), dArray, 0, n - 1));
        return dArray;
    }

    final int getNcuts(int n) throws IloException {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 108;
                break;
            }
            case 1: {
                n2 = 111;
                break;
            }
            case 2: {
                n2 = 110;
                break;
            }
            case 3: {
                n2 = 107;
                break;
            }
            case 4: {
                n2 = 115;
                break;
            }
            case 5: {
                n2 = 120;
                break;
            }
            case 6: {
                n2 = 119;
                break;
            }
            case 7: {
                n2 = 117;
                break;
            }
            case 8: {
                n2 = 112;
                break;
            }
            case 9: {
                n2 = 122;
                break;
            }
            case 10: {
                n2 = 126;
                break;
            }
            case 14: {
                n2 = 133;
                break;
            }
            case 15: {
                n2 = 134;
                break;
            }
            case 16: {
                n2 = 135;
                break;
            }
            case 17: {
                n2 = 136;
                break;
            }
        }
        return this.getIntInfo(n2);
    }

    final int getNcliques() throws IloException {
        return this.getIntInfo(107);
    }

    final int getNcovers() throws IloException {
        return this.getIntInfo(108);
    }

    final int getNflowCovers() throws IloException {
        return this.getIntInfo(110);
    }

    final int getNflowPaths() throws IloException {
        return this.getIntInfo(119);
    }

    final int getNGUBcovers() throws IloException {
        return this.getIntInfo(111);
    }

    final int getNfractionalCuts() throws IloException {
        return this.getIntInfo(115);
    }

    final int getNdisjunctiveCuts() throws IloException {
        return this.getIntInfo(117);
    }

    final int getNMIRs() throws IloException {
        return this.getIntInfo(120);
    }

    final int getNimpliedBounds() throws IloException {
        return this.getIntInfo(112);
    }

    final int getNzeroHalfCuts() throws IloException {
        return this.getIntInfo(122);
    }

    final int getNMCFCuts() throws IloException {
        return this.getIntInfo(126);
    }

    final long getNnodes() throws IloException {
        return this.getLongInfo(140);
    }

    final long getNremainingNodes() throws IloException {
        return this.getLongInfo(141);
    }

    final long getNiterations() throws IloException {
        return this.getLongInfo(142);
    }

    final double getQuality(int n) throws IloException {
        switch (n) {
            case 52: {
                return this.getDoubleInfo(127);
            }
            case 53: {
                return this.getDoubleInfo(128);
            }
            case 54: {
                return this.getDoubleInfo(129);
            }
            case 55: {
                return this.getDoubleInfo(130);
            }
            case 56: {
                return this.getDoubleInfo(131);
            }
            case 57: {
                return this.getDoubleInfo(132);
            }
        }
        return this.getDoubleInfo(-1);
    }
}

