/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloConstraint;
import ilog.concert.IloException;
import ilog.cplex.CpxBranchCallback;
import ilog.cplex.CpxGoal;
import ilog.cplex.CpxIncumbentCallback;
import ilog.cplex.CpxNodeCallback;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxOrGoal;
import ilog.cplex.CpxRange;
import ilog.cplex.IloCplex;
import java.util.ArrayList;

class CpxNode {
    private static final int MAX_NUM_NODES = 2;
    private GoalStack _goalStack = null;
    private LimitStack _limitStack = null;
    private EvaluatorInfo _evaluators = null;
    private EvaluatorInfo _nextEval = null;
    private boolean _phathomed = false;
    private boolean _fail = false;
    private ArrayList _ranges = new ArrayList();
    private ArrayList _globalRanges = new ArrayList();
    private double _estimate;
    private CpxNode[] _newNodes;
    private int _nNewNodes;
    private CpxNodeCallback _ndCallback;
    private CpxBranchCallback _brCallback;
    private CpxIncumbentCallback _incCallback;
    private int _nSons;
    private int _depth;
    private int _lDepth;
    IloCplex _cplex;
    IloCplex.NodeId _nId;

    CpxNode(IloCplex iloCplex, double d) {
        this._estimate = d;
        this._newNodes = new CpxNode[2];
        this._nNewNodes = 0;
        this._ndCallback = null;
        this._brCallback = null;
        this._incCallback = null;
        this._nSons = 0;
        this._cplex = iloCplex;
    }

    final IloCplex getCplex() {
        return this._cplex;
    }

    void addGoalStack(IloCplex.Goal goal) {
        GoalStack goalStack;
        if (goal == null) {
            return;
        }
        goal._node = null;
        this._goalStack = goalStack = new GoalStack(goal, this._goalStack);
    }

    final IloCplex.Goal popGoalStack() {
        if (this._goalStack == null) {
            return null;
        }
        IloCplex.Goal goal = this._goalStack._goal;
        this._goalStack = this._goalStack._prev;
        return goal;
    }

    final void addLimitStack(IloCplex.SearchLimit searchLimit) {
        LimitStack limitStack;
        this._limitStack = limitStack = new LimitStack(searchLimit, this._limitStack);
    }

    final boolean checkLimits() {
        boolean bl = true;
        LimitStack limitStack = this._limitStack;
        IloCplex.SearchLimit searchLimit = null;
        while (limitStack != null) {
            searchLimit = limitStack._limit;
            if (searchLimit.isViolated() || searchLimit.checkNode(this)) {
                bl = false;
                searchLimit.setViolated();
                break;
            }
            limitStack = limitStack._prev;
        }
        return bl;
    }

    final void performBranch() throws IloException {
        while (this._goalStack != null && this._goalStack._goal != null && !(this._goalStack._goal instanceof CpxOrGoal) && this._goalStack._goal instanceof CpxGoal) {
            this.addGoalStack(this.popGoalStack().executeNode(this._cplex, this));
        }
    }

    final void addCut(IloConstraint iloConstraint) {
        this._ranges.add(iloConstraint);
    }

    final void addCuts(IloConstraint[] iloConstraintArray) {
        for (int i = 0; i < iloConstraintArray.length; ++i) {
            this._ranges.add(iloConstraintArray[i]);
        }
    }

    final void addGlobalCut(IloConstraint iloConstraint) {
        this._globalRanges.add(iloConstraint);
    }

    final void addGlobalCuts(IloConstraint[] iloConstraintArray) {
        for (int i = 0; i < iloConstraintArray.length; ++i) {
            this._globalRanges.add(iloConstraintArray[i]);
        }
    }

    final void prepareToBranch() {
        this._newNodes = new CpxNode[2];
        this._ranges = new ArrayList();
        this._globalRanges = new ArrayList();
    }

    final void setNodeCallback(CpxNodeCallback cpxNodeCallback) {
        this._ndCallback = cpxNodeCallback;
    }

    final CpxNodeCallback getNodeCallback() {
        return this._ndCallback;
    }

    final void setBranchCallback(CpxBranchCallback cpxBranchCallback, long l) {
        this._brCallback = cpxBranchCallback;
    }

    final CpxBranchCallback getBranchCallback() {
        return this._brCallback;
    }

    final void setIncumbentCallback(CpxIncumbentCallback cpxIncumbentCallback) {
        this._incCallback = cpxIncumbentCallback;
    }

    final CpxIncumbentCallback getIncumbentCallback() {
        return this._incCallback;
    }

    final CpxNode makeBranch(IloCplex.Goal goal, double d) throws IloException {
        CpxNode cpxNode = new CpxNode(this._cplex, d);
        this.copyGoalStack(cpxNode);
        this.copyLimitStack(cpxNode);
        this.copyEvaluators(cpxNode);
        cpxNode._nextEval = cpxNode._evaluators;
        cpxNode._incCallback = this._incCallback;
        cpxNode._brCallback = this._brCallback;
        cpxNode._ndCallback = this._ndCallback;
        cpxNode.addGoalStack(goal);
        cpxNode.prepareToBranch();
        cpxNode.performBranch();
        cpxNode._incCallback = null;
        cpxNode._brCallback = null;
        cpxNode._ndCallback = null;
        cpxNode._depth = this._depth + 1;
        cpxNode._lDepth = this._nSons == 0 ? this._lDepth + 1 : this._lDepth;
        ++this._nSons;
        this._newNodes[this._nNewNodes++] = cpxNode;
        return cpxNode;
    }

    final boolean isFail() {
        return this._fail;
    }

    final void setFail(boolean bl) {
        this._fail = bl;
    }

    final int getLeftDepth() {
        return this._lDepth;
    }

    final int getRightDepth() {
        return this._depth - this._lDepth;
    }

    final int getDepth() {
        return this._depth;
    }

    final synchronized void evaluate(int n) throws IloException {
        while (this._nextEval != null && !this._phathomed) {
            if (!this._nextEval._evaluator.isInit()) {
                this._nextEval._evaluator.initNode(this);
            }
            this._nextEval._evaluation = this._nextEval._evaluator.evaluateNode(this, n);
            if (this._nextEval._evaluation == Double.MAX_VALUE) {
                this._phathomed = true;
            }
            this._nextEval = this._nextEval._next;
        }
    }

    final boolean subsume(CpxNode cpxNode) {
        if (cpxNode == null || this._evaluators == null) {
            return true;
        }
        boolean bl = true;
        EvaluatorInfo evaluatorInfo = this._evaluators;
        EvaluatorInfo evaluatorInfo2 = cpxNode._evaluators;
        while (evaluatorInfo != null && evaluatorInfo2 != null && evaluatorInfo._evaluator.getId() == evaluatorInfo2._evaluator.getId() && !evaluatorInfo._evaluator.callSubsume(evaluatorInfo2._evaluation, evaluatorInfo._evaluation)) {
            if (evaluatorInfo._evaluator.callSubsume(evaluatorInfo._evaluation, evaluatorInfo2._evaluation)) {
                bl = false;
                break;
            }
            evaluatorInfo = evaluatorInfo._next;
            evaluatorInfo2 = evaluatorInfo2._next;
        }
        return bl;
    }

    final boolean isPhathomed() {
        return this._phathomed;
    }

    final void addEvaluator(IloCplex.NodeEvaluator nodeEvaluator) {
        if (this._evaluators == null) {
            this._nextEval = this._evaluators = new EvaluatorInfo(nodeEvaluator);
        } else {
            EvaluatorInfo evaluatorInfo = this._evaluators;
            while (evaluatorInfo._next != null) {
                evaluatorInfo = evaluatorInfo._next;
            }
            evaluatorInfo._next = new EvaluatorInfo(nodeEvaluator);
            if (this._nextEval == null) {
                this._nextEval = evaluatorInfo._next;
            }
        }
    }

    final void copyEvaluators(CpxNode cpxNode) {
        EvaluatorInfo evaluatorInfo = this._evaluators;
        while (evaluatorInfo != null) {
            if (this._nSons == 0) {
                cpxNode.addEvaluator(evaluatorInfo._evaluator);
            } else {
                cpxNode.addEvaluator(evaluatorInfo._evaluator.makeClone());
            }
            evaluatorInfo = evaluatorInfo._next;
        }
    }

    final void copyLimitStack(CpxNode cpxNode) {
        LimitStack limitStack = this._limitStack;
        while (limitStack != null) {
            if (this._nSons == 0) {
                cpxNode.addLimitStack(limitStack._limit);
            } else {
                cpxNode.addLimitStack(limitStack._limit.makeClone());
            }
            limitStack = limitStack._prev;
        }
    }

    final void copyGoalStack(CpxNode cpxNode) {
        GoalStack goalStack = this._goalStack;
        if (goalStack != null) {
            if (this._nSons != 0) {
                GoalStack goalStack2;
                cpxNode._goalStack = goalStack2 = new GoalStack(goalStack._goal.makeClone(), null);
                while (goalStack._prev != null) {
                    goalStack2 = goalStack2._prev = new GoalStack(goalStack._prev._goal.makeClone(), null);
                    goalStack = goalStack._prev;
                }
            } else {
                cpxNode._goalStack = this._goalStack;
            }
        }
    }

    final void solve() throws IloException {
        if (this._goalStack != null) {
            IloCplex.Goal goal = this.popGoalStack();
            if (!(goal instanceof CpxOrGoal)) {
                do {
                    this.addGoalStack(goal.executeNode(this._cplex, this));
                } while ((goal = this.popGoalStack()) != null && (goal instanceof CpxGoal || this._ranges.size() == 0) && !(goal instanceof CpxOrGoal));
            }
            if (goal == null && this._ranges.size() != 0 || goal != null && !(goal instanceof CpxGoal)) {
                this.makeBranch(goal, this._estimate);
            } else if (goal != null) {
                this.addGoalStack(goal.executeNode(this._cplex, this));
            }
        }
    }

    final int getNNewNodes() {
        return this._nNewNodes;
    }

    final double getEstimate() {
        return this._estimate;
    }

    final CpxNode[] getNewNodes() {
        return this._newNodes;
    }

    final void delNewNodes() {
        this._nNewNodes = 0;
        this._newNodes = null;
    }

    final ArrayList getCuts() {
        return this._ranges;
    }

    final ArrayList getGlobalCuts() {
        return this._globalRanges;
    }

    final boolean hasGoals() {
        return this._goalStack != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CpxNode duplicate() {
        CpxNode cpxNode = new CpxNode(this._cplex, this._estimate);
        try {
            this._nSons = 1;
            this.copyGoalStack(cpxNode);
        }
        finally {
            this._nSons = 0;
        }
        return cpxNode;
    }

    final double getValue(CpxNumExpr cpxNumExpr) throws IloException {
        if (this._incCallback != null) {
            return this._incCallback.getValue(cpxNumExpr);
        }
        return this._brCallback.getValue(cpxNumExpr);
    }

    final boolean checkFeasibility(double d) throws IloException {
        double d2;
        CpxNumExpr cpxNumExpr;
        CpxRange cpxRange;
        int n;
        for (n = 0; n < this._ranges.size(); ++n) {
            cpxRange = (CpxRange)this._ranges.get(n);
            cpxNumExpr = cpxRange.getCpxExpr();
            d2 = this._incCallback.getValue(cpxNumExpr);
            if (!(cpxRange.getLB() != -1.7976931348623157E308 && d2 <= cpxRange.getLB() - d) && (cpxRange.getUB() == Double.MAX_VALUE || !(d2 >= cpxRange.getUB() + d))) continue;
            return false;
        }
        for (n = 0; n < this._globalRanges.size(); ++n) {
            cpxRange = (CpxRange)this._globalRanges.get(n);
            cpxNumExpr = cpxRange.getCpxExpr();
            d2 = this._incCallback.getValue(cpxNumExpr);
            if (!(cpxRange.getLB() != -1.7976931348623157E308 && d2 <= cpxRange.getLB() - d) && (cpxRange.getUB() == Double.MAX_VALUE || !(d2 >= cpxRange.getUB() + d))) continue;
            return false;
        }
        return true;
    }

    protected class EvaluatorInfo {
        IloCplex.NodeEvaluator _evaluator;
        double _evaluation;
        EvaluatorInfo _next;

        EvaluatorInfo(IloCplex.NodeEvaluator nodeEvaluator) {
            this._evaluator = nodeEvaluator;
            this._evaluation = Double.MIN_VALUE;
            this._next = null;
        }
    }

    protected class LimitStack {
        LimitStack _prev;
        IloCplex.SearchLimit _limit;

        LimitStack(IloCplex.SearchLimit searchLimit, LimitStack limitStack) {
            this._limit = searchLimit;
            this._prev = limitStack;
        }
    }

    protected class GoalStack {
        GoalStack _prev;
        IloCplex.Goal _goal;

        GoalStack(IloCplex.Goal goal, GoalStack goalStack) {
            this._goal = goal;
            this._prev = goalStack;
        }
    }
}

