/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarBound;
import ilog.concert.IloNumVarBoundType;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxNumVar;

class CpxNumVarBound
extends CpxExtractable
implements IloNumVarBound {
    private static final long serialVersionUID = 12060300L;
    CpxNumVar _var;
    int _type;

    CpxNumVarBound(IloNumVar iloNumVar, IloNumVarBoundType iloNumVarBoundType) {
        this._var = (CpxNumVar)iloNumVar;
        this._type = iloNumVarBoundType.getTypeValue() == -1 ? 1 : 2;
    }

    CpxNumVarBound(IloNumVar iloNumVar, int n) {
        this._var = (CpxNumVar)iloNumVar;
        this._type = n;
    }

    public IloNumVar getVar() {
        return this._var;
    }

    public final CpxNumVar getCpxVar() {
        return this._var;
    }

    public final int getCpxType() {
        return this._type;
    }

    public IloNumVarBoundType getType() {
        if (this._type == 1) {
            return IloNumVarBoundType.Lower;
        }
        return IloNumVarBoundType.Upper;
    }

    public String toString() {
        return this.getType().toString() + " bound of " + this._var.toString();
    }

    public String getName() {
        return this.getType().toString() + " bound of " + this._var.getName();
    }

    public void setName(String string) {
        this._var.setName(string);
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        throw check;
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        return new CpxNumVarBound((IloNumVar)this._var, this._type);
    }
}

