/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;

class CpxOrder {
    CplexIndex[] _col;
    int[] _pri;
    int[] _dir;
    int _num = 0;
    boolean _changed = false;

    final void markChanged() {
        this._changed = true;
    }

    final int getIndex(CplexIndex cplexIndex) {
        for (int i = 0; i < this._num; ++i) {
            if (this._col[i] != cplexIndex) continue;
            return i;
        }
        return -1;
    }

    final void install(CplexI cplexI) throws IloException {
        if (this._changed) {
            this._changed = false;
            int[] nArray = new int[this._num];
            for (int i = 0; i < this._num; ++i) {
                nArray[i] = this._col[i].getIndex();
            }
            cplexI.copyOrder(nArray, this._pri, this._dir);
        }
    }

    final void read(CplexI cplexI) throws IloException {
        int n = cplexI._getOrderNum();
        this._num = 0;
        this.makeSpace(n);
        this._num = n;
        int[] nArray = new int[n];
        cplexI._getOrder(nArray, this._pri, this._dir);
        for (n = 0; n < this._num; ++n) {
            this._col[n] = cplexI.getVariable(n).getVarIndex();
        }
        this._changed = false;
    }

    CpxOrder() {
    }

    final int getPriority(CplexIndex cplexIndex) {
        int n = this.getIndex(cplexIndex);
        if (n >= 0) {
            return this._pri[n];
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getPriorities(CplexIndex[] cplexIndexArray, int[] nArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = 0;
        }
        n3 = n + n2;
        int[] nArray2 = this.markCols(cplexIndexArray, n, n2);
        try {
            int n4 = this._num;
            for (int i = 0; i < n4; ++i) {
                int n5 = this._col[i].getIndex();
                if (n5 >= 0) continue;
                n5 = -n5 - 1;
                nArray[n5 - n] = this._pri[i];
            }
        }
        finally {
            this.unmarkCols(cplexIndexArray, n, n2, nArray2);
        }
    }

    final int getDirection(CplexIndex cplexIndex) {
        int n = this.getIndex(cplexIndex);
        if (n >= 0) {
            return this._dir[n];
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getDirections(CplexIndex[] cplexIndexArray, int[] nArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = 0;
        }
        n3 = n + n2;
        int[] nArray2 = this.markCols(cplexIndexArray, n, n2);
        try {
            int n4 = this._num;
            for (int i = 0; i < n4; ++i) {
                int n5 = this._col[i].getIndex();
                if (n5 >= 0) continue;
                n5 = -n5 - 1;
                nArray[n5 - n] = this._dir[i];
            }
        }
        finally {
            this.unmarkCols(cplexIndexArray, n, n2, nArray2);
        }
    }

    final void setPriority(CplexIndex cplexIndex, int n) {
        this.markChanged();
        int n2 = this.getIndex(cplexIndex);
        if (n2 < 0) {
            this.addOrder(cplexIndex, n, 0);
        } else if (n == 0 && this._dir[n2] == 0) {
            this.deleteOrder(n2);
        } else {
            this._pri[n2] = n;
        }
    }

    final void setDirection(CplexIndex cplexIndex, int n) {
        this.markChanged();
        int n2 = this.getIndex(cplexIndex);
        if (n2 < 0) {
            this.addOrder(cplexIndex, 0, n);
        } else if (n == 0 && this._pri[n2] == 0) {
            this.deleteOrder(n2);
        } else {
            this._dir[n2] = n;
        }
    }

    private void delDefaults() {
        int n;
        int n2 = 0;
        int n3 = this._num;
        for (n = 0; n < n3; ++n) {
            if (this._dir[n] == 0 && this._pri[n] == 0) continue;
            if (n != n2) {
                this._col[n2] = this._col[n];
                this._pri[n2] = this._pri[n];
                this._dir[n2] = this._dir[n];
            }
            ++n2;
        }
        for (n = n2; n < n3; ++n) {
            this._col[n] = null;
        }
        this._num = n2;
    }

    private int[] markCols(CplexIndex[] cplexIndexArray, int n, int n2) {
        int n3 = n + n2;
        int[] nArray = new int[n3];
        for (int i = n; i < n3; ++i) {
            nArray[i] = cplexIndexArray[i].getIndex();
            cplexIndexArray[i].setIndex(-i - 1);
        }
        return nArray;
    }

    private void unmarkCols(CplexIndex[] cplexIndexArray, int n, int n2, int[] nArray) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            cplexIndexArray[i].setIndex(nArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setDirections(CplexIndex[] cplexIndexArray, int[] nArray, int n, int n2) {
        this.markChanged();
        int n3 = n + n2;
        int[] nArray2 = this.markCols(cplexIndexArray, n, n2);
        try {
            int n4;
            int n5 = this._num;
            for (n4 = 0; n4 < n5; ++n4) {
                int n6 = this._col[n4].getIndex();
                if (n6 >= 0) continue;
                n6 = -n6 - 1;
                this._col[n4].setIndex(nArray2[n6]);
                this._dir[n4] = nArray[n6];
            }
            for (n4 = n; n4 < n3; ++n4) {
                if (cplexIndexArray[n4].getIndex() >= 0) continue;
                cplexIndexArray[n4].setIndex(nArray2[n4]);
                this.addOrder(cplexIndexArray[n4], 0, nArray[n4]);
            }
        }
        finally {
            this.unmarkCols(cplexIndexArray, n, n2, nArray2);
        }
        this.delDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setPriorities(CplexIndex[] cplexIndexArray, int[] nArray, int n, int n2) {
        this.markChanged();
        int n3 = n + n2;
        int[] nArray2 = this.markCols(cplexIndexArray, n, n2);
        try {
            int n4;
            int n5 = this._num;
            for (n4 = 0; n4 < n5; ++n4) {
                int n6 = this._col[n4].getIndex();
                if (n6 >= 0) continue;
                n6 = -n6 - 1;
                this._col[n4].setIndex(nArray2[n6]);
                this._pri[n4] = nArray[n6];
            }
            for (n4 = n; n4 < n3; ++n4) {
                if (cplexIndexArray[n4].getIndex() >= 0) continue;
                cplexIndexArray[n4].setIndex(nArray2[n4]);
                this.addOrder(cplexIndexArray[n4], nArray[n4], 0);
            }
        }
        finally {
            this.unmarkCols(cplexIndexArray, n, n2, nArray2);
        }
        this.delDefaults();
    }

    final void addOrder(CplexIndex cplexIndex, int n, int n2) {
        this.markChanged();
        this.makeSpace(1);
        this._col[this._num] = cplexIndex;
        this._pri[this._num] = n;
        this._dir[this._num] = n2;
        ++this._num;
    }

    final void deleteOrder(int n) {
        this.markChanged();
        int n2 = --this._num;
        while (n < n2) {
            this._col[n] = this._col[n + 1];
            this._pri[n] = this._pri[n + 1];
            this._dir[n] = this._dir[n + 1];
            ++n;
        }
        this._col[this._num] = null;
    }

    final void deleteColumn(CplexIndex cplexIndex) {
        int n = this._num;
        for (int i = 0; i < n; ++i) {
            if (this._col[i] != cplexIndex) continue;
            this.deleteOrder(i);
            break;
        }
    }

    void deleteColumns(int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = this._num;
        for (n = 0; n < n3; ++n) {
            if (nArray[this._col[n].getIndex()] != 0) continue;
            if (n != n2) {
                this._col[n2] = this._col[n];
                this._pri[n2] = this._pri[n];
                this._dir[n2] = this._dir[n];
            }
            ++n2;
        }
        this._num = n2;
        for (n = n2; n < n3; ++n) {
            this._col[n] = null;
        }
    }

    void clear() {
        for (int i = 0; i < this._num; ++i) {
            this._col[i] = null;
        }
        this._num = 0;
    }

    private void makeSpace(int n) {
        if (this._col == null || this._num + n > this._col.length) {
            int n2;
            int n3 = n2 = this._col == null ? 8 : this._col.length;
            while (n2 < this._num + n) {
                n2 *= 2;
            }
            CplexIndex[] cplexIndexArray = new CplexIndex[n2];
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            if (this._col != null) {
                System.arraycopy(this._col, 0, cplexIndexArray, 0, this._num);
                System.arraycopy(this._pri, 0, nArray, 0, this._num);
                System.arraycopy(this._dir, 0, nArray2, 0, this._num);
            }
            this._col = cplexIndexArray;
            this._pri = nArray;
            this._dir = nArray2;
        }
    }
}

