/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.cplex.CpxConstExpr;
import ilog.cplex.CpxExprVisitor;
import ilog.cplex.CpxLinearExpr;
import ilog.cplex.CpxLinearNumExpr;
import ilog.cplex.CpxLinkedExpr;
import ilog.cplex.CpxMult;
import ilog.cplex.CpxNegative;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxObjective;
import ilog.cplex.CpxQExpr;
import ilog.cplex.CpxQLExpr;
import ilog.cplex.CpxQLNumExpr;
import ilog.cplex.CpxQTerm;
import ilog.cplex.CpxQTermExtractor;
import ilog.cplex.CpxQuadNumExpr;

class CpxQextractor
implements CpxExprVisitor {
    CpxQLExpr _expr;
    CpxQTermExtractor _term;

    CpxQextractor(CpxObjective cpxObjective) {
        this._expr = cpxObjective._expr;
        this._term = new CpxQTermExtractor();
    }

    CpxQextractor() {
        this._term = new CpxQTermExtractor();
        this._expr = new CpxQLNumExpr();
    }

    public Object visitNumVar(CpxNumVar cpxNumVar) throws IloException {
        this._expr._lin.addCoef(cpxNumVar, 1.0);
        return this;
    }

    public Object visitLinearExpr(CpxLinearExpr cpxLinearExpr) throws IloException {
        this._expr._lin.addCoefs(cpxLinearExpr);
        this._expr._lin._const += cpxLinearExpr._const;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitNegative(CpxNegative cpxNegative) throws IloException {
        CpxLinearExpr cpxLinearExpr = this._expr._lin;
        CpxQExpr cpxQExpr = this._expr._quad;
        this._expr._lin = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
        this._expr._quad = new CpxQuadNumExpr();
        try {
            if (cpxNegative.getExpr().accept(this) == null) {
                this._expr._lin = cpxLinearExpr;
                this._expr._quad = cpxQExpr;
                Object var4_4 = null;
                return var4_4;
            }
            this._expr._lin.scaleBy(-1.0);
            this._expr._quad.scaleBy(-1.0);
            cpxLinearExpr.addCoefs(this._expr._lin);
            cpxQExpr.addCoefs(this._expr._quad);
            cpxLinearExpr._const -= this._expr._lin._const;
        }
        finally {
            this._expr._lin = cpxLinearExpr;
            this._expr._quad = cpxQExpr;
        }
        return this;
    }

    public Object visitLinkedExpr(CpxLinkedExpr cpxLinkedExpr) throws IloException {
        Object object = null;
        CpxLinkedExpr.Link link = cpxLinkedExpr.first;
        while (link != cpxLinkedExpr.last) {
            object = link.expr.accept(this);
            if (object == null) {
                return null;
            }
            link = link.next;
        }
        if (cpxLinkedExpr.last != null && (object = cpxLinkedExpr.last.expr.accept(this)) == null) {
            return null;
        }
        return object;
    }

    public Object visitQTerm(CpxQTerm cpxQTerm) throws IloException {
        this._expr._quad.addCoef(cpxQTerm.getVar1(), cpxQTerm.getVar2(), cpxQTerm.getVal());
        return this;
    }

    public Object visitQExpr(CpxQExpr cpxQExpr) throws IloException {
        this._expr._quad.add(cpxQExpr);
        return this;
    }

    public Object visitQLExpr(CpxQLExpr cpxQLExpr) throws IloException {
        if (this.visitLinearExpr(cpxQLExpr._lin) != null) {
            return this.visitQExpr(cpxQLExpr._quad);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitMult(CpxMult cpxMult) throws IloException {
        this._term.clear();
        if (cpxMult.accept(this._term) != null) {
            this._term.install(this._expr._lin, this._expr._quad);
            return this;
        }
        CpxLinearExpr cpxLinearExpr = this._expr._lin;
        CpxLinearNumExpr cpxLinearNumExpr = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
        CpxLinearNumExpr cpxLinearNumExpr2 = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
        CpxQExpr cpxQExpr = this._expr._quad;
        CpxQuadNumExpr cpxQuadNumExpr = new CpxQuadNumExpr();
        CpxQuadNumExpr cpxQuadNumExpr2 = new CpxQuadNumExpr();
        try {
            this._expr._lin = cpxLinearNumExpr;
            this._expr._quad = cpxQuadNumExpr;
            if (cpxMult.getRight().accept(this) == null) {
                this._expr._lin = cpxLinearExpr;
                this._expr._quad = cpxQExpr;
                Object var8_8 = null;
                return var8_8;
            }
            this._expr._lin = cpxLinearNumExpr2;
            this._expr._quad = cpxQuadNumExpr2;
            if (cpxMult.getLeft().accept(this) == null) {
                this._expr._lin = cpxLinearExpr;
                this._expr._quad = cpxQExpr;
                Object var8_9 = null;
                return var8_9;
            }
        }
        finally {
            this._expr._lin = cpxLinearExpr;
            this._expr._quad = cpxQExpr;
        }
        if (cpxLinearNumExpr._const != 0.0) {
            cpxLinearNumExpr2.scaleBy(cpxLinearNumExpr._const);
            this._expr._lin.addCoefs(cpxLinearNumExpr2);
            cpxLinearNumExpr2.scaleBy(1.0 / cpxLinearNumExpr._const);
            cpxQuadNumExpr2.scaleBy(cpxLinearNumExpr._const);
            cpxQExpr.addCoefs(cpxQuadNumExpr2.getNumVar1(), cpxQuadNumExpr2.getNumVar2(), cpxQuadNumExpr2.getValues(), 0, cpxQuadNumExpr2.getNum());
            cpxQuadNumExpr2.scaleBy(1.0 / cpxLinearNumExpr._const);
            this._expr._lin._const += cpxLinearNumExpr._const * cpxLinearNumExpr2._const;
        }
        if (cpxLinearNumExpr.getNum() > 0) {
            if (cpxQuadNumExpr2.getNum() > 0) {
                return null;
            }
            if (cpxLinearNumExpr2.getNum() > 0) {
                int n = cpxLinearNumExpr.getNum();
                double[] dArray = cpxLinearNumExpr.getValues();
                CpxNumVar[] cpxNumVarArray = cpxLinearNumExpr.getNumVars();
                int n2 = cpxLinearNumExpr2.getNum();
                double[] dArray2 = cpxLinearNumExpr2.getValues();
                CpxNumVar[] cpxNumVarArray2 = cpxLinearNumExpr2.getNumVars();
                int n3 = n * n2;
                double[] dArray3 = new double[n3];
                CpxNumVar[] cpxNumVarArray3 = new CpxNumVar[n3];
                CpxNumVar[] cpxNumVarArray4 = new CpxNumVar[n3];
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        dArray3[n4] = dArray[i] * dArray2[j];
                        cpxNumVarArray3[n4] = cpxNumVarArray[i];
                        cpxNumVarArray4[n4] = cpxNumVarArray2[j];
                        ++n4;
                    }
                }
                cpxQExpr.addCoefs(cpxNumVarArray3, cpxNumVarArray4, dArray3, 0, n3);
            }
            if (cpxLinearNumExpr2._const != 0.0) {
                cpxLinearNumExpr.scaleBy(cpxLinearNumExpr2._const);
                this._expr._lin.addCoefs(cpxLinearNumExpr);
                cpxLinearNumExpr.scaleBy(1.0 / cpxLinearNumExpr2._const);
            }
        }
        if (cpxQuadNumExpr.getNum() > 0) {
            if (cpxQuadNumExpr2.getNum() > 0 || cpxLinearNumExpr2.getNum() > 0) {
                return null;
            }
            if (cpxLinearNumExpr2._const != 0.0) {
                cpxQuadNumExpr.scaleBy(cpxLinearNumExpr2._const);
                this._expr._quad.addCoefs(cpxQuadNumExpr);
                cpxQuadNumExpr.scaleBy(1.0 / cpxLinearNumExpr2._const);
            }
        }
        return this;
    }

    public Object visitConst(CpxConstExpr cpxConstExpr) throws IloException {
        this._expr._lin._const += cpxConstExpr.getValue();
        return this;
    }
}

