/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.metadata.dialect;

import io.shardingsphere.core.metadata.ColumnMetaData;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;

public abstract class ShardingMetaDataHandler {
    private final DataSource dataSource;
    private final String actualTableName;

    public Collection<ColumnMetaData> getColumnMetaDataList() throws SQLException {
        List<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        try (Connection connection = this.dataSource.getConnection();){
            if (this.isTableExist(connection)) {
                result = this.getExistColumnMeta(connection);
            }
        }
        return result;
    }

    public Collection<ColumnMetaData> getColumnMetaDataList(Connection connection) throws SQLException {
        List<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        if (this.isTableExist(connection)) {
            result = this.getExistColumnMeta(connection);
        }
        return result;
    }

    public abstract boolean isTableExist(Connection var1) throws SQLException;

    public abstract List<ColumnMetaData> getExistColumnMeta(Connection var1) throws SQLException;

    @ConstructorProperties(value={"dataSource", "actualTableName"})
    public ShardingMetaDataHandler(DataSource dataSource, String actualTableName) {
        this.dataSource = dataSource;
        this.actualTableName = actualTableName;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected String getActualTableName() {
        return this.actualTableName;
    }
}

