/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ExponentialBackoff;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniRetryAtMost;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public class UniRetry<T> {
    private final Uni<T> upstream;
    private final Predicate<? super Throwable> predicate;
    private Duration initialBackOffDuration = Duration.ofSeconds(1L);
    private Duration maxBackoffDuration = ExponentialBackoff.MAX_BACKOFF;
    private double jitter = 0.5;
    private boolean backOffConfigured = false;

    public UniRetry(Uni<T> upstream, Predicate<? super Throwable> predicate) {
        this.upstream = upstream;
        this.predicate = predicate;
    }

    public Uni<T> indefinitely() {
        return this.atMost(Long.MAX_VALUE);
    }

    public Uni<T> atMost(long numberOfAttempts) {
        if (!this.backOffConfigured) {
            return Infrastructure.onUniCreation(new UniRetryAtMost<T>(this.upstream, this.predicate, numberOfAttempts));
        }
        Function<Multi<Throwable>, Publisher<Long>> factory = ExponentialBackoff.randomExponentialBackoffFunction(numberOfAttempts, this.initialBackOffDuration, this.maxBackoffDuration, this.jitter, Infrastructure.getDefaultWorkerPool());
        return this.upstream.toMulti().onFailure().retry().when(factory).toUni();
    }

    public Uni<T> until(Predicate<? super Throwable> predicate) {
        ParameterValidation.nonNull(predicate, "predicate");
        Function<Multi, Publisher> whenStreamFactory = stream -> stream.onItem().produceUni(failure -> Uni.createFrom().emitter(emitter -> {
            try {
                if (predicate.test((Throwable)failure)) {
                    emitter.complete(1L);
                } else {
                    emitter.fail((Throwable)failure);
                }
            }
            catch (Throwable ex) {
                emitter.fail(ex);
            }
        })).concatenate();
        return this.when(whenStreamFactory);
    }

    public Uni<T> when(Function<Multi<Throwable>, ? extends Publisher<?>> whenStreamFactory) {
        if (this.backOffConfigured) {
            throw new IllegalArgumentException("Invalid retry configuration, `when` cannot be used with a back-off configuration");
        }
        return this.upstream.toMulti().onFailure().retry().when(whenStreamFactory).toUni();
    }

    public UniRetry<T> withBackOff(Duration initialBackOff) {
        return this.withBackOff(initialBackOff, ExponentialBackoff.MAX_BACKOFF);
    }

    public UniRetry<T> withBackOff(Duration initialBackOff, Duration maxBackOff) {
        this.backOffConfigured = true;
        this.initialBackOffDuration = ParameterValidation.validate(initialBackOff, "initialBackOff");
        this.maxBackoffDuration = ParameterValidation.validate(maxBackOff, "maxBackOff");
        return this;
    }

    public UniRetry<T> withJitter(double jitter) {
        if (jitter < 0.0 || jitter > 1.0) {
            throw new IllegalArgumentException("Invalid `jitter`, the value must be in [0.0, 1.0]");
        }
        this.backOffConfigured = true;
        this.jitter = jitter;
        return this;
    }
}

