/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.ReliabilityTest;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ReliabilityTest
extends Configured
implements Tool {
    private String dir;
    private static final Log LOG = LogFactory.getLog(ReliabilityTest.class);

    private void displayUsage() {
        LOG.info((Object)"This must be run in only the distributed mode (LocalJobRunner not supported).\n\tUsage: MRReliabilityTest -libjars <path to hadoop-examples.jar> [-scratchdir <dir>]\n[-scratchdir] points to a scratch space on this host where temp files for this test will be created. Defaults to current working dir. \nPasswordless SSH must be set up between this host and the nodes which the test is going to use.\nThe test should be run on a free cluster with no parallel job submission going on, as the test requires to restart TaskTrackers and kill tasks any job submission while the tests are running can cause jobs/tests to fail");
        System.exit(-1);
    }

    public int run(String[] args) throws Exception {
        String[] otherArgs;
        Configuration conf = this.getConf();
        if ("local".equals(conf.get("mapreduce.jobtracker.address", "local"))) {
            this.displayUsage();
        }
        if ((otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs()).length == 2) {
            if (otherArgs[0].equals("-scratchdir")) {
                this.dir = otherArgs[1];
            } else {
                this.displayUsage();
            }
        } else if (otherArgs.length == 0) {
            this.dir = System.getProperty("user.dir");
        } else {
            this.displayUsage();
        }
        conf.setInt("mapreduce.map.maxattempts", 10);
        conf.setInt("mapreduce.reduce.maxattempts", 10);
        this.runSleepJobTest(new JobClient(new JobConf(conf)), conf);
        this.runSortJobTests(new JobClient(new JobConf(conf)), conf);
        return 0;
    }

    private void runSleepJobTest(JobClient jc, Configuration conf) throws Exception {
        int mapSleepTime;
        int maxMaps;
        ClusterStatus c = jc.getClusterStatus();
        int maxReduces = maxMaps = c.getMaxMapTasks() * 2;
        int reduceSleepTime = mapSleepTime = (int)c.getTTExpiryInterval();
        String[] sleepJobArgs = new String[]{"-m", Integer.toString(maxMaps), "-r", Integer.toString(maxReduces), "-mt", Integer.toString(mapSleepTime), "-rt", Integer.toString(reduceSleepTime)};
        this.runTest(jc, conf, "org.apache.hadoop.mapreduce.SleepJob", sleepJobArgs, new KillTaskThread(this, jc, 2, 0.2f, false, 2), new KillTrackerThread(this, jc, 2, 0.4f, false, 1));
        LOG.info((Object)"SleepJob done");
    }

    private void runSortJobTests(JobClient jc, Configuration conf) throws Exception {
        String inputPath = "my_reliability_test_input";
        String outputPath = "my_reliability_test_output";
        FileSystem fs = jc.getFs();
        fs.delete(new Path(inputPath), true);
        fs.delete(new Path(outputPath), true);
        this.runRandomWriterTest(jc, conf, inputPath);
        this.runSortTest(jc, conf, inputPath, outputPath);
        this.runSortValidatorTest(jc, conf, inputPath, outputPath);
    }

    private void runRandomWriterTest(JobClient jc, Configuration conf, String inputPath) throws Exception {
        this.runTest(jc, conf, "org.apache.hadoop.examples.RandomWriter", new String[]{inputPath}, null, new KillTrackerThread(this, jc, 0, 0.4f, false, 1));
        LOG.info((Object)"RandomWriter job done");
    }

    private void runSortTest(JobClient jc, Configuration conf, String inputPath, String outputPath) throws Exception {
        this.runTest(jc, conf, "org.apache.hadoop.examples.Sort", new String[]{inputPath, outputPath}, new KillTaskThread(this, jc, 2, 0.2f, false, 2), new KillTrackerThread(this, jc, 2, 0.8f, false, 1));
        LOG.info((Object)"Sort job done");
    }

    private void runSortValidatorTest(JobClient jc, Configuration conf, String inputPath, String outputPath) throws Exception {
        this.runTest(jc, conf, "org.apache.hadoop.mapred.SortValidator", new String[]{"-sortInput", inputPath, "-sortOutput", outputPath}, new KillTaskThread(this, jc, 2, 0.2f, false, 1), new KillTrackerThread(this, jc, 2, 0.8f, false, 1));
        LOG.info((Object)"SortValidator job done");
    }

    private String normalizeCommandPath(String command) {
        String hadoopHome = System.getenv("HADOOP_PREFIX");
        if (hadoopHome != null) {
            command = hadoopHome + "/" + command;
        }
        return command;
    }

    private void checkJobExitStatus(int status, String jobName) {
        if (status != 0) {
            LOG.info((Object)(jobName + " job failed with status: " + status));
            System.exit(status);
        } else {
            LOG.info((Object)(jobName + " done."));
        }
    }

    private void runTest(JobClient jc, Configuration conf, String jobClass, String[] args, KillTaskThread killTaskThread, KillTrackerThread killTrackerThread) throws Exception {
        JobStatus[] jobs;
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        t.setDaemon(true);
        t.start();
        while ((jobs = jc.jobsToComplete()).length == 0) {
            LOG.info((Object)("Waiting for the job " + jobClass + " to start"));
            Thread.sleep(1000L);
        }
        JobID jobId = jobs[jobs.length - 1].getJobID();
        RunningJob rJob = jc.getJob(jobId);
        if (rJob.isComplete()) {
            LOG.error((Object)("The last job returned by the querying JobTracker is complete :" + rJob.getJobID() + " .Exiting the test"));
            System.exit(-1);
        }
        while (rJob.getJobState() == JobStatus.PREP) {
            LOG.info((Object)("JobID : " + jobId + " not started RUNNING yet"));
            Thread.sleep(1000L);
            rJob = jc.getJob(jobId);
        }
        if (killTaskThread != null) {
            killTaskThread.setRunningJob(rJob);
            killTaskThread.start();
            killTaskThread.join();
            LOG.info((Object)"DONE WITH THE TASK KILL/FAIL TESTS");
        }
        if (killTrackerThread != null) {
            killTrackerThread.setRunningJob(rJob);
            killTrackerThread.start();
            killTrackerThread.join();
            LOG.info((Object)"DONE WITH THE TESTS TO DO WITH LOST TASKTRACKERS");
        }
        t.join();
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new ReliabilityTest(), (String[])args);
        System.exit(res);
    }

    static /* synthetic */ void access$000(ReliabilityTest x0, int x1, String x2) {
        x0.checkJobExitStatus(x1, x2);
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ String access$200(ReliabilityTest x0) {
        return x0.dir;
    }

    static /* synthetic */ String access$300(ReliabilityTest x0, String x1) {
        return x0.normalizeCommandPath(x1);
    }
}

