/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.SortValidator;
import org.apache.hadoop.mapred.ThreadedMapBenchmark;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThreadedMapBenchmark
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ThreadedMapBenchmark.class);
    private static Path BASE_DIR = new Path(System.getProperty("test.build.data", File.separator + "benchmarks" + File.separator + "ThreadedMapBenchmark"));
    private static Path INPUT_DIR = new Path(BASE_DIR, "input");
    private static Path OUTPUT_DIR = new Path(BASE_DIR, "output");
    private static final float FACTOR = 2.3f;

    public static void generateInputData(int dataSizePerMap, int numSpillsPerMap, int numMapsPerHost, JobConf masterConf) throws Exception {
        JobConf job = new JobConf((Configuration)masterConf, ThreadedMapBenchmark.class);
        job.setJobName("threaded-map-benchmark-random-writer");
        job.setJarByClass(ThreadedMapBenchmark.class);
        job.setInputFormat(UtilsForTests.RandomInputFormat.class);
        job.setOutputFormat(SequenceFileOutputFormat.class);
        job.setMapperClass(Map.class);
        job.setReducerClass(IdentityReducer.class);
        job.setOutputKeyClass(BytesWritable.class);
        job.setOutputValueClass(BytesWritable.class);
        JobClient client = new JobClient(job);
        ClusterStatus cluster = client.getClusterStatus();
        long totalDataSize = dataSizePerMap * numMapsPerHost * cluster.getTaskTrackers();
        job.set("test.tmb.bytes_per_map", String.valueOf(dataSizePerMap * 1024 * 1024));
        job.setNumReduceTasks(0);
        job.setNumMapTasks(numMapsPerHost * cluster.getTaskTrackers());
        FileOutputFormat.setOutputPath((JobConf)job, (Path)INPUT_DIR);
        FileSystem fs = FileSystem.get((Configuration)job);
        fs.delete(BASE_DIR, true);
        LOG.info((Object)"Generating random input for the benchmark");
        LOG.info((Object)("Total data : " + totalDataSize + " mb"));
        LOG.info((Object)("Data per map: " + dataSizePerMap + " mb"));
        LOG.info((Object)("Number of spills : " + numSpillsPerMap));
        LOG.info((Object)("Number of maps per host : " + numMapsPerHost));
        LOG.info((Object)("Number of hosts : " + cluster.getTaskTrackers()));
        JobClient.runJob((JobConf)job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        LOG.info((Object)"Starting the benchmark for threaded spills");
        String version = "ThreadedMapBenchmark.0.0.1";
        System.out.println(version);
        String usage = "Usage: threadedmapbenchmark [-dataSizePerMap <data size (in mb) per map, default is 128 mb>] [-numSpillsPerMap <number of spills per map, default is 2>] [-numMapsPerHost <number of maps per host, default is 1>]";
        int dataSizePerMap = 128;
        int numSpillsPerMap = 2;
        int numMapsPerHost = 1;
        JobConf masterConf = new JobConf(this.getConf());
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-dataSizePerMap")) {
                dataSizePerMap = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-numSpillsPerMap")) {
                numSpillsPerMap = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-numMapsPerHost")) {
                numMapsPerHost = Integer.parseInt(args[++i]);
                continue;
            }
            System.err.println(usage);
            System.exit(-1);
        }
        if (dataSizePerMap < 1 || numSpillsPerMap < 1 || numMapsPerHost < 1) {
            System.err.println(usage);
            System.exit(-1);
        }
        FileSystem fs = null;
        try {
            ThreadedMapBenchmark.generateInputData((int)dataSizePerMap, (int)numSpillsPerMap, (int)numMapsPerHost, (JobConf)masterConf);
            JobConf job = new JobConf((Configuration)masterConf, ThreadedMapBenchmark.class);
            job.setJobName("threaded-map-benchmark-unspilled");
            job.setJarByClass(ThreadedMapBenchmark.class);
            job.setInputFormat(SortValidator.RecordStatsChecker.NonSplitableSequenceFileInputFormat.class);
            job.setOutputFormat(SequenceFileOutputFormat.class);
            job.setOutputKeyClass(BytesWritable.class);
            job.setOutputValueClass(BytesWritable.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            FileInputFormat.addInputPath((JobConf)job, (Path)INPUT_DIR);
            FileOutputFormat.setOutputPath((JobConf)job, (Path)OUTPUT_DIR);
            JobClient client = new JobClient(job);
            ClusterStatus cluster = client.getClusterStatus();
            job.setNumMapTasks(numMapsPerHost * cluster.getTaskTrackers());
            job.setNumReduceTasks(1);
            int ioSortMb = (int)Math.ceil(2.3f * (float)dataSizePerMap);
            job.set("mapreduce.task.io.sort.mb", String.valueOf(ioSortMb));
            fs = FileSystem.get((Configuration)job);
            LOG.info((Object)"Running sort with 1 spill per map");
            long startTime = System.currentTimeMillis();
            JobClient.runJob((JobConf)job);
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("Total time taken : " + String.valueOf(endTime - startTime) + " millisec"));
            fs.delete(OUTPUT_DIR, true);
            JobConf spilledJob = new JobConf((Configuration)job, ThreadedMapBenchmark.class);
            ioSortMb = (int)Math.ceil((double)2.3f * Math.ceil((double)dataSizePerMap / (double)numSpillsPerMap));
            spilledJob.set("mapreduce.task.io.sort.mb", String.valueOf(ioSortMb));
            spilledJob.setJobName("threaded-map-benchmark-spilled");
            spilledJob.setJarByClass(ThreadedMapBenchmark.class);
            LOG.info((Object)("Running sort with " + numSpillsPerMap + " spills per map"));
            startTime = System.currentTimeMillis();
            JobClient.runJob((JobConf)spilledJob);
            endTime = System.currentTimeMillis();
            LOG.info((Object)("Total time taken : " + String.valueOf(endTime - startTime) + " millisec"));
        }
        finally {
            if (fs != null) {
                fs.delete(BASE_DIR, true);
            }
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new ThreadedMapBenchmark(), (String[])args);
        System.exit(res);
    }
}

