/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TestMapCollection;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMapCollection {
    private static final Log LOG = LogFactory.getLog((String)TestMapCollection.class.getName());

    private static void runTest(String name, int keylen, int vallen, int records, int ioSortMB, float spillPer) throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.client.completion.pollinterval", 100);
        Job job = Job.getInstance((Configuration)conf);
        conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.mb", ioSortMB);
        conf.set("mapreduce.map.sort.spill.percent", Float.toString(spillPer));
        conf.setClass("test.mapcollection.class", FixedRecordFactory.class, RecordFactory.class);
        FixedRecordFactory.setLengths((Configuration)conf, (int)keylen, (int)vallen);
        conf.setInt("test.spillmap.records", records);
        TestMapCollection.runTest((String)name, (Job)job);
    }

    private static void runTest(String name, Job job) throws Exception {
        job.setNumReduceTasks(1);
        job.getConfiguration().set("mapreduce.framework.name", "local");
        job.getConfiguration().setInt("mapreduce.task.io.sort.factor", 1000);
        job.getConfiguration().set("fs.defaultFS", "file:///");
        job.getConfiguration().setInt("test.mapcollection.num.maps", 1);
        job.setInputFormatClass(FakeIF.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapperClass(Mapper.class);
        job.setReducerClass(SpillReducer.class);
        job.setMapOutputKeyClass(KeyWritable.class);
        job.setMapOutputValueClass(ValWritable.class);
        job.setSortComparatorClass(VariableComparator.class);
        LOG.info((Object)("Running " + name));
        Assert.assertTrue((String)"Job failed!", (boolean)job.waitForCompletion(false));
    }

    @Test
    public void testValLastByte() throws Exception {
        TestMapCollection.runTest((String)"vallastbyte", (int)128, (int)896, (int)1344, (int)1, (float)0.5f);
        TestMapCollection.runTest((String)"keylastbyte", (int)512, (int)1024, (int)896, (int)1, (float)0.5f);
    }

    @Test
    public void testLargeRecords() throws Exception {
        TestMapCollection.runTest((String)"largerec", (int)100, (int)0x100000, (int)5, (int)1, (float)0.8f);
        TestMapCollection.runTest((String)"largekeyzeroval", (int)0x100000, (int)0, (int)5, (int)1, (float)0.8f);
    }

    @Test
    public void testSpillPer2B() throws Exception {
        TestMapCollection.runTest((String)"fullspill2B", (int)1, (int)1, (int)10000, (int)1, (float)1.0f);
        TestMapCollection.runTest((String)"fullspill200B", (int)100, (int)100, (int)10000, (int)1, (float)1.0f);
        TestMapCollection.runTest((String)"fullspillbuf", (int)10240, (int)20480, (int)256, (int)1, (float)1.0f);
        TestMapCollection.runTest((String)"lt50perspill", (int)100, (int)100, (int)10000, (int)1, (float)0.3f);
    }

    @Test
    public void testZeroVal() throws Exception {
        TestMapCollection.runTest((String)"zeroval", (int)1, (int)0, (int)10000, (int)1, (float)0.8f);
        TestMapCollection.runTest((String)"zerokey", (int)0, (int)1, (int)10000, (int)1, (float)0.8f);
        TestMapCollection.runTest((String)"zerokeyval", (int)0, (int)0, (int)10000, (int)1, (float)0.8f);
        TestMapCollection.runTest((String)"zerokeyvalfull", (int)0, (int)0, (int)10000, (int)1, (float)1.0f);
    }

    @Test
    public void testSingleRecord() throws Exception {
        TestMapCollection.runTest((String)"singlerecord", (int)100, (int)100, (int)1, (int)1, (float)1.0f);
        TestMapCollection.runTest((String)"zerokeyvalsingle", (int)0, (int)0, (int)1, (int)1, (float)1.0f);
    }

    @Test
    public void testLowSpill() throws Exception {
        TestMapCollection.runTest((String)"lowspill", (int)4000, (int)96, (int)20, (int)1, (float)0.00390625f);
    }

    @Test
    public void testSplitMetaSpill() throws Exception {
        TestMapCollection.runTest((String)"splitmetaspill", (int)7, (int)1, (int)131072, (int)1, (float)0.8f);
    }

    @Test
    public void testPostSpillMeta() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.client.completion.pollinterval", 100);
        Job job = Job.getInstance((Configuration)conf);
        conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.mb", 1);
        conf.set("mapreduce.map.sort.spill.percent", Float.toString(0.9863281f));
        conf.setClass("test.mapcollection.class", StepFactory.class, RecordFactory.class);
        StepFactory.setLengths((Configuration)conf, (int)4000, (int)0, (int)96, (int)0, (int)252);
        conf.setInt("test.spillmap.records", 1000);
        conf.setBoolean("test.disable.key.read", true);
        conf.setBoolean("test.disable.val.read", true);
        TestMapCollection.runTest((String)"postspillmeta", (Job)job);
    }

    @Test
    public void testLargeRecConcurrent() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.client.completion.pollinterval", 100);
        Job job = Job.getInstance((Configuration)conf);
        conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.mb", 1);
        conf.set("mapreduce.map.sort.spill.percent", Float.toString(0.9863281f));
        conf.setClass("test.mapcollection.class", StepFactory.class, RecordFactory.class);
        StepFactory.setLengths((Configuration)conf, (int)4000, (int)261120, (int)96, (int)1024, (int)251);
        conf.setInt("test.spillmap.records", 255);
        conf.setBoolean("test.disable.key.read", false);
        conf.setBoolean("test.disable.val.read", false);
        TestMapCollection.runTest((String)"largeconcurrent", (Job)job);
    }

    @Test
    public void testRandom() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.client.completion.pollinterval", 100);
        Job job = Job.getInstance((Configuration)conf);
        conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.mb", 1);
        conf.setClass("test.mapcollection.class", RandomFactory.class, RecordFactory.class);
        Random r = new Random();
        long seed = r.nextLong();
        LOG.info((Object)("SEED: " + seed));
        r.setSeed(seed);
        conf.set("mapreduce.map.sort.spill.percent", Float.toString(Math.max(0.1f, r.nextFloat())));
        RandomFactory.setLengths((Configuration)conf, (Random)r, (int)16384);
        conf.setInt("test.spillmap.records", r.nextInt(500));
        conf.setLong("test.randomfactory.seed", r.nextLong());
        TestMapCollection.runTest((String)"random", (Job)job);
    }

    @Test
    public void testRandomCompress() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.client.completion.pollinterval", 100);
        Job job = Job.getInstance((Configuration)conf);
        conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.mb", 1);
        conf.setBoolean("mapreduce.map.output.compress", true);
        conf.setClass("test.mapcollection.class", RandomFactory.class, RecordFactory.class);
        Random r = new Random();
        long seed = r.nextLong();
        LOG.info((Object)("SEED: " + seed));
        r.setSeed(seed);
        conf.set("mapreduce.map.sort.spill.percent", Float.toString(Math.max(0.1f, r.nextFloat())));
        RandomFactory.setLengths((Configuration)conf, (Random)r, (int)16384);
        conf.setInt("test.spillmap.records", r.nextInt(500));
        conf.setLong("test.randomfactory.seed", r.nextLong());
        TestMapCollection.runTest((String)"randomCompress", (Job)job);
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

