/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.LoadBalancerTracker;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestMetaWithReplicas {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaWithReplicas.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaWithReplicas.class);
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int REGIONSERVERS_COUNT = 3;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() throws Exception {
        this.TEST_UTIL.getConfiguration().setInt("zookeeper.session.timeout", 30000);
        this.TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", 3);
        this.TEST_UTIL.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 1000);
        this.TEST_UTIL.startMiniCluster(3);
        AssignmentManager am = this.TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        HashSet<ServerName> sns = new HashSet<ServerName>();
        ServerName hbaseMetaServerName = MetaTableLocator.getMetaRegionLocation((ZKWatcher)this.TEST_UTIL.getZooKeeperWatcher());
        LOG.info("HBASE:META DEPLOY: on " + hbaseMetaServerName);
        sns.add(hbaseMetaServerName);
        for (int replicaId = 1; replicaId < 3; ++replicaId) {
            RegionInfo h = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)replicaId);
            AssignmentTestingUtil.waitForAssignment(am, h);
            ServerName sn = am.getRegionStates().getRegionServerOfRegion(h);
            Assert.assertNotNull((Object)sn);
            LOG.info("HBASE:META DEPLOY: " + h.getRegionNameAsString() + " on " + sn);
            sns.add(sn);
        }
        if (sns.size() == 1) {
            int metaServerIndex;
            int count = this.TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size();
            Assert.assertTrue((String)("count=" + count), (count == 3 ? 1 : 0) != 0);
            LOG.warn("All hbase:meta replicas are on the one server; moving hbase:meta: " + sns);
            int newServerIndex = metaServerIndex = this.TEST_UTIL.getHBaseCluster().getServerWithMeta();
            while (newServerIndex == metaServerIndex) {
                newServerIndex = (newServerIndex + 1) % 3;
            }
            Assert.assertNotEquals((long)metaServerIndex, (long)newServerIndex);
            ServerName destinationServerName = this.TEST_UTIL.getHBaseCluster().getRegionServer(newServerIndex).getServerName();
            ServerName metaServerName = this.TEST_UTIL.getHBaseCluster().getRegionServer(metaServerIndex).getServerName();
            Assert.assertNotEquals((Object)destinationServerName, (Object)metaServerName);
            this.TEST_UTIL.getAdmin().move(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), destinationServerName);
        }
        LoadBalancerTracker l = new LoadBalancerTracker(this.TEST_UTIL.getZooKeeperWatcher(), new Abortable(){
            AtomicBoolean aborted = new AtomicBoolean(false);

            public boolean isAborted() {
                return this.aborted.get();
            }

            public void abort(String why, Throwable e) {
                this.aborted.set(true);
            }
        });
        l.setBalancerOn(false);
        LOG.debug("All meta replicas assigned");
    }

    @After
    public void tearDown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMetaHTDReplicaCount() throws Exception {
        Assert.assertEquals((long)3L, (long)this.TEST_UTIL.getAdmin().getDescriptor(TableName.META_TABLE_NAME).getRegionReplication());
    }

    @Test
    public void testZookeeperNodesForReplicas() throws Exception {
        ZKWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
        Configuration conf = this.TEST_UTIL.getConfiguration();
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZNodePaths.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
        ProtobufUtil.toServerName((byte[])data);
        for (int i = 1; i < 3; ++i) {
            String secZnode = ZNodePaths.joinZNode((String)baseZNode, (String)(conf.get("zookeeper.znode.metaserver", "meta-region-server") + "-" + i));
            String str = zkw.getZNodePaths().getZNodeForReplica(i);
            Assert.assertTrue((boolean)str.equals(secZnode));
            data = ZKUtil.getData((ZKWatcher)zkw, (String)secZnode);
            ProtobufUtil.toServerName((byte[])data);
        }
    }

    @Test
    public void testShutdownHandling() throws Exception {
        TestMetaWithReplicas.shutdownMetaAndDoValidations(this.TEST_UTIL);
    }

    public static void shutdownMetaAndDoValidations(HBaseTestingUtility util) throws Exception {
        Throwable throwable;
        Table htable;
        ZKWatcher zkw = util.getZooKeeperWatcher();
        Configuration conf = util.getConfiguration();
        conf.setBoolean("hbase.meta.replicas.use", true);
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZNodePaths.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
        ServerName primary = ProtobufUtil.toServerName((byte[])data);
        LOG.info("Primary=" + primary.toString());
        TableName TABLE = TableName.valueOf((String)"testShutdownHandling");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"foo")};
        if (util.getAdmin().tableExists(TABLE)) {
            util.getAdmin().disableTable(TABLE);
            util.getAdmin().deleteTable(TABLE);
        }
        byte[] row = Bytes.toBytes((String)"test");
        ServerName master = null;
        try (Connection c = ConnectionFactory.createConnection((Configuration)conf);){
            htable = util.createTable(TABLE, (byte[][])FAMILIES);
            throwable = null;
            try {
                util.getAdmin().flush(TableName.META_TABLE_NAME);
                Thread.sleep(conf.getInt("hbase.regionserver.storefile.refresh.period", 30000) * 6);
                List regions = MetaTableAccessor.getTableRegions((Connection)c, (TableName)TABLE);
                HRegionLocation hrl = MetaTableAccessor.getRegionLocation((Connection)c, (RegionInfo)((RegionInfo)regions.get(0)));
                if (hrl.getServerName().equals((Object)primary)) {
                    util.getAdmin().move(hrl.getRegion().getEncodedNameAsBytes());
                    do {
                        Thread.sleep(10L);
                    } while (primary.equals((Object)(hrl = MetaTableAccessor.getRegionLocation((Connection)c, (RegionInfo)((RegionInfo)regions.get(0)))).getServerName()));
                    util.getAdmin().flush(TableName.META_TABLE_NAME);
                    Thread.sleep(conf.getInt("hbase.regionserver.storefile.refresh.period", 30000) * 3);
                }
                master = util.getHBaseClusterInterface().getClusterMetrics().getMasterName();
                LOG.info("Stopping master=" + master.toString());
                util.getHBaseClusterInterface().stopMaster(master);
                util.getHBaseClusterInterface().waitForMasterToStop(master, 60000L);
                LOG.info("Master " + master + " stopped!");
                if (!master.equals((Object)primary)) {
                    util.getHBaseClusterInterface().killRegionServer(primary);
                    util.getHBaseClusterInterface().waitForRegionServerToStop(primary, 60000L);
                }
                c.clearRegionLocationCache();
            }
            catch (Throwable regions) {
                throwable = regions;
                throw regions;
            }
            finally {
                if (htable != null) {
                    if (throwable != null) {
                        try {
                            htable.close();
                        }
                        catch (Throwable regions) {
                            throwable.addSuppressed(regions);
                        }
                    } else {
                        htable.close();
                    }
                }
            }
            LOG.info("Running GETs");
            htable = c.getTable(TABLE);
            throwable = null;
            try {
                Put put = new Put(row);
                put.addColumn("foo".getBytes(), row, row);
                BufferedMutator m = c.getBufferedMutator(TABLE);
                m.mutate((Mutation)put);
                m.flush();
                Result r = htable.get(new Get(row));
                Assert.assertTrue((boolean)Arrays.equals(r.getRow(), row));
                LOG.info("Starting Master");
                util.getHBaseClusterInterface().startMaster(master.getHostname(), 0);
                util.getHBaseClusterInterface().startRegionServer(primary.getHostname(), 0);
                util.getHBaseClusterInterface().waitForActiveAndReadyMaster();
                LOG.info("Master active!");
                c.clearRegionLocationCache();
            }
            catch (Throwable put) {
                throwable = put;
                throw put;
            }
            finally {
                if (htable != null) {
                    if (throwable != null) {
                        try {
                            htable.close();
                        }
                        catch (Throwable put) {
                            throwable.addSuppressed(put);
                        }
                    } else {
                        htable.close();
                    }
                }
            }
        }
        conf.setBoolean("hbase.meta.replicas.use", false);
        LOG.info("Running GETs no replicas");
        c = ConnectionFactory.createConnection((Configuration)conf);
        var12_12 = null;
        try {
            htable = c.getTable(TABLE);
            throwable = null;
            try {
                Result r = htable.get(new Get(row));
                Assert.assertTrue((boolean)Arrays.equals(r.getRow(), row));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (htable != null) {
                    if (throwable != null) {
                        try {
                            htable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        htable.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var12_12 = throwable4;
            throw throwable4;
        }
        finally {
            if (c != null) {
                if (var12_12 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable5) {
                        var12_12.addSuppressed(throwable5);
                    }
                } else {
                    c.close();
                }
            }
        }
    }

    @Test
    public void testAccessingUnknownTables() throws Exception {
        Configuration conf = new Configuration(this.TEST_UTIL.getConfiguration());
        conf.setBoolean("hbase.meta.replicas.use", true);
        Table table = this.TEST_UTIL.getConnection().getTable(TableName.valueOf((String)this.name.getMethodName()));
        Get get = new Get(Bytes.toBytes((String)"foo"));
        try {
            table.get(get);
        }
        catch (TableNotFoundException t) {
            return;
        }
        Assert.fail((String)"Expected TableNotFoundException");
    }

    @Test
    public void testMetaAddressChange() throws Exception {
        Configuration conf = this.TEST_UTIL.getConfiguration();
        ZKWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZNodePaths.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
        ServerName currentServer = ProtobufUtil.toServerName((byte[])data);
        Set liveServers = this.TEST_UTIL.getAdmin().getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet();
        ServerName moveToServer = null;
        for (ServerName s : liveServers) {
            if (currentServer.equals((Object)s)) continue;
            moveToServer = s;
        }
        Assert.assertNotNull(moveToServer);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.TEST_UTIL.createTable(tableName, "f");
        Assert.assertTrue((boolean)this.TEST_UTIL.getAdmin().tableExists(tableName));
        this.TEST_UTIL.getAdmin().move(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), moveToServer);
        int i = 0;
        Assert.assertNotEquals((Object)currentServer, (Object)moveToServer);
        LOG.info("CurrentServer=" + currentServer + ", moveToServer=" + moveToServer);
        int max = 10000;
        do {
            Thread.sleep(10L);
        } while (!moveToServer.equals((Object)(currentServer = ProtobufUtil.toServerName((byte[])(data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode))))) && ++i < 10000);
        Assert.assertNotEquals((long)10000L, (long)i);
        this.TEST_UTIL.getAdmin().disableTable(tableName);
        Assert.assertTrue((boolean)this.TEST_UTIL.getAdmin().isTableDisabled(tableName));
    }

    @Test
    public void testShutdownOfReplicaHolder() throws Exception {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.TEST_UTIL.getConfiguration());
             RegionLocator locator = conn.getRegionLocator(TableName.META_TABLE_NAME);){
            HRegionLocation hrl = (HRegionLocation)locator.getRegionLocations(HConstants.EMPTY_START_ROW, true).get(1);
            ServerName oldServer = hrl.getServerName();
            this.TEST_UTIL.getHBaseClusterInterface().killRegionServer(oldServer);
            int i = 0;
            do {
                LOG.debug("Waiting for the replica " + hrl.getRegion() + " to come up");
                Thread.sleep(10000L);
            } while (((hrl = (HRegionLocation)locator.getRegionLocations(HConstants.EMPTY_START_ROW, true).get(1)) == null || hrl.getServerName().equals((Object)oldServer)) && ++i < 3);
            Assert.assertNotEquals((long)3L, (long)i);
        }
    }
}

