/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.TestSnapshotTemporaryDirectory;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSnapshotDFSTemporaryDirectory
extends TestSnapshotTemporaryDirectory {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotDFSTemporaryDirectory.class);

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotDFSTemporaryDirectory.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
        admin = UTIL.getHBaseAdmin();
    }

    private static void setupConf(Configuration conf) throws IOException {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 10);
        conf.setInt("hbase.hstore.compactionThreshold", 10);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.set("hbase.snapshot.working.dir", UTIL.getDefaultRootDirPath().toString() + "/" + UUID.randomUUID().toString() + "/" + ".tmpdir" + "/");
    }
}

