/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterTestingCluster;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FilterTests.class, MediumTests.class})
public class TestFilterWithScanLimits
extends FilterTestingCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFilterWithScanLimits.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFilterWithScanLimits.class);
    private static final TableName tableName = TableName.valueOf((String)"scanWithLimit");
    private static final String columnFamily = "f1";

    @Test
    public void testScanWithLimit() {
        int kv_number = 0;
        try {
            Scan scan = new Scan();
            scan.setBatch(2);
            SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"c5"), CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("2_c5"));
            scan.setFilter((Filter)filter);
            Table table = TestFilterWithScanLimits.openTable(tableName);
            ResultScanner scanner = table.getScanner(scan);
            for (Result result : scanner) {
                for (Cell kv : result.listCells()) {
                    LOG.debug(++kv_number + ". kv: " + kv);
                }
            }
            scanner.close();
            table.close();
        }
        catch (Exception e) {
            Assert.assertNotNull((String)"No IncompatibleFilterException catched", (Object)e);
        }
        LOG.debug("check the fetched kv number");
        Assert.assertEquals((String)"We should not get result(s) returned.", (long)0L, (long)kv_number);
    }

    @BeforeClass
    public static void prepareData() {
        try {
            TestFilterWithScanLimits.createTable(tableName, columnFamily);
            Table table = TestFilterWithScanLimits.openTable(tableName);
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = 1; i < 4; ++i) {
                Put put = new Put(Bytes.toBytes((String)("row" + i)));
                for (int j = 1; j < 6; ++j) {
                    put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)("c" + j)), Bytes.toBytes((String)(i + "_c" + j)));
                }
                puts.add(put);
            }
            table.put(puts);
            table.close();
        }
        catch (IOException e) {
            Assert.assertNull((String)"Exception found while putting data into table", (Object)e);
        }
    }
}

