/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandlerImpl;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RPCTests.class, SmallTests.class})
public class TestCallRunner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCallRunner.class);

    @Test
    public void testSimpleCall() {
        RpcServerInterface mockRpcServer = (RpcServerInterface)Mockito.mock(RpcServerInterface.class);
        Mockito.when((Object)mockRpcServer.isStarted()).thenReturn((Object)true);
        ServerCall mockCall = (ServerCall)Mockito.mock(ServerCall.class);
        CallRunner cr = new CallRunner(mockRpcServer, (RpcCall)mockCall);
        cr.setStatus((MonitoredRPCHandler)new MonitoredRPCHandlerImpl());
        cr.run();
    }

    @Test
    public void testCallCleanup() {
        RpcServerInterface mockRpcServer = (RpcServerInterface)Mockito.mock(RpcServerInterface.class);
        Mockito.when((Object)mockRpcServer.isStarted()).thenReturn((Object)true);
        ServerCall mockCall = (ServerCall)Mockito.mock(ServerCall.class);
        Mockito.when((Object)mockCall.disconnectSince()).thenReturn((Object)1L);
        CallRunner cr = new CallRunner(mockRpcServer, (RpcCall)mockCall);
        cr.setStatus((MonitoredRPCHandler)new MonitoredRPCHandlerImpl());
        cr.run();
        ((ServerCall)Mockito.verify((Object)mockCall, (VerificationMode)Mockito.times((int)1))).cleanup();
    }

    @Test
    public void testCallRunnerDrop() {
        RpcServerInterface mockRpcServer = (RpcServerInterface)Mockito.mock(RpcServerInterface.class);
        Mockito.when((Object)mockRpcServer.isStarted()).thenReturn((Object)true);
        ServerCall mockCall = (ServerCall)Mockito.mock(ServerCall.class);
        Mockito.when((Object)mockCall.disconnectSince()).thenReturn((Object)1L);
        CallRunner cr = new CallRunner(mockRpcServer, (RpcCall)mockCall);
        cr.setStatus((MonitoredRPCHandler)new MonitoredRPCHandlerImpl());
        cr.drop();
        ((ServerCall)Mockito.verify((Object)mockCall, (VerificationMode)Mockito.times((int)1))).cleanup();
    }
}

