/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetaFixer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMetaFixer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaFixer.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private void deleteRegion(MasterServices services, RegionInfo ri) throws IOException {
        MetaTableAccessor.deleteRegionInfo((Connection)TEST_UTIL.getConnection(), (RegionInfo)ri);
        services.getAssignmentManager().getRegionStates().deleteRegion(ri);
    }

    @Test
    public void testPlugsHoles() throws IOException {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createMultiRegionTable(tn, HConstants.CATALOG_FAMILY);
        List ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        services.getCatalogJanitor().scan();
        CatalogJanitor.Report report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        int originalCount = ris.size();
        this.deleteRegion((MasterServices)services, (RegionInfo)ris.get(ris.size() - 1));
        this.deleteRegion((MasterServices)services, (RegionInfo)ris.get(3));
        this.deleteRegion((MasterServices)services, (RegionInfo)ris.get(0));
        services.getCatalogJanitor().scan();
        report = services.getCatalogJanitor().getLastReport();
        Assert.assertEquals((String)report.toString(), (long)3L, (long)report.getHoles().size());
        MetaFixer fixer = new MetaFixer((MasterServices)services);
        fixer.fixHoles(report);
        services.getCatalogJanitor().scan();
        report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((String)report.toString(), (boolean)report.isEmpty());
        TEST_UTIL.getAdmin().disableTable(tn);
        TEST_UTIL.getAdmin().enableTable(tn);
        ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        Assert.assertEquals((long)originalCount, (long)ris.size());
    }

    @Test
    public void testOneRegionTable() throws IOException {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tn, HConstants.CATALOG_FAMILY);
        List ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        services.getCatalogJanitor().scan();
        this.deleteRegion((MasterServices)services, (RegionInfo)ris.get(0));
        services.getCatalogJanitor().scan();
        CatalogJanitor.Report report = services.getCatalogJanitor().getLastReport();
        ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        Assert.assertTrue((boolean)ris.isEmpty());
        MetaFixer fixer = new MetaFixer((MasterServices)services);
        fixer.fixHoles(report);
        report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        Assert.assertEquals((long)0L, (long)ris.size());
    }

    private static void makeOverlap(MasterServices services, RegionInfo a, RegionInfo b) throws IOException {
        RegionInfo overlapRegion = RegionInfoBuilder.newBuilder((TableName)a.getTable()).setStartKey(a.getStartKey()).setEndKey(b.getEndKey()).build();
        MetaTableAccessor.putsToMetaTable((Connection)services.getConnection(), Collections.singletonList(MetaTableAccessor.makePutFromRegionInfo((RegionInfo)overlapRegion, (long)System.currentTimeMillis())));
        services.getAssignmentManager().assign(overlapRegion);
    }

    @Test
    public void testOverlap() throws IOException {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createMultiRegionTable(tn, HConstants.CATALOG_FAMILY);
        List ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        Assert.assertTrue((ris.size() > 5 ? 1 : 0) != 0);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        services.getCatalogJanitor().scan();
        CatalogJanitor.Report report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        TestMetaFixer.makeOverlap((MasterServices)services, (RegionInfo)ris.get(1), (RegionInfo)ris.get(3));
        TestMetaFixer.makeOverlap((MasterServices)services, (RegionInfo)ris.get(2), (RegionInfo)ris.get(3));
        TestMetaFixer.makeOverlap((MasterServices)services, (RegionInfo)ris.get(2), (RegionInfo)ris.get(4));
        Threads.sleep((long)10000L);
        services.getCatalogJanitor().scan();
        report = services.getCatalogJanitor().getLastReport();
        Assert.assertEquals((long)6L, (long)report.getOverlaps().size());
        Assert.assertEquals((long)1L, (long)MetaFixer.calculateMerges((int)10, (List)report.getOverlaps()).size());
        MetaFixer fixer = new MetaFixer((MasterServices)services);
        fixer.fixOverlaps(report);
        while (true) {
            services.getCatalogJanitor().scan();
            report = services.getCatalogJanitor().getLastReport();
            if (report.isEmpty()) break;
            Threads.sleep((long)10L);
        }
        Assert.assertTrue((String)report.toString(), (boolean)report.isEmpty());
    }
}

