/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, MasterTests.class})
public class TestRegionMoveAndAbandon {
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionMoveAndAbandon.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionMoveAndAbandon.class);
    @Rule
    public TestName name = new TestName();
    private HBaseTestingUtility UTIL;
    private MiniHBaseCluster cluster;
    private MiniZooKeeperCluster zkCluster;
    private HRegionServer rs1;
    private HRegionServer rs2;
    private RegionInfo regionInfo;

    @Before
    public void setup() throws Exception {
        this.UTIL = new HBaseTestingUtility();
        this.zkCluster = this.UTIL.startMiniZKCluster();
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(2).build();
        this.cluster = this.UTIL.startMiniHBaseCluster(option);
        this.rs1 = this.cluster.getRegionServer(0);
        this.rs2 = this.cluster.getRegionServer(1);
        Assert.assertEquals((long)2L, (long)this.cluster.getRegionServerThreads().size());
        this.UTIL.waitTableAvailable(TableName.NAMESPACE_TABLE_NAME, 30000L);
        this.regionInfo = ((HRegion)Iterables.getOnlyElement(this.cluster.getRegions(TableName.NAMESPACE_TABLE_NAME))).getRegionInfo();
    }

    @After
    public void teardown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        if (this.zkCluster != null) {
            this.zkCluster.shutdown();
            this.zkCluster = null;
        }
    }

    @Test
    public void test() throws Exception {
        LOG.info("Moving {} to {}", (Object)this.regionInfo, (Object)this.rs2.getServerName());
        this.UTIL.moveRegionAndWait(this.regionInfo, this.rs2.getServerName());
        LOG.info("Moving {} to {}", (Object)this.regionInfo, (Object)this.rs1.getServerName());
        this.UTIL.moveRegionAndWait(this.regionInfo, this.rs1.getServerName());
        LOG.info("Killing RS {}", (Object)this.rs1.getServerName());
        this.cluster.killRegionServer(this.rs1.getServerName());
        this.UTIL.waitTableAvailable(TableName.NAMESPACE_TABLE_NAME, 30000L);
        LOG.info("Killing master {}", (Object)this.cluster.getMaster().getServerName());
        this.cluster.killMaster(this.cluster.getMaster().getServerName());
        LOG.info("Killing RS {}", (Object)this.rs2.getServerName());
        this.cluster.killRegionServer(this.rs2.getServerName());
        LOG.info("Starting cluster");
        this.UTIL.getMiniHBaseCluster().startMaster();
        this.UTIL.ensureSomeRegionServersAvailable(2);
        this.UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                try (Table nsTable = TestRegionMoveAndAbandon.this.UTIL.getConnection().getTable(TableName.NAMESPACE_TABLE_NAME);){
                    nsTable.get(new Get(Bytes.toBytes((String)"a")));
                    boolean bl = true;
                    return bl;
                }
            }
        });
    }
}

