/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.master.snapshot.DisabledTableSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischarger;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotFromMaster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotFromMaster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotFromMaster.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_RS = 2;
    private static Path rootDir;
    private static FileSystem fs;
    private static HMaster master;
    private static Path archiveDir;
    private static final byte[] TEST_FAM;
    private static final TableName TABLE_NAME;
    private static final long cacheRefreshPeriod = 500L;
    private static final int blockingStoreFiles = 12;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotFromMaster.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
        fs = UTIL.getDFSCluster().getFileSystem();
        master = UTIL.getMiniHBaseCluster().getMaster();
        rootDir = master.getMasterFileSystem().getRootDir();
        archiveDir = new Path(rootDir, "archive");
    }

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 2);
        conf.setInt("hbase.hstore.compactionThreshold", 5);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.set("hbase.master.hfilecleaner.plugins", "");
        conf.set("hbase.master.logcleaner.plugins", "");
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setLong("hbase.snapshot.sentinels.cleanup.timeoutMillis", 3000L);
        conf.setLong("hbase.master.hfilecleaner.plugins.snapshot.period", 500L);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.setInt("hbase.hfile.compactions.cleaner.interval", 20000);
    }

    @Before
    public void setup() throws Exception {
        UTIL.createTable(TABLE_NAME, TEST_FAM);
        master.getSnapshotManager().setSnapshotHandlerForTesting(TABLE_NAME, null);
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTable(TABLE_NAME);
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIsDoneContract() throws Exception {
        MasterProtos.IsSnapshotDoneRequest.Builder builder = MasterProtos.IsSnapshotDoneRequest.newBuilder();
        String snapshotName = "asyncExpectedFailureTest";
        SnapshotTestingUtils.expectSnapshotDoneException(master, builder.build(), UnknownSnapshotException.class);
        SnapshotProtos.SnapshotDescription desc = SnapshotProtos.SnapshotDescription.newBuilder().setName(snapshotName).setTable(TABLE_NAME.getNameAsString()).build();
        builder.setSnapshot(desc);
        SnapshotTestingUtils.expectSnapshotDoneException(master, builder.build(), UnknownSnapshotException.class);
        DisabledTableSnapshotHandler mockHandler = (DisabledTableSnapshotHandler)Mockito.mock(DisabledTableSnapshotHandler.class);
        Mockito.when((Object)((Object)mockHandler.getException())).thenReturn(null);
        Mockito.when((Object)mockHandler.getSnapshot()).thenReturn((Object)desc);
        Mockito.when((Object)mockHandler.isFinished()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockHandler.getCompletionTimestamp()).thenReturn((Object)EnvironmentEdgeManager.currentTime());
        master.getSnapshotManager().setSnapshotHandlerForTesting(TABLE_NAME, (SnapshotSentinel)mockHandler);
        builder = MasterProtos.IsSnapshotDoneRequest.newBuilder();
        SnapshotTestingUtils.expectSnapshotDoneException(master, builder.build(), UnknownSnapshotException.class);
        builder.setSnapshot(desc);
        MasterProtos.IsSnapshotDoneResponse response = master.getMasterRpcServices().isSnapshotDone(null, builder.build());
        Assert.assertTrue((String)"Snapshot didn't complete when it should have.", (boolean)response.getDone());
        builder.setSnapshot(SnapshotProtos.SnapshotDescription.newBuilder().setName("Not A Snapshot").build());
        SnapshotTestingUtils.expectSnapshotDoneException(master, builder.build(), UnknownSnapshotException.class);
        snapshotName = "completed";
        desc = this.createSnapshot(snapshotName);
        builder.setSnapshot(desc);
        response = master.getMasterRpcServices().isSnapshotDone(null, builder.build());
        Assert.assertTrue((String)"Completed, on-disk snapshot not found", (boolean)response.getDone());
    }

    @Test
    public void testGetCompletedSnapshots() throws Exception {
        MasterProtos.GetCompletedSnapshotsRequest request = MasterProtos.GetCompletedSnapshotsRequest.newBuilder().build();
        MasterProtos.GetCompletedSnapshotsResponse response = master.getMasterRpcServices().getCompletedSnapshots(null, request);
        Assert.assertEquals((String)"Found unexpected number of snapshots", (long)0L, (long)response.getSnapshotsCount());
        String snapshotName = "completed";
        SnapshotProtos.SnapshotDescription snapshot = this.createSnapshot(snapshotName);
        response = master.getMasterRpcServices().getCompletedSnapshots(null, request);
        Assert.assertEquals((String)"Found unexpected number of snapshots", (long)1L, (long)response.getSnapshotsCount());
        List snapshots = response.getSnapshotsList();
        ArrayList expected = Lists.newArrayList((Object[])new SnapshotProtos.SnapshotDescription[]{snapshot});
        Assert.assertEquals((String)"Returned snapshots don't match created snapshots", (Object)expected, (Object)snapshots);
        snapshotName = "completed_two";
        snapshot = this.createSnapshot(snapshotName);
        expected.add(snapshot);
        response = master.getMasterRpcServices().getCompletedSnapshots(null, request);
        Assert.assertEquals((String)"Found unexpected number of snapshots", (long)2L, (long)response.getSnapshotsCount());
        snapshots = response.getSnapshotsList();
        Assert.assertEquals((String)"Returned snapshots don't match created snapshots", (Object)expected, (Object)snapshots);
    }

    @Test
    public void testDeleteSnapshot() throws Exception {
        String snapshotName = "completed";
        SnapshotProtos.SnapshotDescription snapshot = SnapshotProtos.SnapshotDescription.newBuilder().setName(snapshotName).build();
        MasterProtos.DeleteSnapshotRequest request = MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        try {
            master.getMasterRpcServices().deleteSnapshot(null, request);
            Assert.fail((String)"Master didn't throw exception when attempting to delete snapshot that doesn't exist");
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.createSnapshot(snapshotName);
        master.getMasterRpcServices().deleteSnapshot(null, request);
    }

    @Test
    public void testSnapshotHFileArchiving() throws Exception {
        Admin admin = UTIL.getAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        UTIL.deleteTable(TABLE_NAME);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])TEST_FAM)).setCompactionEnabled(false).build();
        UTIL.getAdmin().createTable(td);
        for (int i = 0; i < 6; ++i) {
            UTIL.loadTable(UTIL.getConnection().getTable(TABLE_NAME), TEST_FAM);
            UTIL.flush(TABLE_NAME);
        }
        admin.disableTable(TABLE_NAME);
        String snapshotName = "snapshot";
        byte[] snapshotNameBytes = Bytes.toBytes((String)snapshotName);
        admin.snapshot(snapshotNameBytes, TABLE_NAME);
        LOG.info("After snapshot File-System state");
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
        SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshotNameBytes, TABLE_NAME);
        td = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setCompactionEnabled(true).build();
        admin.modifyTable(td);
        admin.enableTable(TABLE_NAME);
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(TABLE_NAME);
        for (HRegion region : regions) {
            region.waitForFlushesAndCompactions();
            region.compactStores();
        }
        List<JVMClusterUtil.RegionServerThread> regionServerThreads = UTIL.getMiniHBaseCluster().getRegionServerThreads();
        HRegionServer hrs = null;
        for (JVMClusterUtil.RegionServerThread rs : regionServerThreads) {
            if (rs.getRegionServer().getRegions(TABLE_NAME).isEmpty()) continue;
            hrs = rs.getRegionServer();
            break;
        }
        CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(100, null, hrs, false);
        cleaner.chore();
        LOG.info("After compaction File-System state");
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
        LOG.debug("Running hfile cleaners");
        TestSnapshotFromMaster.ensureHFileCleanersRun();
        LOG.info("After cleaners File-System state: " + rootDir);
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
        Path snapshotTable = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
        Set snapshotHFiles = SnapshotReferenceUtil.getHFileNames((Configuration)UTIL.getConfiguration(), (FileSystem)fs, (Path)snapshotTable);
        LOG.debug("Have snapshot hfiles:");
        for (String fileName : snapshotHFiles) {
            LOG.debug(fileName);
        }
        Collection<String> archives = this.getHFiles(archiveDir, fs, TABLE_NAME);
        Collection<String> hfiles = this.getHFiles(rootDir, fs, TABLE_NAME);
        for (String fileName : snapshotHFiles) {
            boolean exist = archives.contains(fileName) || hfiles.contains(fileName);
            Assert.assertTrue((String)("Archived hfiles " + archives + " and table hfiles " + hfiles + " is missing snapshot file:" + fileName), (boolean)exist);
        }
        admin.deleteSnapshot(snapshotNameBytes);
        SnapshotTestingUtils.assertNoSnapshots(admin);
        List delegates = TestSnapshotFromMaster.UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().cleanersChain;
        for (BaseHFileCleanerDelegate delegate : delegates) {
            if (!(delegate instanceof SnapshotHFileCleaner)) continue;
            ((SnapshotHFileCleaner)delegate).getFileCacheForTesting().triggerCacheRefreshForTesting();
        }
        LOG.debug("Running hfile cleaners");
        TestSnapshotFromMaster.ensureHFileCleanersRun();
        LOG.info("After delete snapshot cleaners run File-System state");
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
        archives = this.getHFiles(archiveDir, fs, TABLE_NAME);
        Assert.assertEquals((String)"Still have some hfiles in the archive, when their snapshot has been deleted.", (long)0L, (long)archives.size());
    }

    private final Collection<String> getHFiles(Path dir, FileSystem fs, TableName tableName) throws IOException {
        Path tableDir = FSUtils.getTableDir((Path)dir, (TableName)tableName);
        return SnapshotTestingUtils.listHFileNames(fs, tableDir);
    }

    private static void ensureHFileCleanersRun() {
        UTIL.getHBaseCluster().getMaster().getHFileCleaner().chore();
    }

    private SnapshotProtos.SnapshotDescription createSnapshot(String snapshotName) throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(snapshotName, "test", 0);
        builder.commit();
        return builder.getSnapshotDescription();
    }

    @Test
    public void testAsyncSnapshotWillNotBlockSnapshotHFileCleaner() throws Exception {
        Table table = UTIL.getConnection().getTable(TABLE_NAME);
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes((int)i)).addColumn(TEST_FAM, Bytes.toBytes((String)"q"), Bytes.toBytes((int)i));
            table.put(put);
        }
        String snapshotName = "testAsyncSnapshotWillNotBlockSnapshotHFileCleaner01";
        UTIL.getAdmin().snapshotAsync(new SnapshotDescription(snapshotName, TABLE_NAME, SnapshotType.FLUSH));
        Waiter.waitFor((Configuration)UTIL.getConfiguration(), (long)10000L, (long)200L, () -> UTIL.getAdmin().listSnapshots(Pattern.compile(snapshotName)).size() == 1);
        Assert.assertTrue((boolean)master.getSnapshotManager().isTakingAnySnapshot());
        Thread.sleep(11000L);
        Assert.assertFalse((boolean)master.getSnapshotManager().isTakingAnySnapshot());
    }

    static {
        TEST_FAM = Bytes.toBytes((String)"fam");
        TABLE_NAME = TableName.valueOf((String)"test");
    }
}

