/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
@Ignore
public class TestMasterProcedureWalLease {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterProcedureWalLease.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterProcedureWalLease.class);
    @Rule
    public TestName name = new TestName();
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.procedure.store.wal.max.retries.before.roll", 1);
        conf.setInt("hbase.procedure.store.wal.wait.before.roll", 0);
        conf.setInt("hbase.procedure.store.wal.max.roll.retries", 1);
        conf.setInt("hbase.procedure.store.wal.sync.failure.roll.max", 1);
    }

    @Before
    public void setup() throws Exception {
        TestMasterProcedureWalLease.setupConf(UTIL.getConfiguration());
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(2).numRegionServers(3).numDataNodes(3).build();
        UTIL.startMiniCluster(option);
    }

    @After
    public void tearDown() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void testWalRecoverLease() throws Exception {
        ProcedureStore masterStore = this.getMasterProcedureExecutor().getStore();
        Assert.assertTrue((String)"expected WALStore for this test", (boolean)(masterStore instanceof WALProcedureStore));
        HMaster firstMaster = UTIL.getHBaseCluster().getMaster();
        final CountDownLatch masterStoreAbort = new CountDownLatch(1);
        masterStore.registerListener(new ProcedureStore.ProcedureStoreListener(){

            public void postSync() {
            }

            public void abortProcess() {
                LOG.debug("Abort store of Master");
                masterStoreAbort.countDown();
            }
        });
        HMaster backupMaster3 = (HMaster)Mockito.mock(HMaster.class);
        ((HMaster)Mockito.doReturn((Object)firstMaster.getConfiguration()).when((Object)backupMaster3)).getConfiguration();
        ((HMaster)Mockito.doReturn((Object)true).when((Object)backupMaster3)).isActiveMaster();
        final WALProcedureStore backupStore3 = new WALProcedureStore(firstMaster.getConfiguration(), ((WALProcedureStore)masterStore).getWALDir(), null, (WALProcedureStore.LeaseRecovery)new MasterProcedureEnv.WALStoreLeaseRecovery((MasterServices)backupMaster3));
        final CountDownLatch backupStore3Abort = new CountDownLatch(1);
        backupStore3.registerListener(new ProcedureStore.ProcedureStoreListener(){

            public void postSync() {
            }

            public void abortProcess() {
                LOG.debug("Abort store of backupMaster3");
                backupStore3Abort.countDown();
                backupStore3.stop(true);
            }
        });
        backupStore3.start(1);
        backupStore3.recoverLease();
        TableDescriptor htd = MasterProcedureTestingUtility.createHTD(TableName.valueOf((String)this.name.getMethodName()), "f");
        RegionInfo[] regions = ModifyRegionUtils.createRegionInfos((TableDescriptor)htd, (byte[][])null);
        LOG.debug("submit proc");
        try {
            this.getMasterProcedureExecutor().submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)this.getMasterProcedureExecutor().getEnvironment(), htd, regions));
            Assert.fail((String)"expected RuntimeException 'sync aborted'");
        }
        catch (RuntimeException e) {
            LOG.info("got " + e.getMessage());
        }
        LOG.debug("wait master store abort");
        masterStoreAbort.await();
        LOG.debug("wait backup master to startup");
        MasterProcedureTestingUtility.waitBackupMaster(UTIL, firstMaster);
        Assert.assertEquals((Object)true, (Object)firstMaster.isStopped());
        LOG.debug("wait the store to abort");
        backupStore3.getStoreTracker().setDeleted(1L, false);
        try {
            backupStore3.delete(1L);
            Assert.fail((String)"expected RuntimeException 'sync aborted'");
        }
        catch (RuntimeException e) {
            LOG.info("got " + e.getMessage());
        }
        backupStore3Abort.await();
    }

    @Test
    public void testWALfencingWithoutWALRolling() throws IOException {
        this.testWALfencing(false);
    }

    @Test
    public void testWALfencingWithWALRolling() throws IOException {
        this.testWALfencing(true);
    }

    public void testWALfencing(boolean walRolls) throws IOException {
        ProcedureStore procStore = this.getMasterProcedureExecutor().getStore();
        Assert.assertTrue((String)"expected WALStore for this test", (boolean)(procStore instanceof WALProcedureStore));
        HMaster firstMaster = UTIL.getHBaseCluster().getMaster();
        firstMaster.getConfiguration().setLong("hbase.procedure.store.wal.roll.threshold", 1L);
        HMaster backupMaster3 = (HMaster)Mockito.mock(HMaster.class);
        ((HMaster)Mockito.doReturn((Object)firstMaster.getConfiguration()).when((Object)backupMaster3)).getConfiguration();
        ((HMaster)Mockito.doReturn((Object)true).when((Object)backupMaster3)).isActiveMaster();
        WALProcedureStore procStore2 = new WALProcedureStore(firstMaster.getConfiguration(), ((WALProcedureStore)procStore).getWALDir(), null, (WALProcedureStore.LeaseRecovery)new MasterProcedureEnv.WALStoreLeaseRecovery((MasterServices)backupMaster3));
        LOG.info("Starting new WALProcedureStore");
        procStore2.start(1);
        procStore2.recoverLease();
        if (walRolls) {
            LOG.info("Inserting into second WALProcedureStore, causing WAL rolls");
            for (int i = 0; i < 512; ++i) {
                ProcedureTestingUtility.TestProcedure proc2 = new ProcedureTestingUtility.TestProcedure((long)i);
                procStore2.insert((Procedure)proc2, null);
                procStore2.delete(proc2.getProcId());
            }
        }
        LOG.info("Inserting into first WALProcedureStore");
        try {
            procStore.insert((Procedure)new ProcedureTestingUtility.TestProcedure(11L), null);
            Assert.fail((String)"Inserting into Procedure Store should have failed");
        }
        catch (Exception ex) {
            LOG.info("Received expected exception", (Throwable)ex);
        }
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }
}

