/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.quotas.FileSystemUtilizationChore;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestFileSystemUtilizationChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFileSystemUtilizationChore.class);

    @Test
    public void testNoOnlineRegions() {
        List<Long> regionSizes = Collections.emptyList();
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        FileSystemUtilizationChore chore = new FileSystemUtilizationChore(rs);
        ((HRegionServer)Mockito.doAnswer((Answer)new ExpectedRegionSizeSummationAnswer(this.sum(regionSizes))).when((Object)rs)).reportRegionSizesForQuotas((Map)Matchers.any());
        Region region = this.mockRegionWithSize(regionSizes);
        ((HRegionServer)Mockito.doReturn(Arrays.asList(region)).when((Object)rs)).getRegions();
        chore.chore();
    }

    @Test
    public void testRegionSizes() {
        List<Long> regionSizes = Arrays.asList(1024L);
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        FileSystemUtilizationChore chore = new FileSystemUtilizationChore(rs);
        ((HRegionServer)Mockito.doAnswer((Answer)new ExpectedRegionSizeSummationAnswer(this.sum(regionSizes))).when((Object)rs)).reportRegionSizesForQuotas((Map)Matchers.any());
        Region region = this.mockRegionWithSize(regionSizes);
        ((HRegionServer)Mockito.doReturn(Arrays.asList(region)).when((Object)rs)).getRegions();
        chore.chore();
    }

    @Test
    public void testMultipleRegionSizes() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        List<Long> r1Sizes = Arrays.asList(1024L, 2048L);
        long r1Sum = this.sum(r1Sizes);
        List<Long> r2Sizes = Arrays.asList(0x100000L);
        long r2Sum = this.sum(r2Sizes);
        List<Long> r3Sizes = Arrays.asList(0xA00000L);
        long r3Sum = this.sum(r3Sizes);
        FileSystemUtilizationChore chore = new FileSystemUtilizationChore(rs);
        ((HRegionServer)Mockito.doAnswer((Answer)new ExpectedRegionSizeSummationAnswer(this.sum(Arrays.asList(r1Sum, r2Sum, r3Sum)))).when((Object)rs)).reportRegionSizesForQuotas((Map)Matchers.any());
        Region r1 = this.mockRegionWithSize(r1Sizes);
        Region r2 = this.mockRegionWithSize(r2Sizes);
        Region r3 = this.mockRegionWithSize(r3Sizes);
        ((HRegionServer)Mockito.doReturn(Arrays.asList(r1, r2, r3)).when((Object)rs)).getRegions();
        chore.chore();
    }

    @Test
    public void testDefaultConfigurationProperties() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        FileSystemUtilizationChore chore = new FileSystemUtilizationChore(rs);
        Assert.assertEquals((long)300000L, (long)chore.getPeriod());
        Assert.assertEquals((long)60000L, (long)chore.getInitialDelay());
        Assert.assertEquals((Object)((Object)TimeUnit.valueOf(FileSystemUtilizationChore.FS_UTILIZATION_CHORE_TIMEUNIT_DEFAULT)), (Object)((Object)chore.getTimeUnit()));
    }

    @Test
    public void testNonDefaultConfigurationProperties() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        int period = 600;
        long delay = 30L;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        conf.setInt("hbase.regionserver.quotas.fs.utilization.chore.period", 600);
        conf.setLong("hbase.regionserver.quotas.fs.utilization.chore.delay", 30L);
        conf.set("hbase.regionserver.quotas.fs.utilization.chore.timeunit", timeUnit.name());
        HRegionServer rs = this.mockRegionServer(conf);
        FileSystemUtilizationChore chore = new FileSystemUtilizationChore(rs);
        Assert.assertEquals((long)600L, (long)chore.getPeriod());
        Assert.assertEquals((long)30L, (long)chore.getInitialDelay());
        Assert.assertEquals((Object)((Object)timeUnit), (Object)((Object)chore.getTimeUnit()));
    }

    @Test
    public void testProcessingLeftoverRegions() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        List<Long> leftover1Sizes = Arrays.asList(1024L, 4096L);
        long leftover1Sum = this.sum(leftover1Sizes);
        List<Long> leftover2Sizes = Arrays.asList(2048L);
        long leftover2Sum = this.sum(leftover2Sizes);
        final Region lr1 = this.mockRegionWithSize(leftover1Sizes);
        final Region lr2 = this.mockRegionWithSize(leftover2Sizes);
        FileSystemUtilizationChore chore = new FileSystemUtilizationChore(rs){

            Iterator<Region> getLeftoverRegions() {
                return Arrays.asList(lr1, lr2).iterator();
            }
        };
        ((HRegionServer)Mockito.doAnswer((Answer)new ExpectedRegionSizeSummationAnswer(this.sum(Arrays.asList(leftover1Sum, leftover2Sum)))).when((Object)rs)).reportRegionSizesForQuotas((Map)Matchers.any());
        Region r1 = this.mockRegionWithSize(Arrays.asList(1024L, 2048L));
        Region r2 = this.mockRegionWithSize(Arrays.asList(0x100000L));
        Region r3 = this.mockRegionWithSize(Arrays.asList(0xA00000L));
        ((HRegionServer)Mockito.doReturn(Arrays.asList(r1, r2, r3, lr1, lr2)).when((Object)rs)).getRegions();
        chore.chore();
    }

    @Test
    public void testProcessingNowOfflineLeftoversAreIgnored() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        List<Long> leftover1Sizes = Arrays.asList(1024L, 4096L);
        long leftover1Sum = this.sum(leftover1Sizes);
        List<Long> leftover2Sizes = Arrays.asList(2048L);
        final Region lr1 = this.mockRegionWithSize(leftover1Sizes);
        final Region lr2 = this.mockRegionWithSize(leftover2Sizes);
        FileSystemUtilizationChore chore = new FileSystemUtilizationChore(rs){

            Iterator<Region> getLeftoverRegions() {
                return Arrays.asList(lr1, lr2).iterator();
            }
        };
        ((HRegionServer)Mockito.doAnswer((Answer)new ExpectedRegionSizeSummationAnswer(this.sum(Arrays.asList(leftover1Sum)))).when((Object)rs)).reportRegionSizesForQuotas((Map)Matchers.any());
        Region r1 = this.mockRegionWithSize(Arrays.asList(1024L, 2048L));
        Region r2 = this.mockRegionWithSize(Arrays.asList(0x100000L));
        Region r3 = this.mockRegionWithSize(Arrays.asList(0xA00000L));
        ((HRegionServer)Mockito.doReturn(Arrays.asList(r1, r2, r3, lr1)).when((Object)rs)).getRegions();
        chore.chore();
    }

    @Test
    public void testIgnoreSplitParents() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        List<Long> r1Sizes = Arrays.asList(1024L, 2048L);
        long r1Sum = this.sum(r1Sizes);
        List<Long> r2Sizes = Arrays.asList(0x100000L);
        FileSystemUtilizationChore chore = new FileSystemUtilizationChore(rs);
        ((HRegionServer)Mockito.doAnswer((Answer)new ExpectedRegionSizeSummationAnswer(this.sum(Arrays.asList(r1Sum)))).when((Object)rs)).reportRegionSizesForQuotas((Map)Matchers.any());
        Region r1 = this.mockRegionWithSize(r1Sizes);
        Region r2 = this.mockSplitParentRegionWithSize(r2Sizes);
        ((HRegionServer)Mockito.doReturn(Arrays.asList(r1, r2)).when((Object)rs)).getRegions();
        chore.chore();
    }

    @Test
    public void testIgnoreRegionReplicas() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        List<Long> r1Sizes = Arrays.asList(1024L, 2048L);
        long r1Sum = this.sum(r1Sizes);
        List<Long> r2Sizes = Arrays.asList(0x100000L);
        FileSystemUtilizationChore chore = new FileSystemUtilizationChore(rs);
        ((HRegionServer)Mockito.doAnswer((Answer)new ExpectedRegionSizeSummationAnswer(r1Sum)).when((Object)rs)).reportRegionSizesForQuotas((Map)Matchers.any());
        Region r1 = this.mockRegionWithSize(r1Sizes);
        Region r2 = this.mockRegionReplicaWithSize(r2Sizes);
        ((HRegionServer)Mockito.doReturn(Arrays.asList(r1, r2)).when((Object)rs)).getRegions();
        chore.chore();
    }

    @Test
    public void testNonHFilesAreIgnored() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        List<Long> r1StoreFileSizes = Arrays.asList(1024L, 2048L);
        List<Long> r1HFileSizes = Arrays.asList(0L, 2048L);
        long r1HFileSizeSum = this.sum(r1HFileSizes);
        List<Long> r2StoreFileSizes = Arrays.asList(0x100000L);
        List<Long> r2HFileSizes = Arrays.asList(0L);
        long r2HFileSizeSum = this.sum(r2HFileSizes);
        FileSystemUtilizationChore chore = new FileSystemUtilizationChore(rs);
        ((HRegionServer)Mockito.doAnswer((Answer)new ExpectedRegionSizeSummationAnswer(this.sum(Arrays.asList(r1HFileSizeSum, r2HFileSizeSum)))).when((Object)rs)).reportRegionSizesForQuotas((Map)Matchers.any());
        Region r1 = this.mockRegionWithHFileLinks(r1StoreFileSizes, r1HFileSizes);
        Region r2 = this.mockRegionWithHFileLinks(r2StoreFileSizes, r2HFileSizes);
        ((HRegionServer)Mockito.doReturn(Arrays.asList(r1, r2)).when((Object)rs)).getRegions();
        chore.chore();
    }

    private Configuration getDefaultHBaseConfiguration() {
        Configuration conf = HBaseConfiguration.create();
        conf.addResource("hbase-default.xml");
        return conf;
    }

    private HRegionServer mockRegionServer(Configuration conf) {
        HRegionServer rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)rs.getConfiguration()).thenReturn((Object)conf);
        return rs;
    }

    private long sum(Collection<Long> values) {
        long sum = 0L;
        for (Long value : values) {
            Assert.assertNotNull((Object)value);
            sum += value.longValue();
        }
        return sum;
    }

    private Region mockRegionWithSize(Collection<Long> storeSizes) {
        Region r = (Region)Mockito.mock(Region.class);
        RegionInfo info = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)r.getRegionInfo()).thenReturn((Object)info);
        ArrayList<Store> stores = new ArrayList<Store>();
        Mockito.when((Object)r.getStores()).thenReturn(stores);
        for (Long storeSize : storeSizes) {
            Store s = (Store)Mockito.mock(Store.class);
            stores.add(s);
            Mockito.when((Object)s.getHFilesSize()).thenReturn((Object)storeSize);
        }
        return r;
    }

    private Region mockRegionWithHFileLinks(Collection<Long> storeSizes, Collection<Long> hfileSizes) {
        Region r = (Region)Mockito.mock(Region.class);
        RegionInfo info = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)r.getRegionInfo()).thenReturn((Object)info);
        ArrayList<Store> stores = new ArrayList<Store>();
        Mockito.when((Object)r.getStores()).thenReturn(stores);
        Assert.assertEquals((String)"Logic error, storeSizes and linkSizes must be equal in size", (long)storeSizes.size(), (long)hfileSizes.size());
        Iterator<Long> storeSizeIter = storeSizes.iterator();
        Iterator<Long> hfileSizeIter = hfileSizes.iterator();
        while (storeSizeIter.hasNext() && hfileSizeIter.hasNext()) {
            long storeSize = storeSizeIter.next();
            long hfileSize = hfileSizeIter.next();
            Store s = (Store)Mockito.mock(Store.class);
            stores.add(s);
            Mockito.when((Object)s.getStorefilesSize()).thenReturn((Object)storeSize);
            Mockito.when((Object)s.getHFilesSize()).thenReturn((Object)hfileSize);
        }
        return r;
    }

    private Region mockSplitParentRegionWithSize(Collection<Long> storeSizes) {
        Region r = this.mockRegionWithSize(storeSizes);
        RegionInfo info = r.getRegionInfo();
        Mockito.when((Object)info.isSplitParent()).thenReturn((Object)true);
        return r;
    }

    private Region mockRegionReplicaWithSize(Collection<Long> storeSizes) {
        Region r = this.mockRegionWithSize(storeSizes);
        RegionInfo info = r.getRegionInfo();
        Mockito.when((Object)info.getReplicaId()).thenReturn((Object)1);
        return r;
    }

    private static class ExpectedRegionSizeSummationAnswer
    implements Answer<Void> {
        private final long expectedSize;

        public ExpectedRegionSizeSummationAnswer(long expectedSize) {
            this.expectedSize = expectedSize;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            Object[] args = invocation.getArguments();
            Assert.assertEquals((long)1L, (long)args.length);
            Map regionSizes = (Map)args[0];
            long sum = 0L;
            for (Long regionSize : regionSizes.values()) {
                sum += regionSize.longValue();
            }
            Assert.assertEquals((long)this.expectedSize, (long)sum);
            return null;
        }
    }
}

