/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestBulkLoadReplication
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBulkLoadReplication.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestBulkLoadReplication.class);
    private static final String PEER1_CLUSTER_ID = "peer1";
    private static final String PEER4_CLUSTER_ID = "peer4";
    private static final String PEER3_CLUSTER_ID = "peer3";
    private static final String PEER_ID1 = "1";
    private static final String PEER_ID3 = "3";
    private static final String PEER_ID4 = "4";
    private static final AtomicInteger BULK_LOADS_COUNT = new AtomicInteger(0);
    private static CountDownLatch BULK_LOAD_LATCH;
    private static HBaseTestingUtility utility3;
    private static HBaseTestingUtility utility4;
    private static Configuration conf3;
    private static Configuration conf4;
    private static Table htable3;
    private static Table htable4;
    @Rule
    public TestName name = new TestName();
    @ClassRule
    public static TemporaryFolder testFolder;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestBulkLoadReplication.setupBulkLoadConfigsForCluster(conf1, PEER1_CLUSTER_ID);
        conf3 = HBaseConfiguration.create((Configuration)conf1);
        conf3.set("zookeeper.znode.parent", "/3");
        utility3 = new HBaseTestingUtility(conf3);
        conf4 = HBaseConfiguration.create((Configuration)conf1);
        conf4.set("zookeeper.znode.parent", "/4");
        utility3 = new HBaseTestingUtility(conf3);
        utility4 = new HBaseTestingUtility(conf4);
        TestReplicationBase.setUpBeforeClass();
        TestBulkLoadReplication.setupBulkLoadConfigsForCluster(conf3, PEER3_CLUSTER_ID);
        TestBulkLoadReplication.setupBulkLoadConfigsForCluster(conf4, PEER4_CLUSTER_ID);
        TestBulkLoadReplication.startCluster(utility3, conf3);
        TestBulkLoadReplication.startCluster(utility4, conf4);
    }

    private static void startCluster(HBaseTestingUtility util, Configuration configuration) throws Exception {
        LOG.info("Setup Zk to same one from utility1 and utility4");
        util.setZkCluster(utility1.getZkCluster());
        util.startMiniCluster(2);
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setMaxVersions(100).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])noRepfamName)).build();
        Connection connection = ConnectionFactory.createConnection((Configuration)configuration);
        try (Admin admin = connection.getAdmin();){
            admin.createTable(tableDesc, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        }
        util.waitUntilAllRegionsAssigned(tableName);
    }

    @Override
    @Before
    public void setUpBase() throws Exception {
        super.setUpBase();
        ReplicationPeerConfig peer1Config = this.getPeerConfigForCluster(utility1);
        ReplicationPeerConfig peer4Config = this.getPeerConfigForCluster(utility4);
        ReplicationPeerConfig peer3Config = this.getPeerConfigForCluster(utility3);
        utility1.getAdmin().addReplicationPeer(PEER_ID4, peer4Config);
        utility4.getAdmin().addReplicationPeer(PEER_ID1, peer1Config);
        utility4.getAdmin().addReplicationPeer(PEER_ID3, peer3Config);
        utility3.getAdmin().addReplicationPeer(PEER_ID4, peer4Config);
        this.setupCoprocessor(utility1);
        this.setupCoprocessor(utility4);
        this.setupCoprocessor(utility3);
    }

    private ReplicationPeerConfig getPeerConfigForCluster(HBaseTestingUtility util) {
        return ReplicationPeerConfig.newBuilder().setClusterKey(util.getClusterKey()).setSerial(this.isSerialPeer()).build();
    }

    private void setupCoprocessor(HBaseTestingUtility cluster) {
        cluster.getHBaseCluster().getRegions(tableName).forEach(r -> {
            try {
                r.getCoprocessorHost().load(BulkReplicationTestObserver.class, 0, cluster.getConfiguration());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    @Override
    @After
    public void tearDownBase() throws Exception {
        super.tearDownBase();
        utility4.getAdmin().removeReplicationPeer(PEER_ID1);
        utility4.getAdmin().removeReplicationPeer(PEER_ID3);
        utility3.getAdmin().removeReplicationPeer(PEER_ID4);
    }

    private static void setupBulkLoadConfigsForCluster(Configuration config, String clusterReplicationId) throws Exception {
        config.setBoolean("hbase.replication.bulkload.enabled", true);
        config.set("hbase.replication.cluster.id", clusterReplicationId);
        File sourceConfigFolder = testFolder.newFolder(clusterReplicationId);
        File sourceConfigFile = new File(sourceConfigFolder.getAbsolutePath() + "/hbase-site.xml");
        config.writeXml((OutputStream)new FileOutputStream(sourceConfigFile));
        config.set("hbase.replication.conf.dir", testFolder.getRoot().getAbsolutePath());
    }

    @Test
    public void testBulkLoadReplicationActiveActive() throws Exception {
        Table peer1TestTable = utility1.getConnection().getTable(TestReplicationBase.tableName);
        Table peer4TestTable = utility4.getConnection().getTable(TestReplicationBase.tableName);
        Table peer3TestTable = utility3.getConnection().getTable(TestReplicationBase.tableName);
        byte[] row = Bytes.toBytes((String)"001");
        byte[] value = Bytes.toBytes((String)"v1");
        this.assertBulkLoadConditions(row, value, utility1, peer1TestTable, peer4TestTable, peer3TestTable);
        row = Bytes.toBytes((String)"002");
        value = Bytes.toBytes((String)"v2");
        this.assertBulkLoadConditions(row, value, utility4, peer1TestTable, peer4TestTable, peer3TestTable);
        row = Bytes.toBytes((String)"003");
        value = Bytes.toBytes((String)"v3");
        this.assertBulkLoadConditions(row, value, utility3, peer1TestTable, peer4TestTable, peer3TestTable);
        Thread.sleep(400L);
        Assert.assertEquals((long)9L, (long)BULK_LOADS_COUNT.get());
    }

    private void assertBulkLoadConditions(byte[] row, byte[] value, HBaseTestingUtility utility, Table ... tables) throws Exception {
        BULK_LOAD_LATCH = new CountDownLatch(3);
        this.bulkLoadOnCluster(row, value, utility);
        Assert.assertTrue((boolean)BULK_LOAD_LATCH.await(1L, TimeUnit.MINUTES));
        this.assertTableHasValue(tables[0], row, value);
        this.assertTableHasValue(tables[1], row, value);
        this.assertTableHasValue(tables[2], row, value);
    }

    private void bulkLoadOnCluster(byte[] row, byte[] value, HBaseTestingUtility cluster) throws Exception {
        String bulkLoadFile = this.createHFileForFamilies(row, value, cluster.getConfiguration());
        Path bulkLoadFilePath = new Path(bulkLoadFile);
        this.copyToHdfs(bulkLoadFile, cluster.getDFSCluster());
        LoadIncrementalHFiles bulkLoadHFilesTool = new LoadIncrementalHFiles(cluster.getConfiguration());
        HashMap family2Files = new HashMap();
        ArrayList<Path> files = new ArrayList<Path>();
        files.add(new Path("/bulk_dir/f/" + bulkLoadFilePath.getName()));
        family2Files.put(Bytes.toBytes((String)"f"), files);
        bulkLoadHFilesTool.run(family2Files, tableName);
    }

    private void copyToHdfs(String bulkLoadFilePath, MiniDFSCluster cluster) throws Exception {
        Path bulkLoadDir = new Path("/bulk_dir/f");
        cluster.getFileSystem().mkdirs(bulkLoadDir);
        cluster.getFileSystem().copyFromLocalFile(new Path(bulkLoadFilePath), bulkLoadDir);
    }

    private void assertTableHasValue(Table table, byte[] row, byte[] value) throws Exception {
        Get get = new Get(row);
        Result result = table.get(get);
        Assert.assertTrue((boolean)result.advance());
        Assert.assertEquals((Object)Bytes.toString((byte[])value), (Object)Bytes.toString((byte[])result.value()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createHFileForFamilies(byte[] row, byte[] value, Configuration clusterConfig) throws IOException {
        CellBuilder cellBuilder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY);
        cellBuilder.setRow(row).setFamily(TestReplicationBase.famName).setQualifier(Bytes.toBytes((String)PEER_ID1)).setValue(value).setType(Cell.Type.Put);
        HFile.WriterFactory hFileFactory = HFile.getWriterFactoryNoCache((Configuration)clusterConfig);
        File hFileLocation = testFolder.newFile();
        try (FSDataOutputStream out = new FSDataOutputStream((OutputStream)new FileOutputStream(hFileLocation), null);){
            hFileFactory.withOutputStream(out);
            hFileFactory.withFileContext(new HFileContext());
            try (HFile.Writer writer = hFileFactory.create();){
                writer.append((Cell)new KeyValue(cellBuilder.build()));
            }
        }
        return hFileLocation.getAbsoluteFile().getAbsolutePath();
    }

    static {
        testFolder = new TemporaryFolder();
    }

    public static class BulkReplicationTestObserver
    implements RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(new RegionObserver(){

                public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
                    BULK_LOADS_COUNT.incrementAndGet();
                }

                public void postBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> stagingFamilyPaths, Map<byte[], List<Path>> finalPaths) throws IOException {
                    BULK_LOAD_LATCH.countDown();
                }
            });
        }
    }
}

