/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestRecoveredEditsReplayAndAbort {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecoveredEditsReplayAndAbort.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRecoveredEditsReplayAndAbort.class);
    protected final byte[] row = Bytes.toBytes((String)"rowA");
    protected static final byte[] fam1 = Bytes.toBytes((String)"colfamily11");
    @Rule
    public TestName name = new TestName();
    protected TableName tableName;
    protected String method;
    protected static HBaseTestingUtility TEST_UTIL;
    public static Configuration CONF;
    private static FileSystem FILESYSTEM;
    private HRegion region = null;
    private final Random random = new Random();

    @Before
    public void setup() throws IOException {
        TEST_UTIL = new HBaseTestingUtility();
        FILESYSTEM = TEST_UTIL.getTestFileSystem();
        CONF = TEST_UTIL.getConfiguration();
        this.method = this.name.getMethodName();
        this.tableName = TableName.valueOf((String)this.method);
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("Cleaning test directory: " + TEST_UTIL.getDataTestDir());
        TEST_UTIL.cleanupTestDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        CONF.setInt("hbase.hregion.memstore.flush.size", 0xA00000);
        CONF.setInt("hbase.hstore.report.interval.edits", 1);
        CONF.setInt("hbase.hstore.report.period", 0);
        final RegionServerAccounting rsAccounting = new RegionServerAccounting(CONF);
        RegionServerServices rs = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
        Mockito.when((Object)rs.getRegionServerAccounting()).thenReturn((Object)rsAccounting);
        Mockito.when((Object)rs.isAborted()).thenReturn((Object)false);
        Mockito.when((Object)rs.getNonceManager()).thenReturn(null);
        Mockito.when((Object)rs.getServerName()).thenReturn((Object)ServerName.valueOf((String)"test", (int)0, (long)111L));
        Mockito.when((Object)rs.getConfiguration()).thenReturn((Object)CONF);
        TableName testTable = TableName.valueOf((String)"testRecoveredEidtsReplayAndAbort");
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)testTable).addColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])fam1).build()).build();
        HRegionInfo info = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, false);
        Path logDir = TEST_UTIL.getDataTestDirOnTestFS("TestRecoveredEidtsReplayAndAbort.log");
        WAL wal = HBaseTestingUtility.createWal(CONF, logDir, (RegionInfo)info);
        Path rootDir = TEST_UTIL.getDataTestDir();
        Path tableDir = FSUtils.getTableDir((Path)rootDir, (TableName)info.getTable());
        HRegionFileSystem.createRegionOnFileSystem((Configuration)CONF, (FileSystem)TEST_UTIL.getTestFileSystem(), (Path)tableDir, (RegionInfo)info);
        this.region = HRegion.newHRegion((Path)tableDir, (WAL)wal, (FileSystem)TEST_UTIL.getTestFileSystem(), (Configuration)CONF, (RegionInfo)info, (TableDescriptor)htd, (RegionServerServices)rs);
        WALFactory wals = new WALFactory(CONF, this.method);
        try {
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            byte[] regionName = this.region.getRegionInfo().getEncodedNameAsBytes();
            Path recoveredEditsDir = WALSplitUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
            long maxSeqId = 1200L;
            long minSeqId = 1000L;
            final long totalEdits = maxSeqId - minSeqId;
            for (long i = minSeqId; i <= maxSeqId; i += 100L) {
                Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", i));
                LOG.info("Begin to write recovered.edits : " + recoveredEdits);
                fs.create(recoveredEdits);
                WALProvider.Writer writer = wals.createRecoveredEditsWriter(fs, recoveredEdits);
                for (long j = i; j < i + 100L; ++j) {
                    long time = System.nanoTime();
                    WALEdit edit = new WALEdit();
                    byte[] value = new byte[204800];
                    this.random.nextBytes(value);
                    edit.add((Cell)new KeyValue(this.row, fam1, Bytes.toBytes((long)j), time, KeyValue.Type.Put, value));
                    writer.append(new WAL.Entry(new WALKeyImpl(regionName, this.tableName, j, time, HConstants.DEFAULT_CLUSTER_ID), edit));
                }
                writer.close();
            }
            MonitoredTask status = TaskMonitor.get().createStatus(this.method);
            try {
                this.region.initialize(new CancelableProgressable(){
                    private long replayedEdits = 0L;

                    public boolean progress() {
                        ++this.replayedEdits;
                        Assert.assertEquals((long)rsAccounting.getGlobalMemStoreDataSize(), (long)TestRecoveredEditsReplayAndAbort.this.region.getMemStoreDataSize());
                        Assert.assertEquals((long)rsAccounting.getGlobalMemStoreHeapSize(), (long)TestRecoveredEditsReplayAndAbort.this.region.getMemStoreHeapSize());
                        Assert.assertEquals((long)rsAccounting.getGlobalMemStoreOffHeapSize(), (long)TestRecoveredEditsReplayAndAbort.this.region.getMemStoreOffHeapSize());
                        return this.replayedEdits < totalEdits - 10L;
                    }
                });
                Assert.fail((String)"Should not reach here");
            }
            catch (IOException t) {
                LOG.info("Current memstore: " + this.region.getMemStoreDataSize() + ", " + this.region.getMemStoreHeapSize() + ", " + this.region.getMemStoreOffHeapSize());
            }
            Assert.assertEquals((long)0L, (long)rsAccounting.getGlobalMemStoreDataSize());
            Assert.assertEquals((long)0L, (long)this.region.getMemStoreDataSize());
            Assert.assertEquals((long)0L, (long)ChunkCreator.getInstance().numberOfMappedChunks());
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
            wals.close();
        }
    }
}

