/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionReplicasWithModifyTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicasWithModifyTable.class);
    private static final int NB_SERVERS = 3;
    private static Table table;
    private static final byte[] row;
    private static final HBaseTestingUtility HTU;
    private static final byte[] f;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniCluster(3);
    }

    private static void enableReplicationByModification(TableName tableName, boolean withReplica, int initialReplicaCount, int enableReplicaCount, int splitCount) throws IOException, InterruptedException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        if (withReplica) {
            htd.setRegionReplication(initialReplicaCount);
        }
        if (splitCount > 0) {
            byte[][] splits = TestRegionReplicasWithModifyTable.getSplits(splitCount);
            table = HTU.createTable((TableDescriptor)htd, (byte[][])new byte[][]{f}, splits, new Configuration(HTU.getConfiguration()));
        } else {
            table = HTU.createTable((TableDescriptor)htd, (byte[][])new byte[][]{f}, (byte[][])null, new Configuration(HTU.getConfiguration()));
        }
        HBaseTestingUtility.setReplicas(HTU.getAdmin(), table.getName(), enableReplicaCount);
    }

    private static byte[][] getSplits(int numRegions) {
        RegionSplitter.UniformSplit split = new RegionSplitter.UniformSplit();
        split.setFirstRow(Bytes.toBytes((long)0L));
        split.setLastRow(Bytes.toBytes((long)Long.MAX_VALUE));
        return split.split(numRegions);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HRegionServer.TEST_SKIP_REPORTING_TRANSITION = false;
        table.close();
        HTU.shutdownMiniCluster();
    }

    private HRegionServer getRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(0);
    }

    private HRegionServer getSecondaryRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(1);
    }

    private HRegionServer getTertiaryRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicasUsingEnableTable() throws Exception {
        TableName tableName = null;
        try {
            tableName = TableName.valueOf((String)this.name.getMethodName());
            TestRegionReplicasWithModifyTable.enableReplicationByModification(tableName, false, 0, 3, 0);
            List onlineRegions = this.getRS().getRegions(tableName);
            List onlineRegions2 = this.getSecondaryRS().getRegions(tableName);
            List onlineRegions3 = this.getTertiaryRS().getRegions(tableName);
            int totalRegions = onlineRegions.size() + onlineRegions2.size() + onlineRegions3.size();
            Assert.assertEquals((String)"the number of regions should be more than 1", (long)3L, (long)totalRegions);
        }
        finally {
            this.disableAndDeleteTable(tableName);
        }
    }

    private void disableAndDeleteTable(TableName tableName) throws IOException {
        HTU.getAdmin().disableTable(tableName);
        HTU.getAdmin().deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicasUsingEnableTableForMultipleRegions() throws Exception {
        TableName tableName = null;
        try {
            tableName = TableName.valueOf((String)this.name.getMethodName());
            TestRegionReplicasWithModifyTable.enableReplicationByModification(tableName, false, 0, 3, 10);
            List onlineRegions = this.getRS().getRegions(tableName);
            List onlineRegions2 = this.getSecondaryRS().getRegions(tableName);
            List onlineRegions3 = this.getTertiaryRS().getRegions(tableName);
            int totalRegions = onlineRegions.size() + onlineRegions2.size() + onlineRegions3.size();
            Assert.assertEquals((String)"the number of regions should be equal to 30", (long)30L, (long)totalRegions);
        }
        finally {
            this.disableAndDeleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicasByEnableTableWhenReplicaCountIsIncreased() throws Exception {
        TableName tableName = null;
        try {
            tableName = TableName.valueOf((String)this.name.getMethodName());
            TestRegionReplicasWithModifyTable.enableReplicationByModification(tableName, true, 2, 3, 0);
            List onlineRegions = this.getRS().getRegions(tableName);
            List onlineRegions2 = this.getSecondaryRS().getRegions(tableName);
            List onlineRegions3 = this.getTertiaryRS().getRegions(tableName);
            int totalRegions = onlineRegions.size() + onlineRegions2.size() + onlineRegions3.size();
            Assert.assertEquals((String)"the number of regions should be 3", (long)3L, (long)totalRegions);
        }
        finally {
            this.disableAndDeleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicasByEnableTableWhenReplicaCountIsDecreased() throws Exception {
        TableName tableName = null;
        try {
            tableName = TableName.valueOf((String)this.name.getMethodName());
            TestRegionReplicasWithModifyTable.enableReplicationByModification(tableName, true, 3, 2, 0);
            List onlineRegions = this.getRS().getRegions(tableName);
            List onlineRegions2 = this.getSecondaryRS().getRegions(tableName);
            List onlineRegions3 = this.getTertiaryRS().getRegions(tableName);
            int totalRegions = onlineRegions.size() + onlineRegions2.size() + onlineRegions3.size();
            Assert.assertEquals((String)"the number of regions should be reduced to 2", (long)2L, (long)totalRegions);
        }
        finally {
            this.disableAndDeleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicasByEnableTableWhenReplicaCountIsDecreasedWithMultipleRegions() throws Exception {
        TableName tableName = null;
        try {
            tableName = TableName.valueOf((String)this.name.getMethodName());
            TestRegionReplicasWithModifyTable.enableReplicationByModification(tableName, true, 3, 2, 20);
            List onlineRegions = this.getRS().getRegions(tableName);
            List onlineRegions2 = this.getSecondaryRS().getRegions(tableName);
            List onlineRegions3 = this.getTertiaryRS().getRegions(tableName);
            int totalRegions = onlineRegions.size() + onlineRegions2.size() + onlineRegions3.size();
            Assert.assertEquals((String)"the number of regions should be reduced to 40", (long)40L, (long)totalRegions);
        }
        finally {
            this.disableAndDeleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicasByEnableTableWhenReplicaCountIsIncreasedWithmultipleRegions() throws Exception {
        TableName tableName = null;
        try {
            tableName = TableName.valueOf((String)this.name.getMethodName());
            TestRegionReplicasWithModifyTable.enableReplicationByModification(tableName, true, 2, 3, 15);
            List onlineRegions = this.getRS().getRegions(tableName);
            List onlineRegions2 = this.getSecondaryRS().getRegions(tableName);
            List onlineRegions3 = this.getTertiaryRS().getRegions(tableName);
            int totalRegions = onlineRegions.size() + onlineRegions2.size() + onlineRegions3.size();
            Assert.assertEquals((String)"the number of regions should be equal to 45", (long)45L, (long)totalRegions);
        }
        finally {
            this.disableAndDeleteTable(tableName);
        }
    }

    static {
        row = "TestRegionReplicasWithModifyTable".getBytes();
        HTU = new HBaseTestingUtility();
        f = HConstants.CATALOG_FAMILY;
    }
}

