/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationEmptyWALRecovery
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationEmptyWALRecovery.class);

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.cleanUp();
    }

    private void waitForLogAdvance(final int numRs) throws Exception {
        Waiter.waitFor((Configuration)conf1, (long)10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                for (int i = 0; i < numRs; ++i) {
                    HRegionServer hrs = TestReplicationBase.utility1.getHBaseCluster().getRegionServer(i);
                    RegionInfo regionInfo = TestReplicationBase.utility1.getHBaseCluster().getRegions(TestReplicationBase.htable1.getName()).get(0).getRegionInfo();
                    WAL wal = hrs.getWAL(regionInfo);
                    Path currentFile = ((AbstractFSWAL)wal).getCurrentFileName();
                    Replication replicationService = (Replication)TestReplicationBase.utility1.getHBaseCluster().getRegionServer(i).getReplicationSourceService();
                    for (ReplicationSourceInterface rsi : replicationService.getReplicationManager().getSources()) {
                        ReplicationSource source = (ReplicationSource)rsi;
                        if (currentFile.equals((Object)source.getCurrentPath())) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }

    @Test
    public void testEmptyWALRecovery() throws Exception {
        int i;
        int numRs = utility1.getHBaseCluster().getRegionServerThreads().size();
        ArrayList<Path> emptyWalPaths = new ArrayList<Path>();
        long ts = System.currentTimeMillis();
        for (i = 0; i < numRs; ++i) {
            RegionInfo regionInfo = utility1.getHBaseCluster().getRegions(htable1.getName()).get(0).getRegionInfo();
            WAL wal = utility1.getHBaseCluster().getRegionServer(i).getWAL(regionInfo);
            Path currentWalPath = AbstractFSWALProvider.getCurrentFileName((WAL)wal);
            String walGroupId = AbstractFSWALProvider.getWALPrefixFromWALName((String)currentWalPath.getName());
            Path emptyWalPath = new Path(utility1.getDataTestDir(), walGroupId + "." + ts);
            utility1.getTestFileSystem().create(emptyWalPath).close();
            emptyWalPaths.add(emptyWalPath);
        }
        for (i = 0; i < numRs; ++i) {
            HRegionServer hrs = utility1.getHBaseCluster().getRegionServer(i);
            Replication replicationService = (Replication)hrs.getReplicationSourceService();
            replicationService.getReplicationManager().preLogRoll((Path)emptyWalPaths.get(i));
            replicationService.getReplicationManager().postLogRoll((Path)emptyWalPaths.get(i));
            RegionInfo regionInfo = utility1.getHBaseCluster().getRegions(htable1.getName()).get(0).getRegionInfo();
            WAL wal = hrs.getWAL(regionInfo);
            wal.rollWriter(true);
        }
        this.waitForLogAdvance(numRs);
        TestReplicationEmptyWALRecovery.runSimplePutDeleteTest();
    }
}

