/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MultiThreadedAction;
import org.apache.hadoop.hbase.util.MultiThreadedReader;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestMiniClusterLoadSequential {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMiniClusterLoadSequential.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMiniClusterLoadSequential.class);
    protected static final TableName TABLE = TableName.valueOf((String)"load_test_tbl");
    protected static final byte[] CF = Bytes.toBytes((String)"load_test_cf");
    protected static final int NUM_THREADS = 8;
    protected static final int NUM_RS = 2;
    protected static final int TIMEOUT_MS = 180000;
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected final Configuration conf = TEST_UTIL.getConfiguration();
    protected final boolean isMultiPut;
    protected final DataBlockEncoding dataBlockEncoding;
    protected MultiThreadedWriter writerThreads;
    protected MultiThreadedReader readerThreads;
    protected int numKeys;
    protected Compression.Algorithm compression = Compression.Algorithm.NONE;

    public TestMiniClusterLoadSequential(boolean isMultiPut, DataBlockEncoding dataBlockEncoding) {
        this.isMultiPut = isMultiPut;
        this.dataBlockEncoding = dataBlockEncoding;
        this.conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        this.conf.setFloat("hbase.regions.slop", 10.0f);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (boolean multiPut : new boolean[]{false, true}) {
            for (DataBlockEncoding dataBlockEncoding : new DataBlockEncoding[]{DataBlockEncoding.NONE, DataBlockEncoding.PREFIX}) {
                parameters.add(new Object[]{multiPut, dataBlockEncoding});
            }
        }
        return parameters;
    }

    @Before
    public void setUp() throws Exception {
        LOG.debug("Test setup: isMultiPut=" + this.isMultiPut);
        TEST_UTIL.startMiniCluster(2);
    }

    @After
    public void tearDown() throws Exception {
        LOG.debug("Test teardown: isMultiPut=" + this.isMultiPut);
        TEST_UTIL.shutdownMiniCluster();
    }

    protected MultiThreadedReader prepareReaderThreads(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName, double verifyPercent) throws IOException {
        MultiThreadedReader reader = new MultiThreadedReader(dataGen, conf, tableName, verifyPercent);
        return reader;
    }

    protected MultiThreadedWriter prepareWriterThreads(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName) throws IOException {
        MultiThreadedWriter writer = new MultiThreadedWriter(dataGen, conf, tableName);
        writer.setMultiPut(this.isMultiPut);
        return writer;
    }

    @Test
    public void loadTest() throws Exception {
        this.prepareForLoadTest();
        this.runLoadTestOnExistingTable();
    }

    protected void runLoadTestOnExistingTable() throws IOException {
        this.writerThreads.start(0L, this.numKeys, 8);
        this.writerThreads.waitForFinish();
        Assert.assertEquals((long)0L, (long)this.writerThreads.getNumWriteFailures());
        this.readerThreads.start(0L, this.numKeys, 8);
        this.readerThreads.waitForFinish();
        Assert.assertEquals((long)0L, (long)this.readerThreads.getNumReadFailures());
        Assert.assertEquals((long)0L, (long)this.readerThreads.getNumReadErrors());
        Assert.assertEquals((long)this.numKeys, (long)this.readerThreads.getNumKeysVerified());
    }

    protected void createPreSplitLoadTestTable(HTableDescriptor htd, HColumnDescriptor hcd) throws IOException {
        HBaseTestingUtility.createPreSplitLoadTestTable(this.conf, (TableDescriptor)htd, (ColumnFamilyDescriptor)hcd);
        TEST_UTIL.waitUntilAllRegionsAssigned(htd.getTableName());
    }

    protected void prepareForLoadTest() throws IOException {
        LOG.info("Starting load test: dataBlockEncoding=" + this.dataBlockEncoding + ", isMultiPut=" + this.isMultiPut);
        this.numKeys = this.numKeys();
        Admin admin = TEST_UTIL.getAdmin();
        while (admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().size() < 2) {
            LOG.info("Sleeping until 2 RSs are online");
            Threads.sleepWithoutInterrupt((long)1000L);
        }
        admin.close();
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        HColumnDescriptor hcd = new HColumnDescriptor(CF).setCompressionType(this.compression).setDataBlockEncoding(this.dataBlockEncoding);
        this.createPreSplitLoadTestTable(htd, hcd);
        MultiThreadedAction.DefaultDataGenerator dataGen = new MultiThreadedAction.DefaultDataGenerator(new byte[][]{CF});
        this.writerThreads = this.prepareWriterThreads(dataGen, this.conf, TABLE);
        this.readerThreads = this.prepareReaderThreads(dataGen, this.conf, TABLE, 100.0);
    }

    protected int numKeys() {
        return 1000;
    }

    protected HColumnDescriptor getColumnDesc(Admin admin) throws TableNotFoundException, IOException {
        return admin.getTableDescriptor(TABLE).getFamily(CF);
    }
}

