/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client.shaded.org.jboss.netty.handler.logging;

import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelDownstreamHandler;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelEvent;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelHandler;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelUpstreamHandler;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ExceptionEvent;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.MessageEvent;
import org.apache.kudu.client.shaded.org.jboss.netty.logging.InternalLogLevel;
import org.apache.kudu.client.shaded.org.jboss.netty.logging.InternalLogger;
import org.apache.kudu.client.shaded.org.jboss.netty.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public class LoggingHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final InternalLogLevel DEFAULT_LEVEL;
    private static final String NEWLINE;
    private static final String[] BYTE2HEX;
    private static final String[] HEXPADDING;
    private static final String[] BYTEPADDING;
    private static final char[] BYTE2CHAR;
    private final InternalLogger logger;
    private final InternalLogLevel level;
    private final boolean hexDump;

    public LoggingHandler() {
        this(true);
    }

    public LoggingHandler(InternalLogLevel level) {
        this(level, true);
    }

    public LoggingHandler(boolean hexDump) {
        this(DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(InternalLogLevel level, boolean hexDump) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(this.getClass());
        this.level = level;
        this.hexDump = hexDump;
    }

    public LoggingHandler(Class<?> clazz) {
        this(clazz, true);
    }

    public LoggingHandler(Class<?> clazz, boolean hexDump) {
        this(clazz, DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(Class<?> clazz, InternalLogLevel level) {
        this(clazz, level, true);
    }

    public LoggingHandler(Class<?> clazz, InternalLogLevel level, boolean hexDump) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(clazz);
        this.level = level;
        this.hexDump = hexDump;
    }

    public LoggingHandler(String name) {
        this(name, true);
    }

    public LoggingHandler(String name, boolean hexDump) {
        this(name, DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(String name, InternalLogLevel level, boolean hexDump) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(name);
        this.level = level;
        this.hexDump = hexDump;
    }

    public InternalLogger getLogger() {
        return this.logger;
    }

    public InternalLogLevel getLevel() {
        return this.level;
    }

    public void log(ChannelEvent e) {
        if (this.getLogger().isEnabled(this.level)) {
            MessageEvent me;
            String msg = e.toString();
            if (this.hexDump && e instanceof MessageEvent && (me = (MessageEvent)e).getMessage() instanceof ChannelBuffer) {
                msg = msg + LoggingHandler.formatBuffer((ChannelBuffer)me.getMessage());
            }
            if (e instanceof ExceptionEvent) {
                this.getLogger().log(this.level, msg, ((ExceptionEvent)e).getCause());
            } else {
                this.getLogger().log(this.level, msg);
            }
        }
    }

    private static String formatBuffer(ChannelBuffer buf) {
        int i;
        int length = buf.readableBytes();
        int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
        StringBuilder dump = new StringBuilder(rows * 80);
        dump.append(NEWLINE + "         +-------------------------------------------------+" + NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + NEWLINE + "+--------+-------------------------------------------------+----------------+");
        int startIndex = buf.readerIndex();
        int endIndex = buf.writerIndex();
        for (i = startIndex; i < endIndex; ++i) {
            int relIdx = i - startIndex;
            int relIdxMod16 = relIdx & 0xF;
            if (relIdxMod16 == 0) {
                dump.append(NEWLINE);
                dump.append(Long.toHexString((long)relIdx & 0xFFFFFFFFL | 0x100000000L));
                dump.setCharAt(dump.length() - 9, '|');
                dump.append('|');
            }
            dump.append(BYTE2HEX[buf.getUnsignedByte(i)]);
            if (relIdxMod16 != 15) continue;
            dump.append(" |");
            for (int j = i - 15; j <= i; ++j) {
                dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
            }
            dump.append('|');
        }
        if ((i - startIndex & 0xF) != 0) {
            int remainder = length & 0xF;
            dump.append(HEXPADDING[remainder]);
            dump.append(" |");
            for (int j = i - remainder; j < i; ++j) {
                dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
            }
            dump.append(BYTEPADDING[remainder]);
            dump.append('|');
        }
        dump.append(NEWLINE + "+--------+-------------------------------------------------+----------------+");
        return dump.toString();
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.log(e);
        ctx.sendUpstream(e);
    }

    @Override
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.log(e);
        ctx.sendDownstream(e);
    }

    static {
        int j;
        StringBuilder buf;
        StringBuilder buf2;
        int i;
        DEFAULT_LEVEL = InternalLogLevel.DEBUG;
        NEWLINE = String.format("%n", new Object[0]);
        BYTE2HEX = new String[256];
        HEXPADDING = new String[16];
        BYTEPADDING = new String[16];
        BYTE2CHAR = new char[256];
        for (i = 0; i < 10; ++i) {
            buf2 = new StringBuilder(3);
            buf2.append(" 0");
            buf2.append(i);
            LoggingHandler.BYTE2HEX[i] = buf2.toString();
        }
        while (i < 16) {
            buf2 = new StringBuilder(3);
            buf2.append(" 0");
            buf2.append((char)(97 + i - 10));
            LoggingHandler.BYTE2HEX[i] = buf2.toString();
            ++i;
        }
        while (i < BYTE2HEX.length) {
            buf2 = new StringBuilder(3);
            buf2.append(' ');
            buf2.append(Integer.toHexString(i));
            LoggingHandler.BYTE2HEX[i] = buf2.toString();
            ++i;
        }
        for (i = 0; i < HEXPADDING.length; ++i) {
            int padding = HEXPADDING.length - i;
            buf = new StringBuilder(padding * 3);
            for (j = 0; j < padding; ++j) {
                buf.append("   ");
            }
            LoggingHandler.HEXPADDING[i] = buf.toString();
        }
        for (i = 0; i < BYTEPADDING.length; ++i) {
            int padding = BYTEPADDING.length - i;
            buf = new StringBuilder(padding);
            for (j = 0; j < padding; ++j) {
                buf.append(' ');
            }
            LoggingHandler.BYTEPADDING[i] = buf.toString();
        }
        for (i = 0; i < BYTE2CHAR.length; ++i) {
            LoggingHandler.BYTE2CHAR[i] = i <= 31 || i >= 127 ? 46 : (char)i;
        }
    }
}

