/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.DataSetMap;
import org.datayoo.moql.MapEntry;
import org.datayoo.moql.MapEntryImpl;
import org.datayoo.moql.RecordSet;

public class DataSetMapImpl
implements DataSetMap {
    protected Map<String, Object> dataSetMap = new HashMap<String, Object>();

    public DataSetMapImpl() {
    }

    public DataSetMapImpl(DataSetMap dataSetMap) {
        this.putAll(dataSetMap);
    }

    @Override
    public Set<MapEntry<String, Object>> entrySet() {
        HashSet<MapEntry<String, Object>> entrySet = new HashSet<MapEntry<String, Object>>();
        for (Map.Entry<String, Object> entry : this.dataSetMap.entrySet()) {
            MapEntryImpl<String, Object> mEntry = new MapEntryImpl<String, Object>(entry.getKey());
            mEntry.setValue(entry.getValue());
            entrySet.add(mEntry);
        }
        return entrySet;
    }

    @Override
    public Object getDataSet(String dataSetName) {
        Validate.notEmpty((String)dataSetName, (String)"Parameter 'dataSetName' is empty!");
        return this.dataSetMap.get(dataSetName);
    }

    @Override
    public Object putDataSet(String dataSetName, Object dataSet) {
        Validate.notEmpty((String)dataSetName, (String)"Parameter 'dataSetName' is empty!");
        Validate.notNull((Object)dataSet, (String)"Parameter 'dataSet' is null!");
        if (!this.isDataSet(dataSet)) {
            Validate.notNull((Object)dataSet, (String)"Parameter 'dataSet' must be an instance of Array, Map, Iterable, RowSet or ResultSet!");
        }
        return this.dataSetMap.put(dataSetName, dataSet);
    }

    @Override
    public Object removeDataSet(String dataSetName) {
        Validate.notEmpty((String)dataSetName, (String)"Parameter 'dataSetName' is empty!");
        return this.dataSetMap.remove(dataSetName);
    }

    protected boolean isDataSet(Object dataSet) {
        if (dataSet.getClass().isArray()) {
            return true;
        }
        if (dataSet instanceof Map) {
            return true;
        }
        if (dataSet instanceof Iterable) {
            return true;
        }
        if (dataSet instanceof RecordSet) {
            return true;
        }
        return dataSet instanceof ResultSet;
    }

    @Override
    public void putAll(DataSetMap dataSetMap) {
        Validate.notNull((Object)dataSetMap, (String)"Parameter 'dataSetMap' is null!");
        for (MapEntry<String, Object> entry : dataSetMap.entrySet()) {
            this.dataSetMap.put(entry.getKey(), entry.getValue());
        }
    }
}

