/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.MapEntry;
import org.datayoo.moql.MapEntryImpl;

public class EntityMapImpl
implements EntityMap {
    protected Map<String, Object> entityMap = new HashMap<String, Object>();

    public EntityMapImpl() {
    }

    public EntityMapImpl(Map<String, Object> map) {
        Validate.notNull(map, (String)"Parameter 'map' is null!");
        this.entityMap = map;
    }

    public EntityMapImpl(EntityMap entityMap) {
        this.putAll(entityMap);
    }

    @Override
    public Set<MapEntry<String, Object>> entrySet() {
        HashSet<MapEntry<String, Object>> entrySet = new HashSet<MapEntry<String, Object>>();
        for (Map.Entry<String, Object> entry : this.entityMap.entrySet()) {
            MapEntryImpl<String, Object> mEntry = new MapEntryImpl<String, Object>(entry.getKey());
            mEntry.setValue(entry.getValue());
            entrySet.add(mEntry);
        }
        return entrySet;
    }

    @Override
    public Object getEntity(String entityName) {
        return this.entityMap.get(entityName);
    }

    @Override
    public Object putEntity(String entityName, Object entity) {
        Validate.notEmpty((String)entityName, (String)"Parameter 'entityName' is empty!");
        return this.entityMap.put(entityName, entity);
    }

    @Override
    public Object removeEntity(String entityName) {
        Validate.notEmpty((String)entityName, (String)"Parameter 'entityName' is empty!");
        return this.entityMap.remove(entityName);
    }

    @Override
    public void putAll(EntityMap entityMap) {
        Validate.notNull((Object)entityMap, (String)"Parameter 'entityMap' is null!");
        for (MapEntry<String, Object> entry : entityMap.entrySet()) {
            this.entityMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(Map<String, Object> map) {
        Validate.notNull(map, (String)"Parameter 'map' is null!");
        this.entityMap.putAll(map);
    }
}

