/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.metadata.LimitMetadata;

public class LimitImpl
implements Limit {
    protected LimitMetadata limitMetadata;

    public LimitImpl(LimitMetadata limitMetadata) {
        Validate.notNull((Object)limitMetadata, (String)"Parameter 'limitMetadata' is null!");
        this.limitMetadata = limitMetadata;
    }

    @Override
    public RecordSet decorate(RecordSet recordSet, Columns columns) {
        if (this.limitMetadata.getValue() == 0) {
            return recordSet;
        }
        List<Object[]> records = recordSet.getRecords();
        int value = this.limitMetadata.getValue();
        if (this.limitMetadata.isPercent()) {
            double percent = (double)value / 100.0;
            value = (int)((double)records.size() * percent);
        }
        ArrayList<Object[]> resultRecords = new ArrayList<Object[]>(value);
        int offset = this.limitMetadata.getOffset();
        Iterator<Object[]> it = records.iterator();
        while (it.hasNext()) {
            if (offset > 0) {
                it.next();
                --offset;
                continue;
            }
            if (value == 0) break;
            resultRecords.add(it.next());
            --value;
        }
        return new RecordSetImpl(recordSet.getRecordSetDefinition(), recordSet.getStart(), recordSet.getEnd(), resultRecords);
    }

    @Override
    public LimitMetadata getLimitMetadata() {
        return this.limitMetadata;
    }
}

