/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.MoqlGrammarException;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.Order;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.core.RecordSetMetadata;
import org.datayoo.moql.metadata.OrderMetadata;
import org.datayoo.moql.metadata.OrderType;
import org.datayoo.moql.util.StringFormater;

public class OrderImpl
implements Order {
    protected List<OrderMetadata> orderMetadatas;
    protected Columns columns;
    protected int[] orderColumnIndexs;
    protected OrderType[] orderTypes;
    protected List<ColumnDefinition> columnDefinitions;
    protected int[] justOrderColumnIndexes;
    protected int justOrderCount = 0;
    protected RecordComparator recordComparator = new RecordComparator();

    public OrderImpl(Columns columns, List<OrderMetadata> orderMetadatas) throws MoqlGrammarException {
        Validate.notEmpty(orderMetadatas, (String)"Parameter 'orderMetadatas' is empty!");
        this.columns = columns;
        this.orderMetadatas = orderMetadatas;
        this.initialize();
    }

    protected void initialize() throws MoqlGrammarException {
        this.initializeOrderColumnIndexes();
        this.initializeColumnDefinitions();
    }

    protected void initializeOrderColumnIndexes() throws MoqlGrammarException {
        this.orderColumnIndexs = new int[this.orderMetadatas.size()];
        this.orderTypes = new OrderType[this.orderMetadatas.size()];
        int i = 0;
        for (OrderMetadata orderMetadata : this.orderMetadatas) {
            int index = this.getOrderColumnIndex(orderMetadata, this.columns.getColumns());
            if (index > this.columns.getColumns().size() || index < 1) {
                throw new MoqlGrammarException(StringFormater.format((String)"Order column indexed '{}' out of columns' bound!", (Object[])new Object[]{index}));
            }
            this.orderColumnIndexs[i] = index - 1;
            this.orderTypes[i++] = orderMetadata.getOrderType();
        }
    }

    protected void initializeColumnDefinitions() {
        this.columnDefinitions = new ArrayList<ColumnDefinition>(this.columns.getColumns().size());
        this.justOrderColumnIndexes = new int[this.columns.getColumns().size()];
        int i = 0;
        for (Column column : this.columns.getColumns()) {
            if (column.isJustUsed4Order()) {
                this.justOrderColumnIndexes[this.justOrderCount++] = i;
            } else {
                this.columnDefinitions.add((ColumnDefinition)column.getColumnMetadata());
            }
            ++i;
        }
        if (this.justOrderCount == 0) {
            this.columnDefinitions = null;
            this.justOrderColumnIndexes = null;
        }
    }

    protected int getOrderColumnIndex(OrderMetadata orderMetadata, List<Column> columns) throws MoqlGrammarException {
        String columnName = orderMetadata.getColumn();
        int index = 1;
        try {
            index = Integer.valueOf(columnName);
            return index;
        }
        catch (Throwable throwable) {
            for (Column column : columns) {
                if (column.getColumnMetadata().getName().equals(columnName)) {
                    return index;
                }
                ++index;
            }
            throw new MoqlGrammarException(StringFormater.format((String)"Order column '{}' doesn't existed in colums!", (Object[])new Object[]{columnName}));
        }
    }

    @Override
    public List<OrderMetadata> getOrderMetadatas() {
        return this.orderMetadatas;
    }

    public Column[] getOrderColumns() {
        Column[] orderColumns = new Column[this.orderColumnIndexs.length];
        List<Column> columnList = this.columns.getColumns();
        for (int i = 0; i < this.orderColumnIndexs.length; ++i) {
            orderColumns[i] = columnList.get(this.orderColumnIndexs[i]);
        }
        return orderColumns;
    }

    public OrderType[] getOrderTypes() {
        return this.orderTypes;
    }

    @Override
    public RecordSet decorate(RecordSet recordSet, Columns columns) {
        List<Object[]> records = recordSet.getRecords();
        Collections.sort(records, this.recordComparator);
        if (this.columnDefinitions == null) {
            return new RecordSetImpl(recordSet.getRecordSetDefinition(), recordSet.getStart(), recordSet.getEnd(), records);
        }
        records = this.clearOrderColumns(records);
        return new RecordSetImpl(this.reCreateRecordSetDefinition(recordSet.getRecordSetDefinition()), recordSet.getStart(), recordSet.getEnd(), records);
    }

    protected RecordSetDefinition reCreateRecordSetDefinition(RecordSetDefinition recordSetDefinition) {
        return new RecordSetMetadata(this.columnDefinitions, recordSetDefinition.getGroupColumns());
    }

    protected List<Object[]> clearOrderColumns(List<Object[]> records) {
        ArrayList<Object[]> newRecords = new ArrayList<Object[]>(records.size());
        for (Object[] record : records) {
            newRecords.add(this.clearOrderColumns(record));
        }
        return newRecords;
    }

    protected Object[] clearOrderColumns(Object[] record) {
        Object[] newRecord = new Object[record.length - this.justOrderCount];
        int j = 0;
        for (int i = 0; i < record.length; ++i) {
            if (this.isJustOrderColumn(i)) continue;
            newRecord[j++] = record[i];
        }
        return newRecord;
    }

    protected boolean isJustOrderColumn(int index) {
        for (int i = 0; i < this.justOrderCount; ++i) {
            if (this.justOrderColumnIndexes[i] != index) continue;
            return true;
        }
        return false;
    }

    class RecordComparator
    implements Comparator<Object[]> {
        RecordComparator() {
        }

        @Override
        public int compare(Object[] o1, Object[] o2) {
            int index;
            int ret = 0;
            for (int i = 0; i < OrderImpl.this.orderColumnIndexs.length && (ret = this.compare((Comparable)o1[index = OrderImpl.this.orderColumnIndexs[i]], (Comparable)o2[index], OrderImpl.this.orderTypes[i])) == 0; ++i) {
            }
            return ret;
        }

        private int compare(Comparable cmp1, Comparable cmp2, OrderType order) {
            int ret = 0;
            if (cmp1 != null && cmp2 != null) {
                ret = cmp1.compareTo(cmp2);
            } else if (cmp1 == null && cmp2 != null) {
                ret = -1;
            } else if (cmp1 != null && cmp2 == null) {
                ret = 1;
            }
            if (order == OrderType.DESC) {
                ret = -ret;
            }
            return ret;
        }
    }
}

