/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.RecordNode;

public class RecordNodeImpl
implements RecordNode,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object[] columns;
    private RecordNode parent;
    private List<RecordNode> children = new LinkedList<RecordNode>();

    public RecordNodeImpl(Object[] columns) {
        this.setColumns(columns);
    }

    public RecordNodeImpl() {
    }

    public void addChild(RecordNodeImpl child) {
        child.setParent(this);
        this.children.add(child);
    }

    @Override
    public RecordNode getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public List<RecordNode> getChildren() {
        return this.children;
    }

    @Override
    public Object[] getColumns() {
        return this.columns;
    }

    @Override
    public RecordNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public void setChildren(List<RecordNode> children) {
        Validate.notNull(children, (String)"children is null!");
        this.children = children;
    }

    public void setColumns(Object[] columns) {
        Validate.notNull((Object)columns, (String)"columns is null!");
        this.columns = columns;
    }

    public void setParent(RecordNodeImpl parent) {
        this.parent = parent;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordNode)) {
            return false;
        }
        RecordNode rn = (RecordNode)obj;
        return ArrayUtils.isEquals((Object)rn.getColumns(), (Object)this.columns);
    }
}

