/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.DataSetMap;
import org.datayoo.moql.DataSetMapImpl;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.Selector;
import org.datayoo.moql.SelectorContext;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.Decorator;
import org.datayoo.moql.core.Having;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.Order;
import org.datayoo.moql.core.RecordSetOperator;
import org.datayoo.moql.core.Tables;
import org.datayoo.moql.metadata.SelectorMetadata;

public class SelectorImpl
implements Selector {
    protected String alias;
    protected SelectorMetadata selectorMetadata;
    protected RecordSetOperator recordSetOperator;
    protected Tables tables;
    protected Condition where;
    protected Having having;
    protected Order order;
    protected Limit limit;
    protected Decorator decorator;
    protected List<Selector> nestedTableSelectors = new LinkedList<Selector>();
    protected List<Selector> nestedColumnSelectors = new LinkedList<Selector>();
    protected SelectorContext selectorContext;
    protected RecordSet recentRecordSet;

    public SelectorImpl(SelectorMetadata selectorMetadata) {
        Validate.notNull((Object)selectorMetadata, (String)"Parameter 'selectorMetadata' is null!");
        this.selectorMetadata = selectorMetadata;
    }

    @Override
    public void setAlias(String alias) {
        Validate.notEmpty((String)alias, (String)"alias is empty!");
        this.alias = alias;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public synchronized RecordSet getRecordSet() {
        if (this.recentRecordSet != null) {
            return this.recentRecordSet;
        }
        this.caculateRecordSet();
        return this.recentRecordSet;
    }

    protected void caculateRecordSet() {
        RecordSet recordSet = (RecordSet)this.recordSetOperator.getValue();
        if (this.having != null) {
            recordSet = this.having.decorate(recordSet, this.recordSetOperator.getColumns());
        }
        if (this.order != null) {
            recordSet = this.order.decorate(recordSet, this.recordSetOperator.getColumns());
        }
        if (this.limit != null) {
            recordSet = this.limit.decorate(recordSet, this.recordSetOperator.getColumns());
        }
        if (this.decorator != null) {
            recordSet = this.decorator.decorate(recordSet, this.recordSetOperator.getColumns());
        }
        this.recentRecordSet = recordSet;
    }

    protected void fillTableSelectors(DataSetMap dataSetMap) {
        for (Selector selector : this.nestedTableSelectors) {
            dataSetMap.putDataSet(selector.getAlias(), selector.getRecordSet());
        }
    }

    @Override
    public SelectorContext getSelectorContext() {
        return this.selectorContext;
    }

    @Override
    public SelectorDefinition getSelectorDefinition() {
        return this.selectorMetadata;
    }

    @Override
    public synchronized void clear() {
        this.recentRecordSet = null;
        this.recordSetOperator.clear();
        for (Selector selector : this.nestedTableSelectors) {
            selector.clear();
        }
        for (Selector selector : this.nestedColumnSelectors) {
            selector.clear();
        }
    }

    @Override
    public synchronized void select(DataSetMap dataSetMap) {
        this.selectByNestedSelectors(dataSetMap);
        if (this.nestedTableSelectors.size() != 0) {
            dataSetMap = new DataSetMapImpl(dataSetMap);
            this.fillTableSelectors(dataSetMap);
        }
        this.innerSelect(dataSetMap);
    }

    protected void selectByNestedSelectors(DataSetMap dataSetMap) {
        for (Selector selector : this.nestedTableSelectors) {
            selector.select(dataSetMap);
        }
        for (Selector selector : this.nestedColumnSelectors) {
            selector.select(dataSetMap);
        }
    }

    protected void innerSelect(DataSetMap dataSetMap) {
        this.tables.bind(dataSetMap);
        for (EntityMap entityMap : this.tables) {
            if (this.where != null && !this.where.isMatch(entityMap)) continue;
            this.recordSetOperator.operate(entityMap);
            this.recentRecordSet = null;
        }
    }

    @Override
    public void setSelectorContext(SelectorContext context) {
        Validate.notNull((Object)context, (String)"Parameter 'context' is null!");
        this.selectorContext = context;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Condition getWhere() {
        return this.where;
    }

    public void setWhere(Condition where) {
        this.where = where;
    }

    public Having getHaving() {
        return this.having;
    }

    public void setHaving(Having having) {
        this.having = having;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public List<Selector> getNestedTableSelectors() {
        return this.nestedTableSelectors;
    }

    public void setNestedTableSelectors(List<Selector> nestedTableSelectors) {
        if (nestedTableSelectors == null) {
            nestedTableSelectors = new LinkedList<Selector>();
        }
        this.nestedTableSelectors = nestedTableSelectors;
    }

    public List<Selector> getNestedColumnSelectors() {
        return this.nestedColumnSelectors;
    }

    public void setNestedColumnSelectors(List<Selector> nestedColumnSelectors) {
        if (nestedColumnSelectors == null) {
            nestedColumnSelectors = new LinkedList<Selector>();
        }
        this.nestedColumnSelectors = nestedColumnSelectors;
    }

    public RecordSetOperator getRecordSetOperator() {
        return this.recordSetOperator;
    }

    public void setRecordSetOperator(RecordSetOperator recordSetOperator) {
        Validate.notNull((Object)recordSetOperator, (String)"Parameter 'recordSetOperator' is null!");
        this.recordSetOperator = recordSetOperator;
    }

    public Tables getTables() {
        return this.tables;
    }

    public void setTables(Tables tables) {
        Validate.notNull((Object)tables, (String)"Parameter 'tables' is null!");
        this.tables = tables;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(Decorator decorator) {
        this.decorator = decorator;
    }
}

