/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.DataSetMap;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.Selector;
import org.datayoo.moql.SelectorContext;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.core.Decorator;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.Order;
import org.datayoo.moql.core.RecordSetCombination;
import org.datayoo.moql.metadata.SetlectorMetadata;

public class SetlectorImpl
implements Selector {
    protected String alias;
    protected SetlectorMetadata setlectorMetadata;
    protected RecordSetCombination combination;
    protected Order order;
    protected Limit limit;
    protected Decorator decorator;
    protected List<Selector> nestedSelectors = new LinkedList<Selector>();
    protected List<Selector> sets = new LinkedList<Selector>();
    protected SelectorContext selectorContext;
    protected RecordSet recentRecordSet;

    public SetlectorImpl(SetlectorMetadata setlectorMetadata) {
        Validate.notNull((Object)setlectorMetadata, (String)"Parameter 'setlectorMetadata' is null!");
        this.setlectorMetadata = setlectorMetadata;
    }

    @Override
    public void setAlias(String alias) {
        Validate.notEmpty((String)alias, (String)"alias is empty!");
        this.alias = alias;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public synchronized RecordSet getRecordSet() {
        if (this.recentRecordSet != null) {
            return this.recentRecordSet;
        }
        this.caculateRecordSet();
        return this.recentRecordSet;
    }

    protected void caculateRecordSet() {
        RecordSet lRecordSet = this.sets.get(0).getRecordSet();
        RecordSet rRecordSet = this.sets.get(1).getRecordSet();
        RecordSet recordSet = this.combination.combine(lRecordSet, rRecordSet);
        if (this.order != null) {
            recordSet = this.order.decorate(recordSet, null);
        }
        if (this.limit != null) {
            recordSet = this.limit.decorate(recordSet, null);
        }
        if (this.decorator != null) {
            recordSet = this.decorator.decorate(recordSet, null);
        }
        this.recentRecordSet = recordSet;
    }

    public List<Selector> getNestedSelectors() {
        return this.nestedSelectors;
    }

    public void setNestedSelectors(List<Selector> nestedSelectors) {
        if (nestedSelectors == null) {
            nestedSelectors = new LinkedList<Selector>();
        } else if (nestedSelectors.size() > 2) {
            throw new IllegalArgumentException("Nested selector's count exceed 2!");
        }
        this.nestedSelectors = nestedSelectors;
    }

    public List<Selector> getSets() {
        return this.sets;
    }

    public void setSets(List<Selector> sets) {
        Validate.notEmpty(sets, (String)"Parameter 'sets' is empty!");
        if (sets.size() != 2) {
            throw new IllegalArgumentException("Selector's count is not 2!");
        }
        this.sets = sets;
    }

    @Override
    public SelectorContext getSelectorContext() {
        return this.selectorContext;
    }

    @Override
    public SelectorDefinition getSelectorDefinition() {
        return this.setlectorMetadata;
    }

    @Override
    public synchronized void clear() {
        this.recentRecordSet = null;
        for (Selector selector : this.nestedSelectors) {
            selector.clear();
        }
    }

    @Override
    public synchronized void select(DataSetMap dataSetMap) {
        this.selectByNestedSelectors(dataSetMap);
    }

    protected void selectByNestedSelectors(DataSetMap dataSetMap) {
        for (Selector selector : this.nestedSelectors) {
            selector.select(dataSetMap);
        }
    }

    @Override
    public void setSelectorContext(SelectorContext context) {
        Validate.notNull((Object)context, (String)"Parameter 'context' is null!");
        this.selectorContext = context;
    }

    public RecordSetCombination getCombination() {
        return this.combination;
    }

    public void setCombination(RecordSetCombination combination) {
        Validate.notNull((Object)combination, (String)"Parameter 'combination' is null!");
        this.combination = combination;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(Decorator decorator) {
        this.decorator = decorator;
    }
}

