/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.core.Cache;
import org.datayoo.moql.core.CacheElement;
import org.datayoo.moql.core.WashoutExecutor;
import org.datayoo.moql.core.cache.CacheElementImpl;
import org.datayoo.moql.core.cache.WashoutExecutorFactory;
import org.datayoo.moql.metadata.CacheMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheImpl<K, V>
implements Cache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(CacheImpl.class);
    protected List<CacheElement> listCache;
    protected Map<K, CacheElement> mapCache;
    protected CacheMetadata cacheMetadata;
    protected WashoutExecutor washoutExecutor;

    public CacheImpl(CacheMetadata cacheMetadata) {
        Validate.notNull((Object)cacheMetadata, (String)"Parameter 'cacheMetadata' is null!");
        this.cacheMetadata = cacheMetadata;
        this.washoutExecutor = WashoutExecutorFactory.createWashoutExecutor(cacheMetadata.getWashoutStrategy());
        this.initialize();
    }

    protected void initialize() {
        this.listCache = new LinkedList<CacheElement>();
        this.mapCache = this.cacheMetadata.getSize() != 0 ? new HashMap<K, CacheElement>(this.cacheMetadata.getSize()) : new HashMap<K, CacheElement>();
    }

    @Override
    public synchronized V get(Object key) {
        CacheElement element = this.mapCache.get(key);
        if (element == null) {
            return null;
        }
        element.hit();
        return element.getValue();
    }

    @Override
    public CacheMetadata getCacheMetadata() {
        return this.cacheMetadata;
    }

    @Override
    public WashoutExecutor getWashoutExecutor() {
        return this.washoutExecutor;
    }

    @Override
    public synchronized boolean isFull() {
        if (this.cacheMetadata.getSize() == 0) {
            return false;
        }
        return this.listCache.size() >= this.cacheMetadata.getSize();
    }

    @Override
    public synchronized V put(K key, V value) {
        CacheElement oldElement = null;
        if (this.isFull()) {
            oldElement = this.washoutExecutor.washout(this.listCache);
            if (oldElement == null) {
                return value;
            }
            this.mapCache.remove(oldElement.getKey());
            if (logger.isDebugEnabled()) {
                logger.debug("One cache element is washed out!");
            }
        }
        CacheElementImpl element = new CacheElementImpl((Object)key);
        element.setValue(value);
        this.listCache.add(element);
        this.mapCache.put(key, element);
        if (oldElement != null) {
            oldElement.hit();
            return oldElement.getValue();
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.listCache.size();
    }

    @Override
    public void clear() {
        this.initialize();
    }

    @Override
    public List<V> values() {
        ArrayList values = new ArrayList(this.listCache.size());
        for (CacheElement cacheElement : this.listCache) {
            values.add(cacheElement.getValue());
        }
        return values;
    }

    @Override
    public List<Object[]> values(Cache.RecordConverter<V> converter) {
        ArrayList<Object[]> values = new ArrayList<Object[]>(this.listCache.size());
        for (CacheElement cacheElement : this.listCache) {
            Object value = cacheElement.getValue();
            values.add(converter.convert(value));
        }
        return values;
    }
}

